/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.rdc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.LayoutStyle;
import org.tentackle.common.Compare;
import org.tentackle.log.Logger;
import org.tentackle.misc.StringHelper;
import org.tentackle.swing.FormButton;
import org.tentackle.swing.FormDialog;
import org.tentackle.swing.FormLabel;
import org.tentackle.swing.FormPanel;
import org.tentackle.swing.FormQuestion;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.plaf.PlafUtilities;
import org.tentackle.swing.rdc.InteractiveErrorFactory;
import org.tentackle.swing.rdc.RdcSwingRdcBundle;
import org.tentackle.swing.rdc.TooltipAndErrorPanel;

public class PasswordDialog
extends FormDialog {
    private static final long serialVersionUID = -4354288019954531769L;
    private boolean checkOld;
    private boolean okFlag;
    private String oldPassword;
    private String password;
    private int passwordLength = 8;
    private FormPanel buttonPanel;
    private FormButton cancelButton;
    private FormPanel dataPanel;
    private TooltipAndErrorPanel errorPanel;
    private FormLabel jLabel2;
    private FormLabel jLabel3;
    private JPasswordField new1PasswordField;
    private JPasswordField new2PasswordField;
    private FormButton okButton;
    private JPasswordField oldPasswordField;
    private FormLabel oldPasswordLabel;
    private FormPanel passwordPanel;

    public PasswordDialog(String oldPassword) {
        this.oldPassword = oldPassword;
        this.checkOld = oldPassword != null;
        this.initComponents();
        FormUtilities.getInstance().setupDefaultBindings((JComponent)this.oldPasswordField);
        FormUtilities.getInstance().setupDefaultBindings((JComponent)this.new1PasswordField);
        FormUtilities.getInstance().setupDefaultBindings((JComponent)this.new2PasswordField);
    }

    public PasswordDialog() {
        this(null);
    }

    public void setPasswordLength(int passwordLength) {
        this.passwordLength = passwordLength;
    }

    public int getPasswordLength() {
        return this.passwordLength;
    }

    public boolean showDialog() {
        this.okFlag = false;
        this.oldPasswordField.setVisible(this.checkOld);
        this.oldPasswordLabel.setVisible(this.checkOld);
        this.oldPasswordField.setColumns(this.passwordLength);
        this.new1PasswordField.setColumns(this.passwordLength);
        this.new2PasswordField.setColumns(this.passwordLength);
        this.pack();
        this.setVisible(true);
        return this.okFlag;
    }

    public String getPassword() {
        return this.password;
    }

    public String encryptPassword(char[] password) {
        return StringHelper.md5sum((char[])password);
    }

    private boolean checkOldPassword() {
        String passwd;
        if (this.checkOld && Compare.compare((Comparable)((Object)(passwd = this.encryptPassword(this.oldPasswordField.getPassword()))), (Comparable)((Object)this.oldPassword)) != 0) {
            this.errorPanel.setErrors(InteractiveErrorFactory.getInstance().createInteractiveError(RdcSwingRdcBundle.getString("OLD PASSWORD DOES NOT MATCH!"), Logger.Level.WARNING, null, null, null));
            return false;
        }
        return true;
    }

    private String encrypt(char[] pass) {
        if (pass != null && pass.length == 0) {
            pass = null;
        }
        String passwd = this.encryptPassword(pass);
        if (pass != null) {
            for (int i = 0; i < pass.length; ++i) {
                pass[i] = '\u0000';
            }
        }
        return passwd;
    }

    private void initComponents() {
        this.passwordPanel = new FormPanel();
        this.dataPanel = new FormPanel();
        this.oldPasswordLabel = new FormLabel();
        this.jLabel2 = new FormLabel();
        this.jLabel3 = new FormLabel();
        this.oldPasswordField = new JPasswordField();
        this.new1PasswordField = new JPasswordField();
        this.new2PasswordField = new JPasswordField();
        this.errorPanel = new TooltipAndErrorPanel();
        this.buttonPanel = new FormPanel();
        this.okButton = new FormButton();
        this.cancelButton = new FormButton();
        this.setAutoPosition(true);
        this.setHelpURL("#passworddialog");
        this.setTitle(RdcSwingRdcBundle.getTranslation("CHANGE PASSWORD"));
        this.setModal(true);
        this.passwordPanel.setLayout((LayoutManager)new BorderLayout());
        this.oldPasswordLabel.setText(RdcSwingRdcBundle.getTranslation("OLD PASSWORD:"));
        this.jLabel2.setText(RdcSwingRdcBundle.getTranslation("NEW PASSWORD:"));
        this.jLabel3.setText(RdcSwingRdcBundle.getTranslation("NEW PASSWORD REPEATED:"));
        this.oldPasswordField.setColumns(8);
        this.oldPasswordField.setName("oldPassword");
        this.new1PasswordField.setColumns(8);
        this.new1PasswordField.setName("newPassword");
        this.new2PasswordField.setColumns(8);
        this.new2PasswordField.setName("newRepeatedPassword");
        GroupLayout dataPanelLayout = new GroupLayout((Container)this.dataPanel);
        this.dataPanel.setLayout((LayoutManager)dataPanelLayout);
        dataPanelLayout.setHorizontalGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dataPanelLayout.createSequentialGroup().addContainerGap().addGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.jLabel3, -2, -1, -2).addComponent((Component)this.jLabel2, -2, -1, -2).addComponent((Component)this.oldPasswordLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.oldPasswordField, -2, -1, -2).addComponent(this.new1PasswordField, -2, -1, -2).addComponent(this.new2PasswordField, -2, -1, -2)).addContainerGap(48, Short.MAX_VALUE)));
        dataPanelLayout.setVerticalGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dataPanelLayout.createSequentialGroup().addContainerGap().addGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.oldPasswordLabel, -2, -1, -2).addComponent(this.oldPasswordField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.jLabel2, -2, -1, -2).addComponent(this.new1PasswordField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.jLabel3, -2, -1, -2).addComponent(this.new2PasswordField, -2, -1, -2)).addContainerGap(31, Short.MAX_VALUE)));
        this.passwordPanel.add((Component)this.dataPanel, (Object)"Center");
        this.passwordPanel.add((Component)((Object)this.errorPanel), (Object)"South");
        this.getContentPane().add((Component)this.passwordPanel, "Center");
        this.okButton.setIcon((Icon)PlafUtilities.getInstance().getIcon("ok"));
        this.okButton.setText(RdcSwingRdcBundle.getTranslation("OK"));
        this.okButton.setName("ok");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PasswordDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add((Component)this.okButton);
        this.cancelButton.setIcon((Icon)PlafUtilities.getInstance().getIcon("cancel"));
        this.cancelButton.setText(RdcSwingRdcBundle.getTranslation("CANCEL"));
        this.cancelButton.setName("cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PasswordDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add((Component)this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.checkOldPassword()) {
            this.password = this.encrypt(this.new1PasswordField.getPassword());
            String passwd2 = this.encrypt(this.new2PasswordField.getPassword());
            if (Compare.compare((Comparable)((Object)this.password), (Comparable)((Object)passwd2)) != 0) {
                this.errorPanel.setErrors(InteractiveErrorFactory.getInstance().createInteractiveError(RdcSwingRdcBundle.getString("NEW PASSWORDS DON'T MATCH!"), Logger.Level.WARNING, null, null, null));
            } else if (FormQuestion.yesNo((String)(this.password == null ? RdcSwingRdcBundle.getString("REALLY CLEAR THE PASSWORD?") : RdcSwingRdcBundle.getString("REALLY SET THE NEW PASSWORD?")))) {
                this.okFlag = true;
                this.dispose();
            }
        }
    }
}

