/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.rdc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.tentackle.misc.StringHelper;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.security.Permission;
import org.tentackle.security.SecurityFactory;
import org.tentackle.security.SecurityResult;
import org.tentackle.swing.FormButton;
import org.tentackle.swing.FormDialog;
import org.tentackle.swing.FormInfo;
import org.tentackle.swing.FormPanel;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.FormWrapEvent;
import org.tentackle.swing.FormWrapListener;
import org.tentackle.swing.StringFormField;
import org.tentackle.swing.ValueEvent;
import org.tentackle.swing.ValueListener;
import org.tentackle.swing.plaf.PlafUtilities;
import org.tentackle.swing.rdc.PdoEditDialogPool;
import org.tentackle.swing.rdc.PdoNavigationPanel;
import org.tentackle.swing.rdc.PdoSearch;
import org.tentackle.swing.rdc.Rdc;
import org.tentackle.swing.rdc.RdcSwingRdcBundle;
import org.tentackle.swing.rdc.SelectionFilter;

public class PdoSearchDialog<T extends PersistentDomainObject<T>>
extends FormDialog
implements KeyEventDispatcher {
    private PdoSearch<T> pdoSearch;
    private SelectionFilter selectionFilter;
    private boolean allowCreate;
    private boolean multiSelection;
    private boolean autoSelectFirstItem;
    private boolean showMessageIfNotFound;
    private FormPanel searchPanel;
    private String morePattern;
    private PersistentDomainObject<?> selectedObject;
    private List<PersistentDomainObject<?>> selectedObjects;
    private PdoNavigationPanel<T> naviPanel;
    private List<T> naviList;
    private boolean packed;
    private FormPanel buttonPanel;
    private FormButton cancelButton;
    private FormButton moreButton;
    private StringFormField morePatternField;
    private FormButton newButton;
    private FormPanel patternPanel;
    private FormButton searchButton;
    private FormPanel searchCriteriaPanel;

    public PdoSearchDialog(Window owner, DomainContext context, Class<T> pdoClass, SelectionFilter selectionFilter, boolean allowCreate, boolean modal) {
        super(owner, modal);
        this.setup(context, pdoClass, selectionFilter, allowCreate);
    }

    public PdoSearchDialog(DomainContext context, Class<T> pdoClass, SelectionFilter selectionFilter, boolean allowCreate, boolean modal) {
        this(null, context, pdoClass, selectionFilter, allowCreate, modal);
    }

    public PdoSearchDialog(Window owner, PdoSearch<T> pdoSearch, SelectionFilter selectionFilter, boolean allowCreate, boolean modal) {
        super(owner, modal);
        this.setup(pdoSearch, selectionFilter, allowCreate);
    }

    public SelectionFilter getSelectionFilter() {
        return this.selectionFilter;
    }

    public boolean isAllowCreate() {
        return this.allowCreate;
    }

    public PdoSearch<T> getPdoSearch() {
        return this.pdoSearch;
    }

    public void setPdoSearch(PdoSearch<T> pdoSearch) {
        this.pdoSearch = pdoSearch;
    }

    public boolean checkAutoClose() {
        return this.isAutoCloseable() && this.isVisible() && this.getTimeOfLastValuesChanged() + this.getAutoClose() < System.currentTimeMillis();
    }

    public void setButtonsEnabled(boolean flag) {
        this.searchButton.setEnabled(flag);
        this.cancelButton.setEnabled(flag);
        this.moreButton.setEnabled(flag);
        this.newButton.setEnabled(flag);
    }

    public PdoNavigationPanel<T> getNaviPanel() {
        return this.naviPanel;
    }

    public void setMultiSelection(boolean multiSelection) {
        this.multiSelection = multiSelection;
    }

    public boolean isMultiSelection() {
        return this.multiSelection;
    }

    public void setAutoSelectFirstItem(boolean autoSelectFistItem) {
        this.autoSelectFirstItem = autoSelectFistItem;
    }

    public boolean isAutoSelectFirstItem() {
        return this.autoSelectFirstItem;
    }

    public PersistentDomainObject<?> showDialog() {
        SecurityResult sr = SecurityFactory.getInstance().getSecurityManager().evaluate(this.pdoSearch.getDomainContext(), (Permission)SecurityFactory.getInstance().getReadPermission(), this.pdoSearch.getPdoClassId(), 0L);
        if (!sr.isAccepted()) {
            FormInfo.show((String)sr.explain(RdcSwingRdcBundle.getString("YOU DON'T HAVE ENOUGH PERMISSIONS TO VIEW THIS KIND OF DATA!")));
            return null;
        }
        if (this.pdoSearch.isSearchImmediate() && this.pdoSearch.isSearchPanelInvisible()) {
            this.searchPanel.setVisible(false);
        }
        this.setFormValues();
        this.saveValues();
        this.pack();
        if (this.pdoSearch.isSearchImmediate()) {
            this.runSearch();
            if (this.pdoSearch.isDialogNotShownIfSearchImmediateFindsSingleMatch() && this.naviList != null && this.naviList.size() == 1) {
                this.selectedObject = (PersistentDomainObject)this.naviList.get(0);
                return this.selectedObject;
            }
            if (!this.pdoSearch.isDialogShownIfSearchImmediateFails() && (this.naviList == null || this.naviList.isEmpty())) {
                return null;
            }
        }
        this.setVisible(true);
        return this.selectedObject;
    }

    public PersistentDomainObject<?> getSelectedObject() {
        return this.selectedObject;
    }

    public List<PersistentDomainObject<?>> getSelectedObjects() {
        return this.selectedObjects;
    }

    public List<T> getObjects() {
        return this.naviList;
    }

    public boolean isShowMessageIfNotFound() {
        return this.showMessageIfNotFound;
    }

    public void setShowMessageIfNotFound(boolean showMessageIfNotFound) {
        this.showMessageIfNotFound = showMessageIfNotFound;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (this.isFocused() && e.getID() == 401) {
            if (e.getModifiers() == 2) {
                switch (e.getKeyCode()) {
                    case 78: {
                        if (!this.newButton.isVisible() || !this.newButton.isEnabled()) break;
                        this.newButton.doClick();
                        break;
                    }
                    case 70: {
                        if (!this.searchButton.isVisible() || !this.searchButton.isEnabled()) break;
                        this.searchButton.doClick();
                        break;
                    }
                    case 87: {
                        if (!this.cancelButton.isVisible() || !this.cancelButton.isEnabled()) break;
                        this.cancelButton.doClick();
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                e.consume();
                return true;
            }
            if (e.getModifiers() == 0 && e.getKeyCode() == 27 && this.isModal()) {
                if (this.cancelButton.isVisible() && this.cancelButton.isEnabled()) {
                    this.cancelButton.doClick();
                }
                e.consume();
                return true;
            }
        }
        return false;
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 205) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        }
        if (e.getID() == 206) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        }
        super.processWindowEvent(e);
    }

    protected void runSearch() {
        if (this.pdoSearch.isSearchCriteriaValid()) {
            this.setButtonsEnabled(false);
            FormUtilities.getInstance().setWaitCursor((Component)((Object)this));
            this.pdoSearch.execute(t -> {
                if (this.pdoSearch.isResultValid((List<T>)t)) {
                    this.updateResult((List<T>)t);
                    if (t.isEmpty()) {
                        FormInfo.show((String)RdcSwingRdcBundle.getString("NO SUCH OBJECTS FOUND"));
                    }
                    if (this.morePattern != null) {
                        this.morePattern = null;
                        this.morePatternField.fireValueChanged();
                    }
                    if (!t.isEmpty() && this.autoSelectFirstItem) {
                        this.naviPanel.requestFocusForFirstItem();
                    } else {
                        this.setInitialFocus();
                    }
                }
                this.setButtonsEnabled(true);
                FormUtilities.getInstance().setDefaultCursor((Component)((Object)this));
            });
        }
    }

    protected void setInitialFocus() {
        FocusTraversalPolicy policy = this.getFocusTraversalPolicy();
        if (policy != null) {
            Component c = policy.getInitialComponent((Window)((Object)this));
            if (c == null) {
                c = policy.getFirstComponent((Container)((Object)this));
            }
            if (c != null) {
                c.requestFocusInWindow();
            }
        }
    }

    protected void doMoreSearch() {
        if (this.naviList != null && this.morePattern != null && this.morePattern.length() > 0) {
            String thMorePattern = StringHelper.normalize((String)this.morePattern);
            ArrayList<PersistentDomainObject> nlist = new ArrayList<PersistentDomainObject>();
            for (PersistentDomainObject mo : this.naviList) {
                if (mo == null || !mo.containsPattern(thMorePattern)) continue;
                nlist.add(mo);
            }
            this.updateResult(nlist);
        }
    }

    public PdoNavigationPanel<T> createNavigationPanel() {
        PdoNavigationPanel<List<T>> panel = Rdc.createPdoNavigationPanel(this.getObjects(), this.getSelectionFilter(), this.isModal() ? (this.pdoSearch.isSearchPanelInvisible() ? 3 : 2) : (this.pdoSearch.isSearchPanelInvisible() ? 4 : 0), this.pdoSearch.isTableViewInitiallyShown(), this.pdoSearch.getFormTableName());
        if (this.pdoSearch.isViewModeFixed()) {
            panel.setViewModeButtonsVisible(false);
        }
        return panel;
    }

    protected void updateResult(List<T> list) {
        this.clearResult();
        if (list != null) {
            this.naviList = list;
            if (this.naviPanel == null) {
                this.naviPanel = this.createNavigationPanel();
                this.getContentPane().add((Component)((Object)this.naviPanel), "Center");
                this.naviPanel.addActionListener(e -> {
                    this.selectedObject = this.naviPanel.getSelectedObject();
                    this.selectedObjects = this.naviPanel.getSelectedObjects();
                    if (this.isModal() || this.selectedObject == null) {
                        this.dispose();
                    } else {
                        PdoEditDialogPool.getInstance().view(this.selectedObject);
                    }
                });
            } else {
                this.naviPanel.setObjects(list, this.pdoSearch.isViewRebuildNecessary());
            }
            this.naviPanel.setTableIntro(this.pdoSearch.getSearchCriteriaAsString());
            if (this.isModal()) {
                this.naviPanel.setDisposeKeyEnabled(true);
            }
            if (this.multiSelection) {
                this.naviPanel.setTreeSelectionMode(4);
            } else {
                this.naviPanel.setTreeSelectionMode(1);
            }
            if (this.naviList.size() > 1) {
                this.moreButton.setVisible(true);
                this.morePatternField.setVisible(true);
            }
        }
        this.setTimeOfLastValuesChanged(System.currentTimeMillis());
        if (!this.packed) {
            this.pack();
            this.packed = true;
        }
    }

    protected void doCancel() {
        this.selectedObject = null;
        this.selectedObjects = null;
    }

    protected PdoSearch<T> createPdoSearch(DomainContext context, Class<T> searchClass) {
        return Rdc.createGuiProvider(Pdo.create(searchClass, (DomainContext)context)).createPdoSearch();
    }

    protected void setup(DomainContext context, Class<T> pdoClass, SelectionFilter selectionFilter, boolean allowCreate) {
        this.setup(this.createPdoSearch(context, pdoClass), selectionFilter, allowCreate);
    }

    protected void setup(PdoSearch<T> pdoSearch, SelectionFilter selectionFilter, boolean allowCreate) {
        this.pdoSearch = pdoSearch;
        this.selectionFilter = selectionFilter;
        this.allowCreate = allowCreate;
        this.enableEvents(64L);
        this.initComponents();
        this.setMultiSelection(true);
        this.setAutoSelectFirstItem(true);
        this.setShowMessageIfNotFound(true);
        this.searchPanel = pdoSearch.getSearchPanel();
        this.searchCriteriaPanel.add((Component)this.searchPanel, (Object)"Center");
        this.searchPanel.addActionListener(e -> this.searchButton.doClick());
        String fmtClass = null;
        String fmtContext = null;
        try {
            T pdo = pdoSearch.createPdo();
            fmtClass = pdo.getPlural();
            fmtContext = pdo.getBaseContext().toString();
        }
        catch (Exception pdo) {
            // empty catch block
        }
        String title = fmtClass == null ? RdcSwingRdcBundle.getString("SEARCH") : (fmtContext == null || fmtContext.length() == 0 ? MessageFormat.format(RdcSwingRdcBundle.getString("SEARCH {0}"), fmtClass) : MessageFormat.format(RdcSwingRdcBundle.getString("SEARCH {0} IN {1}"), fmtClass, fmtContext));
        if (this.isModal()) {
            title = title + RdcSwingRdcBundle.getString(" (MODAL)");
        }
        this.setTitle(title);
        this.newButton.setVisible(allowCreate);
        this.setFormValues();
        this.clearResult();
    }

    protected void clearResult() {
        this.selectedObject = null;
        this.selectedObjects = null;
        this.naviList = null;
        if (this.naviPanel != null) {
            this.naviPanel.setObjects(new ArrayList());
        }
        this.morePatternField.setVisible(false);
        this.moreButton.setVisible(false);
    }

    private void initComponents() {
        this.searchCriteriaPanel = new FormPanel();
        this.patternPanel = new FormPanel();
        this.buttonPanel = new FormPanel();
        this.searchButton = new FormButton();
        this.newButton = new FormButton();
        this.cancelButton = new FormButton();
        this.morePatternField = new StringFormField();
        this.moreButton = new FormButton();
        this.setAutoPosition(true);
        this.addFormWrapListener(new FormWrapListener(){

            public void formWrapped(FormWrapEvent evt) {
                PdoSearchDialog.this.formFormWrapped(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                PdoSearchDialog.this.formWindowClosed(evt);
            }
        });
        this.searchCriteriaPanel.setLayout((LayoutManager)new BorderLayout());
        this.patternPanel.setLayout((LayoutManager)new GridBagLayout());
        this.buttonPanel.setLayout((LayoutManager)new GridBagLayout());
        this.searchButton.setIcon((Icon)PlafUtilities.getInstance().getIcon("search"));
        this.searchButton.setMnemonic('f');
        this.searchButton.setText(RdcSwingRdcBundle.getTranslation("FIND"));
        this.searchButton.setMargin(new Insets(1, 3, 1, 3));
        this.searchButton.setName("find");
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoSearchDialog.this.searchButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.buttonPanel.add((Component)this.searchButton, (Object)gridBagConstraints);
        this.newButton.setIcon((Icon)PlafUtilities.getInstance().getIcon("new"));
        this.newButton.setMnemonic('n');
        this.newButton.setText(RdcSwingRdcBundle.getTranslation("NEW"));
        this.newButton.setMargin(new Insets(1, 3, 1, 3));
        this.newButton.setName("new");
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoSearchDialog.this.newButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.buttonPanel.add((Component)this.newButton, (Object)gridBagConstraints);
        this.cancelButton.setIcon((Icon)PlafUtilities.getInstance().getIcon("close"));
        this.cancelButton.setMnemonic('c');
        this.cancelButton.setText(RdcSwingRdcBundle.getTranslation("CANCEL"));
        this.cancelButton.setMargin(new Insets(1, 3, 1, 3));
        this.cancelButton.setName("cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoSearchDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.buttonPanel.add((Component)this.cancelButton, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        this.patternPanel.add((Component)this.buttonPanel, (Object)gridBagConstraints);
        this.morePatternField.setAutoSelect(true);
        this.morePatternField.setColumns(15);
        this.morePatternField.setConvert('^');
        this.morePatternField.setInvalidChars("=%");
        this.morePatternField.setName("morePattern");
        this.morePatternField.addValueListener(new ValueListener(){

            public void valueEntered(ValueEvent evt) {
                PdoSearchDialog.this.morePatternFieldValueEntered(evt);
            }

            public void valueChanged(ValueEvent evt) {
                PdoSearchDialog.this.morePatternFieldValueChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.patternPanel.add((Component)this.morePatternField, (Object)gridBagConstraints);
        this.moreButton.setIcon((Icon)PlafUtilities.getInstance().getIcon("search"));
        this.moreButton.setText(RdcSwingRdcBundle.getTranslation("FIND IN RESULTS"));
        this.moreButton.setMargin(new Insets(1, 3, 1, 3));
        this.moreButton.setName("findInResults");
        this.moreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoSearchDialog.this.moreButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.patternPanel.add((Component)this.moreButton, (Object)gridBagConstraints);
        this.searchCriteriaPanel.add((Component)this.patternPanel, (Object)"South");
        this.getContentPane().add((Component)this.searchCriteriaPanel, "North");
    }

    private void formFormWrapped(FormWrapEvent evt) {
        if (this.moreButton.isVisible() && !this.moreButton.isSelected()) {
            this.moreButton.doClick();
        } else if (this.searchButton.isVisible()) {
            this.searchButton.doClick();
        }
    }

    private void formWindowClosed(WindowEvent evt) {
        if (this.pdoSearch != null) {
            this.clearResult();
        }
    }

    private void morePatternFieldValueEntered(ValueEvent evt) {
        this.morePattern = this.morePatternField.getText();
    }

    private void morePatternFieldValueChanged(ValueEvent evt) {
        this.morePatternField.setFormValue((Object)this.morePattern);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doCancel();
        this.dispose();
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        T newObject = PdoEditDialogPool.getInstance().editModal(this.pdoSearch.createPdo());
        this.selectedObject = newObject;
        if (this.selectedObject != null) {
            if (this.selectionFilter != null && !this.selectionFilter.isSelectable(this.selectedObject)) {
                ArrayList<T> list = new ArrayList<T>();
                list.add(newObject);
                this.updateResult(list);
                this.selectedObjects = new ArrayList();
                this.selectedObjects.add(this.selectedObject);
            } else if (this.isModal()) {
                this.dispose();
            }
        }
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        this.runSearch();
    }

    private void moreButtonActionPerformed(ActionEvent evt) {
        this.morePattern = this.morePatternField.getText();
        this.doMoreSearch();
        if (this.naviPanel != null) {
            this.naviPanel.requestFocusForFirstItem();
        }
    }
}

