/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.rdc;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.tentackle.security.Permission;
import org.tentackle.security.SecurityFactory;
import org.tentackle.swing.FormCheckBox;
import org.tentackle.swing.FormComponentPanel;

public class PermissionEditor
extends FormComponentPanel
implements KeyListener {
    private final Map<Permission, FormCheckBox> boxMap = new HashMap<Permission, FormCheckBox>();
    private FormCheckBox firstBox;
    private String oldPermissions;

    public PermissionEditor() {
        this.setLayout(new GridBagLayout());
        int y = 0;
        for (Permission permission : SecurityFactory.getInstance().getPermissions()) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = y++;
            gridBagConstraints.anchor = 21;
            FormCheckBox box = new FormCheckBox(permission.getName());
            box.addKeyListener((KeyListener)this);
            this.add((Component)box, gridBagConstraints);
            if (this.firstBox == null) {
                this.firstBox = box;
            }
            this.boxMap.put(permission, box);
        }
    }

    public void applyClazz(Class<?> clazz) {
        for (Map.Entry<Permission, FormCheckBox> entry : this.boxMap.entrySet()) {
            entry.getValue().setVisible(entry.getKey().appliesTo(clazz));
        }
    }

    public void setPermissions(String str) {
        for (FormCheckBox box : this.boxMap.values()) {
            box.setSelected(false);
        }
        if (str != null) {
            for (Permission permission : SecurityFactory.getInstance().stringToPermissions(str)) {
                FormCheckBox box = this.boxMap.get(permission);
                if (box == null) continue;
                box.setSelected(true);
            }
        }
        if (this.firstBox != null) {
            this.firstBox.requestFocusLater();
        }
    }

    public String getPermissions() {
        LinkedHashSet<Permission> permissions = new LinkedHashSet<Permission>();
        for (Map.Entry<Permission, FormCheckBox> entry : this.boxMap.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            permissions.add(entry.getKey());
        }
        return permissions.isEmpty() ? null : SecurityFactory.getInstance().permissionsToString(permissions);
    }

    public void saveValue() {
        this.oldPermissions = this.getPermissions();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10 || e.getKeyChar() == '\t') {
            this.fireActionPerformed(null);
        } else if (e.getKeyCode() == 27) {
            this.setPermissions(this.oldPermissions);
            this.fireActionPerformed(null);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

