/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.rdc;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.tentackle.prefs.PersistedPreferences;
import org.tentackle.prefs.PersistedPreferencesFactory;
import org.tentackle.swing.FormError;
import org.tentackle.swing.WorkerThread;

public class PreferencesHelper {
    private static final String FILE_EXTENSION = ".xml";
    private static final String FILE_DESCRIPTION = "Preferences";

    public static void exportPreferences(boolean system) {
        JFileChooser jfc = new JFileChooser();
        jfc.setFileSelectionMode(0);
        jfc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(PreferencesHelper.FILE_EXTENSION) || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return PreferencesHelper.FILE_DESCRIPTION;
            }
        });
        if (jfc.showSaveDialog(null) == 0) {
            File outFile = jfc.getSelectedFile();
            if (!outFile.getName().toLowerCase().endsWith(FILE_EXTENSION)) {
                outFile = new File(outFile.getPath() + FILE_EXTENSION);
            }
            String pathname = outFile.getPath();
            new WorkerThread(() -> {
                try {
                    PersistedPreferences prefs = system ? PersistedPreferences.systemRoot() : PersistedPreferences.userRoot();
                    prefs.sync();
                    prefs.exportSubtree((OutputStream)new FileOutputStream(pathname));
                }
                catch (Exception ex) {
                    FormError.showException((String)"exporting preferences failed", (Throwable)ex);
                }
            }, "exporting preferences...").start();
        }
    }

    public static void importPreferences(boolean system) {
        JFileChooser jfc = new JFileChooser();
        jfc.setFileSelectionMode(0);
        jfc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(PreferencesHelper.FILE_EXTENSION) || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return PreferencesHelper.FILE_DESCRIPTION;
            }
        });
        if (jfc.showOpenDialog(null) == 0) {
            File inFile = jfc.getSelectedFile();
            new WorkerThread(() -> {
                try {
                    PersistedPreferencesFactory.getInstance().importPreferences((InputStream)new BufferedInputStream(new FileInputStream(inFile)));
                    if (system) {
                        PersistedPreferences.systemRoot().flush();
                    } else {
                        PersistedPreferences.userRoot().flush();
                    }
                }
                catch (Exception ex) {
                    FormError.showException((String)"importing preferences failed", (Throwable)ex);
                }
            }, "importing preferences...").start();
        }
    }

    private PreferencesHelper() {
    }
}

