/**
 * Tentackle - http://www.tentackle.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package org.tentackle.swing.rdc;

import org.tentackle.swing.FormDialog;

/**
 * Progress dialog for search cursors.
 * <p>
 * The modal dialog is shown if more than {@link AbstractPdoSearch#warnRowCount}
 * rows are retrieved and the user answers the question to retrieve more
 * with "yes". The progress dialog shows and updates the numbers of rows retrieved
 * and provides an abort button.
 *
 * @author harald
 */
public class PdoCursorProgressDialog extends FormDialog {

  private static final long serialVersionUID = -6880264515974835266L;


  private volatile boolean abortRequested;    // true if abort has been requested


  /**
   * Creates a progress dialog.
   */
  public PdoCursorProgressDialog() {
    initComponents();
  }

  /**
   * Shows the modal dialog.
   */
  public void showDialog()  {
    pack();
    setVisible(true);
  }

  /**
   * Updates and displays the row count.
   *
   * @param rowCount the row count
   */
  public void updateRowCount(int rowCount) {
    rowCountField.setIntValue(rowCount);
  }

  /**
   * Returns whether user clicked the abort button.
   *
   * @return true if abort
   */
  public boolean isAbortRequested() {
    return abortRequested;
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {
    java.awt.GridBagConstraints gridBagConstraints;

    infoPanel = new org.tentackle.swing.FormPanel();
    jLabel1 = new org.tentackle.swing.FormLabel();
    rowCountField = new org.tentackle.swing.IntegerFormField();
    buttonPanel = new org.tentackle.swing.FormPanel();
    abortButton = new org.tentackle.swing.FormButton();

    setAutoPosition(true);
    setTitle(RdcSwingRdcBundle.getTranslation("LOADING OBJECTS...")); // NOI18N
    setModal(true);

    infoPanel.setLayout(new java.awt.GridBagLayout());

    jLabel1.setText(RdcSwingRdcBundle.getTranslation("OBJECTS READ SO FAR:")); // NOI18N
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
    infoPanel.add(jLabel1, gridBagConstraints);

    rowCountField.setChangeable(false);
    rowCountField.setColumns(10);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 5);
    infoPanel.add(rowCountField, gridBagConstraints);

    getContentPane().add(infoPanel, java.awt.BorderLayout.CENTER);

    abortButton.setIcon(org.tentackle.swing.plaf.PlafUtilities.getInstance().getIcon("working"));
    abortButton.setText(RdcSwingRdcBundle.getTranslation("ABORT")); // NOI18N
    abortButton.setName("abort"); // NOI18N
    abortButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        abortButtonActionPerformed(evt);
      }
    });
    buttonPanel.add(abortButton);

    getContentPane().add(buttonPanel, java.awt.BorderLayout.SOUTH);

    pack();
  }// </editor-fold>//GEN-END:initComponents

  private void abortButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_abortButtonActionPerformed
    abortRequested = true;
  }//GEN-LAST:event_abortButtonActionPerformed


  // Variables declaration - do not modify//GEN-BEGIN:variables
  private org.tentackle.swing.FormButton abortButton;
  private org.tentackle.swing.FormPanel buttonPanel;
  private org.tentackle.swing.FormPanel infoPanel;
  private org.tentackle.swing.FormLabel jLabel1;
  private org.tentackle.swing.IntegerFormField rowCountField;
  // End of variables declaration//GEN-END:variables

}
