/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.app;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.tentackle.app.AbstractApplication;
import org.tentackle.app.AppSwingRdcBundle;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.misc.ApplicationException;
import org.tentackle.misc.CommandLine;
import org.tentackle.misc.StringHelper;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.LoginFailedException;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PdoTracker;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.pdo.Session;
import org.tentackle.pdo.SessionInfo;
import org.tentackle.reflect.ReflectionHelper;
import org.tentackle.swing.FormError;
import org.tentackle.swing.FormInfo;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.FormWindow;
import org.tentackle.swing.GUIExceptionHandler;
import org.tentackle.swing.plaf.PlafUtilities;
import org.tentackle.swing.rdc.DefaultLoginDialog;
import org.tentackle.swing.rdc.LoginDialog;
import org.tentackle.swing.rdc.PdoEditDialogPool;
import org.tentackle.swing.rdc.PdoSearchDialog;
import org.tentackle.swing.rdc.Rdc;

public abstract class DesktopApplication
extends AbstractApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(DesktopApplication.class);
    private static final String DEFAULT_LAF = MetalLookAndFeel.class.getName();
    private final Icon logo;
    private CommandLine cmdLine;
    private FormWindow window;
    private LoginDialog loginDialog;
    private String sessionPropsName;

    public static DesktopApplication getDesktopApplication() {
        return (DesktopApplication)DesktopApplication.getRunningApplication();
    }

    public DesktopApplication(String name, Icon logo) {
        super(name);
        this.logo = logo;
    }

    public boolean isServer() {
        return false;
    }

    protected void configurePdoTracker() {
        super.configurePdoTracker();
        Session trackerSession = this.getSession().clone();
        trackerSession.groupWith(this.getSession().getSessionId());
        PdoTracker.getInstance().setSession(trackerSession);
    }

    public DomainContext createDomainContext(Session session) {
        return super.createDomainContext(null);
    }

    public void start(String[] args) {
        this.cmdLine = new CommandLine(args);
        this.setProperties(this.cmdLine.getOptionsAsProperties());
        try {
            LOGGER.fine("register application", new Object[0]);
            this.register();
            LOGGER.fine("initialize application", new Object[0]);
            this.doInitialize();
            LOGGER.fine("login to backend", new Object[0]);
            if (this.doLogin() == null) {
                System.exit(1);
            }
            LOGGER.fine("configure application", new Object[0]);
            this.doConfigureApplication();
            LOGGER.fine("show application", new Object[0]);
            this.doInitializeGUI();
            Session session = this.getSession();
            EventQueue.invokeAndWait(() -> {
                try {
                    session.makeCurrent();
                    this.window = this.doCreateWindow();
                    if (StringHelper.isAllWhitespace((String)this.window.getTitle())) {
                        this.window.setTitle(this.getName());
                    }
                    this.doShowWindow();
                }
                catch (RuntimeException | ApplicationException e) {
                    this.doStop(2, (Exception)e);
                }
            });
            LOGGER.fine("waiting for all shown...", new Object[0]);
            FormUtilities.getInstance().waitForEmptyEventQueue();
            LOGGER.fine("finish startup", new Object[0]);
            this.doFinishStartup();
        }
        catch (InterruptedException | RuntimeException | InvocationTargetException | ApplicationException ex) {
            FormError.showException((String)MessageFormat.format(AppSwingRdcBundle.getString("LAUNCHING {0} FAILED"), this.getName()), (Throwable)ex, (boolean)false, (Logger)LOGGER);
            this.doStop(3, (Exception)ex);
        }
    }

    public void stop() {
        try {
            this.unregister();
            this.doStop(0);
        }
        catch (RuntimeException | ApplicationException e) {
            LOGGER.logStacktrace(e);
            this.doStop(4, (Exception)e);
        }
    }

    public synchronized CommandLine getCommandLine() {
        return this.cmdLine;
    }

    public Icon getLogo() {
        return this.logo;
    }

    public FormWindow getWindow() {
        return this.window;
    }

    public void setLookAndFeel(String name) {
        if (EventQueue.isDispatchThread()) {
            new LafRunnable(name).run();
        } else {
            try {
                EventQueue.invokeAndWait(new LafRunnable(name));
            }
            catch (InterruptedException | RuntimeException | InvocationTargetException ex) {
                FormError.showException((String)AppSwingRdcBundle.getString("CHANGING THE LOOK-AND-FEEL FAILED"), (Throwable)ex);
            }
        }
    }

    public void changeLookAndFeel(String name) {
        this.setLookAndFeel(name);
    }

    public JMenu createLookAndFeelMenu() {
        final JMenu guiMenu = new JMenu(AppSwingRdcBundle.getString("GUI STYLE ..."));
        UIManager.LookAndFeelInfo[] looks = PlafUtilities.getInstance().getInstalledTentackleLookAndFeels();
        if (looks != null) {
            for (UIManager.LookAndFeelInfo look : looks) {
                JRadioButtonMenuItem lnfitem = new JRadioButtonMenuItem(look.getName());
                lnfitem.setActionCommand(look.getClassName());
                lnfitem.addActionListener(e -> this.changeLookAndFeel(e.getActionCommand()));
                guiMenu.add(lnfitem);
            }
            guiMenu.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent e) {
                    Component[] items;
                    String name = UIManager.getLookAndFeel().getClass().getName();
                    for (Component item1 : items = guiMenu.getMenuComponents()) {
                        JRadioButtonMenuItem item = (JRadioButtonMenuItem)item1;
                        item.setSelected(item.getActionCommand().equals(name));
                    }
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                }

                @Override
                public void menuCanceled(MenuEvent e) {
                }
            });
        }
        return guiMenu;
    }

    public void showLoginStatus(String msg) {
        if (this.loginDialog != null && this.loginDialog.isShowing()) {
            this.loginDialog.showStatus(msg);
        } else {
            LOGGER.info(msg, new Object[0]);
        }
    }

    public <T extends PersistentDomainObject<T>> T showEditDialog(Component comp, T object, boolean modal) {
        if (modal) {
            return PdoEditDialogPool.getInstance().editModal(object, comp);
        }
        PdoEditDialogPool.getInstance().edit(object, comp, false);
        return null;
    }

    public <T extends PersistentDomainObject<T>> T showEditDialog(Component comp, Class<T> clazz, boolean modal) {
        return (T)this.showEditDialog(comp, this.on(clazz), modal);
    }

    public <T extends PersistentDomainObject<T>> void showEditDialog(Class<T> clazz) {
        this.showEditDialog((Component)((Window)this.window), clazz, false);
    }

    public <T extends PersistentDomainObject<T>> void showSearchDialog(FormWindow w, Class<T> clazz) {
        PdoSearchDialog<T> sd = Rdc.createPdoSearchDialog(null, this.getDomainContext(), clazz, o -> clazz.isAssignableFrom(o.getClass()), false, false);
        sd.setRelatedWindow(w);
        sd.showDialog();
    }

    public <T extends PersistentDomainObject<T>> void showSearchDialog(Class<T> clazz) {
        this.showSearchDialog(this.window, clazz);
    }

    protected void configurePreferences() {
        this.showLoginStatus(AppSwingRdcBundle.getString("INSTALLING PREFERENCES..."));
        super.configurePreferences();
    }

    protected void installLookAndFeels() {
        this.showLoginStatus(AppSwingRdcBundle.getString("INSTALLING LOOK AND FEELS..."));
        PlafUtilities.getInstance().installTentackleLookAndFeels();
    }

    public LoginDialog createLoginDialog(SessionInfo sessionInfo, Icon logo) {
        return new DefaultLoginDialog(sessionInfo, logo);
    }

    protected DomainContext doLogin() throws ApplicationException {
        String username = this.cmdLine.getOptionValue("user");
        char[] password = StringHelper.toCharArray((String)this.cmdLine.getOptionValue("password"));
        this.sessionPropsName = this.cmdLine.getOptionValue("backend");
        SessionInfo sessionInfo = this.createSessionInfo(username, password, this.sessionPropsName);
        if (!UIManager.getLookAndFeel().isNativeLookAndFeel()) {
            try {
                UIManager.setLookAndFeel(DEFAULT_LAF);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | RuntimeException | UnsupportedLookAndFeelException ex) {
                LOGGER.warning("can not switch to default laf " + DEFAULT_LAF, (Throwable)ex);
            }
        }
        this.loginDialog = this.createLoginDialog(sessionInfo, this.logo);
        DomainContext context = null;
        int retry = 4;
        while (--retry >= 0) {
            if (username == null || password == null) {
                sessionInfo = this.loginDialog.getSessionInfo();
                if (sessionInfo == null) {
                    return null;
                }
            } else {
                this.loginDialog.setVisible(true);
                sessionInfo = this.createSessionInfo(username, password, this.sessionPropsName);
            }
            this.loginDialog.showStatus(AppSwingRdcBundle.getString("CONNECTING TO SERVER..."));
            if (sessionInfo.getApplicationName() == null) {
                sessionInfo.setApplicationName(ReflectionHelper.getClassBaseName(((Object)((Object)this)).getClass()));
            }
            this.setSessionInfo(sessionInfo);
            Session session = this.createSession(sessionInfo);
            try {
                session.open();
            }
            catch (LoginFailedException lfx) {
                String msg;
                switch (retry) {
                    case 2: {
                        msg = AppSwingRdcBundle.getString("LOGIN FAILED! (2 MORE RETRIES)");
                        break;
                    }
                    case 1: {
                        msg = AppSwingRdcBundle.getString("LOGIN FAILED! (LAST RETRY)");
                        break;
                    }
                    default: {
                        msg = AppSwingRdcBundle.getString("LOGIN FAILED!");
                    }
                }
                sessionInfo.setPassword(null);
                LOGGER.info(msg, (Throwable)lfx);
                this.showLoginStatus(msg);
                continue;
            }
            session.makeCurrent();
            context = this.createDomainContext(session);
            if (context != null) break;
            session.getSessionInfo().clearPassword();
            session.close();
        }
        if (retry < 0) {
            FormInfo.show((String)AppSwingRdcBundle.getString("LOGIN REFUSED! PLEASE CHECK YOUR USERNAME AND PASSWORD"));
            this.loginDialog.dispose();
            context = null;
        }
        this.setDomainContext(context);
        this.updateSessionInfoAfterLogin();
        return context;
    }

    protected void doConfigureApplication() throws ApplicationException {
        super.doConfigureApplication();
        this.installLookAndFeels();
    }

    protected abstract FormWindow doCreateWindow() throws ApplicationException;

    protected void doInitializeGUI() throws ApplicationException {
        FormUtilities fu = FormUtilities.getInstance();
        fu.activate();
        fu.getEventQueue();
    }

    protected void doShowWindow() throws ApplicationException {
        this.window.setFormValues();
        this.window.saveValues();
        ((Window)this.window).setVisible(true);
        if (this.loginDialog != null && this.loginDialog.isShowing()) {
            this.loginDialog.dispose();
        }
    }

    protected void doFinishStartup() throws ApplicationException {
        super.doFinishStartup();
        PdoTracker.getInstance().addShutdownRunnable(() -> {
            if (!PdoTracker.getInstance().isTerminationRequested()) {
                LOGGER.severe("*** emergency shutdown ***", new Object[0]);
                this.stop();
            }
        });
    }

    protected void doStop(int exitValue, Exception ex) {
        if (exitValue != 0 || ex != null) {
            LOGGER.log(Logger.Level.SEVERE, "application " + this.getName() + " abnormally terminated with exit code " + exitValue, (Throwable)ex);
        } else {
            LOGGER.info("application {0} terminated", new Object[]{this.getName()});
        }
        try {
            Session session;
            if (this.window != null && ((Window)this.window).isShowing()) {
                ((Window)this.window).dispose();
            }
            PdoEditDialogPool.getInstance().disposeAllDialogs();
            GUIExceptionHandler.runSaveState();
            Pdo.terminateHelperThreads();
            DomainContext context = this.getDomainContext();
            if (context != null && (session = context.getSession()) != null) {
                session.close();
            }
        }
        catch (Exception anyEx) {
            LOGGER.severe("desktop application stopped ungracefully", (Throwable)anyEx);
        }
        System.exit(exitValue);
    }

    protected void doStop(int exitValue) {
        this.doStop(exitValue, null);
    }

    private static class LafRunnable
    implements Runnable {
        private final String name;

        private LafRunnable(String name) {
            this.name = name;
        }

        @Override
        public void run() {
            if (this.name != null && UIManager.getLookAndFeel().getClass().getName().compareTo(this.name) != 0) {
                try {
                    UIManager.setLookAndFeel(this.name);
                    PlafUtilities.getInstance().triggerLookAndFeelUpdated();
                    FormUtilities.getInstance().updateUIofAllWindows();
                }
                catch (UnsupportedLookAndFeelException ex) {
                    FormError.show((String)AppSwingRdcBundle.getString("THIS LOOK-AND-FEEL IS NOT SUPPORTED ON THIS COMPUTER"));
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                    FormError.showException((String)AppSwingRdcBundle.getString("CHANGING THE LOOK-AND-FEEL FAILED"), (Throwable)ex);
                }
            }
        }
    }
}

