/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.rdc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.LayoutStyle;
import org.tentackle.common.Version;
import org.tentackle.swing.FormButton;
import org.tentackle.swing.FormDialog;
import org.tentackle.swing.FormLabel;
import org.tentackle.swing.FormPanel;
import org.tentackle.swing.FormTextArea;
import org.tentackle.swing.GCButton;
import org.tentackle.swing.rdc.RdcSwingRdcBundle;

public class AboutDialog
extends FormDialog {
    private static final long serialVersionUID = -3397099233126775727L;
    private Thread gcUpdater;
    private final String text;
    private Icon logo;
    private FormTextArea applicationTextArea;
    private FormButton closeButton;
    private GCButton gcButton;
    private JLabel imageLabel;
    private FormPanel infoPanel;
    private FormLabel jLabel1;
    private JLabel javaVersionLabel;
    private JLayeredPane layeredPane;
    private JLabel logoLabel;
    private FormPanel logoPanel;
    private JLabel tentackleVersionLabel;

    public AboutDialog(String text, Icon logo) {
        this.text = text;
        this.logo = logo;
        if (logo == null) {
            this.logo = new ImageIcon(AboutDialog.class.getResource("/org/tentackle/swing/rdc/images/loginLogo.png"));
        }
        this.setup();
    }

    private void setup() {
        this.initComponents();
        this.applicationTextArea.setText(this.text);
        this.tentackleVersionLabel.setText("Tentackle " + Version.RELEASE);
        this.javaVersionLabel.setText("Java " + System.getProperty("java.version"));
        Dimension size = this.imageLabel.getPreferredSize();
        int width = size.width;
        int height = size.height;
        this.layeredPane.setPreferredSize(size);
        this.imageLabel.setBounds(0, 0, width, height);
        this.logoPanel.setBounds(0, 0, width, height);
        int logoWidth = this.logo.getIconWidth();
        int logoHeight = this.logo.getIconHeight();
        this.logoLabel.setIcon(this.logo);
        this.logoLabel.setBounds((width / 2 - logoWidth) / 2, (height - logoHeight) / 2, logoWidth, logoHeight);
        StringTokenizer stok = new StringTokenizer(this.text);
        if (stok.hasMoreTokens()) {
            this.setTitle(MessageFormat.format(RdcSwingRdcBundle.getString("ABOUT {0}"), stok.nextToken()));
        }
        this.gcUpdater = new Thread("AboutDialog GC Info Updater"){

            @Override
            public void run() {
                while (!this.isInterrupted()) {
                    try {
                        1.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        return;
                    }
                    EventQueue.invokeLater(() -> AboutDialog.this.gcButton.refresh());
                }
            }
        };
        this.pack();
        this.gcUpdater.start();
    }

    private void initComponents() {
        this.layeredPane = new JLayeredPane();
        this.imageLabel = new JLabel();
        this.infoPanel = new FormPanel();
        this.applicationTextArea = new FormTextArea();
        this.tentackleVersionLabel = new JLabel();
        this.javaVersionLabel = new JLabel();
        this.gcButton = new GCButton();
        this.closeButton = new FormButton();
        this.jLabel1 = new FormLabel();
        this.logoPanel = new FormPanel();
        this.logoLabel = new JLabel();
        this.setAutoPosition(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AboutDialog.this.formWindowClosing(evt);
            }
        });
        this.imageLabel.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/org/tentackle/swing/rdc/images/login.png")));
        this.layeredPane.add(this.imageLabel);
        this.imageLabel.setBounds(0, 0, 500, 350);
        this.infoPanel.setOpaque(false);
        this.applicationTextArea.setChangeable(false);
        this.applicationTextArea.setForeground(Color.orange);
        this.applicationTextArea.setFont(new Font("Dialog", 1, 12));
        this.tentackleVersionLabel.setForeground(new Color(204, 204, 255));
        this.tentackleVersionLabel.setText("Tentackle Build xxx");
        this.javaVersionLabel.setForeground(new Color(204, 204, 255));
        this.javaVersionLabel.setText("java xxx");
        this.gcButton.setBorder(null);
        this.gcButton.setForeground(new Color(204, 204, 255));
        this.gcButton.setText("? / ? M");
        this.gcButton.setBorderPainted(false);
        this.gcButton.setFocusable(false);
        this.gcButton.setFont(new Font("Dialog", 0, 12));
        this.gcButton.setName("gc");
        this.closeButton.setBackground(new Color(204, 204, 255));
        this.closeButton.setText(RdcSwingRdcBundle.getTranslation("CLOSE"));
        this.closeButton.setMargin(new Insets(1, 4, 1, 4));
        this.closeButton.setName("close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setForeground(new Color(204, 204, 255));
        this.jLabel1.setText(RdcSwingRdcBundle.getTranslation("MEMORY:"));
        GroupLayout infoPanelLayout = new GroupLayout((Container)this.infoPanel);
        this.infoPanel.setLayout((LayoutManager)infoPanelLayout);
        infoPanelLayout.setHorizontalGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(infoPanelLayout.createSequentialGroup().addContainerGap(276, Short.MAX_VALUE).addGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, infoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tentackleVersionLabel).addComponent((Component)this.applicationTextArea, -2, 212, -2).addComponent(this.javaVersionLabel).addGroup(infoPanelLayout.createSequentialGroup().addComponent((Component)this.jLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.gcButton, -2, -1, -2))).addComponent((Component)this.closeButton, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addContainerGap()));
        infoPanelLayout.setVerticalGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, infoPanelLayout.createSequentialGroup().addContainerGap(98, Short.MAX_VALUE).addComponent((Component)this.applicationTextArea, -2, 97, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tentackleVersionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.javaVersionLabel).addGap(7, 7, 7).addGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.jLabel1, -2, -1, -2).addComponent((Component)this.gcButton, -2, -1, -2)).addGap(56, 56, 56).addComponent((Component)this.closeButton, -2, -1, -2).addContainerGap()));
        this.layeredPane.add((Component)this.infoPanel);
        this.infoPanel.setBounds(0, 0, 500, 350);
        this.layeredPane.setLayer((Component)this.infoPanel, JLayeredPane.PALETTE_LAYER);
        this.logoPanel.setOpaque(false);
        this.logoPanel.setLayout(null);
        this.logoLabel.setFont(new Font("SansSerif", 1, 12));
        this.logoPanel.add((Component)this.logoLabel);
        this.logoLabel.setBounds(45, 60, 140, 200);
        this.layeredPane.add((Component)this.logoPanel);
        this.logoPanel.setBounds(0, 0, 500, 350);
        this.layeredPane.setLayer((Component)this.logoPanel, JLayeredPane.MODAL_LAYER);
        this.getContentPane().add((Component)this.layeredPane, "Center");
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.gcUpdater.interrupt();
    }
}

