/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.rdc;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.tentackle.swing.FormButton;
import org.tentackle.swing.FormDialog;
import org.tentackle.swing.FormTextArea;
import org.tentackle.swing.plaf.PlafUtilities;
import org.tentackle.swing.rdc.RdcSwingRdcBundle;

public class CancelSaveDiscardDialog
extends FormDialog {
    private static final String SAVE_KEYS = RdcSwingRdcBundle.getString("SAVE_KEYS");
    private static final String DISCARD_KEYS = RdcSwingRdcBundle.getString("DISCARD_KEYS");
    public static final int CANCEL = 0;
    public static final int SAVE = 1;
    public static final int DISCARD = 2;
    private static final long serialVersionUID = -7542059032899743591L;
    private int answer;
    private Component messageComp;
    private JPanel buttonPanel;
    private FormButton cancelButton;
    private FormButton discardButton;
    private JLabel iconLabel;
    private FormTextArea messageField;
    private JPanel messagePanel;
    private FormButton saveButton;

    public static int getAnswer(String question, String discard, String save, String cancel) {
        return new CancelSaveDiscardDialog().showDialog(question, discard, save, cancel);
    }

    public static int getAnswer(String question) {
        return CancelSaveDiscardDialog.getAnswer(question, null, null, null);
    }

    public static int getAnswer() {
        return CancelSaveDiscardDialog.getAnswer(RdcSwingRdcBundle.getString("DATA_HAS_BEEN_MODIFIED!_DISCARD,_SAVE_OR_CANCEL?"));
    }

    public CancelSaveDiscardDialog() {
        this.initComponents();
        this.messageComp = this.messagePanel;
    }

    public int showDialog(String question, String discard, String save, String cancel) {
        if (question != null) {
            this.messageField.setText(question);
            this.messageField.setSize(this.messageField.getOptimalSize());
        }
        if (discard != null) {
            this.discardButton.setText(discard);
        }
        if (save != null) {
            this.saveButton.setText(save);
        }
        if (cancel != null) {
            this.cancelButton.setText(cancel);
        }
        this.answer = 0;
        this.pack();
        this.setVisible(true);
        return this.answer;
    }

    public int showDialog() {
        return this.showDialog(null, null, null, null);
    }

    public void setMessageComponent(Component comp) {
        this.getContentPane().remove(this.messageComp);
        this.messageComp = comp;
        this.getContentPane().add(this.messageComp, "Center");
    }

    public Component getMessageComponent() {
        return this.messageComp;
    }

    private void initComponents() {
        this.messagePanel = new JPanel();
        this.iconLabel = new JLabel();
        this.messageField = new FormTextArea();
        this.buttonPanel = new JPanel();
        this.discardButton = new FormButton();
        this.saveButton = new FormButton();
        this.cancelButton = new FormButton();
        this.setAutoPosition(true);
        this.setModal(true);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                CancelSaveDiscardDialog.this.formKeyTyped(evt);
            }
        });
        this.messagePanel.setLayout(new GridBagLayout());
        this.iconLabel.setHorizontalAlignment(0);
        this.iconLabel.setIcon(PlafUtilities.getInstance().getIcon("QuestionDialog"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.messagePanel.add((Component)this.iconLabel, gridBagConstraints);
        this.messageField.setEditable(false);
        this.messageField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.messageField.setLineWrap(true);
        this.messageField.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.messagePanel.add((Component)this.messageField, gridBagConstraints);
        this.getContentPane().add((Component)this.messagePanel, "Center");
        this.buttonPanel.setLayout(new GridBagLayout());
        this.discardButton.setIcon((Icon)PlafUtilities.getInstance().getIcon("ok"));
        this.discardButton.setText(RdcSwingRdcBundle.getTranslation("DISCARD"));
        this.discardButton.setName("discard");
        this.discardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CancelSaveDiscardDialog.this.discardButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.buttonPanel.add((Component)this.discardButton, gridBagConstraints);
        this.saveButton.setIcon((Icon)PlafUtilities.getInstance().getIcon("save"));
        this.saveButton.setText(RdcSwingRdcBundle.getTranslation("SAVE"));
        this.saveButton.setName("save");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CancelSaveDiscardDialog.this.saveButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.buttonPanel.add((Component)this.saveButton, gridBagConstraints);
        this.cancelButton.setIcon((Icon)PlafUtilities.getInstance().getIcon("cancel"));
        this.cancelButton.setText(RdcSwingRdcBundle.getTranslation("CANCEL"));
        this.cancelButton.setName("cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CancelSaveDiscardDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.buttonPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.answer = 1;
        this.dispose();
    }

    private void formKeyTyped(KeyEvent evt) {
        char key = evt.getKeyChar();
        if (key != '\uffff') {
            if (DISCARD_KEYS.indexOf(key) >= 0) {
                this.discardButton.doClick();
            } else if (SAVE_KEYS.indexOf(key) >= 0) {
                this.saveButton.doClick();
            } else {
                this.cancelButton.doClick();
            }
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void discardButtonActionPerformed(ActionEvent evt) {
        this.answer = 2;
        this.dispose();
    }
}

