/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.rdc;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.EventListenerList;
import org.tentackle.common.ExceptionHelper;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.misc.FormatHelper;
import org.tentackle.misc.StringHelper;
import org.tentackle.pdo.ConstraintException;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.NotFoundException;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PdoRuntimeException;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.security.SecurityDialogFactory;
import org.tentackle.security.SecurityFactory;
import org.tentackle.security.SecurityManager;
import org.tentackle.security.SecurityResult;
import org.tentackle.security.permissions.EditPermission;
import org.tentackle.security.permissions.ViewPermission;
import org.tentackle.swing.FormButton;
import org.tentackle.swing.FormDialog;
import org.tentackle.swing.FormError;
import org.tentackle.swing.FormInfo;
import org.tentackle.swing.FormLabel;
import org.tentackle.swing.FormPanel;
import org.tentackle.swing.FormQuestion;
import org.tentackle.swing.LongFormField;
import org.tentackle.swing.plaf.PlafUtilities;
import org.tentackle.swing.rdc.CancelSaveDiscardDialog;
import org.tentackle.swing.rdc.GuiProvider;
import org.tentackle.swing.rdc.PdoEditDialogPool;
import org.tentackle.swing.rdc.PdoNavigationDialog;
import org.tentackle.swing.rdc.PdoPanel;
import org.tentackle.swing.rdc.PdoSearchDialog;
import org.tentackle.swing.rdc.PdoTransferData;
import org.tentackle.swing.rdc.PdoTransferable;
import org.tentackle.swing.rdc.Rdc;
import org.tentackle.swing.rdc.RdcSwingRdcBundle;
import org.tentackle.swing.rdc.TooltipAndErrorPanel;
import org.tentackle.validate.ValidationFailedException;
import org.tentackle.validate.ValidationResult;

public class PdoEditDialog<T extends PersistentDomainObject<T>>
extends FormDialog
implements DropTargetListener,
KeyEventDispatcher {
    private static final long serialVersionUID = 3026626637222875722L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PdoEditDialog.class);
    public static boolean defaultNewAfterSave = false;
    public static final String TX_SAVE = "dialog save";
    public static final String TX_DELETE = "dialog delete";
    public static final String ACTION_NEW = "new";
    public static final String ACTION_SEARCH = "search";
    public static final String ACTION_DELETE = "delete";
    public static final String ACTION_SAVE = "save";
    public static final String ACTION_CANCEL = "cancel";
    public static final String ACTION_PREVIOUS = "previous";
    public static final String ACTION_NEXT = "next";
    private static final String NO_ACCESS_PANEL = "noAccess";
    private static final String NO_INFO_PANEL = "noInfo";
    private static final String DATA_PANEL = "dataPanel";
    private DomainContext context;
    private DomainContext baseContext;
    private T pdo;
    private Class<T> pdoClass;
    private T lastPdo;
    private GuiProvider<T> guiProvider;
    private PdoPanel<T> pdoPanel;
    private EventListenerList listenerList;
    private DataFlavor dndFlavor;
    private Boolean disposeOnDeleteOrSave;
    private boolean noPersistance;
    private boolean newAfterSave;
    private List<T> linkedPdoList;
    private int linkedPdoIndex;
    private long txVoucher;
    private boolean previousButtonAvailable = true;
    private boolean nextButtonAvailable = true;
    private boolean idButtonAvailable = true;
    private boolean browserButtonAvailable = true;
    private boolean newButtonAvailable = true;
    private boolean saveButtonAvailable = true;
    private boolean deleteButtonAvailable = true;
    private boolean searchButtonAvailable = true;
    private boolean printButtonAvailable = false;
    private boolean editable;
    private boolean viewable;
    private boolean deletable;
    private FormButton browserButton;
    private FormPanel buttonPanel;
    private JPopupMenu clipboardMenu;
    private FormButton closeButton;
    private JMenuItem copyItem;
    private FormPanel dataPanel;
    private FormButton deleteButton;
    private FormButton idButton;
    private FormButton idCancelButton;
    private FormDialog idDialog;
    private LongFormField idNumberField;
    private FormButton idSearchButton;
    private FormLabel jLabel1;
    private FormLabel jLabel3;
    private JSeparator jSeparator1;
    private FormButton newButton;
    private FormButton nextButton;
    private FormLabel noAccessLabel;
    private JPanel noAccessPanel;
    private JPanel noInfoPanel;
    private JMenuItem pasteAsCopyItem;
    private JMenuItem pasteItem;
    private FormButton previousButton;
    private FormButton printButton;
    private FormButton saveButton;
    private FormButton searchButton;
    private FormButton securityButton;
    private TooltipAndErrorPanel tipAndErrorPanel;

    protected PdoEditDialog(Window owner, T pdo, boolean modal) {
        super(owner, null, modal);
        String title;
        this.enableEvents(64L);
        this.newAfterSave = defaultNewAfterSave;
        this.linkedPdoIndex = -1;
        this.listenerList = new EventListenerList();
        this.initComponents();
        this.setTooltipDisplay(this.tipAndErrorPanel);
        this.buttonPanel.setBackground(PlafUtilities.getInstance().getDropFieldActiveColor());
        this.guiProvider = Rdc.createGuiProvider(pdo);
        FormPanel panel = this.guiProvider.createPanel();
        if (panel != null && (title = panel.getTitle()) != null) {
            this.setTitle(title);
        }
        if (panel instanceof PdoPanel) {
            this.pdoPanel = (PdoPanel)panel;
            this.dataPanel.add(this.pdoPanel, (Object)DATA_PANEL);
            ((CardLayout)this.dataPanel.getLayout()).show((Container)this.dataPanel, DATA_PANEL);
            this.pdoPanel.setPdoEditDialog(this);
            if (!this.setPdo(pdo) && pdo != null) {
                this.setPdo(Pdo.create(pdo));
            }
            DropTarget target = new DropTarget((Component)this.buttonPanel, this);
            target.setDefaultActions(3);
            this.dndFlavor = pdo == null ? null : new DataFlavor(pdo.getEffectiveClass(), pdo.getClassBaseName());
            this.buttonPanel.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    PdoEditDialog.this.checkPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    PdoEditDialog.this.checkPopup(e);
                }
            });
        } else {
            if (panel != null) {
                this.dataPanel.add((Component)panel, (Object)DATA_PANEL);
                ((CardLayout)this.dataPanel.getLayout()).show((Container)this.dataPanel, DATA_PANEL);
                panel.setChangeable(false);
            } else {
                ((CardLayout)this.dataPanel.getLayout()).show((Container)this.dataPanel, NO_INFO_PANEL);
            }
            this.previousButton.setVisible(false);
            this.nextButton.setVisible(false);
            this.idButton.setVisible(false);
            this.browserButton.setVisible(false);
            this.newButton.setVisible(false);
            this.saveButton.setVisible(false);
            this.deleteButton.setVisible(false);
            this.searchButton.setVisible(false);
            this.printButton.setVisible(false);
        }
    }

    public boolean isBrowserButtonAvailable() {
        return this.browserButtonAvailable;
    }

    public void setBrowserButtonAvailable(boolean browserButtonAvailable) {
        this.browserButtonAvailable = browserButtonAvailable;
    }

    public boolean isDeleteButtonAvailable() {
        return this.deleteButtonAvailable;
    }

    public void setDeleteButtonAvailable(boolean deleteButtonAvailable) {
        this.deleteButtonAvailable = deleteButtonAvailable;
    }

    public boolean isIdButtonAvailable() {
        return this.idButtonAvailable;
    }

    public void setIdButtonAvailable(boolean idButtonAvailable) {
        this.idButtonAvailable = idButtonAvailable;
    }

    public boolean isNewButtonAvailable() {
        return this.newButtonAvailable;
    }

    public void setNewButtonAvailable(boolean newButtonAvailable) {
        this.newButtonAvailable = newButtonAvailable;
    }

    public boolean isNextButtonAvailable() {
        return this.nextButtonAvailable;
    }

    public void setNextButtonAvailable(boolean nextButtonAvailable) {
        this.nextButtonAvailable = nextButtonAvailable;
    }

    public boolean isPreviousButtonAvailable() {
        return this.previousButtonAvailable;
    }

    public void setPreviousButtonAvailable(boolean previousButtonAvailable) {
        this.previousButtonAvailable = previousButtonAvailable;
    }

    public boolean isPrintButtonAvailable() {
        return this.printButtonAvailable;
    }

    public void setPrintButtonAvailable(boolean printButtonAvailable) {
        this.printButtonAvailable = printButtonAvailable;
    }

    public boolean isSaveButtonAvailable() {
        return this.saveButtonAvailable;
    }

    public void setSaveButtonAvailable(boolean saveButtonAvailable) {
        this.saveButtonAvailable = saveButtonAvailable;
    }

    public boolean isSearchButtonAvailable() {
        return this.searchButtonAvailable;
    }

    public void setSearchButtonAvailable(boolean searchButtonAvailable) {
        this.searchButtonAvailable = searchButtonAvailable;
    }

    public void setLinkedPdoList(List<T> linkedPdoList) {
        this.linkedPdoList = linkedPdoList;
        this.updateObjectListIndex();
        this.setupButtons();
    }

    public List<T> getLinkedPdoList() {
        return this.linkedPdoList;
    }

    public int getLinkedPdoIndex() {
        return this.linkedPdoIndex;
    }

    public void clearPdo() {
        if (this.pdo != null) {
            this.lastPdo = this.pdo;
            this.pdo = Pdo.create(this.lastPdo);
            this.setPdo(this.pdo);
        }
    }

    public boolean isPdoViewable() {
        return this.viewable;
    }

    public boolean isPdoEditable() {
        return this.editable;
    }

    public boolean isPdoDeletable() {
        return this.deletable;
    }

    public boolean setPdo(T pdo, boolean requestFocus) {
        if (this.pdoPanel == null) {
            return false;
        }
        if (this.pdo != null && !this.pdo.equals(pdo)) {
            this.pdoPanel.prepareCancel();
            this.clearEditedBy();
        }
        if (pdo != null) {
            this.guiProvider = Rdc.createGuiProvider(pdo);
            pdo = this.guiProvider.getPanelObject();
            if (pdo != null && pdo.isCached()) {
                pdo = pdo.reload();
            }
        }
        if (pdo != null && (this.pdoClass == null || this.pdoClass == pdo.getEffectiveClass())) {
            this.pdo = pdo;
            this.context = pdo.getDomainContext();
            this.pdoClass = pdo.getEffectiveClass();
            this.baseContext = pdo.getBaseContext();
            this.determinePermissions();
            if (!pdo.isNew() && this.editable) {
                String msg;
                PdoEditDialog<T> otherDialog;
                if (PdoEditDialogPool.getInstance().isPdoEditedOnlyOnce() && (otherDialog = PdoEditDialogPool.getInstance().isObjectBeingEdited(pdo, this)) != null) {
                    FormInfo.show((String)RdcSwingRdcBundle.getString("OBJECT IS USED IN ANOTHER DIALOG. PLEASE FINISH THAT DIALOG FIRST!"));
                    EventQueue.invokeLater(() -> otherDialog.toFront());
                    this.editable = false;
                }
                if (this.editable && pdo.getTokenLockTimeout() > 0L && !pdo.isTokenLockedByMe() && (msg = this.applyLock(pdo)) != null) {
                    FormInfo.show((String)msg);
                    this.editable = false;
                    this.deletable = false;
                }
            }
            this.pdoPanel.setChangeable(this.editable);
            StringBuilder idText = new StringBuilder(Long.toString(pdo.getId()));
            while (idText.length() < 8) {
                idText.insert(0, ' ');
            }
            this.idButton.setText(idText.toString());
            this.updateObjectListIndex();
            this.setupButtons();
            if (this.disposeOnDeleteOrSave == null) {
                if (this.isModal()) {
                    this.setDisposeOnDeleteOrSave(true);
                } else {
                    this.setDisposeOnDeleteOrSave(false);
                }
            }
            if (this.viewable) {
                ((CardLayout)this.dataPanel.getLayout()).show((Container)this.dataPanel, DATA_PANEL);
            } else {
                ((CardLayout)this.dataPanel.getLayout()).show((Container)this.dataPanel, NO_ACCESS_PANEL);
            }
            if (!this.pdoPanel.setPdo(pdo)) {
                return false;
            }
            String title = this.pdoPanel.getTitle();
            if (title != null) {
                this.setTitle(title);
            }
            if (requestFocus) {
                this.pdoPanel.setInitialFocus();
            }
            EventQueue.invokeLater(this::saveValues);
            this.tipAndErrorPanel.clearErrors();
            return true;
        }
        this.clearPdo();
        return false;
    }

    public boolean setPdo(T pdo) {
        return this.setPdo(pdo, true);
    }

    public T getPdo() {
        return this.pdo;
    }

    public T getLastPdo() {
        return this.lastPdo;
    }

    public PdoPanel<T> getPdoPanel() {
        return this.pdoPanel;
    }

    public Class<T> getPdoClass() {
        return this.pdoClass;
    }

    public T showDialog(boolean noPersistance) {
        this.noPersistance = noPersistance;
        this.disableButtonsIfNoPersistance();
        this.pack();
        this.setVisible(true);
        return this.pdo;
    }

    public T showDialog() {
        return this.showDialog(false);
    }

    public boolean isNewAfterSave() {
        return this.newAfterSave;
    }

    public void setNewAfterSave(boolean newAfterSave) {
        this.newAfterSave = newAfterSave;
    }

    public boolean isDisposeOnDeleteOrSave() {
        return this.disposeOnDeleteOrSave == null ? false : this.disposeOnDeleteOrSave;
    }

    public void setDisposeOnDeleteOrSave(boolean disposeOnDeleteOrSave) {
        this.disposeOnDeleteOrSave = disposeOnDeleteOrSave;
    }

    public TooltipAndErrorPanel getTooltipAndErrorPanel() {
        return this.tipAndErrorPanel;
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    public void removeAllListeners() {
        this.listenerList = new EventListenerList();
    }

    public void fireActionPerformed(ActionEvent e) {
        ActionEvent evt = null;
        Object[] listeners = this.listenerList.getListenerList();
        if (listeners != null) {
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ActionListener.class) continue;
                if (evt == null) {
                    evt = new ActionEvent(this, e.getID(), e.getActionCommand());
                }
                ((ActionListener)listeners[i + 1]).actionPerformed(evt);
            }
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (this.isFocused() && e.getID() == 401) {
            if (e.getModifiers() == 2) {
                switch (e.getKeyCode()) {
                    case 70: {
                        if (!this.searchButton.isVisible() || !this.searchButton.isEnabled()) break;
                        this.searchButton.doClick();
                        break;
                    }
                    case 83: {
                        if (!this.saveButton.isVisible() || !this.saveButton.isEnabled()) break;
                        this.saveButton.doClick();
                        break;
                    }
                    case 78: {
                        if (!this.newButton.isVisible() || !this.newButton.isEnabled()) break;
                        this.newButton.doClick();
                        break;
                    }
                    case 87: {
                        if (!this.closeButton.isVisible() || !this.closeButton.isEnabled()) break;
                        this.closeButton.doClick();
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                e.consume();
                return true;
            }
            if (e.getModifiers() == 0 && e.getKeyCode() == 27 && this.isModal()) {
                if (this.closeButton.isVisible() && this.closeButton.isEnabled()) {
                    this.closeButton.doClick();
                }
                e.consume();
                return true;
            }
        }
        return false;
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        if (!this.isDragAcceptable(event)) {
            event.rejectDrag();
        } else {
            event.acceptDrag(1);
        }
    }

    @Override
    public void dragExit(DropTargetEvent event) {
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
        if (!this.isDragAcceptable(event)) {
            event.rejectDrag();
        } else {
            event.acceptDrag(1);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        if (this.isDropAcceptable(event)) {
            event.acceptDrop(1);
            Transferable trans = event.getTransferable();
            try {
                Object droppedObject;
                Object transferData = trans.getTransferData(this.dndFlavor);
                if (transferData instanceof PdoTransferData && (droppedObject = ((PdoTransferData)transferData).getPdo(this.context.getSession())) != null) {
                    this.setPdo(droppedObject);
                }
            }
            catch (Exception e) {
                FormError.showException((String)RdcSwingRdcBundle.getString("DROP ERROR:"), (Throwable)e);
            }
            event.dropComplete(true);
        } else {
            event.rejectDrop();
        }
    }

    public void setTitle(String title) {
        if (this.isModal()) {
            title = title == null ? RdcSwingRdcBundle.getString("(MODAL)") : title + RdcSwingRdcBundle.getString(" (MODAL)");
        }
        super.setTitle(title);
    }

    public void setChangeable(boolean changeable) {
        super.setChangeable(changeable);
        this.setupButtons();
    }

    public boolean areValuesChanged() {
        return this.pdo != null && this.pdo.getCopiedObject() != null || super.areValuesChanged();
    }

    public void triggerValuesChanged() {
        super.triggerValuesChanged();
        if (this.saveButton.isVisible()) {
            TooltipAndErrorPanel ttPanel;
            this.saveButton.setEnabled(this.noPersistance || this.editable && this.areValuesChanged());
            if (!this.saveButton.isEnabled() && (ttPanel = this.getTooltipAndErrorPanel()) != null) {
                ttPanel.clearErrors();
            }
        }
    }

    public void saveValues() {
        super.saveValues();
        this.saveButton.setEnabled(this.noPersistance || this.pdo.getCopiedObject() != null);
    }

    public void dispose() {
        super.dispose();
        this.removeAllListeners();
        this.linkedPdoList = null;
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.closeButton.requestFocusInWindow();
            this.closeButton.doClick();
        } else {
            if (e.getID() == 205) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
            }
            if (e.getID() == 206) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
            }
            super.processWindowEvent(e);
        }
    }

    protected void determinePermissions() {
        if (this.pdo == null) {
            this.viewable = false;
            this.editable = false;
            this.deletable = false;
        } else {
            SecurityManager manager = SecurityFactory.getInstance().getSecurityManager();
            SecurityResult sr = manager.evaluate(this.context, SecurityFactory.getInstance().getPermission(ViewPermission.class), this.pdo.getClassId(), this.pdo.getId());
            this.viewable = sr.isAccepted();
            if (!this.viewable) {
                this.noAccessLabel.setText(StringHelper.toHTML((String)sr.explain(RdcSwingRdcBundle.getString("YOU DON'T HAVE ENOUGH PERMISSIONS TO VIEW THE DATA"))));
            }
            sr = manager.evaluate(this.context, SecurityFactory.getInstance().getPermission(EditPermission.class), this.pdo.getClassId(), this.pdo.getId());
            this.editable = this.viewable && this.isChangeable() && sr.isAccepted();
            this.deletable = this.editable && this.pdo.isRemovable();
        }
    }

    protected String applyLock(T pdo) {
        try {
            pdo.requestTokenLock();
            return null;
        }
        catch (RuntimeException e) {
            Object editedSince = pdo.getEditedSince();
            if (editedSince == null) {
                editedSince = new Date();
            }
            return MessageFormat.format(RdcSwingRdcBundle.getString("OBJECT {0} IS BEING EDITED SINCE {1} BY {2}"), pdo.getSingular(), FormatHelper.formatShortTimestamp((Date)editedSince), pdo.getTokenLockObject());
        }
    }

    protected void revokeLock() {
        this.pdo.releaseTokenLock();
    }

    protected void saveObject() {
        this.determinePermissions();
        if (!this.editable) {
            throw new PdoRuntimeException(this.pdo, RdcSwingRdcBundle.getString("NO WRITE PERMISSION"));
        }
        this.pdo = this.isDisposeOnDeleteOrSave() ? this.pdo.persist() : this.pdo.persistTokenLocked();
    }

    public boolean save() {
        block6: {
            if (this.pdoPanel.announceSave()) {
                this.begin(TX_SAVE);
                long editedBy = 0L;
                try {
                    if (this.pdoPanel.prepareSave() && !this.noPersistance) {
                        this.saveObject();
                        this.lastPdo = this.pdo;
                        this.commit();
                        return true;
                    }
                    this.rollback();
                }
                catch (RuntimeException ex) {
                    try {
                        this.rollback();
                    }
                    catch (PersistenceException dbx) {
                        LOGGER.warning("rollback failed", (Throwable)dbx);
                    }
                    if (!this.showErrorOnSave(this.determineRealCause(ex), editedBy)) break block6;
                    Object transData = this.pdo.getTransientData();
                    PersistentDomainObject obj = this.pdo.reload();
                    if (obj == null) break block6;
                    obj.setTransientData(transData);
                    this.setPdo(obj);
                }
            }
        }
        return false;
    }

    protected Throwable determineRealCause(Throwable ex) {
        Throwable t;
        RemoteException remEx = (RemoteException)ExceptionHelper.extractException(RemoteException.class, (boolean)true, (Throwable)ex);
        if (remEx != null && remEx.getCause() instanceof Exception) {
            ex = remEx.getCause();
        }
        if ((t = ExceptionHelper.extractException((boolean)true, (Throwable)ex, (Class[])new Class[]{ValidationFailedException.class, PersistenceException.class})) != null) {
            ex = t;
        }
        return ex;
    }

    protected void showValidationResults(List<ValidationResult> validationResults) {
        this.getTooltipAndErrorPanel().setErrors(this.pdoPanel.createInteractiveErrors(validationResults));
    }

    protected boolean showErrorOnSave(Throwable ex, long editedBy) {
        if (!this.editable) {
            FormError.show((String)MessageFormat.format(RdcSwingRdcBundle.getString("{0} LOST ITS WRITE PERMISSION"), this.pdo.getSingular()));
        } else if (ex instanceof ValidationFailedException) {
            this.showValidationResults(((ValidationFailedException)ex).getResults());
        } else if (ex instanceof ConstraintException) {
            LOGGER.logStacktrace(Logger.Level.WARNING, ex);
            FormError.show((String)MessageFormat.format(RdcSwingRdcBundle.getString("{0} ALREADY EXISTS"), this.pdo.getSingular()));
        } else if (ex instanceof NotFoundException) {
            LOGGER.logStacktrace(Logger.Level.WARNING, ex);
            FormError.show((String)MessageFormat.format(RdcSwingRdcBundle.getString("{0} MODIFIED BY_ANOTHER USER MEANWHILE"), this.pdo.getSingular()));
        } else {
            if (this.pdo.getEditedBy() != editedBy) {
                if (this.pdo.getEditedBy() != 0L) {
                    FormError.show((String)MessageFormat.format(RdcSwingRdcBundle.getString("{0} LOCKED BY {1} MEANWHILE. YOUR LOCK TIMED OUT."), this.pdo.getSingular(), this.pdo.getTokenLockObject()));
                } else {
                    FormError.showException((String)MessageFormat.format(RdcSwingRdcBundle.getString("{0} COULD NOT BE SAVED"), this.pdo.getSingular()), (Throwable)ex, (boolean)false, (Logger)LOGGER);
                }
            } else if (editedBy != 0L) {
                FormError.show((String)MessageFormat.format(RdcSwingRdcBundle.getString("{0} MODIFIED BY ANOTHER USER MEANWHILE. YOUR LOCK TIMED OUT."), this.pdo.getSingular()));
            } else {
                FormError.showException((String)MessageFormat.format(RdcSwingRdcBundle.getString("UNSPECIFIED ERROR WHILE SAVING {0}"), this.pdo.getSingular()), (Throwable)ex, (boolean)false, (Logger)LOGGER);
            }
            return true;
        }
        return false;
    }

    protected void deleteObject() {
        this.determinePermissions();
        if (!this.deletable) {
            throw new PdoRuntimeException(RdcSwingRdcBundle.getString("NO DELETE PERMISSION"));
        }
        this.pdo.delete();
    }

    protected boolean delete() {
        if (this.pdoPanel.announceDelete()) {
            this.begin(TX_DELETE);
            try {
                if (this.pdoPanel.prepareDelete()) {
                    this.deleteObject();
                    this.commit();
                    return true;
                }
                this.rollback();
            }
            catch (RuntimeException e) {
                this.rollback();
            }
        }
        return false;
    }

    protected void begin(String txName) {
        this.txVoucher = this.pdo.getSession().begin(txName);
    }

    protected void commit() {
        this.pdo.getSession().commit(this.txVoucher);
        this.txVoucher = 0L;
    }

    protected void rollback() {
        this.pdo.getSession().rollback(this.txVoucher);
        this.txVoucher = 0L;
    }

    private void updateObjectListIndex() {
        this.linkedPdoIndex = this.linkedPdoList != null && this.pdo != null ? this.linkedPdoList.indexOf(this.pdo) : -1;
    }

    private void disableButtonsIfNoPersistance() {
        if (this.noPersistance) {
            this.previousButton.setVisible(false);
            this.nextButton.setVisible(false);
            this.browserButton.setVisible(false);
            this.deleteButton.setVisible(false);
            this.idButton.setVisible(false);
            this.newButton.setVisible(false);
            this.printButton.setVisible(false);
            this.searchButton.setVisible(false);
            this.securityButton.setVisible(false);
        }
    }

    public void setupButtons() {
        if (this.pdo != null) {
            if (this.linkedPdoList != null && this.linkedPdoList.size() > 1) {
                this.previousButton.setVisible(this.previousButtonAvailable);
                this.nextButton.setVisible(this.nextButtonAvailable);
                this.previousButton.setEnabled(this.linkedPdoIndex > 0);
                this.nextButton.setEnabled(this.linkedPdoIndex < this.linkedPdoList.size() - 1);
            } else {
                this.previousButton.setVisible(false);
                this.nextButton.setVisible(false);
            }
            this.deleteButton.setEnabled(this.deletable && !this.pdo.isNew());
            this.browserButton.setEnabled(this.viewable && !this.pdo.isNew());
            this.saveButton.setEnabled(this.editable);
            this.printButton.setEnabled(this.viewable);
            this.printButton.setVisible(this.printButtonAvailable);
            boolean visible = false;
            try {
                visible = SecurityDialogFactory.getInstance().isDialogAllowed(this.context);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.securityButton.setVisible(visible);
            boolean changeable = this.isChangeable();
            if (this.isModal()) {
                this.newButton.setVisible(changeable && this.newButtonAvailable);
                this.deleteButton.setVisible(changeable && this.deleteButtonAvailable);
                this.searchButton.setVisible(changeable && this.searchButtonAvailable);
                this.idButton.setVisible(changeable && this.idButtonAvailable);
            } else {
                this.newButton.setVisible(this.newButtonAvailable);
                this.deleteButton.setVisible(this.deleteButtonAvailable);
                this.searchButton.setVisible(this.searchButtonAvailable);
                this.idButton.setVisible(this.idButtonAvailable);
                this.newButton.setEnabled(changeable);
                this.searchButton.setEnabled(true);
            }
            this.saveButton.setVisible(changeable && this.saveButtonAvailable);
            this.browserButton.setVisible(this.browserButtonAvailable);
            this.disableButtonsIfNoPersistance();
        } else {
            this.previousButton.setVisible(false);
            this.nextButton.setVisible(false);
            this.securityButton.setVisible(false);
            this.deleteButton.setVisible(false);
            this.browserButton.setVisible(false);
            this.saveButton.setVisible(false);
            this.printButton.setVisible(false);
            this.searchButton.setVisible(false);
            this.idButton.setVisible(false);
            this.newButton.setVisible(false);
        }
        this.closeButton.setEnabled(true);
    }

    private int discardOk() {
        if (!this.editable || !this.areValuesChanged()) {
            return 2;
        }
        return CancelSaveDiscardDialog.getAnswer();
    }

    protected void doClose(ActionEvent evt) {
        if (this.pdoPanel != null) {
            int answer = this.discardOk();
            if (answer == 1) {
                this.doSaveAndDispose(evt);
            } else if (answer == 2 && this.pdoPanel.prepareCancel()) {
                this.clearEditedBy();
                this.lastPdo = this.pdo;
                this.pdo = null;
                this.fireActionPerformed(evt);
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }

    protected boolean doSave(ActionEvent evt) {
        if (this.save()) {
            this.fireActionPerformed(evt);
            if (this.isDisposeOnDeleteOrSave()) {
                this.dispose();
            } else if (this.newAfterSave) {
                this.clearPdo();
            } else {
                this.setPdo(this.getPdo());
            }
            return true;
        }
        return false;
    }

    protected boolean doSaveAndDispose(ActionEvent evt) {
        if (this.doSave(evt)) {
            this.dispose();
            return true;
        }
        return false;
    }

    protected void doPrint(ActionEvent evt) {
        LOGGER.warning("printing not implementated", new Object[0]);
    }

    protected boolean doDelete(ActionEvent evt) {
        boolean result = false;
        if (FormQuestion.yesNo((String)RdcSwingRdcBundle.getString("ARE YOU SURE TO DELETE THIS OBJECT?"))) {
            if (this.delete()) {
                this.fireActionPerformed(evt);
                if (this.isDisposeOnDeleteOrSave()) {
                    this.dispose();
                } else {
                    this.clearPdo();
                }
                result = true;
            } else {
                FormError.show((String)RdcSwingRdcBundle.getString("DELETING OBJECT FAILED!"));
            }
        }
        return result;
    }

    protected void doNew(ActionEvent evt) {
        int answer = this.discardOk();
        if (answer == 1) {
            this.saveButton.doClick();
        } else if (answer == 2 && this.pdoPanel.prepareNew()) {
            this.clearEditedBy();
            this.clearPdo();
            this.fireActionPerformed(evt);
        }
    }

    protected void doSearch(ActionEvent evt) {
        if (this.pdoPanel.prepareSearch()) {
            try {
                PersistentDomainObject<?> newPdo;
                PdoSearchDialog<T> sd = Rdc.createPdoSearchDialog((Component)((Object)this), this.context, this.pdoClass, o -> this.pdoClass.isAssignableFrom(o.getClass()), false, true);
                sd.setMultiSelection(false);
                T oldObject = this.pdo;
                if (this.pdo != null) {
                    if (!this.pdo.isNew()) {
                        this.setKeepChangedValues(true);
                        this.setPdo(Pdo.create(this.pdo), false);
                        this.setKeepChangedValues(false);
                        this.getFormValues();
                    }
                    sd.getPdoSearch().presetSearchCriteria(this.pdo);
                }
                if ((newPdo = sd.showDialog()) != null) {
                    if (!this.setPdo(newPdo)) {
                        this.clearPdo();
                    }
                    this.fireActionPerformed(evt);
                } else {
                    this.setPdo(oldObject);
                }
            }
            catch (Exception ex) {
                FormError.showException((String)RdcSwingRdcBundle.getString("COULD NOT LAUNCH SEARCH DIALOG"), (Throwable)ex);
            }
        }
    }

    protected void clearEditedBy() {
        if (this.pdo != null && !this.pdo.isNew() && this.pdo.isTokenLockedByMe()) {
            this.revokeLock();
        }
    }

    private void checkPopup(InputEvent e) {
        if (e instanceof MouseEvent && ((MouseEvent)e).isPopupTrigger()) {
            Point p = ((MouseEvent)e).getPoint();
            this.copyItem.setEnabled(this.pdo != null && !this.pdo.isNew());
            this.pasteAsCopyItem.setEnabled(this.newButton.isEnabled() && this.newButton.isVisible());
            this.clipboardMenu.show((Component)this.buttonPanel, p.x, p.y);
        }
    }

    private boolean isDragAcceptable(DropTargetDragEvent event) {
        return (event.getDropAction() & 3) != 0 && event.isDataFlavorSupported(this.dndFlavor);
    }

    private boolean isDropAcceptable(DropTargetDropEvent event) {
        return (event.getDropAction() & 3) != 0 && event.isDataFlavorSupported(this.dndFlavor);
    }

    private void initComponents() {
        this.idDialog = new FormDialog((Window)((Object)this));
        this.jLabel1 = new FormLabel();
        this.idNumberField = new LongFormField();
        this.idSearchButton = new FormButton();
        this.idCancelButton = new FormButton();
        this.clipboardMenu = new JPopupMenu();
        this.copyItem = new JMenuItem();
        this.pasteItem = new JMenuItem();
        this.pasteAsCopyItem = new JMenuItem();
        this.dataPanel = new FormPanel();
        this.noAccessPanel = new JPanel();
        this.noAccessLabel = new FormLabel();
        this.noInfoPanel = new JPanel();
        this.jLabel3 = new FormLabel();
        this.buttonPanel = new FormPanel();
        this.searchButton = new FormButton();
        this.newButton = new FormButton();
        this.saveButton = new FormButton();
        this.deleteButton = new FormButton();
        this.printButton = new FormButton();
        this.closeButton = new FormButton();
        this.idButton = new FormButton();
        this.jSeparator1 = new JSeparator();
        this.securityButton = new FormButton();
        this.browserButton = new FormButton();
        this.tipAndErrorPanel = new TooltipAndErrorPanel();
        this.previousButton = new FormButton();
        this.nextButton = new FormButton();
        this.idDialog.setAutoPosition(true);
        this.idDialog.setTitle(RdcSwingRdcBundle.getTranslation("READ OBJECT BY ID"));
        this.idDialog.setModal(true);
        this.idDialog.getContentPane().setLayout(new GridBagLayout());
        this.jLabel1.setText(RdcSwingRdcBundle.getTranslation("ID-NO:"));
        this.idDialog.getContentPane().add((Component)this.jLabel1, new GridBagConstraints());
        this.idNumberField.setAutoSelect(true);
        this.idNumberField.setColumns(10);
        this.idNumberField.setUnsigned(true);
        this.idNumberField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoEditDialog.this.idNumberFieldActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.idDialog.getContentPane().add((Component)this.idNumberField, gridBagConstraints);
        this.idSearchButton.setText(RdcSwingRdcBundle.getTranslation("READ"));
        this.idSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoEditDialog.this.idSearchButtonActionPerformed(evt);
            }
        });
        this.idDialog.getContentPane().add((Component)this.idSearchButton, new GridBagConstraints());
        this.idCancelButton.setText(RdcSwingRdcBundle.getTranslation("CANCEL"));
        this.idCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoEditDialog.this.idCancelButtonActionPerformed(evt);
            }
        });
        this.idDialog.getContentPane().add((Component)this.idCancelButton, new GridBagConstraints());
        this.copyItem.setText(RdcSwingRdcBundle.getString("COPY"));
        this.copyItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoEditDialog.this.copyItemActionPerformed(evt);
            }
        });
        this.clipboardMenu.add(this.copyItem);
        this.pasteItem.setText(RdcSwingRdcBundle.getString("PASTE"));
        this.pasteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoEditDialog.this.pasteItemActionPerformed(evt);
            }
        });
        this.clipboardMenu.add(this.pasteItem);
        this.pasteAsCopyItem.setText(RdcSwingRdcBundle.getString("PASTE AS NEW"));
        this.pasteAsCopyItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoEditDialog.this.pasteAsCopyItemActionPerformed(evt);
            }
        });
        this.clipboardMenu.add(this.pasteAsCopyItem);
        this.setAutoPosition(true);
        this.dataPanel.setLayout((LayoutManager)new CardLayout());
        this.noAccessPanel.setLayout(new BorderLayout());
        this.noAccessLabel.setForeground(Color.red);
        this.noAccessLabel.setHorizontalAlignment(0);
        this.noAccessLabel.setText(RdcSwingRdcBundle.getTranslation("YOU DON'T HAVE PERMISSION TO VIEW THIS KIND OF DATA!"));
        this.noAccessPanel.add((Component)this.noAccessLabel, "Center");
        this.dataPanel.add((Component)this.noAccessPanel, (Object)NO_ACCESS_PANEL);
        this.noInfoPanel.setLayout(new BorderLayout());
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText(RdcSwingRdcBundle.getTranslation("NO FURTHER INFORMATION"));
        this.noInfoPanel.add((Component)this.jLabel3, "Center");
        this.dataPanel.add((Component)this.noInfoPanel, (Object)NO_INFO_PANEL);
        this.getContentPane().add((Component)this.dataPanel, "Center");
        this.buttonPanel.setLayout((LayoutManager)new GridBagLayout());
        this.searchButton.setIcon((Icon)PlafUtilities.getInstance().getIcon(ACTION_SEARCH));
        this.searchButton.setMnemonic('f');
        this.searchButton.setText(RdcSwingRdcBundle.getTranslation("FIND"));
        this.searchButton.setActionCommand(ACTION_SEARCH);
        this.searchButton.setMargin(new Insets(1, 3, 1, 3));
        this.searchButton.setName("find");
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoEditDialog.this.searchButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.buttonPanel.add((Component)this.searchButton, (Object)gridBagConstraints);
        this.newButton.setIcon((Icon)PlafUtilities.getInstance().getIcon(ACTION_NEW));
        this.newButton.setMnemonic('n');
        this.newButton.setText(RdcSwingRdcBundle.getTranslation("NEW"));
        this.newButton.setActionCommand(ACTION_NEW);
        this.newButton.setMargin(new Insets(1, 3, 1, 3));
        this.newButton.setName(ACTION_NEW);
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoEditDialog.this.newButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.buttonPanel.add((Component)this.newButton, (Object)gridBagConstraints);
        this.saveButton.setIcon((Icon)PlafUtilities.getInstance().getIcon(ACTION_SAVE));
        this.saveButton.setMnemonic('s');
        this.saveButton.setText(RdcSwingRdcBundle.getTranslation("SAVE"));
        this.saveButton.setActionCommand(ACTION_SAVE);
        this.saveButton.setMargin(new Insets(1, 3, 1, 3));
        this.saveButton.setName(ACTION_SAVE);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoEditDialog.this.saveButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.buttonPanel.add((Component)this.saveButton, (Object)gridBagConstraints);
        this.deleteButton.setIcon((Icon)PlafUtilities.getInstance().getIcon(ACTION_DELETE));
        this.deleteButton.setMnemonic('d');
        this.deleteButton.setText(RdcSwingRdcBundle.getTranslation("DELETE"));
        this.deleteButton.setActionCommand(ACTION_DELETE);
        this.deleteButton.setMargin(new Insets(1, 3, 1, 3));
        this.deleteButton.setName(ACTION_DELETE);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoEditDialog.this.deleteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.buttonPanel.add((Component)this.deleteButton, (Object)gridBagConstraints);
        this.printButton.setIcon((Icon)PlafUtilities.getInstance().getIcon("print"));
        this.printButton.setMnemonic('p');
        this.printButton.setText(RdcSwingRdcBundle.getTranslation("PRINT"));
        this.printButton.setMargin(new Insets(1, 3, 1, 3));
        this.printButton.setName("print");
        this.printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoEditDialog.this.printButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.buttonPanel.add((Component)this.printButton, (Object)gridBagConstraints);
        this.closeButton.setIcon((Icon)PlafUtilities.getInstance().getIcon("close"));
        this.closeButton.setMnemonic('c');
        this.closeButton.setText(RdcSwingRdcBundle.getTranslation("CANCEL"));
        this.closeButton.setActionCommand(ACTION_CANCEL);
        this.closeButton.setMargin(new Insets(1, 3, 1, 3));
        this.closeButton.setName(ACTION_CANCEL);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoEditDialog.this.closeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 0, 2, 2);
        this.buttonPanel.add((Component)this.closeButton, (Object)gridBagConstraints);
        this.idButton.setText("0");
        this.idButton.setFont(new Font("DialogInput", 1, 12));
        this.idButton.setMargin(new Insets(1, 0, 1, 0));
        this.idButton.setName("objectId");
        this.idButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoEditDialog.this.idButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 0);
        this.buttonPanel.add((Component)this.idButton, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 50, 0, 50);
        this.buttonPanel.add((Component)this.jSeparator1, (Object)gridBagConstraints);
        this.securityButton.setIcon((Icon)PlafUtilities.getInstance().getIcon("security"));
        this.securityButton.setMargin(new Insets(1, 0, 1, 0));
        this.securityButton.setName("security");
        this.securityButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoEditDialog.this.securityButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.buttonPanel.add((Component)this.securityButton, (Object)gridBagConstraints);
        this.browserButton.setIcon((Icon)PlafUtilities.getInstance().getIcon("browser"));
        this.browserButton.setMnemonic('t');
        this.browserButton.setText(RdcSwingRdcBundle.getTranslation("TREE"));
        this.browserButton.setMargin(new Insets(1, 3, 1, 3));
        this.browserButton.setName("tree");
        this.browserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoEditDialog.this.browserButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.buttonPanel.add((Component)this.browserButton, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 0, 2);
        this.buttonPanel.add((Component)((Object)this.tipAndErrorPanel), (Object)gridBagConstraints);
        this.previousButton.setIcon((Icon)PlafUtilities.getInstance().getIcon("up"));
        this.previousButton.setActionCommand(ACTION_PREVIOUS);
        this.previousButton.setMargin(new Insets(1, 3, 1, 3));
        this.previousButton.setName(ACTION_PREVIOUS);
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoEditDialog.this.previousButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.buttonPanel.add((Component)this.previousButton, (Object)gridBagConstraints);
        this.nextButton.setIcon((Icon)PlafUtilities.getInstance().getIcon("down"));
        this.nextButton.setActionCommand(ACTION_NEXT);
        this.nextButton.setMargin(new Insets(1, 3, 1, 3));
        this.nextButton.setName(ACTION_NEXT);
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoEditDialog.this.nextButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.buttonPanel.add((Component)this.nextButton, (Object)gridBagConstraints);
        this.getContentPane().add((Component)this.buttonPanel, "South");
    }

    private void pasteAsCopyItemActionPerformed(ActionEvent evt) {
        try {
            Object droppedObject;
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable trans = clip.getContents(this);
            Object transferData = trans.getTransferData(this.dndFlavor);
            if (transferData instanceof PdoTransferData && (droppedObject = ((PdoTransferData)transferData).getPdo(this.context.getSession())) != null) {
                this.setPdo(droppedObject.createCopyInContext(this.pdo.getDomainContext()));
            }
        }
        catch (Exception e) {
            FormError.showException((String)RdcSwingRdcBundle.getString("COULDN'T INSERT NEW COPY"), (Throwable)e);
        }
    }

    private void copyItemActionPerformed(ActionEvent evt) {
        if (this.pdo != null) {
            try {
                Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
                PdoTransferable<T> trans = new PdoTransferable<T>(this.pdo);
                clip.setContents(trans, trans);
            }
            catch (Exception e) {
                LOGGER.logStacktrace(Logger.Level.WARNING, (Throwable)e);
                FormInfo.show((String)RdcSwingRdcBundle.getString("COULDN'T COPY"));
            }
        }
    }

    private void pasteItemActionPerformed(ActionEvent evt) {
        try {
            Object droppedObject;
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable trans = clip.getContents(this);
            Object transferData = trans.getTransferData(this.dndFlavor);
            if (transferData instanceof PdoTransferData && (droppedObject = ((PdoTransferData)transferData).getPdo(this.context.getSession())) != null) {
                this.setPdo(droppedObject);
            }
        }
        catch (Exception e) {
            LOGGER.logStacktrace(Logger.Level.WARNING, (Throwable)e);
            FormInfo.show((String)RdcSwingRdcBundle.getString("COULDN'T INSERT"));
        }
    }

    private void browserButtonActionPerformed(ActionEvent evt) {
        PdoNavigationDialog<T> d = Rdc.createPdoNavigationDialog((Window)((Object)this), this.pdo, null);
        d.setTitle(MessageFormat.format(RdcSwingRdcBundle.getString("BROWSER FOR {0} IN {1}"), this.pdo, this.pdo.getDomainContext()));
        d.getNaviPanel().getNaviTree().expandTree(2);
        d.pack();
        d.setVisible(true);
    }

    private void securityButtonActionPerformed(ActionEvent evt) {
        SecurityDialogFactory.getInstance().createDialog(this.baseContext, this.pdo.getEffectiveClass(), this.pdo.getId()).showDialog();
    }

    private void idCancelButtonActionPerformed(ActionEvent evt) {
        this.idDialog.dispose();
    }

    private void idSearchButtonActionPerformed(ActionEvent evt) {
        long newId = this.idNumberField.getLongValue();
        if (newId > 0L) {
            PersistentDomainObject reloadedPdo = this.pdo.select(newId);
            if (reloadedPdo != null) {
                this.setPdo(reloadedPdo);
            } else {
                FormError.show((String)RdcSwingRdcBundle.getString("NO OBJECT WITH SUCH AN ID"));
            }
        }
        this.idDialog.dispose();
    }

    private void idNumberFieldActionPerformed(ActionEvent evt) {
        this.idSearchButton.doClick();
    }

    private void idButtonActionPerformed(ActionEvent evt) {
        if (this.pdo != null && !this.isModal()) {
            this.idDialog.pack();
            this.idNumberField.setLongValue(this.pdo.getId());
            this.idNumberField.requestFocusLater();
            this.idDialog.setVisible(true);
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.doClose(evt);
    }

    private void printButtonActionPerformed(ActionEvent evt) {
        this.doPrint(evt);
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        this.doDelete(evt);
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.doSave(evt);
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        this.doNew(evt);
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        this.doSearch(evt);
    }

    private void prevNextHandler(ActionEvent evt, int offset) {
        int answer = this.discardOk();
        if (answer == 1) {
            this.saveButton.doClick();
        } else if (answer == 2 && this.pdoPanel.prepareCancel()) {
            int oldIndex = this.linkedPdoIndex;
            this.clearEditedBy();
            this.clearEditedBy();
            this.clearPdo();
            if (this.linkedPdoList != null) {
                PersistentDomainObject obj;
                this.linkedPdoIndex = oldIndex;
                for (int ndx = this.linkedPdoIndex + offset; !(ndx < 0 || ndx >= this.linkedPdoList.size() || (obj = (PersistentDomainObject)this.linkedPdoList.get(ndx)) != null && this.setPdo(obj)); ndx += offset) {
                }
            }
            this.fireActionPerformed(evt);
        }
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        this.prevNextHandler(evt, 1);
    }

    private void previousButtonActionPerformed(ActionEvent evt) {
        this.prevNextHandler(evt, -1);
    }
}

