/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.rdc;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.List;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.swing.FormDialog;
import org.tentackle.swing.rdc.PdoNavigationPanel;
import org.tentackle.swing.rdc.Rdc;
import org.tentackle.swing.rdc.RdcSwingRdcBundle;
import org.tentackle.swing.rdc.SelectionFilter;

public class PdoNavigationDialog<T extends PersistentDomainObject<T>>
extends FormDialog {
    private final PdoNavigationPanel<T> naviPanel;
    private PersistentDomainObject<?> selectedObject;

    public PdoNavigationDialog(Window owner, List<T> list, SelectionFilter selectionFilter, int buttonMode, boolean showTable) {
        super(owner);
        this.naviPanel = Rdc.createPdoNavigationPanel(list, selectionFilter, buttonMode, showTable);
        this.setup();
    }

    public PdoNavigationDialog(Window owner, List<T> list, SelectionFilter selectionFilter) {
        this(owner, list, selectionFilter, 3, false);
    }

    public PdoNavigationDialog(List<T> list, SelectionFilter selectionFilter, boolean showTable) {
        this((Window)null, list, selectionFilter, 3, showTable);
    }

    public PdoNavigationDialog(List<T> list, SelectionFilter selectionFilter) {
        this((Window)null, list, selectionFilter, 3, false);
    }

    public PdoNavigationDialog(Window owner, T obj, SelectionFilter selectionFilter, int buttonMode, boolean showTable) {
        super(owner);
        this.naviPanel = Rdc.createPdoNavigationPanel(obj, selectionFilter, buttonMode, showTable);
        this.setup();
    }

    public PdoNavigationDialog(Window owner, T obj, SelectionFilter selectionFilter) {
        this(owner, obj, selectionFilter, 3, false);
    }

    public PdoNavigationDialog(T obj, SelectionFilter selectionFilter, boolean showTable) {
        this(null, obj, selectionFilter, 3, showTable);
    }

    public PdoNavigationDialog(T obj, SelectionFilter selectionFilter) {
        this(null, obj, selectionFilter, 3, false);
    }

    public PdoNavigationPanel<T> getNaviPanel() {
        return this.naviPanel;
    }

    public PersistentDomainObject<?> showDialog() {
        this.setVisible(true);
        return this.selectedObject;
    }

    private void setup() {
        this.initComponents();
        this.naviPanel.addActionListener(this::naviPanel_actionPerformed);
        this.getContentPane().add((Component)((Object)this.naviPanel), "Center");
        Class<T> clazz = this.naviPanel.getTableClass();
        if (clazz != null) {
            try {
                this.setTitle(MessageFormat.format(RdcSwingRdcBundle.getString("{0} BROWSER"), Pdo.create(clazz).getSingular()));
            }
            catch (Exception ex) {
                this.setTitle(RdcSwingRdcBundle.getString("BROWSER"));
            }
        }
        this.pack();
    }

    private void naviPanel_actionPerformed(ActionEvent e) {
        this.selectedObject = this.naviPanel.getSelectedObject();
        this.dispose();
    }

    private void initComponents() {
        this.setAutoPosition(true);
        this.setTitle(RdcSwingRdcBundle.getString("BROWSER"));
        this.setModal(true);
        this.pack();
    }
}

