/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.rdc;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import javax.swing.Icon;
import org.tentackle.bind.BindingException;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.misc.ShortLongText;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PdoRuntimeException;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.reflect.ReflectionHelper;
import org.tentackle.swing.FormButton;
import org.tentackle.swing.FormComponent;
import org.tentackle.swing.FormError;
import org.tentackle.swing.FormFieldComponent;
import org.tentackle.swing.FormFieldComponentPanel;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.StringFormField;
import org.tentackle.swing.bind.FormComponentBinding;
import org.tentackle.swing.plaf.PlafUtilities;
import org.tentackle.swing.rdc.PdoEditDialogPool;
import org.tentackle.swing.rdc.PdoSearch;
import org.tentackle.swing.rdc.PdoSearchDialog;
import org.tentackle.swing.rdc.PdoTransferData;
import org.tentackle.swing.rdc.Rdc;
import org.tentackle.swing.rdc.RdcSwingRdcBundle;

public class PdoFieldPanel<T extends PersistentDomainObject<T>>
extends FormFieldComponentPanel
implements DropTargetListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdoFieldPanel.class);
    private PdoSearch<T> pdoSearch;
    protected long linkedId;
    protected T linkedObject;
    private DataFlavor dndFlavor;
    private DropTarget dropTarget;
    private boolean checkExistsEnabled = true;
    private boolean searchRunning;
    private FormButton editButton;
    private StringFormField infoField;
    private FormButton searchButton;

    public PdoFieldPanel() {
        this.initComponents();
        this.setup();
    }

    protected void setup() {
        this.setFormComponent((FormComponent)new StringFormField());
        this.setDropEnabled(true);
        this.loadObject();
    }

    public void setName(String name) {
        super.setName(name);
        if (name != null) {
            ((Component)this.getFormComponent()).setName(name + "/key");
            this.infoField.setName(name + "/info");
            this.editButton.setName(name + "/edit");
            this.searchButton.setName(name + "/search");
        } else {
            ((Component)this.getFormComponent()).setName("key");
            this.infoField.setName("info");
            this.editButton.setName("edit");
            this.searchButton.setName("search");
        }
    }

    public void setCheckExistsEnabled(boolean checkExistsEnabled) {
        this.checkExistsEnabled = checkExistsEnabled;
    }

    public boolean isCheckExistsEnabled() {
        return this.checkExistsEnabled;
    }

    public void setFormComponent(FormComponent comp) {
        FormFieldComponent oldComponent = this.getFormComponent();
        if (oldComponent != null) {
            this.remove((Component)oldComponent);
        }
        super.setFormComponent(comp);
        this.setName(this.getName());
        ((Component)comp).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 114) {
                    if (PdoFieldPanel.this.searchButton.isEnabled()) {
                        PdoFieldPanel.this.searchButton.doClick();
                    }
                } else if (e.getKeyCode() == 113) {
                    if (PdoFieldPanel.this.editButton.isEnabled() && PdoFieldPanel.this.editButton.isVisible()) {
                        PdoFieldPanel.this.runEdit();
                    }
                } else if (e.getKeyChar() != '\uffff') {
                    PdoFieldPanel.this.infoField.clearText();
                }
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 1);
        this.add((Component)comp, gridBagConstraints);
    }

    public void setFormValue(Object obj) {
        FormComponentBinding binding = this.getBinding();
        if (binding != null) {
            try {
                Class clazz = binding.getMember().getType();
                if (PersistentDomainObject.class.isAssignableFrom(clazz)) {
                    if (obj instanceof PersistentDomainObject) {
                        this.setLink(clazz, ((PersistentDomainObject)obj).getDomainContext(), ((PersistentDomainObject)obj).getId());
                    } else {
                        this.setLink(clazz, (DomainContext)binding.getBinder().getBindingProperty(DomainContext.class), 0L);
                    }
                    return;
                }
            }
            catch (Exception ex) {
                throw new BindingException("could not determine type for " + binding, (Throwable)ex);
            }
        }
        super.setFormValue(obj);
    }

    public Object getFormValue() {
        FormComponentBinding binding = this.getBinding();
        if (binding != null) {
            Class clazz;
            try {
                clazz = binding.getMember().getType();
            }
            catch (Exception ex) {
                throw new BindingException("could not determine type for " + binding, (Throwable)ex);
            }
            if (PersistentDomainObject.class.isAssignableFrom(clazz)) {
                try {
                    this.searchRunning = true;
                    T pdo = this.findByKey(clazz, (DomainContext)binding.getBinder().getBindingProperty(DomainContext.class), super.getFormValue());
                    FormUtilities.getInstance().doValidate((FormComponent)this);
                    Object object = this.checkObject(pdo, clazz);
                    return object;
                }
                catch (Exception ex) {
                    throw new BindingException("cannot find object by domain key", (Throwable)ex);
                }
                finally {
                    this.searchRunning = false;
                }
            }
        } else if (this.pdoSearch != null) {
            Class<T> clazz = this.pdoSearch.getPdoClass();
            DomainContext context = this.pdoSearch.getDomainContext();
            if (clazz != null && context != null) {
                try {
                    this.searchRunning = true;
                    Object object = this.checkObject(this.findByKey(clazz, context, super.getFormValue()), clazz);
                    return object;
                }
                catch (Exception ex) {
                    throw new PdoRuntimeException("cannot find object by domain key", (Throwable)ex);
                }
                finally {
                    this.searchRunning = false;
                }
            }
        }
        return super.getFormValue();
    }

    protected Object checkObject(Object object, Class<T> clazz) {
        String text;
        if (object == null && this.checkExistsEnabled && (text = this.getFormComponent().getText()) != null && !text.isEmpty() && this.getFormComponent().wasTransferFocusByEnter()) {
            try {
                this.setErrorMessage(MessageFormat.format(RdcSwingRdcBundle.getString("NO SUCH {0} FOUND"), Pdo.create(clazz).getPlural()));
            }
            catch (Exception ex) {
                this.setErrorMessage(RdcSwingRdcBundle.getString("NO SUCH DATA"));
            }
            this.setErrorOffset(0);
        }
        return object;
    }

    public void setDropEnabled(boolean dropEnabled) {
        if (dropEnabled) {
            this.dropTarget = new DropTarget((Component)this.infoField, this);
            this.dropTarget.setDefaultActions(3);
        } else {
            this.dropTarget = null;
        }
        this.updateInfoFieldDropAndColor();
    }

    public boolean isDropEnabled() {
        return this.dropTarget != null;
    }

    public T findByKey(Class<T> clazz, DomainContext contextDb, Object key) {
        return (T)(key == null ? null : Pdo.create(clazz, (DomainContext)contextDb).findByUniqueDomainKey(key));
    }

    public void setLink(PdoSearch<T> pdoSearch, long linkedId) {
        this.pdoSearch = pdoSearch;
        this.linkedId = 0L;
        this.linkedObject = null;
        if (linkedId != 0L && pdoSearch != null) {
            try {
                this.linkedObject = pdoSearch.createPdo().selectCached(linkedId);
                if (this.linkedObject != null) {
                    this.linkedId = this.linkedObject.getId();
                }
            }
            catch (Exception ex) {
                LOGGER.logStacktrace((Throwable)ex);
            }
        }
        this.loadObject();
    }

    public void setLink(T pdo) {
        if (pdo != null && this.pdoSearch != null && this.pdoSearch.getPdoClass().isAssignableFrom(pdo.getEffectiveClass())) {
            this.setLink(this.pdoSearch, pdo.getId());
        } else {
            this.setLink(this.pdoSearch, 0L);
        }
    }

    public void setLink(Class<T> clazz, DomainContext context, long linkedId, boolean keepPlugin) {
        try {
            if (context != null && clazz != null) {
                if (keepPlugin && this.pdoSearch != null) {
                    this.setLink(this.pdoSearch, linkedId);
                } else {
                    this.setLink(Rdc.createGuiProvider(Pdo.create(clazz, (DomainContext)context)).createPdoSearch(), linkedId);
                }
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setLink(null, 0L);
    }

    public void setLink(Class<T> clazz, DomainContext context, long linkedId) {
        this.setLink(clazz, context, linkedId, false);
    }

    public long getLinkId() {
        if (this.isFireRunning() && this.getBinding() == null) {
            T obj = this.getLink();
            this.linkedId = obj == null ? 0L : obj.getId();
        }
        return this.linkedId;
    }

    public T getLink() {
        if (this.isFireRunning() && this.getBinding() == null) {
            Object obj = this.getFormValue();
            if (obj instanceof PersistentDomainObject) {
                this.setLink((PersistentDomainObject)obj);
            } else {
                this.linkedId = 0L;
                this.linkedObject = null;
            }
        }
        return this.linkedObject;
    }

    public PdoSearch<T> getSearchPlugin() {
        return this.pdoSearch;
    }

    public void setInfoColumns(int col) {
        this.infoField.setColumns(col);
    }

    public int getInfoColumns() {
        return this.infoField.getColumns();
    }

    public void updateCodeAndInfoField(T linkedObject) {
        if (linkedObject instanceof ShortLongText) {
            this.getFormComponent().setText(((ShortLongText)linkedObject).getShortText());
            this.infoField.setText(((ShortLongText)linkedObject).getLongText());
        } else {
            this.getFormComponent().setText(linkedObject.toString());
            this.infoField.setText(Rdc.createGuiProvider(linkedObject).getTreeText());
        }
        this.getFormComponent().clearValueShownModified();
    }

    public void setInfoFieldVisible(boolean visible) {
        this.infoField.setVisible(visible);
    }

    public boolean isInfoFieldVisible() {
        return this.infoField.isVisible();
    }

    public void setChangeable(boolean changeable) {
        super.setChangeable(changeable);
        this.loadObject();
    }

    public void setCellEditorUsage(boolean flag) {
        super.setCellEditorUsage(flag);
        this.editButton.setFocusable(!flag);
        this.searchButton.setFocusable(!flag);
    }

    protected void loadObject() {
        if (this.linkedObject == null) {
            this.infoField.clearText();
            this.getFormComponent().clearText();
            this.linkedId = 0L;
            this.editButton.setEnabled(false);
        } else {
            this.linkedId = this.linkedObject.getId();
            this.updateCodeAndInfoField(this.linkedObject);
            this.editButton.setEnabled(this.isChangeable());
        }
        this.searchButton.setEnabled(this.isChangeable());
        this.updateInfoFieldDropAndColor();
    }

    protected void updateInfoFieldDropAndColor() {
        if (this.dropTarget != null) {
            if (this.isChangeable() && this.linkedId == 0L && this.pdoSearch != null) {
                this.dndFlavor = new DataFlavor(this.pdoSearch.getPdoClass(), ReflectionHelper.getClassBaseName(this.pdoSearch.getPdoClass()));
                this.dropTarget.setActive(true);
                this.infoField.setBackground(PlafUtilities.getInstance().getDropFieldActiveColor());
            } else {
                this.dropTarget.setActive(false);
                this.infoField.setBackground(PlafUtilities.getInstance().getDropFieldInactiveColor());
            }
        } else {
            this.infoField.setBackground(PlafUtilities.getInstance().getTextFieldInactiveBackgroundColor());
        }
    }

    public PdoSearchDialog<T> createSearchDialog() {
        return Rdc.createPdoSearchDialog((Component)((Object)this), this.pdoSearch, o -> this.pdoSearch.getPdoClass().isAssignableFrom(o.getClass()), true, true);
    }

    public void runSearch() {
        if (this.pdoSearch != null && !this.searchRunning) {
            this.pdoSearch.resetSearchCriteria();
            try {
                this.searchRunning = true;
                PersistentDomainObject<?> obj = this.createSearchDialog().showDialog();
                if (obj != null) {
                    this.setLink(obj);
                    if (!this.isCellEditorUsage()) {
                        this.fireValueEntered();
                        this.searchButton.transferFocus();
                    }
                }
            }
            catch (Exception ex) {
                FormError.showException((String)RdcSwingRdcBundle.getString("SEARCH FAILED"), (Throwable)ex);
            }
            finally {
                this.searchRunning = false;
            }
        }
    }

    public void runEdit() {
        if (this.linkedObject != null && PdoEditDialogPool.getInstance().editModal(this.linkedObject) != null) {
            this.loadObject();
            if (!this.isCellEditorUsage() && this.isAutoUpdate()) {
                this.fireValueEntered();
            }
        }
    }

    public void setEditButtonVisible(boolean visible) {
        this.editButton.setVisible(visible);
    }

    public boolean isEditButtonVisible() {
        return this.editButton.isVisible();
    }

    public void setSearchButtonVisible(boolean visible) {
        this.searchButton.setVisible(visible);
    }

    public boolean isSearchButtonVisible() {
        return this.searchButton.isVisible();
    }

    public FormButton getEditButton() {
        return this.editButton;
    }

    public FormButton getSearchButton() {
        return this.searchButton;
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        if (!this.isDragAcceptable(event)) {
            event.rejectDrag();
        } else {
            event.acceptDrag(1);
        }
    }

    @Override
    public void dragExit(DropTargetEvent event) {
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
        if (!this.isDragAcceptable(event)) {
            event.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        if (this.isDropAcceptable(event)) {
            event.acceptDrop(1);
            Transferable trans = event.getTransferable();
            try {
                Object transferData = trans.getTransferData(this.dndFlavor);
                if (transferData instanceof PdoTransferData) {
                    PersistentDomainObject object = this.pdoSearch.createPdo().selectCached(((PdoTransferData)transferData).getId());
                    this.setLink(object);
                    if (this.isAutoUpdate()) {
                        this.fireValueEntered();
                    }
                }
            }
            catch (Exception e) {
                FormError.showException((String)RdcSwingRdcBundle.getString("DROP ERROR:"), (Throwable)e);
            }
            event.dropComplete(true);
        } else {
            event.rejectDrop();
        }
    }

    private boolean isDragAcceptable(DropTargetDragEvent event) {
        return (event.getDropAction() & 3) != 0 && event.isDataFlavorSupported(this.dndFlavor);
    }

    private boolean isDropAcceptable(DropTargetDropEvent event) {
        return (event.getDropAction() & 3) != 0 && event.isDataFlavorSupported(this.dndFlavor);
    }

    private void initComponents() {
        this.editButton = new FormButton();
        this.infoField = new StringFormField();
        this.searchButton = new FormButton();
        this.setToolTipText("");
        this.setLayout(new GridBagLayout());
        this.editButton.setIcon((Icon)PlafUtilities.getInstance().getIcon("edit"));
        this.editButton.setToolTipText(RdcSwingRdcBundle.getString("EDIT"));
        this.editButton.setName("edit");
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoFieldPanel.this.editButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.add((Component)this.editButton, gridBagConstraints);
        this.infoField.setEditable(false);
        this.infoField.setName("info");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.infoField, gridBagConstraints);
        this.searchButton.setIcon((Icon)PlafUtilities.getInstance().getIcon("search"));
        this.searchButton.setToolTipText(RdcSwingRdcBundle.getString("SEARCH"));
        this.searchButton.setName("search");
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoFieldPanel.this.searchButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.add((Component)this.searchButton, gridBagConstraints);
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        this.runSearch();
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        this.runEdit();
    }
}

