/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.rdc.security;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.misc.TrackedList;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PdoUtilities;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.reflect.ReflectionHelper;
import org.tentackle.security.pdo.Security;
import org.tentackle.session.SessionUtilities;
import org.tentackle.swing.AcceptDenyCheckBox;
import org.tentackle.swing.FormDialog;
import org.tentackle.swing.FormError;
import org.tentackle.swing.FormPanel;
import org.tentackle.swing.FormTable;
import org.tentackle.swing.rdc.CancelSaveDiscardDialog;
import org.tentackle.swing.rdc.PdoTablePanel;
import org.tentackle.swing.rdc.Rdc;
import org.tentackle.swing.rdc.security.SecuritySwingRdcBundle;

public class SecurityDialog
extends FormDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityDialog.class);
    public static final String TX_SAVE_RULES = "save rules";
    private static final long serialVersionUID = 7560878743739380186L;
    private final DomainContext context;
    private final Class<?> clazz;
    private final long id;
    private final String className;
    private final int pdoClassId;
    private final PdoTablePanel<Security> clazzPanel;
    private final PdoTablePanel<Security> objectPanel;
    private final TrackedList<Security> clazzList;
    private final TrackedList<Security> objectList;
    private final boolean writeAllowed;
    private FormPanel headerPanel;
    private JTabbedPane topicPane;
    protected JLabel userLabel;

    public SecurityDialog(DomainContext context, Class<?> clazz, final long id) {
        this.context = context;
        this.clazz = clazz;
        this.id = id;
        this.initComponents();
        this.pdoClassId = SessionUtilities.getInstance().getClassId(clazz.getName());
        this.className = this.pdoClassId != 0 ? null : clazz.getName();
        Security sec = (Security)Pdo.create(Security.class, (DomainContext)context);
        this.writeAllowed = sec.isWriteAllowed();
        this.setupUserLabel();
        this.clazzList = this.pdoClassId == 0 ? sec.selectByObjectClass(this.className) : sec.selectByObject(this.pdoClassId, 0L);
        this.clazzPanel = new PdoTablePanel<Security>(Rdc.createGuiProvider(sec).getFormTableEntry(), this.clazzList, true, "securityDialogTable"){

            @Override
            protected Security createPdo() {
                Security sec = (Security)super.createPdo();
                sec.setObjectClassName(SecurityDialog.this.className);
                sec.setObjectClassId(SecurityDialog.this.pdoClassId);
                return sec;
            }
        };
        this.configureTable(this.clazzPanel.getFormTable());
        this.clazzPanel.addActionListener(e -> {
            if (e.getActionCommand() != null && e.getActionCommand().equals("save")) {
                this.doSave();
            } else {
                this.doCancel();
            }
        });
        String tabName = ReflectionHelper.getClassBaseName(clazz);
        if (PersistentDomainObject.class.isAssignableFrom(clazz)) {
            try {
                tabName = ((PersistentDomainObject)clazz.newInstance()).getSingular();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.topicPane.addTab(tabName, (Component)((Object)this.clazzPanel));
        if (id != 0L && this.pdoClassId != 0) {
            this.objectList = sec.selectByObject(this.pdoClassId, id);
            this.objectPanel = new PdoTablePanel<Security>(Rdc.createGuiProvider(sec).getFormTableEntry(), this.objectList, true, "securityDialogTable"){

                @Override
                protected Security createPdo() {
                    Security sec = (Security)super.createPdo();
                    sec.setObjectClassId(SecurityDialog.this.pdoClassId);
                    sec.setObjectId(id);
                    return sec;
                }
            };
            this.configureTable(this.objectPanel.getFormTable());
            this.objectPanel.addActionListener(e -> {
                if (e.getActionCommand() != null && e.getActionCommand().equals("save")) {
                    this.doSave();
                } else {
                    this.doCancel();
                }
            });
            tabName = this.className + "[" + id + "]";
            try {
                tabName = Pdo.create(clazz, (DomainContext)context).selectCached(id).toString();
            }
            catch (Exception e2) {
                LOGGER.severe("could not determine tabName", (Throwable)e2);
            }
            this.topicPane.addTab(tabName, (Component)((Object)this.objectPanel));
        } else {
            this.objectList = null;
            this.objectPanel = null;
        }
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public DomainContext getDomainContext() {
        return this.context;
    }

    public boolean isWriteAllowed() {
        return this.writeAllowed;
    }

    protected void setupUserLabel() {
        this.userLabel.setText(MessageFormat.format(SecuritySwingRdcBundle.getString("YOU ARE LOGGED IN AS {0}"), this.context.getSessionInfo().getUserName()));
    }

    public void showDialog() {
        this.setFormValues();
        this.saveValues();
        this.pack();
        this.setVisible(true);
    }

    protected boolean saveRules() {
        long txVoucher = this.context.getSession().begin(TX_SAVE_RULES);
        try {
            if (this.clazzList.isSomeRemoved()) {
                PdoUtilities.getInstance().deleteCollection(this.clazzList.getRemovedObjects());
            }
            int prioIndex = 0;
            for (Security sec : this.clazzList) {
                sec.setObjectClassName(this.className);
                sec.setObjectId(0L);
                sec.setPriority(prioIndex++);
                if (!sec.isModified()) continue;
                sec.save();
            }
            if (this.objectList != null) {
                if (this.objectList.isSomeRemoved()) {
                    PdoUtilities.getInstance().deleteCollection(this.objectList.getRemovedObjects());
                }
                prioIndex = 0;
                for (Security sec : this.objectList) {
                    sec.setPriority(prioIndex++);
                    sec.setObjectClassName(this.className);
                    sec.setObjectId(this.id);
                    if (!sec.isModified()) continue;
                    sec.save();
                }
            }
            this.context.getSession().commit(txVoucher);
            return true;
        }
        catch (RuntimeException e) {
            this.context.getSession().rollback(txVoucher);
            LOGGER.logStacktrace(Logger.Level.WARNING, (Throwable)e);
            return false;
        }
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.doCancel();
            return;
        }
        super.processWindowEvent(e);
    }

    public void triggerValuesChanged() {
        super.triggerValuesChanged();
        boolean enabled = this.areValuesChanged() && this.writeAllowed;
        this.clazzPanel.getSaveButton().setEnabled(enabled);
        if (this.objectPanel != null) {
            this.objectPanel.getSaveButton().setEnabled(enabled);
        }
    }

    public void saveValues() {
        super.saveValues();
        this.clazzPanel.getSaveButton().setEnabled(false);
        if (this.objectPanel != null) {
            this.objectPanel.getSaveButton().setEnabled(false);
        }
    }

    protected void configureTable(FormTable<Security> table) {
        table.setDefaultRenderer(Boolean.class, AcceptDenyCheckBox.getTableCellRenderer());
        table.setDefaultEditor(Boolean.class, AcceptDenyCheckBox.getTableCellEditor());
        table.setSurrendersFocusOnKeystroke(true);
        table.setCellTraversal(25);
    }

    private void doSave() {
        if (!this.saveRules()) {
            FormError.show((String)SecuritySwingRdcBundle.getString("ERROR SAVING RULES"));
        } else {
            this.dispose();
        }
    }

    private void doCancel() {
        if (this.clazzPanel.isDataChanged() || this.objectPanel != null && this.objectPanel.isDataChanged()) {
            int answer = CancelSaveDiscardDialog.getAnswer();
            if (answer == 2) {
                this.dispose();
            } else if (answer == 1) {
                this.doSave();
            }
        } else {
            this.dispose();
        }
    }

    private void initComponents() {
        this.headerPanel = new FormPanel();
        this.userLabel = new JLabel();
        this.topicPane = new JTabbedPane();
        this.setAutoPosition(true);
        this.setHelpURL("#securitymanager");
        this.setTitle(SecuritySwingRdcBundle.getString("SECURITY RULES"));
        this.setModal(true);
        this.headerPanel.setLayout((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 20);
        this.headerPanel.add((Component)this.userLabel, (Object)gridBagConstraints);
        this.getContentPane().add((Component)this.headerPanel, "North");
        this.getContentPane().add((Component)this.topicPane, "Center");
        this.pack();
    }
}

