/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.rdc;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.swing.rdc.PdoTransferData;

public class PdoTransferable<T extends PersistentDomainObject<T>>
implements Transferable,
ClipboardOwner {
    private T object;
    private DataFlavor objectFlavor;
    private final List<T> objectList;
    private DataFlavor[] flavors;
    public static final DataFlavor PDO_FLAVOR = new DataFlavor(PersistentDomainObject.class, "PDO");
    public static final DataFlavor PDO_LIST_FLAVOR = new DataFlavor(List.class, "PDO-List");

    public PdoTransferable(T pdo) {
        this.object = pdo;
        this.objectList = new ArrayList<T>();
        this.objectList.add(pdo);
        this.objectFlavor = new DataFlavor(pdo.getEffectiveClass(), pdo.getClassBaseName());
        this.flavors = new DataFlavor[]{DataFlavor.stringFlavor, PDO_FLAVOR, PDO_LIST_FLAVOR, this.objectFlavor};
    }

    public PdoTransferable(Collection<?> objects) {
        this.objectList = new ArrayList<T>();
        if (objects != null && objects.size() > 0) {
            Iterator<?> iter = objects.iterator();
            boolean first = true;
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof PersistentDomainObject)) continue;
                this.objectList.add((PersistentDomainObject)obj);
                DataFlavor flavor = new DataFlavor(obj.getClass(), ((PersistentDomainObject)obj).getClassBaseName());
                if (!first) continue;
                this.object = (PersistentDomainObject)obj;
                this.objectFlavor = flavor;
                first = false;
            }
            this.flavors = new DataFlavor[]{DataFlavor.stringFlavor, PDO_FLAVOR, PDO_LIST_FLAVOR, this.objectFlavor};
        }
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flv) {
        for (DataFlavor flavor : this.flavors) {
            if (!flv.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flv) throws UnsupportedFlavorException {
        if (flv.equals(PDO_FLAVOR) || flv.equals(this.objectFlavor)) {
            return new PdoTransferData<T>(this.object);
        }
        if (flv.equals(PDO_LIST_FLAVOR)) {
            ArrayList<PdoTransferData<PersistentDomainObject>> transferList = new ArrayList<PdoTransferData<PersistentDomainObject>>();
            for (PersistentDomainObject pdo : this.objectList) {
                transferList.add(new PdoTransferData<PersistentDomainObject>(pdo));
            }
            return transferList;
        }
        if (flv.equals(DataFlavor.stringFlavor)) {
            return this.object.toString();
        }
        throw new UnsupportedFlavorException(flv);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

