/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.rdc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.RowSorter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.tentackle.misc.ObjectFilter;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.swing.FormButton;
import org.tentackle.swing.FormPanel;
import org.tentackle.swing.FormRadioButton;
import org.tentackle.swing.FormTable;
import org.tentackle.swing.FormTableEntry;
import org.tentackle.swing.FormTableModel;
import org.tentackle.swing.FormTableSorter;
import org.tentackle.swing.FormTableUtilityPopup;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.SumFormTableEntry;
import org.tentackle.swing.plaf.PlafUtilities;
import org.tentackle.swing.rdc.PdoEditDialog;
import org.tentackle.swing.rdc.PdoEditDialogPool;
import org.tentackle.swing.rdc.PdoTableCellRenderer;
import org.tentackle.swing.rdc.PdoTransferable;
import org.tentackle.swing.rdc.PdoTree;
import org.tentackle.swing.rdc.PdoTreeObject;
import org.tentackle.swing.rdc.Rdc;
import org.tentackle.swing.rdc.RdcSwingRdcBundle;
import org.tentackle.swing.rdc.SelectionFilter;

public class PdoNavigationPanel<T extends PersistentDomainObject<T>>
extends FormPanel
implements KeyListener {
    public static final int SHOW_CANCEL = 1;
    public static final int SHOW_SELECT = 2;
    public static final int SHOW_CLOSE = 4;
    public static final int SHOW_BUTTONS = 3;
    public static final int SHOW_NOBUTTON = 0;
    public static final String ACTION_SELECT = "select";
    public static final String ACTION_CANCEL = "cancel";
    public static final String ACTION_CLOSE = "close";
    private static final long serialVersionUID = -5490593382006669760L;
    private ViewMode viewMode;
    private List<T> list;
    private T templateProvider;
    private SelectionFilter selectionFilter;
    private int buttonMode;
    private PersistentDomainObject<?> selectedObject;
    private List<PersistentDomainObject<?>> selectedObjects;
    private boolean disposeKeyEnabled;
    private int treeSelectionMode = 4;
    private int listSelectionMode = 2;
    private PdoTree naviTree;
    private boolean naviTreeUpdated;
    private ObjectFilter<T> treeFilter;
    private Class<T> tableClass;
    private FormTable<T> naviTable;
    private boolean naviTableUpdated;
    private FormTableSorter<T> naviSorter;
    private FormTableModel<T> naviModel;
    private boolean packed;
    private boolean autoPack = true;
    private String tableName;
    private String tableIntro;
    private String tableTitle;
    private ButtonGroup buttonGroup1;
    private JPanel buttonPanel;
    private FormButton cancelButton;
    private FormButton closeButton;
    private JButton cutSelectedButton;
    private JLabel jLabel1;
    private JScrollPane naviScroll;
    private JLabel rowCountLabel;
    private FormButton selectButton;
    private FormRadioButton sortBox;
    private JToggleButton sumButton;
    private JToggleButton tableViewButton;
    private JToggleButton treeViewButton;
    private FormPanel viewButtonPanel;

    public PdoNavigationPanel(List<T> list, SelectionFilter selectionFilter, int buttonMode, boolean showTable, String tableName) {
        this.setup(list, selectionFilter, buttonMode, showTable, tableName);
    }

    public PdoNavigationPanel(List<T> list, SelectionFilter selectionFilter, int buttonMode, boolean showTable) {
        this(list, selectionFilter, buttonMode, showTable, (String)null);
    }

    public PdoNavigationPanel(List<T> list, SelectionFilter selectionFilter) {
        this(list, selectionFilter, 3, false);
    }

    public PdoNavigationPanel(List<T> list) {
        this(list, (SelectionFilter)null, 3, false);
    }

    public PdoNavigationPanel(T obj, SelectionFilter selectionFilter, int buttonMode, boolean showTable, String tableName) {
        ArrayList<T> objList = new ArrayList<T>();
        objList.add(obj);
        this.setup(objList, selectionFilter, buttonMode, showTable, tableName);
    }

    public PdoNavigationPanel(T obj, SelectionFilter selectionFilter, int buttonMode, boolean showTable) {
        this(obj, selectionFilter, buttonMode, showTable, null);
    }

    public PdoNavigationPanel(T obj, SelectionFilter selectionFilter) {
        this(obj, selectionFilter, 3, false);
    }

    public PdoNavigationPanel(T obj) {
        this(obj, null, 3, false);
    }

    public PdoNavigationPanel() {
        this((T)new ArrayList(), null, 3, false, null);
    }

    public void setTableIntro(String tableIntro) {
        this.tableIntro = tableIntro;
    }

    public String getTableIntro() {
        return this.tableIntro;
    }

    public void setTableTitle(String tableTitle) {
        this.tableTitle = tableTitle;
    }

    public String getTableTitle() {
        return this.tableTitle;
    }

    public Class<T> getTableClass() {
        return this.tableClass;
    }

    public SelectionFilter getSelectionFilter() {
        return this.selectionFilter;
    }

    public void setTreeFilter(ObjectFilter<T> treeFilter) {
        this.treeFilter = treeFilter;
        if (this.viewMode == ViewMode.TREE) {
            this.listUpdated();
        }
    }

    public ObjectFilter<T> getTreeFilter() {
        return this.treeFilter;
    }

    public void setPopupEnabled(boolean enabled) {
        this.naviTree.setPopupEnabled(enabled);
    }

    public boolean isPopupEnabled() {
        return this.naviTree.isPopupEnabled();
    }

    public void setViewModeButtonsVisible(boolean visible) {
        this.treeViewButton.setVisible(visible);
        this.tableViewButton.setVisible(visible);
    }

    public boolean isViewModeButtonsVisible() {
        return this.treeViewButton.isVisible();
    }

    public void requestFocusForFirstItem() {
        if (this.list != null && !this.list.isEmpty()) {
            if (this.viewMode == ViewMode.TABLE) {
                this.naviTable.setSelectedRow(0);
                this.naviTable.scrollToCell(0, 0);
                EventQueue.invokeLater(() -> {
                    if (this.naviTable.isVisible()) {
                        this.naviTable.requestFocus();
                    }
                });
            } else if (this.viewMode == ViewMode.TREE) {
                this.naviTree.requestFocusForFirstItem();
            }
        }
    }

    public void scrollToFirstItem() {
        if (this.list != null && !this.list.isEmpty()) {
            if (this.naviTable != null) {
                this.naviTable.scrollToCell(0, 0);
            }
            if (this.naviTree != null) {
                this.naviTree.scrollRowToVisible(0);
            }
        }
    }

    public List<T> getObjects() {
        return this.list;
    }

    public void setObjects(List<T> list, ViewMode viewMode) {
        this.list = list;
        this.cutSelectedButton.setEnabled(false);
        if (list == null || list.isEmpty()) {
            this.treeViewButton.setEnabled(false);
            this.tableViewButton.setEnabled(false);
        } else {
            if (this.tableClass == null) {
                this.determineTableClass(viewMode == ViewMode.TABLE);
            }
            this.treeViewButton.setEnabled(true);
            this.tableViewButton.setEnabled(true);
        }
        this.clearSelection();
        if (this.viewMode == null && viewMode == null) {
            viewMode = ViewMode.TREE;
        }
        if (viewMode != null) {
            this.showView(viewMode, true);
            if (this.naviSorter != null && this.sumButton.isVisible() && this.sumButton.isSelected()) {
                this.naviSorter.setSumEntry((FormTableEntry)new SumFormTableEntry(this.naviModel));
            }
        } else {
            this.listUpdated();
            this.scrollToFirstItem();
        }
    }

    public void setObjects(List<T> list, boolean rebuildView) {
        this.setObjects(list, rebuildView ? this.viewMode : null);
    }

    public void setObjects(List<T> list) {
        this.setObjects(list, null);
    }

    public T getTemplateProvider() {
        return this.templateProvider;
    }

    public void setTemplateProvider(T templateProvider) {
        this.templateProvider = templateProvider;
    }

    protected int getModelIndex(int viewRow) {
        int modelRow = viewRow;
        RowSorter rowSorter = this.naviTable.getRowSorter();
        if (rowSorter != null && viewRow >= 0 && viewRow < rowSorter.getViewRowCount()) {
            modelRow = rowSorter.convertRowIndexToModel(modelRow);
        }
        if (this.naviSorter != null) {
            modelRow = this.naviSorter.getModelIndex(modelRow);
        }
        return modelRow;
    }

    protected int getViewIndex(int modelRow) {
        int viewRow = this.naviSorter != null ? this.naviSorter.getMappedIndex(modelRow) : modelRow;
        RowSorter rowSorter = this.naviTable.getRowSorter();
        if (rowSorter != null && viewRow >= 0 && viewRow < rowSorter.getModelRowCount()) {
            viewRow = rowSorter.convertRowIndexToView(viewRow);
        }
        return viewRow;
    }

    public ViewMode getViewMode() {
        return this.viewMode;
    }

    public boolean isAutoPack() {
        return this.autoPack;
    }

    public void setAutoPack(boolean autoPack) {
        this.autoPack = autoPack;
    }

    public void setButtonMode(int buttonMode) {
        this.buttonMode = buttonMode;
        this.selectButton.setVisible((buttonMode & 2) != 0);
        this.cancelButton.setVisible((buttonMode & 1) != 0);
        this.closeButton.setVisible((buttonMode & 4) != 0);
    }

    public int getButtonMode() {
        return this.buttonMode;
    }

    public void setCancelButtonVisible(boolean visible) {
        this.buttonMode = visible ? this.buttonMode | 1 : this.buttonMode & 0xFFFFFFFE;
        this.cancelButton.setVisible(visible);
    }

    public boolean isCancelButtonVisible() {
        return (this.buttonMode & 1) != 0;
    }

    public void setSelectButtonVisible(boolean visible) {
        this.buttonMode = visible ? this.buttonMode | 2 : this.buttonMode & 0xFFFFFFFD;
        this.selectButton.setVisible(visible);
    }

    public boolean isSelectButtonVisible() {
        return (this.buttonMode & 2) != 0;
    }

    public void setCloseButtonVisible(boolean visible) {
        this.buttonMode = visible ? this.buttonMode | 4 : this.buttonMode & 0xFFFFFFFB;
        this.closeButton.setVisible(visible);
    }

    public boolean isCloseButtonVisible() {
        return (this.buttonMode & 4) != 0;
    }

    public FormTable<T> createTable() {
        FormTable<?> table = Rdc.createFormTable();
        table.setDragEnabled(true);
        table.setAutoResizeMode(0);
        table.setCreateDefaultColumnsFromPreferences(true);
        table.setEnterActionEnabled(true);
        table.setDefaultRenderer(PersistentDomainObject.class, (TableCellRenderer)((Object)new PdoTableCellRenderer()));
        table.addActionListener(this::naviTable_actionPerformed);
        table.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.naviTable_valueChanged(e);
            }
        });
        table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                PdoNavigationPanel.this.updateSumButton();
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
                PdoNavigationPanel.this.updateSumButton();
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                PersistentDomainObject obj = PdoNavigationPanel.this.getFirstSelectedObjectInTable();
                if (obj != null && e.isControlDown()) {
                    switch (keyCode) {
                        case 67: {
                            try {
                                Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
                                PdoTransferable<PersistentDomainObject> trans = new PdoTransferable<PersistentDomainObject>(obj);
                                clip.setContents(trans, trans);
                            }
                            catch (Exception exception) {}
                            break;
                        }
                        case 69: {
                            PdoNavigationPanel.this.editObjectInTable(true);
                            break;
                        }
                        case 78: {
                            PdoNavigationPanel.this.editObjectInTable(false);
                        }
                    }
                    e.consume();
                }
            }
        });
        if (this.disposeKeyEnabled) {
            table.addKeyListener((KeyListener)this);
        }
        return table;
    }

    public PdoTree createTree() {
        PdoTree tree = Rdc.createPdoTree();
        tree.addActionListener(this::naviTree_actionPerformed);
        tree.addTreeSelectionListener(this::naviTree_valueChanged);
        tree.getSelectionModel().setSelectionMode(this.treeSelectionMode);
        return tree;
    }

    public void setup(List<T> list, SelectionFilter selectionFilter, int buttonMode, boolean showTable, String tableName) {
        this.list = list;
        this.selectionFilter = selectionFilter;
        this.tableName = tableName;
        this.setBindable(false);
        this.naviTree = this.createTree();
        this.naviTable = this.createTable();
        this.tableClass = null;
        this.viewMode = null;
        this.initComponents();
        if (selectionFilter == null) {
            buttonMode = 0;
        }
        this.setButtonMode(buttonMode);
        this.selectedObject = null;
        this.selectedObjects = null;
        this.selectButton.setEnabled(false);
        this.cutSelectedButton.setEnabled(false);
        this.sumButton.setVisible(false);
        this.determineTableClass(showTable);
        this.packed = true;
        this.showView(showTable ? ViewMode.TABLE : ViewMode.TREE, false);
        this.packed = false;
    }

    public FormButton getCancelButton() {
        return this.cancelButton;
    }

    public FormButton getSelectButton() {
        return this.selectButton;
    }

    public void setListSelectionMode(int mode) {
        this.listSelectionMode = mode;
        switch (mode) {
            case 0: {
                this.treeSelectionMode = 1;
                break;
            }
            case 2: {
                this.treeSelectionMode = 4;
                break;
            }
            case 1: {
                this.treeSelectionMode = 2;
            }
        }
        this.applySelectionMode();
    }

    public void setTreeSelectionMode(int mode) {
        this.treeSelectionMode = mode;
        switch (mode) {
            case 1: {
                this.listSelectionMode = 0;
                break;
            }
            case 4: {
                this.listSelectionMode = 2;
                break;
            }
            case 2: {
                this.listSelectionMode = 1;
            }
        }
        this.applySelectionMode();
    }

    public PdoTree getNaviTree() {
        return this.naviTree;
    }

    public FormTable<T> getNaviTable() {
        return this.naviTable;
    }

    public void clearSelection() {
        if (this.naviTable != null) {
            this.naviTable.clearSelection();
        }
        if (this.naviTree != null) {
            this.naviTree.clearSelection();
        }
    }

    public void listUpdated() {
        if (this.viewMode == ViewMode.TABLE) {
            SumFormTableEntry sumEntry;
            this.naviModel.listChanged(this.list);
            this.naviTableUpdated = true;
            this.naviTreeUpdated = false;
            if (this.naviSorter != null && (sumEntry = (SumFormTableEntry)this.naviSorter.getSumEntry()) != null) {
                sumEntry.sumUp(this.naviModel);
                this.naviSorter.setSumEntry((FormTableEntry)sumEntry);
            }
        } else if (this.viewMode == ViewMode.TREE) {
            this.buildTree();
            this.naviTableUpdated = false;
            this.naviTreeUpdated = true;
        }
        this.updateRowCountLabel();
        this.updateSumButton();
    }

    public void addSelectionInterval(int firstIndex, int lastIndex) {
        int i;
        if (this.naviTable != null) {
            for (i = firstIndex; i <= lastIndex; ++i) {
                int row = this.getViewIndex(i);
                this.naviTable.getSelectionModel().addSelectionInterval(row, row);
            }
        }
        for (i = firstIndex; i <= lastIndex; ++i) {
            this.naviTree.addSelectionRow(i);
        }
    }

    public void removeSelectionInterval(int firstIndex, int lastIndex) {
        int i;
        if (this.naviTable != null) {
            for (i = firstIndex; i <= lastIndex; ++i) {
                int row = this.getViewIndex(i);
                this.naviTable.getSelectionModel().removeSelectionInterval(row, row);
            }
        }
        for (i = firstIndex; i <= lastIndex; ++i) {
            this.naviTree.removeSelectionRow(i);
        }
    }

    public void scrollToIndex(int index) {
        if (this.viewMode == ViewMode.TABLE) {
            if (this.naviTable != null) {
                int row = this.getViewIndex(index);
                this.naviTable.scrollToCell(row, 0);
                this.naviTable.requestFocusInWindow();
            }
        } else if (this.viewMode == ViewMode.TREE) {
            this.naviTree.scrollRowToVisible(index);
            this.naviTree.requestFocusInWindow();
        }
    }

    public void setDisposeKeyEnabled(boolean enabled) {
        if (enabled != this.disposeKeyEnabled) {
            if (!enabled) {
                this.naviTree.removeKeyListener(this);
                this.naviTable.removeKeyListener((KeyListener)this);
            } else {
                this.naviTree.addKeyListener(this);
                this.naviTable.addKeyListener((KeyListener)this);
            }
            this.disposeKeyEnabled = enabled;
        }
    }

    public boolean isDisposeKeyEnabled() {
        return this.disposeKeyEnabled;
    }

    public synchronized void addListSelectionListener(ListSelectionListener listener) {
        this.listenerList.add(ListSelectionListener.class, listener);
    }

    public synchronized void removeListSelectionListener(ListSelectionListener listener) {
        this.listenerList.remove(ListSelectionListener.class, listener);
    }

    public PersistentDomainObject<?> getSelectedObject() {
        return this.selectedObject;
    }

    public List<PersistentDomainObject<?>> getSelectedObjects() {
        return this.selectedObjects;
    }

    private void determineTableClass(boolean showTable) {
        if (this.list != null) {
            try {
                for (PersistentDomainObject pdo : this.list) {
                    if (this.tableClass == null) {
                        this.tableClass = pdo.getEffectiveClass();
                        continue;
                    }
                    if (this.tableClass.equals(pdo.getClass())) continue;
                    this.tableClass = null;
                    break;
                }
            }
            catch (Exception e) {
                this.tableClass = null;
            }
        }
        if (this.tableClass != null) {
            this.viewButtonPanel.setVisible(true);
            if (showTable) {
                this.tableViewButton.setSelected(true);
                this.treeViewButton.setSelected(false);
            } else {
                this.treeViewButton.setSelected(true);
                this.tableViewButton.setSelected(false);
            }
        } else {
            this.viewButtonPanel.setVisible(false);
        }
    }

    private void updateRowCountLabel() {
        if (this.list != null) {
            this.rowCountLabel.setText("" + this.list.size());
        } else {
            this.rowCountLabel.setText(null);
        }
    }

    private void applySelectionMode() {
        this.naviTable.setSelectionMode(this.listSelectionMode);
        this.naviTree.getSelectionModel().setSelectionMode(this.treeSelectionMode);
        this.cutSelectedButton.setVisible(this.listSelectionMode != 0);
    }

    private void fireActionPerformed(String action) {
        this.fireActionPerformed(new ActionEvent(this, 1001, action));
    }

    private void fireValueChanged() {
        if (this.viewMode == ViewMode.TREE || this.viewMode == ViewMode.TABLE) {
            Object[] listeners = this.listenerList.getListenerList();
            ListSelectionEvent e = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ListSelectionListener.class) continue;
                if (e == null) {
                    e = new ListSelectionEvent(this.viewMode == ViewMode.TREE ? this.naviTree : this.naviTable, 0, this.selectedObjects == null ? -1 : this.selectedObjects.size() - 1, false);
                }
                ((ListSelectionListener)listeners[i + 1]).valueChanged(e);
            }
        }
    }

    private boolean addToSelectedObjects(T obj) {
        if (this.isObjectAllowed(obj)) {
            this.selectedObject = obj;
            if (this.selectedObjects == null) {
                this.selectedObjects = new ArrayList();
            }
            this.selectedObjects.add(this.selectedObject);
            return true;
        }
        return false;
    }

    private boolean isObjectAllowed(Object obj) {
        return this.selectionFilter != null && this.selectionFilter.isSelectable(obj);
    }

    private void naviTree_actionPerformed(ActionEvent e) {
        if (this.selectedObject != null && this.selectButton.isVisible() && this.selectButton.isEnabled()) {
            this.selectButton.doClick();
        } else if (e.getActionCommand().equals("enter")) {
            this.naviTree.showPopup();
        }
    }

    private void naviTree_valueChanged(TreeSelectionEvent e) {
        TreePath[] paths = this.naviTree.getSelectionPaths();
        this.selectedObject = null;
        this.selectedObjects = null;
        int enableCut = 0;
        if (paths != null) {
            for (TreePath path : paths) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object obj = ((PdoTreeObject)node.getUserObject()).getObject();
                if (!(obj instanceof PersistentDomainObject)) continue;
                this.addToSelectedObjects((PersistentDomainObject)obj);
                if (path.getPathCount() != 2) continue;
                ++enableCut;
            }
        }
        this.cutSelectedButton.setEnabled(enableCut > 1);
        this.fireValueChanged();
        this.selectButton.setEnabled(this.selectedObject != null);
    }

    private int findRowInModel(T object) {
        return object == null ? -1 : this.list.indexOf(object);
    }

    private T getFirstSelectedObjectInTable() {
        int row = this.getModelIndex(this.naviTable.getSelectedRow());
        return (T)(row >= 0 ? (PersistentDomainObject)this.list.get(row) : null);
    }

    protected boolean isObjectEditedModal() {
        return FormUtilities.getInstance().isParentWindowModal((Component)((Object)this));
    }

    protected void editObjectInTable(boolean changeable) {
        T obj = this.getFirstSelectedObjectInTable();
        if (obj != null) {
            if (this.isObjectEditedModal()) {
                PdoEditDialogPool.getInstance().editModal(obj);
            } else {
                PdoEditDialog<T> d = PdoEditDialogPool.getInstance().useNonModalDialog(obj, changeable, true);
                d.setLinkedPdoList(this.list);
                d.addActionListener(e -> {
                    if (e.getActionCommand() != null) {
                        switch (e.getActionCommand()) {
                            case "save": {
                                int modelRow;
                                Object obj1 = d.getLastPdo();
                                if (!obj1.isNew()) {
                                    obj1 = obj1.reload();
                                }
                                if (obj1 == null || (modelRow = this.findRowInModel(obj1)) < 0 || modelRow >= this.list.size()) break;
                                this.list.set(modelRow, obj1);
                                this.naviModel.listUpdated(modelRow, modelRow);
                                break;
                            }
                            case "delete": {
                                int modelRow;
                                Object obj2 = d.getLastPdo();
                                if (obj2 == null || (modelRow = this.findRowInModel(obj2)) < 0 || modelRow >= this.list.size()) break;
                                this.naviModel.listDeleted(modelRow, modelRow);
                                this.list.remove(modelRow);
                                break;
                            }
                            case "previous": {
                                int modelRow = this.findRowInModel(d.getLastPdo());
                                if (modelRow <= 0 || modelRow > this.list.size()) break;
                                this.naviTable.setSelectedRow(modelRow - 1);
                                break;
                            }
                            case "next": {
                                int modelRow = this.findRowInModel(d.getLastPdo());
                                if (modelRow < 0 || modelRow >= this.list.size() - 1) break;
                                this.naviTable.setSelectedRow(modelRow + 1);
                            }
                        }
                    }
                });
            }
        }
    }

    private void naviTable_actionPerformed(ActionEvent e) {
        if (this.selectionFilter != null) {
            if (this.selectedObject != null) {
                this.selectButton.doClick();
            }
        } else {
            this.editObjectInTable(true);
        }
    }

    private void naviTable_valueChanged(ListSelectionEvent e) {
        int[] rows = this.naviTable.getSelectedRows();
        this.selectedObject = null;
        this.selectedObjects = null;
        int enableCut = 0;
        for (int i = 0; i < rows.length; ++i) {
            int row = rows[i];
            if (row < 0 || row >= this.list.size()) continue;
            this.addToSelectedObjects((PersistentDomainObject)this.list.get(this.getModelIndex(row)));
            ++enableCut;
        }
        this.cutSelectedButton.setEnabled(enableCut > 1);
        this.fireValueChanged();
        this.selectButton.setEnabled(this.selectedObject != null);
    }

    private void updateSumButton() {
        boolean sumUpEnabled = false;
        if (this.list != null && !this.list.isEmpty() && this.naviModel != null) {
            FormTableEntry template = this.naviModel.getTemplate();
            int cols = template.getColumnCount();
            for (int col = 0; col < cols; ++col) {
                if (!this.naviTable.isColumnVisible(col) || template.isColumnNotSummable(col)) continue;
                sumUpEnabled = true;
                break;
            }
            if (!sumUpEnabled && this.naviSorter != null && this.naviSorter.getSumEntry() != null) {
                this.naviSorter.setSumEntry(null);
                this.sumButton.setSelected(false);
            }
        }
        this.sumButton.setVisible(sumUpEnabled);
    }

    private void buildTree() {
        if (this.naviSorter != null && this.naviSorter.isSorted() || this.naviTable.getRowSorter() != null) {
            ArrayList<PersistentDomainObject> sortedList = new ArrayList<PersistentDomainObject>();
            int size = this.list == null ? 0 : this.list.size();
            for (int viewRow = 0; viewRow < size; ++viewRow) {
                PersistentDomainObject object;
                int row = this.getModelIndex(viewRow);
                if (row < 0 || (object = (PersistentDomainObject)this.list.get(row)) == null || this.treeFilter != null && !this.treeFilter.isValid((Object)object)) continue;
                sortedList.add(object);
            }
            this.naviTree.buildTree(sortedList);
        } else {
            this.naviTree.buildTree(this.treeFilter != null ? this.treeFilter.filter(this.list) : this.list);
        }
    }

    public FormTableModel<T> createFormTableModel(FormTableEntry<T> template) {
        FormTableModel model = new FormTableModel(template);
        model.bind();
        return model;
    }

    private void showView(ViewMode mode, boolean rebuildView) {
        Object pdo = this.getTemplateProvider();
        if (pdo == null && this.list != null && !this.list.isEmpty()) {
            pdo = (PersistentDomainObject)this.list.iterator().next();
        }
        if (pdo != null && (rebuildView || this.viewMode != mode)) {
            Window w;
            boolean scrollToFirstSelection = false;
            if (mode == ViewMode.TABLE) {
                if (this.naviModel == null || rebuildView) {
                    this.naviModel = this.createFormTableModel(Rdc.createGuiProvider(pdo).getFormTableEntry());
                    this.naviSorter = this.naviTable.getRowSorter() == null ? new FormTableSorter(this.naviModel) : null;
                    this.naviTable.setName(this.tableName == null ? Rdc.createGuiProvider(pdo).getFormTableName() : this.tableName);
                    String title = this.tableTitle;
                    if (title == null) {
                        String contextName;
                        title = pdo.getPlural();
                        DomainContext context = pdo.getBaseContext();
                        if (context != null && (contextName = context.toString()).length() > 0) {
                            title = MessageFormat.format(RdcSwingRdcBundle.getString("{0} IN {1}"), title, contextName);
                        }
                    }
                    this.naviTable.createDefaultColumnsFromModel();
                    FormTableUtilityPopup popup = Rdc.createPopup();
                    popup.setTitle(title);
                    popup.setIntro(this.tableIntro);
                    this.naviTable.setUtilityPopup(popup);
                    this.naviScroll.setViewportView((Component)this.naviTable);
                    this.naviModel.listChanged(this.list);
                    this.naviTable.setSelectionMode(this.listSelectionMode);
                    this.naviTable.setModel(this.naviSorter == null ? this.naviModel : this.naviSorter);
                    this.naviTableUpdated = true;
                    scrollToFirstSelection = true;
                    int width = (int)(this.naviTable.getPreferredSize().getWidth() + this.naviScroll.getVerticalScrollBar().getPreferredSize().getWidth()) + 4;
                    Dimension size = this.naviScroll.getPreferredSize();
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    if (width > screenSize.width - 50) {
                        width = screenSize.width - 50;
                    }
                    if (size.height < 50) {
                        size.height = screenSize.height >> 1;
                    }
                    size.width = width;
                    this.naviScroll.setPreferredSize(size);
                    if (this.naviSorter != null) {
                        this.naviSorter.addPropertyChangeListener(e -> {
                            if (e.getSource() instanceof FormTableSorter) {
                                this.setSorting(((FormTableSorter)e.getSource()).getSortNames());
                                this.naviTreeUpdated = false;
                            }
                        });
                    }
                } else {
                    if (!this.naviTableUpdated) {
                        this.naviModel.listChanged(this.list);
                        this.naviTableUpdated = true;
                        this.naviTreeUpdated = false;
                        scrollToFirstSelection = true;
                    }
                    this.naviScroll.setViewportView((Component)this.naviTable);
                }
                FormTableUtilityPopup paths = this.naviTree.getSelectionPaths();
                this.naviTable.clearSelection();
                this.selectedObjects = null;
                this.selectedObject = null;
                if (paths != null) {
                    for (FormTableUtilityPopup path : paths) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                        Object so = ((PdoTreeObject)node.getUserObject()).getObject();
                        int i = this.getViewIndex(this.list.indexOf(so));
                        if (i < 0) continue;
                        this.naviTable.getSelectionModel().addSelectionInterval(i, i);
                        if (!scrollToFirstSelection) continue;
                        this.naviTable.scrollToCell(i, 0);
                        scrollToFirstSelection = false;
                    }
                }
                if (scrollToFirstSelection) {
                    this.naviTable.scrollToCell(0, 0);
                }
                if (this.naviSorter != null) {
                    this.sortBox.setVisible(true);
                    this.setSorting(this.naviSorter.getSortNames());
                } else {
                    this.sortBox.setVisible(false);
                }
                this.updateSumButton();
            } else if (mode == ViewMode.TREE) {
                int[] rows = this.naviTable.getSelectedRows();
                this.naviTree.clearSelection();
                this.selectedObject = null;
                this.selectedObjects = null;
                if (!this.naviTreeUpdated || rebuildView) {
                    this.treeFilter = Rdc.createGuiProvider(pdo).getTreeFilter();
                    this.buildTree();
                    this.naviTreeUpdated = true;
                    this.naviTableUpdated = false;
                    scrollToFirstSelection = this.list != null && !this.list.isEmpty();
                }
                this.naviScroll.setViewportView((Component)((Object)this.naviTree));
                for (int i = 0; i < rows.length; ++i) {
                    Object obj = this.naviTable.getObjectAt(rows[i]);
                    TreePath path = this.naviTree.findPathInCollection(obj);
                    if (path != null) {
                        this.naviTree.getSelectionModel().addSelectionPath(path);
                    }
                    if (!scrollToFirstSelection) continue;
                    this.naviTree.scrollPathToVisible(path);
                    scrollToFirstSelection = false;
                }
                if (scrollToFirstSelection) {
                    this.naviTree.scrollRowToVisible(0);
                }
                if (this.naviSorter != null && this.naviSorter.isSorted()) {
                    this.sortBox.setVisible(true);
                    this.sortBox.setEnabled(false);
                } else {
                    this.sortBox.setVisible(false);
                }
                this.sumButton.setVisible(false);
            }
            this.viewMode = mode;
            if (this.autoPack && this.isShowing() && !this.packed && (w = this.getParentWindow()) != null) {
                w.pack();
                this.packed = true;
            }
        }
        this.updateRowCountLabel();
    }

    private void setSorting(String text) {
        if (text == null) {
            this.sortBox.setText(RdcSwingRdcBundle.getString("UNSORTED"));
            this.sortBox.setSelected(false);
            this.sortBox.setEnabled(false);
        } else {
            this.sortBox.setText(text);
            this.sortBox.setSelected(true);
            this.sortBox.setEnabled(true);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.getParentWindow().dispose();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.viewButtonPanel = new FormPanel();
        this.tableViewButton = new JToggleButton();
        this.treeViewButton = new JToggleButton();
        this.sortBox = new FormRadioButton();
        this.jLabel1 = new JLabel();
        this.rowCountLabel = new JLabel();
        this.cutSelectedButton = new JButton();
        this.sumButton = new JToggleButton();
        this.naviScroll = new JScrollPane();
        this.buttonPanel = new JPanel();
        this.selectButton = new FormButton();
        this.cancelButton = new FormButton();
        this.closeButton = new FormButton();
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.setLayout(new BorderLayout());
        this.viewButtonPanel.setLayout((LayoutManager)new GridBagLayout());
        this.buttonGroup1.add(this.tableViewButton);
        this.tableViewButton.setIcon(PlafUtilities.getInstance().getIcon("table"));
        this.tableViewButton.setToolTipText(RdcSwingRdcBundle.getString("TABLE VIEW"));
        this.tableViewButton.setMargin(new Insets(1, 1, 1, 1));
        this.tableViewButton.setName("table");
        this.tableViewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoNavigationPanel.this.tableViewButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        this.viewButtonPanel.add((Component)this.tableViewButton, (Object)gridBagConstraints);
        this.buttonGroup1.add(this.treeViewButton);
        this.treeViewButton.setIcon(PlafUtilities.getInstance().getIcon("tree"));
        this.treeViewButton.setToolTipText(RdcSwingRdcBundle.getString("TREE VIEW"));
        this.treeViewButton.setMargin(new Insets(1, 1, 1, 1));
        this.treeViewButton.setName("tree");
        this.treeViewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoNavigationPanel.this.treeViewButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        this.viewButtonPanel.add((Component)this.treeViewButton, (Object)gridBagConstraints);
        this.sortBox.setFont(new Font("Dialog", 0, 12));
        this.sortBox.setName("sort");
        this.sortBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoNavigationPanel.this.sortBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.viewButtonPanel.add((Component)this.sortBox, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 80;
        gridBagConstraints.weightx = 1.0;
        this.viewButtonPanel.add((Component)this.jLabel1, (Object)gridBagConstraints);
        this.rowCountLabel.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.viewButtonPanel.add((Component)this.rowCountLabel, (Object)gridBagConstraints);
        this.cutSelectedButton.setIcon(PlafUtilities.getInstance().getIcon("cut"));
        this.cutSelectedButton.setToolTipText(RdcSwingRdcBundle.getString("KEEP SELECTED ONLY"));
        this.buttonGroup1.add(this.cutSelectedButton);
        this.cutSelectedButton.setMargin(new Insets(1, 1, 1, 1));
        this.cutSelectedButton.setName("cut");
        this.cutSelectedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoNavigationPanel.this.cutSelectedButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        this.viewButtonPanel.add((Component)this.cutSelectedButton, (Object)gridBagConstraints);
        this.sumButton.setIcon(PlafUtilities.getInstance().getIcon("sum"));
        this.sumButton.setToolTipText(RdcSwingRdcBundle.getString("COMPUTE SUMS"));
        this.sumButton.setMargin(new Insets(1, 1, 1, 1));
        this.sumButton.setName("sum");
        this.sumButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoNavigationPanel.this.sumButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        this.viewButtonPanel.add((Component)this.sumButton, (Object)gridBagConstraints);
        this.add((Component)this.viewButtonPanel, "North");
        this.add(this.naviScroll, "Center");
        this.selectButton.setIcon((Icon)PlafUtilities.getInstance().getIcon("ok"));
        this.selectButton.setText(RdcSwingRdcBundle.getString("SELECT"));
        this.selectButton.setActionCommand(ACTION_SELECT);
        this.selectButton.setName(ACTION_SELECT);
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoNavigationPanel.this.selectButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add((Component)this.selectButton);
        this.cancelButton.setIcon((Icon)PlafUtilities.getInstance().getIcon(ACTION_CANCEL));
        this.cancelButton.setText(RdcSwingRdcBundle.getString("CANCEL"));
        this.cancelButton.setActionCommand(ACTION_CANCEL);
        this.cancelButton.setName(ACTION_CANCEL);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoNavigationPanel.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add((Component)this.cancelButton);
        this.closeButton.setIcon((Icon)PlafUtilities.getInstance().getIcon(ACTION_CLOSE));
        this.closeButton.setText(RdcSwingRdcBundle.getString("CLOSE"));
        this.closeButton.setActionCommand(ACTION_CLOSE);
        this.closeButton.setName(ACTION_CLOSE);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoNavigationPanel.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add((Component)this.closeButton);
        this.add(this.buttonPanel, "South");
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.selectedObject = null;
        this.selectedObjects = null;
        this.fireActionPerformed(evt.getActionCommand());
    }

    private void sumButtonActionPerformed(ActionEvent evt) {
        FormUtilities.getInstance().setWaitCursor((Component)((Object)this));
        EventQueue.invokeLater(() -> {
            if (this.sumButton.isSelected()) {
                if (this.naviSorter != null) {
                    this.naviSorter.setSumEntry((FormTableEntry)new SumFormTableEntry(this.naviModel));
                }
                this.naviTable.scrollToCell(this.naviModel.getRowCount(), 0);
            } else if (this.naviSorter != null) {
                this.naviSorter.setSumEntry(null);
            }
            FormUtilities.getInstance().setDefaultCursor((Component)((Object)this));
        });
    }

    private void cutSelectedButtonActionPerformed(ActionEvent evt) {
        TreePath[] paths;
        ArrayList<Object> objList = new ArrayList<Object>();
        if (this.viewMode == ViewMode.TABLE) {
            int[] rows = this.naviTable.getSelectedRows();
            for (int i = 0; i < rows.length; ++i) {
                int row = this.getModelIndex(rows[i]);
                if (row < 0 || row >= this.list.size()) continue;
                objList.add(this.list.get(row));
            }
        } else if (this.viewMode == ViewMode.TREE && (paths = this.naviTree.getSelectionPaths()) != null) {
            for (TreePath path : paths) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object obj = ((PdoTreeObject)node.getUserObject()).getObject();
                if (path.getPathCount() != 2 || !(obj instanceof PersistentDomainObject)) continue;
                objList.add((PersistentDomainObject)obj);
            }
        }
        if (objList.size() > 0) {
            this.setObjects(objList);
            this.naviTable.clearSelection();
            this.naviTree.clearSelection();
        }
    }

    private void sortBoxActionPerformed(ActionEvent evt) {
        if (!this.sortBox.isSelected()) {
            if (this.naviSorter != null) {
                this.naviSorter.clearSorting();
                this.naviSorter.sort();
            }
            this.setSorting(null);
            this.naviTreeUpdated = false;
        }
    }

    private void treeViewButtonActionPerformed(ActionEvent evt) {
        if (this.treeViewButton.isSelected()) {
            FormUtilities.getInstance().setWaitCursor((Component)((Object)this));
            EventQueue.invokeLater(() -> {
                this.showView(ViewMode.TREE, false);
                if (this.naviTree != null) {
                    FormUtilities.getInstance().setDefaultCursor((Component)((Object)this));
                    this.naviTree.requestFocusInWindow();
                }
            });
        }
    }

    private void tableViewButtonActionPerformed(ActionEvent evt) {
        if (this.tableViewButton.isSelected()) {
            FormUtilities.getInstance().setWaitCursor((Component)((Object)this));
            EventQueue.invokeLater(() -> {
                this.showView(ViewMode.TABLE, false);
                FormUtilities.getInstance().setDefaultCursor((Component)((Object)this));
                this.naviTable.requestFocusInWindow();
            });
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.selectedObject = null;
        this.selectedObjects = null;
        this.fireActionPerformed(evt.getActionCommand());
    }

    private void selectButtonActionPerformed(ActionEvent evt) {
        this.fireActionPerformed(evt.getActionCommand());
    }

    public static enum ViewMode {
        TREE,
        TABLE;

    }
}

