/**
 * Tentackle - http://www.tentackle.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

// Created on September 18, 2002, 4:57 PM

package org.tentackle.swing.rdc;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import org.tentackle.swing.FormPanel;


/**
 * The default search panel for the normtext search.
 */
public class DefaultSearchPanel extends FormPanel {

  private static final long serialVersionUID = -2212802891577868573L;


  private String pattern;  // normtext pattern


  /**
   * Creates a search panel for a given search parameter.
   */
  public DefaultSearchPanel() {
    initComponents();
  }


  /**
   * Gets the normtext pattern.
   *
   * @return the pattern
   */
  public String getPattern() {
    return pattern;
  }

  /**
   * Sets the normtext pattern.
   *
   * @param pattern the pattern
   */
  public void setPattern(String pattern) {
    this.pattern = pattern;
  }


  /**
   * Notifies all ActionListeners (usually only one!) that the query will start.
   */
  public void fireActionPerformed () {
    fireActionPerformed(new ActionEvent (this, ActionEvent.ACTION_PERFORMED, "search"));
  }


  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {
    java.awt.GridBagConstraints gridBagConstraints;

    jLabel1 = new javax.swing.JLabel();
    searchPatternField = new org.tentackle.swing.StringFormField();

    setLayout(new java.awt.GridBagLayout());

    jLabel1.setText("Pattern:");
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
    add(jLabel1, gridBagConstraints);

    searchPatternField.setAutoSelect(true);
    searchPatternField.setColumns(20);
    searchPatternField.setConvert(org.tentackle.swing.FormFieldComponent.CONVERT_UC);
    searchPatternField.setName("pattern"); // NOI18N
    searchPatternField.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        searchPatternFieldActionPerformed(evt);
      }
    });
    searchPatternField.addValueListener(new org.tentackle.swing.ValueListener() {
      public void valueEntered(org.tentackle.swing.ValueEvent evt) {
        searchPatternFieldValueEntered(evt);
      }
      public void valueChanged(org.tentackle.swing.ValueEvent evt) {
        searchPatternFieldValueChanged(evt);
      }
    });
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 5);
    add(searchPatternField, gridBagConstraints);
  }// </editor-fold>//GEN-END:initComponents

  private void searchPatternFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_searchPatternFieldActionPerformed
    EventQueue.invokeLater(() -> {
      pattern = searchPatternField.getText();
      fireActionPerformed();
    });
  }//GEN-LAST:event_searchPatternFieldActionPerformed

  private void searchPatternFieldValueEntered(org.tentackle.swing.ValueEvent evt) {//GEN-FIRST:event_searchPatternFieldValueEntered
    pattern = searchPatternField.getText();
  }//GEN-LAST:event_searchPatternFieldValueEntered

  private void searchPatternFieldValueChanged(org.tentackle.swing.ValueEvent evt) {//GEN-FIRST:event_searchPatternFieldValueChanged
    searchPatternField.setText(pattern);
  }//GEN-LAST:event_searchPatternFieldValueChanged

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JLabel jLabel1;
  private org.tentackle.swing.StringFormField searchPatternField;
  // End of variables declaration//GEN-END:variables

}

