/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.rdc;

import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.security.Permission;
import org.tentackle.security.SecurityFactory;
import org.tentackle.security.permissions.EditPermission;
import org.tentackle.security.permissions.ViewPermission;
import org.tentackle.swing.FileTransferable;
import org.tentackle.swing.FormInfo;
import org.tentackle.swing.FormTree;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.rdc.GuiProvider;
import org.tentackle.swing.rdc.PdoEditDialog;
import org.tentackle.swing.rdc.PdoEditDialogPool;
import org.tentackle.swing.rdc.PdoNavigationDialog;
import org.tentackle.swing.rdc.PdoTransferable;
import org.tentackle.swing.rdc.PdoTreeCellRenderer;
import org.tentackle.swing.rdc.PdoTreeExtension;
import org.tentackle.swing.rdc.PdoTreeExtensionEditor;
import org.tentackle.swing.rdc.PdoTreeExtensionToggleNode;
import org.tentackle.swing.rdc.PdoTreeExtensionUsageToggleNode;
import org.tentackle.swing.rdc.PdoTreeObject;
import org.tentackle.swing.rdc.PdoTreeToggleNodeObject;
import org.tentackle.swing.rdc.Rdc;
import org.tentackle.swing.rdc.RdcSwingRdcBundle;

public class PdoTree
extends FormTree
implements TreeWillExpandListener,
DragSourceListener,
DragGestureListener,
DropTargetListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdoTree.class);
    private static final long serialVersionUID = -559339241973400671L;
    private boolean popupEnabled;
    private int maxDepthForExtractPath;
    private Collection<?> objCollection;
    protected PersistentDomainObject popupObject;
    protected GuiProvider guiProvider;
    protected DefaultMutableTreeNode popupNode;
    protected TreePath popupPath;
    protected Runnable openEditor;
    protected PdoTreeExtensionUsageToggleNode usageToggleNode;
    protected JMenuItem usageMenuItem;
    protected JMenuItem[] toggleItems;
    protected JSeparator toggleSeparator;
    protected JMenuItem[] extraItems;
    protected JSeparator extraSeparator;
    protected JMenuItem collapseItem;
    protected JMenuItem copyItem;
    protected JMenuItem deleteItem;
    protected JMenuItem editItem;
    protected JMenuItem expandItem;
    protected JMenuItem insertItem;
    protected JMenuItem makeTableItem;
    protected JMenuItem openItem;
    protected JPopupMenu popupMenu;
    protected JMenuItem selectAllItem;
    protected JMenuItem showItem;
    protected JMenuItem subTreeItem;

    public static Object getObjectInParentNode(DefaultMutableTreeNode node) {
        Object object;
        DefaultMutableTreeNode parentNode;
        if (node != null && (parentNode = (DefaultMutableTreeNode)node.getParent()) != null && (object = parentNode.getUserObject()) instanceof PdoTreeObject) {
            return ((PdoTreeObject)object).getObject();
        }
        return null;
    }

    public PdoTree(Collection<?> objects) {
        this.setDragEnabled(false);
        this.maxDepthForExtractPath = 5;
        this.popupEnabled = true;
        this.addTreeWillExpandListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PdoTree.this.checkPopup(e, true);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                PdoTree.this.checkPopup(e, true);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (e.isControlDown()) {
                    switch (keyCode) {
                        case 67: 
                        case 68: 
                        case 69: 
                        case 78: 
                        case 79: 
                        case 85: 
                        case 86: 
                        case 88: 
                        case 90: {
                            PdoTree.this.checkPopup(e, false);
                            if (keyCode == 88 && PdoTree.this.expandItem.isEnabled() && PdoTree.this.expandItem.isVisible()) {
                                PdoTree.this.expandItem.doClick();
                                break;
                            }
                            if (keyCode == 90 && PdoTree.this.collapseItem.isEnabled() && PdoTree.this.collapseItem.isVisible()) {
                                PdoTree.this.collapseItem.doClick();
                                break;
                            }
                            if (keyCode == 78 && PdoTree.this.showItem.isEnabled() && PdoTree.this.showItem.isVisible()) {
                                PdoTree.this.showItem.doClick();
                                break;
                            }
                            if (keyCode == 69 && PdoTree.this.editItem.isEnabled() && PdoTree.this.editItem.isVisible()) {
                                PdoTree.this.editItem.doClick();
                                break;
                            }
                            if (keyCode == 79 && PdoTree.this.openItem.isEnabled() && PdoTree.this.openItem.isVisible()) {
                                PdoTree.this.openItem.doClick();
                                break;
                            }
                            if (keyCode == 68 && PdoTree.this.deleteItem.isEnabled() && PdoTree.this.deleteItem.isVisible()) {
                                PdoTree.this.deleteItem.doClick();
                                break;
                            }
                            if (keyCode == 67 && PdoTree.this.copyItem.isEnabled() && PdoTree.this.copyItem.isVisible()) {
                                PdoTree.this.copyItem.doClick();
                                break;
                            }
                            if (keyCode != 86 || !PdoTree.this.insertItem.isEnabled() || !PdoTree.this.insertItem.isVisible()) break;
                            PdoTree.this.insertItem.doClick();
                        }
                    }
                } else if (keyCode == 32) {
                    PdoTree.this.checkPopup(e, true);
                }
            }
        });
        this.setTransferHandler(new TransferHandler(){
            private static final long serialVersionUID = 6532199703856836746L;

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                TreePath[] paths = PdoTree.this.getSelectionPaths();
                if (paths != null) {
                    ArrayList<PersistentDomainObject> objectList = new ArrayList<PersistentDomainObject>();
                    for (TreePath path : paths) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                        Object obj = ((PdoTreeObject)node.getUserObject()).getObject();
                        if (!(obj instanceof PersistentDomainObject)) continue;
                        objectList.add((PersistentDomainObject)obj);
                    }
                    return new PdoTransferable((Collection<?>)objectList);
                }
                return super.createTransferable(c);
            }
        });
        this.initComponents();
        this.setCellRenderer(this.createDefaultRenderer());
        this.getSelectionModel().setSelectionMode(1);
        DragSource dnd = DragSource.getDefaultDragSource();
        dnd.createDefaultDragGestureRecognizer((Component)((Object)this), 3, this);
        DropTarget target = new DropTarget((Component)((Object)this), this);
        target.setDefaultActions(3);
        this.buildTree(objects);
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
    }

    public PdoTree(Object object) {
        this(PdoTree.createCollectionFromObject(object));
    }

    public PdoTree() {
        this(null);
    }

    private static Collection<?> createCollectionFromObject(Object object) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(object);
        return list;
    }

    public Collection<?> getObjects() {
        return this.objCollection;
    }

    public TreeCellRenderer createDefaultRenderer() {
        return new PdoTreeCellRenderer();
    }

    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof PersistentDomainObject) {
            try {
                super.convertValueToText(((PersistentDomainObject)value).getUniqueDomainKey(), selected, expanded, leaf, row, hasFocus);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return super.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
    }

    public void setPopupEnabled(boolean enabled) {
        this.popupEnabled = enabled;
    }

    public boolean isPopupEnabled() {
        return this.popupEnabled;
    }

    public void setMaxDepthForExtractPath(int maxDepth) {
        this.maxDepthForExtractPath = maxDepth;
    }

    public int getMaxDepthForExtractPath() {
        return this.maxDepthForExtractPath;
    }

    public void showPopup() {
        this.checkPopup(null, true);
    }

    public void buildTree(Collection<?> col) {
        this.objCollection = col == null ? new ArrayList() : col;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        if (col != null) {
            for (Object obj : col) {
                Object treeObject;
                if (obj == null) continue;
                GuiProvider<PersistentDomainObject> guiProvider = null;
                if (obj instanceof PersistentDomainObject) {
                    guiProvider = Rdc.createGuiProvider((PersistentDomainObject)obj);
                    treeObject = guiProvider.getTreeRoot();
                } else {
                    treeObject = obj;
                }
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(new PdoTreeObject(treeObject, null));
                node.setAllowsChildren(treeObject instanceof PdoTreeExtension && ((PdoTreeExtension)treeObject).allowsTreeChildObjects() || guiProvider != null && guiProvider.allowsTreeChildObjects());
                root.add(node);
            }
        }
        DefaultTreeModel tModel = new DefaultTreeModel(root);
        tModel.setAsksAllowsChildren(true);
        this.setModel(tModel);
        this.putClientProperty("JTree.lineStyle", "Angled");
    }

    public void expandTree(int maxLevel) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeModel.getRoot();
        if (node != null) {
            this.doExpandPath(0, maxLevel, null, new TreePath(node));
        }
    }

    public void expandTree() {
        this.expandTree(0);
    }

    public void requestFocusForFirstItem() {
        this.setSelectionRow(0);
        this.scrollRowToVisible(0);
        FormUtilities.getInstance().requestFocusLater((Component)((Object)this));
    }

    public boolean isObjectAppendable(Object childObject) {
        return childObject != null && (!(childObject instanceof PersistentDomainObject) || ((PersistentDomainObject)childObject).isPermissionAccepted((Permission)SecurityFactory.getInstance().getReadPermission()));
    }

    public boolean isObjectInParents(Object childObject, DefaultMutableTreeNode node) {
        while (node != null) {
            Object pathObject = node.getUserObject();
            if (pathObject instanceof PdoTreeObject && ((PdoTreeObject)pathObject).getObject() != null && ((PdoTreeObject)pathObject).getObject().equals(childObject)) {
                return true;
            }
            node = (DefaultMutableTreeNode)node.getParent();
        }
        return false;
    }

    public boolean isObjectInChilds(Object childObject, DefaultMutableTreeNode node) {
        if (childObject != null && node != null) {
            Object pathObject = node.getUserObject();
            if (pathObject instanceof PdoTreeObject && ((PdoTreeObject)pathObject).getObject() != null && ((PdoTreeObject)pathObject).getObject().equals(childObject)) {
                return true;
            }
            Enumeration<TreeNode> ce = node.children();
            while (ce.hasMoreElements()) {
                if (!this.isObjectInChilds(childObject, (DefaultMutableTreeNode)ce.nextElement())) continue;
                return true;
            }
        }
        return false;
    }

    public void doExpandPath(int level, int maxLevel, PersistentDomainObject<?> stopObject, TreePath path) {
        this.expandPath(path);
        if (maxLevel == 0 || level + 1 < maxLevel) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Enumeration<TreeNode> children = node.children();
            while (children.hasMoreElements()) {
                node = (DefaultMutableTreeNode)children.nextElement();
                if (node.getUserObject() instanceof PdoTreeObject) {
                    PdoTreeObject userObject = (PdoTreeObject)node.getUserObject();
                    if (level > 0 && userObject.isStopExpandPath() || stopObject != null && userObject.getObject().equals(stopObject)) continue;
                }
                if (!node.getAllowsChildren()) continue;
                this.doExpandPath(level + 1, maxLevel, stopObject, new TreePath(node.getPath()));
            }
        }
    }

    public void doCollapsePath(TreePath path) {
        this.collapsePath(path);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        PdoTreeObject tobj = (PdoTreeObject)node.getUserObject();
        tobj.setExpanded(false);
        if (!(tobj instanceof PdoTreeToggleNodeObject)) {
            node.removeAllChildren();
        }
        ((DefaultTreeModel)this.treeModel).reload(node);
    }

    public boolean pathConsistsOfPdos(TreePath path) {
        int depth = path.getPathCount();
        for (int i = 1; i < depth; ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getPathComponent(i);
            if (((PdoTreeObject)node.getUserObject()).getObject() instanceof PersistentDomainObject) continue;
            return false;
        }
        return true;
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
        PdoTreeObject tobj;
        TreePath path = e.getPath();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (node != null && (tobj = (PdoTreeObject)node.getUserObject()) != null && !tobj.isExpanded()) {
            if (tobj.isStopTreeWillExpand()) {
                tobj.setStopTreeWillExpand(false);
                throw new ExpandVetoException(e);
            }
            List childList = null;
            Object object = tobj.getObject();
            FormUtilities.getInstance().setWaitCursor((Component)((Object)this));
            if (object instanceof PdoTreeExtension) {
                childList = ((PdoTreeExtension)object).getTreeChildObjects(tobj.getParentObject());
            }
            if (object instanceof PersistentDomainObject) {
                childList = (List)Rdc.createGuiProvider((PersistentDomainObject)object).getTreeChildObjects(tobj.getParentObject());
            }
            if (childList != null) {
                for (Object obj : childList) {
                    if (!this.isObjectAppendable(obj)) continue;
                    PdoTreeObject to = new PdoTreeObject(obj, object);
                    to.setStopTreeWillExpand(this.isObjectInParents(obj, node));
                    DefaultMutableTreeNode childnode = new DefaultMutableTreeNode(to);
                    childnode.setAllowsChildren(obj instanceof PdoTreeExtension && ((PdoTreeExtension)obj).allowsTreeChildObjects() || obj instanceof PersistentDomainObject && Rdc.createGuiProvider((PersistentDomainObject)obj).allowsTreeChildObjects());
                    ((DefaultTreeModel)this.treeModel).insertNodeInto(childnode, node, node.getChildCount());
                }
            }
            FormUtilities.getInstance().setDefaultCursor((Component)((Object)this));
            tobj.setExpanded(true);
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent e) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
        TreePath path = this.getSelectionPath();
        if (path != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object obj = ((PdoTreeObject)node.getUserObject()).getObject();
            PdoTransferable<PersistentDomainObject> tr = null;
            if (obj instanceof PdoTreeExtension) {
                tr = ((PdoTreeExtension)obj).getTransferable();
            }
            if (tr == null && obj instanceof PersistentDomainObject) {
                PersistentDomainObject dragObject = (PersistentDomainObject)obj;
                tr = Rdc.createGuiProvider(dragObject).getTransferable();
            }
            if (tr instanceof FileTransferable) {
                event.startDrag(event.getDragAction() == 2 ? DragSource.DefaultMoveDrop : DragSource.DefaultCopyDrop, tr, this);
            } else if (tr != null) {
                event.startDrag(null, tr, this);
            }
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent event) {
    }

    @Override
    public void dragOver(DragSourceDragEvent event) {
    }

    @Override
    public void dragExit(DragSourceEvent event) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent event) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent event) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        DefaultMutableTreeNode node;
        PdoTreeObject mto;
        Object obj;
        Point p = dtde.getLocation();
        TreePath path = this.getPathForLocation(p.x, p.y);
        if (path != null && (obj = (mto = (PdoTreeObject)(node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()).getObject()) instanceof PersistentDomainObject) {
            Object transData = ((PersistentDomainObject)obj).getTransientData();
            if (!((PersistentDomainObject)obj).isNew()) {
                obj = ((PersistentDomainObject)obj).reload();
            }
            if (obj != null) {
                ((PersistentDomainObject)obj).setTransientData(transData);
                mto.setObject(obj);
                if (Rdc.createGuiProvider((PersistentDomainObject)obj).allowsTreeChildObjects()) {
                    this.setSelectionPath(path);
                    this.popupPath = path;
                    this.popupObject = (PersistentDomainObject)obj;
                    this.popupNode = node;
                    dtde.acceptDrag(dtde.getDropAction());
                    return;
                }
            }
        }
        this.clearSelection();
        this.popupPath = null;
        this.popupObject = null;
        this.popupNode = null;
        dtde.rejectDrag();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable tr = dtde.getTransferable();
            this.insertDndOrCb(tr, dtde);
        }
        catch (UnsupportedFlavorException | IOException e) {
            LOGGER.severe(e.toString(), new Object[0]);
        }
    }

    void hideInUseTree(int childIndex) {
        ((DefaultTreeModel)this.treeModel).removeNodeFromParent((DefaultMutableTreeNode)this.popupNode.getChildAt(childIndex));
    }

    void showInUseTree() {
        FormUtilities.getInstance().setWaitCursor((Component)((Object)this));
        ArrayList<DefaultMutableTreeNode> rootNodes = new ArrayList<DefaultMutableTreeNode>();
        List parentList = (List)Rdc.createGuiProvider(this.popupObject).getTreeParentObjects(((PdoTreeObject)this.popupNode.getUserObject()).getParentObject());
        if (parentList != null && parentList.size() > 0) {
            for (Object obj : parentList) {
                if (!(obj instanceof PersistentDomainObject)) continue;
                this.addTreeParentRootNodes((PersistentDomainObject)obj, new DefaultMutableTreeNode(new PdoTreeObject(this.popupObject, null)), rootNodes);
            }
        }
        if (rootNodes.size() > 0) {
            DefaultMutableTreeNode inUseNode = new DefaultMutableTreeNode(this.usageToggleNode.getToggleNodeObject(this.popupObject));
            for (DefaultMutableTreeNode node : rootNodes) {
                Enumeration<TreeNode> ce = inUseNode.children();
                DefaultMutableTreeNode insNode = node;
                while (ce.hasMoreElements()) {
                    DefaultMutableTreeNode childnode = (DefaultMutableTreeNode)ce.nextElement();
                    if (!childnode.getUserObject().equals(node.getUserObject()) || node.getChildCount() <= 0) continue;
                    DefaultMutableTreeNode firstChild = (DefaultMutableTreeNode)node.getChildAt(0);
                    childnode.add(firstChild);
                    insNode = null;
                    break;
                }
                if (insNode == null) continue;
                inUseNode.add(insNode);
            }
            ((DefaultTreeModel)this.treeModel).insertNodeInto(inUseNode, this.popupNode, 0);
            this.doExpandPath(0, 1, null, this.popupPath);
            TreePath inUsePath = this.popupPath.pathByAddingChild(inUseNode);
            this.doExpandPath(0, 0, this.popupObject, inUsePath);
            Enumeration<TreeNode> ce = inUseNode.children();
            while (ce.hasMoreElements()) {
                this.collapsePath(inUsePath.pathByAddingChild(ce.nextElement()));
            }
            FormUtilities.getInstance().setDefaultCursor((Component)((Object)this));
        } else {
            FormUtilities.getInstance().setDefaultCursor((Component)((Object)this));
            FormInfo.show((String)RdcSwingRdcBundle.getString("NO REFERENCES FOUND"));
        }
    }

    private boolean insertDndOrCb(Transferable tr, DropTargetDropEvent dtde) throws UnsupportedFlavorException, IOException {
        if (this.popupPath != null && this.popupNode != null && this.popupObject.isPermissionAccepted((Permission)SecurityFactory.getInstance().getWritePermission())) {
            if (dtde != null) {
                dtde.acceptDrop(dtde.getDropAction());
            }
            if (Rdc.createGuiProvider(this.popupObject).dropTransferable(tr)) {
                if (((PdoTreeObject)this.popupNode.getUserObject()).isExpanded()) {
                    this.doCollapsePath(this.popupPath);
                }
                this.doExpandPath(0, 1, null, this.popupPath);
                if (dtde != null) {
                    dtde.dropComplete(true);
                }
                return true;
            }
            if (dtde != null) {
                dtde.dropComplete(false);
            }
        }
        return false;
    }

    private void addTreeParentRootNodes(PersistentDomainObject parentObj, DefaultMutableTreeNode childNode, List<DefaultMutableTreeNode> rootNodes) {
        while (this.isObjectAppendable(parentObj)) {
            Collection p;
            PdoTreeObject tobj = new PdoTreeObject(parentObj, null);
            tobj.setExpanded(true);
            DefaultMutableTreeNode parentNode = new DefaultMutableTreeNode(tobj);
            parentNode.add(childNode);
            if (!this.isObjectInChilds(parentObj, childNode) && (p = Rdc.createGuiProvider(parentObj).getTreeParentObjects(tobj.getParentObject())) != null && !p.isEmpty()) {
                if (p.size() > 1) {
                    for (Object obj : p) {
                        if (!(obj instanceof PersistentDomainObject)) continue;
                        this.addTreeParentRootNodes((PersistentDomainObject)obj, this.duplicateTreeNode(parentNode), rootNodes);
                    }
                }
                childNode = parentNode;
                Object obj = p.iterator().next();
                if (obj instanceof PersistentDomainObject) {
                    parentObj = (PersistentDomainObject)obj;
                    continue;
                }
            }
            rootNodes.add(parentNode);
            break;
        }
    }

    private void checkPopup(InputEvent e, boolean show) {
        if (this.popupEnabled) {
            Point p = null;
            if (e instanceof MouseEvent) {
                if (!((MouseEvent)e).isPopupTrigger()) {
                    return;
                }
                p = ((MouseEvent)e).getPoint();
                this.popupPath = this.getPathForLocation(p.x, p.y);
            } else {
                this.popupPath = this.getSelectionPath();
                if (this.popupPath != null) {
                    JMenuItem[] r = this.getPathBounds(this.popupPath);
                    if (r != null) {
                        p = new Point(r.x + r.width / 2, r.y + r.height / 2);
                    } else {
                        this.popupPath = null;
                    }
                }
            }
            if (show) {
                if (this.usageMenuItem != null) {
                    this.popupMenu.remove(this.usageMenuItem);
                    this.usageMenuItem = null;
                }
                if (this.toggleItems != null) {
                    for (JMenuItem toggleItem : this.toggleItems) {
                        this.popupMenu.remove(toggleItem);
                    }
                    this.toggleItems = null;
                }
                if (this.toggleSeparator != null) {
                    this.popupMenu.remove(this.toggleSeparator);
                    this.toggleSeparator = null;
                }
                if (this.extraItems != null) {
                    for (JMenuItem extraItem : this.extraItems) {
                        this.popupMenu.remove(extraItem);
                    }
                    this.extraItems = null;
                }
                if (this.extraSeparator != null) {
                    this.popupMenu.remove(this.extraSeparator);
                    this.extraSeparator = null;
                }
            }
            if (this.popupPath != null && p != null) {
                this.popupNode = (DefaultMutableTreeNode)this.popupPath.getLastPathComponent();
                PdoTreeObject mto = (PdoTreeObject)this.popupNode.getUserObject();
                Object obj = mto.getObject();
                this.selectAllItem.setVisible(this.getSelectionModel().getSelectionMode() != 0);
                if (this.popupNode.getAllowsChildren()) {
                    this.expandItem.setText(RdcSwingRdcBundle.getString("EXPAND"));
                    if (mto.isExpanded()) {
                        this.expandItem.setEnabled(true);
                        this.expandItem.setText(RdcSwingRdcBundle.getString("EXPAND_AGAIN"));
                        this.collapseItem.setEnabled(true);
                    } else {
                        this.expandItem.setEnabled(true);
                        this.collapseItem.setEnabled(false);
                    }
                } else {
                    this.expandItem.setEnabled(false);
                    this.collapseItem.setEnabled(false);
                }
                this.openEditor = null;
                if (obj instanceof PdoTreeExtension) {
                    this.openEditor = ((PdoTreeExtension)obj).getOpenEditor();
                    if (show) {
                        PdoTreeExtensionToggleNode[] toggleNodes;
                        this.extraItems = ((PdoTreeExtension)obj).getExtraMenuItems(this, this.popupNode);
                        if (this.extraItems != null && this.extraItems.length > 0) {
                            this.extraSeparator = new JSeparator();
                            this.popupMenu.add(this.extraSeparator);
                            for (JMenuItem extraItem : this.extraItems) {
                                this.popupMenu.add(extraItem);
                            }
                        }
                        if ((toggleNodes = ((PdoTreeExtension)obj).getToggleNodes(this, this.popupNode)) != null) {
                            this.toggleItems = new JMenuItem[toggleNodes.length];
                            for (int i = 0; i < toggleNodes.length; ++i) {
                                this.toggleItems[i] = toggleNodes[i].getMenuItem(this, this.popupNode, this.popupPath);
                            }
                            if (this.toggleItems.length > 0) {
                                this.toggleSeparator = new JSeparator();
                                this.popupMenu.add((Component)this.toggleSeparator, 0);
                                for (JMenuItem toggleItem : this.toggleItems) {
                                    this.popupMenu.add((Component)toggleItem, 0);
                                }
                            }
                        }
                    }
                }
                this.openItem.setVisible(this.openEditor != null);
                this.subTreeItem.setVisible(false);
                this.makeTableItem.setVisible(false);
                boolean editAllowed = false;
                if (obj instanceof PersistentDomainObject) {
                    Object transData = ((PersistentDomainObject)obj).getTransientData();
                    if (!FormUtilities.getInstance().isParentWindowModal((Component)((Object)this))) {
                        int depth = this.popupPath.getPathCount() - 1;
                        this.subTreeItem.setVisible(depth > 1 || this.objCollection.size() > 1);
                        if (depth > 1) {
                            this.makeTableItem.setText(MessageFormat.format(RdcSwingRdcBundle.getString("CREATE TABLE"), ((PersistentDomainObject)obj).getPlural()));
                            this.makeTableItem.setVisible(true);
                        }
                    }
                    if (((PersistentDomainObject)obj).isNew()) {
                        this.popupObject = (PersistentDomainObject)obj;
                        this.copyItem.setEnabled(false);
                        this.insertItem.setEnabled(false);
                    } else {
                        this.popupObject = ((PersistentDomainObject)obj).reload();
                        this.copyItem.setEnabled(true);
                        this.insertItem.setEnabled(true);
                    }
                    mto.setObject(this.popupObject);
                    if (this.popupObject == null) {
                        return;
                    }
                    this.popupObject.setTransientData(transData);
                    obj = this.popupObject;
                    this.guiProvider = Rdc.createGuiProvider(this.popupObject);
                    if (this.guiProvider.allowsTreeParentObjects()) {
                        if (this.toggleSeparator == null) {
                            this.toggleSeparator = new JSeparator();
                            this.popupMenu.add((Component)this.toggleSeparator, 0);
                        }
                        this.usageToggleNode = new PdoTreeExtensionUsageToggleNode();
                        this.usageMenuItem = this.usageToggleNode.getMenuItem(this, this.popupNode, this.popupPath);
                        this.popupMenu.add((Component)this.usageMenuItem, 0);
                    } else {
                        this.usageToggleNode = null;
                    }
                    boolean viewAllowed = this.popupObject.isPermissionAccepted(SecurityFactory.getInstance().getPermission(ViewPermission.class));
                    boolean bl = editAllowed = viewAllowed && this.popupObject.isPermissionAccepted(SecurityFactory.getInstance().getPermission(EditPermission.class));
                    if (Rdc.createGuiProvider(this.popupObject).panelExists() && this.popupObject.isPermissionAccepted((Permission)SecurityFactory.getInstance().getReadPermission())) {
                        this.editItem.setVisible(true);
                        this.editItem.setEnabled(editAllowed);
                        this.showItem.setVisible(true);
                        this.showItem.setEnabled(viewAllowed);
                    } else {
                        this.editItem.setVisible(false);
                        this.showItem.setVisible(false);
                    }
                    ((DefaultTreeModel)this.treeModel).nodeChanged(this.popupNode);
                    this.setSelectionPath(this.popupPath);
                } else {
                    this.copyItem.setEnabled(false);
                    this.insertItem.setEnabled(false);
                    this.editItem.setVisible(false);
                    this.showItem.setVisible(false);
                }
                boolean deleteAllowed = editAllowed;
                if (deleteAllowed && (obj != null && !((PersistentDomainObject)obj).isRemovable() || obj instanceof PdoTreeExtension && !((PdoTreeExtension)obj).isRemovable())) {
                    deleteAllowed = false;
                }
                this.deleteItem.setEnabled(deleteAllowed);
                if (show) {
                    this.popupMenu.show((Component)((Object)this), p.x, p.y);
                }
            }
        }
    }

    private DefaultMutableTreeNode duplicateTreeNode(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(node.getUserObject(), node.getAllowsChildren());
        for (int i = 0; i < node.getChildCount(); ++i) {
            parent.add(this.duplicateTreeNode((DefaultMutableTreeNode)node.getChildAt(i)));
        }
        return parent;
    }

    public DefaultMutableTreeNode findNodeInCollection(Object object) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        Enumeration<TreeNode> childs = root.children();
        while (childs.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)childs.nextElement();
            if (!(node.getUserObject() instanceof PdoTreeObject) || !((PdoTreeObject)node.getUserObject()).getObject().equals(object)) continue;
            return node;
        }
        return null;
    }

    public TreePath findPathInCollection(Object object) {
        DefaultMutableTreeNode node = this.findNodeInCollection(object);
        if (node != null) {
            return new TreePath(new Object[]{this.getModel().getRoot(), node});
        }
        return null;
    }

    public void collapseAll() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        Enumeration<TreeNode> childs = root.children();
        while (childs.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)childs.nextElement();
            this.collapsePath(new TreePath(new Object[]{this.getModel().getRoot(), node}));
        }
        TreePath path = this.getSelectionPath();
        if (path != null) {
            this.scrollPathToVisible(path);
        }
    }

    public void refreshCurrentNode() {
        if (this.popupNode != null && this.popupPath != null) {
            PdoTreeObject treeObject = (PdoTreeObject)this.popupNode.getUserObject();
            if (treeObject.isExpanded()) {
                this.doCollapsePath(this.popupPath);
                this.doExpandPath(0, 1, null, this.popupPath);
            }
            ((DefaultTreeModel)this.treeModel).nodeChanged(this.popupNode);
        }
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.expandItem = new JMenuItem();
        this.collapseItem = new JMenuItem();
        this.subTreeItem = new JMenuItem();
        this.makeTableItem = new JMenuItem();
        this.showItem = new JMenuItem();
        this.editItem = new JMenuItem();
        this.openItem = new JMenuItem();
        this.deleteItem = new JMenuItem();
        this.copyItem = new JMenuItem();
        this.selectAllItem = new JMenuItem();
        this.insertItem = new JMenuItem();
        this.popupMenu.setName("popupMenu");
        this.expandItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.expandItem.setText(RdcSwingRdcBundle.getString("EXPAND"));
        this.expandItem.setName("expand");
        this.expandItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoTree.this.expandItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.expandItem);
        this.collapseItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.collapseItem.setText(RdcSwingRdcBundle.getString("COLLAPSE"));
        this.collapseItem.setName("collapse");
        this.collapseItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoTree.this.collapseItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.collapseItem);
        this.subTreeItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.subTreeItem.setText(RdcSwingRdcBundle.getString("SUBTREE"));
        this.subTreeItem.setName("subTree");
        this.subTreeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoTree.this.subTreeItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.subTreeItem);
        this.makeTableItem.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        this.makeTableItem.setText("create table");
        this.makeTableItem.setName("makeTable");
        this.makeTableItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoTree.this.makeTableItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.makeTableItem);
        this.showItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.showItem.setText(RdcSwingRdcBundle.getString("VIEW"));
        this.showItem.setName("show");
        this.showItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoTree.this.showItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.showItem);
        this.editItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.editItem.setText(RdcSwingRdcBundle.getString("EDIT"));
        this.editItem.setName("edit");
        this.editItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoTree.this.editItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.editItem);
        this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openItem.setText(RdcSwingRdcBundle.getString("OPEN"));
        this.openItem.setName("open");
        this.openItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoTree.this.openItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.openItem);
        this.deleteItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.deleteItem.setText(RdcSwingRdcBundle.getString("DELETE"));
        this.deleteItem.setName("delete");
        this.deleteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoTree.this.deleteItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.deleteItem);
        this.copyItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.copyItem.setText(RdcSwingRdcBundle.getString("COPY"));
        this.copyItem.setName("copy");
        this.copyItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoTree.this.copyItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.copyItem);
        this.selectAllItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.selectAllItem.setText(RdcSwingRdcBundle.getString("SELECT ALL"));
        this.selectAllItem.setName("select");
        this.selectAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoTree.this.selectAllItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.selectAllItem);
        this.insertItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.insertItem.setText(RdcSwingRdcBundle.getString("INSERT"));
        this.insertItem.setName("insert");
        this.insertItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoTree.this.insertItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.insertItem);
        this.setRootVisible(false);
    }

    private void makeTableItemActionPerformed(ActionEvent evt) {
        ArrayList<PersistentDomainObject> list = new ArrayList<PersistentDomainObject>();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.popupPath.getParentPath().getLastPathComponent();
        int childNum = parentNode.getChildCount();
        for (int childIndex = 0; childIndex < childNum; ++childIndex) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)parentNode.getChildAt(childIndex);
            PdoTreeObject to = (PdoTreeObject)childNode.getUserObject();
            if (to.getObjectClass() != this.popupObject.getEffectiveClass()) continue;
            list.add((PersistentDomainObject)to.getObject());
        }
        if (!list.isEmpty()) {
            PdoNavigationDialog d = Rdc.createPdoNavigationDialog(list, null, true);
            d.setTitle(this.popupObject.getPlural());
            d.getNaviPanel().getNaviTable().getSelectionModel().setSelectionMode(2);
            d.setVisible(true);
        }
    }

    private void subTreeItemActionPerformed(ActionEvent evt) {
        PersistentDomainObject dbObject = this.popupObject;
        PdoNavigationDialog<PersistentDomainObject> d = Rdc.createPdoNavigationDialog(dbObject, null);
        d.setTitle(dbObject.getSingular() + " " + dbObject);
        d.getNaviPanel().getNaviTree().getSelectionModel().setSelectionMode(4);
        d.getNaviPanel().getNaviTree().expandTree(2);
        d.setVisible(true);
    }

    private void insertItemActionPerformed(ActionEvent evt) {
        try {
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable trans = clip.getContents(this);
            this.insertDndOrCb(trans, null);
        }
        catch (HeadlessException | UnsupportedFlavorException | IOException e) {
            LOGGER.logStacktrace(Logger.Level.WARNING, (Throwable)e);
            FormInfo.show((String)RdcSwingRdcBundle.getString("COULDN'T INSERT"));
        }
    }

    private void selectAllItemActionPerformed(ActionEvent evt) {
        this.setSelectionInterval(0, this.getRowCount());
    }

    private void copyItemActionPerformed(ActionEvent evt) {
        try {
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            PdoTransferable<PersistentDomainObject> trans = new PdoTransferable<PersistentDomainObject>(this.popupObject);
            clip.setContents(trans, trans);
        }
        catch (RuntimeException e) {
            LOGGER.logStacktrace(Logger.Level.WARNING, (Throwable)e);
        }
    }

    private void openItemActionPerformed(ActionEvent evt) {
        if (this.openEditor != null) {
            this.openEditor.run();
        }
    }

    private void deleteItemActionPerformed(ActionEvent evt) {
        if (PdoEditDialogPool.getInstance().delete(this.popupObject)) {
            ((DefaultTreeModel)this.treeModel).removeNodeFromParent(this.popupNode);
        }
    }

    private void editItemActionPerformed(ActionEvent evt) {
        PdoTreeExtensionEditor editor;
        if (this.popupObject instanceof PdoTreeExtension && (editor = ((PdoTreeExtension)this.popupObject).getEditor()) != null) {
            editor.showEditor(this, this.popupNode, true, false);
            return;
        }
        if (FormUtilities.getInstance().isParentWindowModal((Component)((Object)this))) {
            if (PdoEditDialogPool.getInstance().editModal(this.popupObject) == null) {
                return;
            }
            this.refreshCurrentNode();
        } else {
            PdoEditDialog<PersistentDomainObject> d = PdoEditDialogPool.getInstance().useNonModalDialog(this.popupObject, true, true);
            if (this.objCollection instanceof List && this.popupPath.getPathCount() == 2) {
                d.setLinkedPdoList((List)this.objCollection);
            }
            d.addActionListener(e -> {
                switch (e.getActionCommand()) {
                    case "save": {
                        DefaultMutableTreeNode node;
                        Object obj = d.getLastPdo();
                        if (!obj.isNew()) {
                            obj = obj.reload();
                        }
                        if (obj == null || (node = this.findNodeInCollection(obj)) == null) break;
                        ((PdoTreeObject)node.getUserObject()).setObject(obj);
                        ((DefaultTreeModel)this.treeModel).nodeChanged(node);
                        break;
                    }
                    case "delete": {
                        DefaultMutableTreeNode node;
                        Object obj = d.getLastPdo();
                        if (obj == null || (node = this.findNodeInCollection(obj)) == null) break;
                        ((DefaultTreeModel)this.treeModel).removeNodeFromParent(node);
                        break;
                    }
                    case "previous": 
                    case "next": {
                        TreePath path = this.findPathInCollection(d.getPdo());
                        if (path == null) break;
                        this.scrollPathToVisible(path);
                        this.setSelectionPath(path);
                    }
                }
            });
        }
    }

    private void showItemActionPerformed(ActionEvent evt) {
        PdoTreeExtensionEditor editor;
        if (this.popupObject instanceof PdoTreeExtension && (editor = ((PdoTreeExtension)this.popupObject).getEditor()) != null) {
            editor.showEditor(this, this.popupNode, false, true);
            return;
        }
        if (FormUtilities.getInstance().isParentWindowModal((Component)((Object)this))) {
            PdoEditDialogPool.getInstance().viewModal(this.popupObject, (Component)((Object)this));
        } else {
            PdoEditDialog<PersistentDomainObject> d = PdoEditDialogPool.getInstance().useNonModalDialog(this.popupObject, false, false);
            if (this.objCollection instanceof List && this.popupPath.getPathCount() == 2) {
                d.setLinkedPdoList((List)this.objCollection);
            }
            this.collapseAll();
            d.addActionListener(e -> {
                TreePath path;
                if (("previous".equals(e.getActionCommand()) || "next".equals(e.getActionCommand())) && (path = this.findPathInCollection(d.getPdo())) != null) {
                    this.scrollPathToVisible(path);
                    this.setSelectionPath(path);
                }
            });
        }
    }

    private void collapseItemActionPerformed(ActionEvent evt) {
        this.doCollapsePath(this.popupPath);
    }

    private void expandItemActionPerformed(ActionEvent evt) {
        if (((PdoTreeObject)this.popupNode.getUserObject()).isExpanded()) {
            this.doCollapsePath(this.popupPath);
        }
        this.doExpandPath(0, Rdc.createGuiProvider(this.popupObject).getTreeExpandMaxDepth(), null, this.popupPath);
    }
}

