/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.rdc.security;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.security.pdo.Security;
import org.tentackle.swing.FormButton;
import org.tentackle.swing.FormComponentCellEditor;
import org.tentackle.swing.FormFieldComponentCellEditor;
import org.tentackle.swing.FormQuestion;
import org.tentackle.swing.FormTable;
import org.tentackle.swing.FormTableCellRenderer;
import org.tentackle.swing.StringFormField;
import org.tentackle.swing.rdc.DefaultPdoTableEntry;
import org.tentackle.swing.rdc.PermissionEditor;
import org.tentackle.swing.rdc.Rdc;

public class SecurityTableEntry
extends DefaultPdoTableEntry<Security> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityTableEntry.class);
    public static Class<? extends PersistentDomainObject> granteeClazz;
    public static Class[] contextClasses;
    protected static final int GRANTEE = 0;
    protected static final int CONTEXT = 1;
    protected static final int PERMISSIONS = 2;
    protected static final int TEXT = 3;
    protected static final int ALLOW = 4;
    protected static final String[] columnNames;

    public SecurityTableEntry(Security security) {
        super(security);
    }

    public SecurityTableEntry newInstance(Security object) {
        return new SecurityTableEntry(object);
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    public String getDisplayedColumnName(int col) {
        switch (col) {
            case 0: {
                return "User";
            }
            case 1: {
                return "Context";
            }
            case 2: {
                return "Permissions";
            }
            case 3: {
                return "Remark";
            }
            case 4: {
                return "allowed";
            }
        }
        return "?";
    }

    public boolean isCellEditable(int mColumn) {
        return mColumn != 1 || contextClasses != null;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public Object getValueAt(int col) {
        try {
            switch (col) {
                case 0: {
                    return ((Security)this.getObject()).getGrantee();
                }
                case 1: {
                    return ((Security)this.getObject()).getDomainContextObject();
                }
                case 2: {
                    return ((Security)this.getObject()).getPermissions();
                }
                case 3: {
                    return ((Security)this.getObject()).getMessage();
                }
                case 4: {
                    return ((Security)this.getObject()).isAllowed();
                }
            }
        }
        catch (Exception e) {
            LOGGER.warning("cannot retrieve value for column " + col, (Throwable)e);
        }
        return null;
    }

    public void setValueAt(int col, Object obj) {
        switch (col) {
            case 0: {
                ((Security)this.getObject()).setGrantee((PersistentDomainObject)obj);
                break;
            }
            case 1: {
                ((Security)this.getObject()).setDomainContextObject((PersistentDomainObject)obj);
                break;
            }
            case 2: {
                ((Security)this.getObject()).setPermissions((String)obj);
                break;
            }
            case 3: {
                ((Security)this.getObject()).setMessage((String)obj);
                break;
            }
            case 4: {
                ((Security)this.getObject()).setAllowed(((Boolean)obj).booleanValue());
            }
        }
    }

    public TableCellRenderer getCellRenderer(int col) {
        if (col == 0 || col == 1) {
            return new SecurityObjectCellRenderer();
        }
        return null;
    }

    public TableCellEditor getCellEditor(int col) {
        if (col == 0) {
            return new SecurityGranteeCellEditor();
        }
        if (col == 1) {
            return new SecurityContextCellEditor();
        }
        if (col == 2) {
            return new SecurityPermissionCellEditor();
        }
        return null;
    }

    public PersistentDomainObject selectGrantee() {
        return granteeClazz == null ? null : Rdc.createPdoSearchDialog(((Security)this.getObject()).getDomainContext(), granteeClazz, o -> granteeClazz.isAssignableFrom(o.getClass()), true, true).showDialog();
    }

    static {
        columnNames = new String[]{"User", "Context", "Permission", "Remark", "allowed"};
    }

    private class SecurityPermissionCellEditor
    extends FormFieldComponentCellEditor {
        private final PermissionEditor permissionEditor;
        private int width;
        private Popup popup;

        public SecurityPermissionCellEditor() {
            StringFormField field = (StringFormField)this.getEditorComponent();
            field.setChangeable(false);
            this.permissionEditor = new PermissionEditor(){

                public Dimension getPreferredSize() {
                    Dimension size = super.getPreferredSize();
                    size.width = SecurityPermissionCellEditor.this.width;
                    return size;
                }
            };
            this.permissionEditor.setOpaque(true);
            this.permissionEditor.setBorder(BorderFactory.createRaisedSoftBevelBorder());
            this.permissionEditor.addActionListener(e -> this.fireEditingStopped());
        }

        public String getCellEditorValue() {
            return this.permissionEditor.getPermissions();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.permissionEditor.setPermissions((String)value);
            this.permissionEditor.saveValue();
            SecurityTableEntry entry = (SecurityTableEntry)((FormTable)table).getEntryAt(row);
            this.permissionEditor.applyClazz(((Security)entry.getObject()).getObjectClass());
            Point tLoc = table.getLocationOnScreen();
            Rectangle rect = table.getCellRect(row, column, false);
            this.width = rect.width;
            this.popup = PopupFactory.getSharedInstance().getPopup(table, (Component)((Object)this.permissionEditor), tLoc.x + rect.x, tLoc.y + rect.y);
            this.popup.show();
            return (Component)this.getEditorComponent();
        }

        protected void fireEditingCanceled() {
            this.popup.hide();
            super.fireEditingCanceled();
        }

        protected void fireEditingStopped() {
            this.popup.hide();
            super.fireEditingStopped();
        }
    }

    private class SecurityContextCellEditor
    extends FormComponentCellEditor {
        private final FormButton button = new FormButton();
        private PersistentDomainObject contextObject;

        public SecurityContextCellEditor() {
            this.button.addActionListener(e -> {
                try {
                    PersistentDomainObject<?> obj = Rdc.createPdoSearchDialog(((Security)SecurityTableEntry.this.getObject()).getDomainContext(), contextClasses[0], o -> {
                        for (Class cls : contextClasses) {
                            if (!cls.equals(o.getClass())) continue;
                            return true;
                        }
                        return false;
                    }, true, true).showDialog();
                    if (obj == null) {
                        if (FormQuestion.yesNo((String)"free for all?")) {
                            this.contextObject = null;
                        }
                    } else {
                        this.contextObject = obj;
                    }
                }
                catch (Exception ex) {
                    LOGGER.severe(ex.toString(), new Object[0]);
                }
                this.stopCellEditing();
            });
        }

        public Object getCellEditorValue() {
            return this.contextObject;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.contextObject = (PersistentDomainObject)value;
            this.button.setText(this.contextObject == null ? "all" : this.contextObject.toString());
            return this.button;
        }
    }

    private class SecurityGranteeCellEditor
    extends FormComponentCellEditor {
        private final FormButton button = new FormButton();
        private PersistentDomainObject rootObject;

        public SecurityGranteeCellEditor() {
            this.button.addActionListener(e -> {
                try {
                    PersistentDomainObject obj = SecurityTableEntry.this.selectGrantee();
                    if (obj != null || FormQuestion.yesNo((String)"free for all?")) {
                        this.rootObject = obj;
                    }
                }
                catch (Exception ex) {
                    LOGGER.severe(ex.toString(), new Object[0]);
                }
                this.stopCellEditing();
            });
        }

        public Object getCellEditorValue() {
            return this.rootObject;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.rootObject = (PersistentDomainObject)value;
            this.button.setText(this.rootObject == null ? "all" : this.rootObject.toString());
            return this.button;
        }
    }

    private static class SecurityObjectCellRenderer
    extends FormTableCellRenderer {
        public SecurityObjectCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return super.getTableCellRendererComponent(table, (Object)(value != null ? ((PersistentDomainObject)value).getSingular() + " " + value : "all"), isSelected, hasFocus, row, column);
        }
    }
}

