/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.rdc;

import java.awt.EventQueue;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.tentackle.misc.ScrollableResource;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.session.AbstractSessionTask;
import org.tentackle.session.ModificationTracker;
import org.tentackle.session.Session;
import org.tentackle.session.SessionUtilities;
import org.tentackle.swing.FormInfo;
import org.tentackle.swing.GUIRuntimeException;
import org.tentackle.swing.rdc.PdoCursorProgressDialog;
import org.tentackle.swing.rdc.PdoSearch;
import org.tentackle.swing.rdc.RdcSwingRdcBundle;
import org.tentackle.task.Task;

public abstract class AbstractPdoSearch<T extends PersistentDomainObject<T>>
implements PdoSearch<T> {
    public static int defaultFetchSize = 1000;
    public static int defaultWarnRowCount = 5000;
    public static int defaultMaxRowCount = 100000;
    private final int pdoClassId;
    private final Class<T> pdoClass;
    private final DomainContext context;
    private final int warnRowCount;
    private final int maxRowCount;
    private final int fetchSize;
    private boolean searchImmediate;
    private boolean searchPanelInvisible;
    private boolean dialogNotShownIfSingleMatch;
    private boolean dialogShownIfSearchImmediateFails;
    private boolean tableViewInitiallyShown;
    private boolean viewModeFixed;
    private boolean viewRebuildNecessary;
    private String formTableName;

    public AbstractPdoSearch(Class<T> pdoClass, DomainContext context, int fetchSize, int warnRowCount, int maxRowCount) {
        this.pdoClass = pdoClass;
        this.pdoClassId = SessionUtilities.getInstance().getClassId(pdoClass.getName());
        this.context = context;
        this.warnRowCount = warnRowCount;
        this.maxRowCount = maxRowCount;
        this.fetchSize = fetchSize;
    }

    public AbstractPdoSearch(Class<T> pdoClass, DomainContext context) {
        this(pdoClass, context, defaultFetchSize, defaultWarnRowCount, defaultMaxRowCount);
    }

    @Override
    public int getPdoClassId() {
        return this.pdoClassId;
    }

    @Override
    public Class<T> getPdoClass() {
        return this.pdoClass;
    }

    public DomainContext getDomainContext() {
        return this.context;
    }

    @Override
    public T createPdo() {
        return (T)this.on(this.pdoClass);
    }

    @Override
    public void execute(Consumer<List<T>> pdoDisplay) {
        T proxy = this.createPdo();
        final boolean all = this.isSearchRetrievingAll();
        if (all && proxy.getCache() != null && proxy.getCache().isPreloading()) {
            pdoDisplay.accept(proxy.selectAllCached());
        } else {
            Session.assertCurrentSessionValid();
            if (!EventQueue.isDispatchThread()) {
                throw new GUIRuntimeException("not in AWT dispatch thread");
            }
            PdoCursorProgressDialog cursorDialog = this.warnRowCount > 0 ? new PdoCursorProgressDialog() : null;
            boolean runInDispatchThread = this.isSearchImmediate() && (this.isDialogNotShownIfSearchImmediateFindsSingleMatch() || !this.isDialogShownIfSearchImmediateFails());
            AbstractSessionTask searchTask = new AbstractSessionTask((PersistentDomainObject)proxy, cursorDialog, runInDispatchThread, pdoDisplay){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ PersistentDomainObject val$proxy;
                final /* synthetic */ PdoCursorProgressDialog val$cursorDialog;
                final /* synthetic */ boolean val$runInDispatchThread;
                final /* synthetic */ Consumer val$pdoDisplay;
                {
                    this.val$proxy = persistentDomainObject;
                    this.val$cursorDialog = pdoCursorProgressDialog;
                    this.val$runInDispatchThread = bl2;
                    this.val$pdoDisplay = consumer;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ArrayList list = new ArrayList();
                    try (ScrollableResource<PersistentDomainObject> cursor = all ? this.val$proxy.selectAllAsCursor() : AbstractPdoSearch.this.findByCriteria(this.val$proxy);){
                        List fetched;
                        cursor.setFetchSize(AbstractPdoSearch.this.fetchSize);
                        while (!(this.val$cursorDialog != null && this.val$cursorDialog.isAbortRequested() || (fetched = cursor.fetch()) == null)) {
                            list.addAll(fetched);
                            int count = list.size();
                            if (this.val$cursorDialog != null) {
                                if (this.val$cursorDialog.isShowing()) {
                                    EventQueue.invokeLater(() -> this.val$cursorDialog.updateRowCount(count));
                                } else if (count > AbstractPdoSearch.this.warnRowCount) {
                                    EventQueue.invokeLater(this.val$cursorDialog::showDialog);
                                }
                            }
                            if (AbstractPdoSearch.this.maxRowCount <= 0 || count <= AbstractPdoSearch.this.maxRowCount) continue;
                            EventQueue.invokeLater(() -> FormInfo.show((String)MessageFormat.format(RdcSwingRdcBundle.getString("MORE THAN {0} OBJECTS RETRIEVED -> ABORTED!"), AbstractPdoSearch.this.maxRowCount)));
                            break;
                        }
                    }
                    if (this.val$cursorDialog != null && this.val$cursorDialog.isShowing()) {
                        EventQueue.invokeLater(() -> this.val$cursorDialog.dispose());
                    }
                    if (this.val$runInDispatchThread) {
                        this.val$pdoDisplay.accept(list);
                    } else {
                        EventQueue.invokeLater(() -> this.val$pdoDisplay.accept(list));
                    }
                }
            };
            if (runInDispatchThread) {
                searchTask.run();
            } else {
                ModificationTracker.getInstance().addTask((Task)searchTask);
            }
        }
    }

    public abstract ScrollableResource<T> findByCriteria(T var1);

    @Override
    public boolean isSearchImmediate() {
        return this.searchImmediate;
    }

    public void setSearchImmediate(boolean searchImmediate) {
        this.searchImmediate = searchImmediate;
    }

    @Override
    public boolean isDialogNotShownIfSearchImmediateFindsSingleMatch() {
        return this.dialogNotShownIfSingleMatch;
    }

    public void setDialogNotShownIfSingleMatch(boolean dialogNotShownIfSingleMatch) {
        this.dialogNotShownIfSingleMatch = dialogNotShownIfSingleMatch;
    }

    @Override
    public boolean isSearchPanelInvisible() {
        return this.searchPanelInvisible;
    }

    public void setSearchPanelInvisible(boolean searchPanelInvisible) {
        this.searchPanelInvisible = searchPanelInvisible;
    }

    @Override
    public boolean isDialogShownIfSearchImmediateFails() {
        return this.dialogShownIfSearchImmediateFails;
    }

    public void setDialogShownIfSearchImmediateFails(boolean dialogShownIfSearchImmediateFails) {
        this.dialogShownIfSearchImmediateFails = dialogShownIfSearchImmediateFails;
    }

    @Override
    public boolean isTableViewInitiallyShown() {
        return this.tableViewInitiallyShown;
    }

    public void setTableViewInitiallyShown(boolean tableViewInitiallyShown) {
        this.tableViewInitiallyShown = tableViewInitiallyShown;
    }

    @Override
    public boolean isViewModeFixed() {
        return this.viewModeFixed;
    }

    public void setViewModeFixed(boolean viewModeFixed) {
        this.viewModeFixed = viewModeFixed;
    }

    @Override
    public boolean isViewRebuildNecessary() {
        return this.viewRebuildNecessary;
    }

    public void setViewRebuildNecessary(boolean viewRebuildNecessary) {
        this.viewRebuildNecessary = viewRebuildNecessary;
    }

    @Override
    public String getFormTableName() {
        return this.formTableName;
    }

    public void setFormTableName(String formTableName) {
        this.formTableName = formTableName;
    }
}

