/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.rdc;

import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ImageIcon;
import org.tentackle.misc.ObjectFilter;
import org.tentackle.misc.ShortLongText;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.swing.FormPanel;
import org.tentackle.swing.FormTableEntry;
import org.tentackle.swing.plaf.PlafUtilities;
import org.tentackle.swing.rdc.DefaultPdoTableEntry;
import org.tentackle.swing.rdc.DefaultSearch;
import org.tentackle.swing.rdc.GuiProvider;
import org.tentackle.swing.rdc.PdoEditDialog;
import org.tentackle.swing.rdc.PdoSearch;
import org.tentackle.swing.rdc.PdoTransferable;

public class DefaultGuiProvider<T extends PersistentDomainObject<T>>
implements GuiProvider<T> {
    private T pdo;

    public DefaultGuiProvider(T pdo) {
        this.setPdo(pdo);
    }

    public T getPdo() {
        return this.pdo;
    }

    public void setPdo(T pdo) {
        if (pdo == null) {
            throw new NullPointerException("pdo must not be null");
        }
        this.pdo = pdo;
    }

    public DomainContext getDomainContext() {
        return this.pdo.getDomainContext();
    }

    @Override
    public ImageIcon getIcon() {
        return PlafUtilities.getInstance().getIcon("unknown");
    }

    @Override
    public boolean panelExists() {
        return false;
    }

    @Override
    public FormPanel createPanel() {
        return null;
    }

    @Override
    public PdoEditDialog<T> createDialog(Component comp, boolean modal) {
        return null;
    }

    @Override
    public T getPanelObject() {
        return this.getPdo();
    }

    @Override
    public PdoTransferable<T> getTransferable() {
        return this.getPdo().getPersistenceDelegate().isNew() ? null : new PdoTransferable<T>(this.getPdo());
    }

    @Override
    public boolean dropTransferable(Transferable transferable) {
        return false;
    }

    @Override
    public PdoSearch<T> createPdoSearch() {
        return new DefaultSearch<T>(this.pdo);
    }

    @Override
    public FormTableEntry<T> getFormTableEntry() {
        return new DefaultPdoTableEntry<T>(this.getPdo());
    }

    @Override
    public String getFormTableName() {
        return "default";
    }

    public String toString() {
        return this.getClass().getName() + " for " + this.getPdo().toGenericString();
    }

    @Override
    public ObjectFilter<T> getTreeFilter() {
        return null;
    }

    @Override
    public boolean allowsTreeChildObjects() {
        return true;
    }

    @Override
    public Collection getTreeChildObjects() {
        return new ArrayList();
    }

    @Override
    public Collection getTreeChildObjects(Object parentObject) {
        return this.getTreeChildObjects();
    }

    @Override
    public int getTreeExpandMaxDepth() {
        return 0;
    }

    @Override
    public boolean allowsTreeParentObjects() {
        return false;
    }

    @Override
    public Collection getTreeParentObjects() {
        return new ArrayList();
    }

    @Override
    public Collection getTreeParentObjects(Object parentObject) {
        return this.getTreeParentObjects();
    }

    @Override
    public T getTreeRoot() {
        return this.getPdo();
    }

    @Override
    public String getTreeText() {
        if (this.getPdo() instanceof ShortLongText) {
            return ((ShortLongText)this.getPdo()).getShortText() + " : " + ((ShortLongText)this.getPdo()).getLongText();
        }
        return this.getPdo().toString();
    }

    @Override
    public String getTreeText(Object parent) {
        return this.getTreeText();
    }

    @Override
    public String getToolTipText() {
        return this.getTreeText();
    }

    @Override
    public String getToolTipText(Object parent) {
        return this.getToolTipText();
    }

    @Override
    public boolean stopTreeExpansion() {
        return false;
    }
}

