/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.rdc;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.Icon;
import org.tentackle.bind.BindingException;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.reflect.ReflectionHelper;
import org.tentackle.swing.FormButton;
import org.tentackle.swing.FormComponent;
import org.tentackle.swing.FormError;
import org.tentackle.swing.FormFieldComponent;
import org.tentackle.swing.FormFieldComponentPanel;
import org.tentackle.swing.FormQuestion;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.StringFormField;
import org.tentackle.swing.bind.FormComponentBinding;
import org.tentackle.swing.plaf.PlafUtilities;
import org.tentackle.swing.rdc.PdoEditDialogPool;
import org.tentackle.swing.rdc.PdoSearch;
import org.tentackle.swing.rdc.PdoSearchDialog;
import org.tentackle.swing.rdc.PdoTransferData;
import org.tentackle.swing.rdc.Rdc;
import org.tentackle.swing.rdc.RdcSwingRdcBundle;

public class PdoLinkPanel<T extends PersistentDomainObject<T>>
extends FormFieldComponentPanel
implements DropTargetListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdoLinkPanel.class);
    private PdoSearch<T> pdoSearch;
    private long linkedId;
    private T linkedObject;
    private DataFlavor dndFlavor;
    private DropTarget dropTarget;
    private boolean dropEnabled;
    private boolean changeable;
    private FormButton editButton;
    private FormButton linkButton;

    public PdoLinkPanel() {
        this.initComponents();
        this.dropEnabled = true;
        this.changeable = true;
        this.setFormComponent((FormComponent)new StringFormField());
        this.loadObject();
    }

    public void setName(String name) {
        super.setName(name);
        if (name != null) {
            ((Component)this.getFormComponent()).setName(name + "/key");
            this.editButton.setName(name + "/edit");
            this.linkButton.setName(name + "/link");
        } else {
            ((Component)this.getFormComponent()).setName("key");
            this.editButton.setName("edit");
            this.linkButton.setName("link");
        }
    }

    public void setFormComponent(FormComponent comp) {
        FormFieldComponent oldComponent = this.getFormComponent();
        if (oldComponent != null) {
            this.remove((Component)oldComponent);
        }
        super.setFormComponent(comp);
        comp.setChangeable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 1);
        this.add((Component)comp, gridBagConstraints);
        this.setDropEnabled(this.dropEnabled);
    }

    public void setDropEnabled(boolean dropEnabled) {
        this.dropEnabled = dropEnabled;
        if (dropEnabled) {
            this.dropTarget = new DropTarget((Component)this.getFormComponent(), this);
            this.dropTarget.setDefaultActions(3);
        } else {
            this.dropTarget = null;
        }
        this.updateFormComponentDropAndColor();
    }

    public boolean isDropEnabled() {
        return this.dropEnabled;
    }

    public void setEditButtonVisible(boolean visible) {
        this.editButton.setVisible(visible);
    }

    public boolean isEditButtonVisible() {
        return this.editButton.isVisible();
    }

    public void setFormValue(Object obj) {
        FormComponentBinding binding = this.getBinding();
        if (binding != null) {
            try {
                Class clazz = binding.getMember().getType();
                if (PersistentDomainObject.class.isAssignableFrom(clazz)) {
                    if (obj instanceof PersistentDomainObject) {
                        this.setLink(clazz, ((PersistentDomainObject)obj).getDomainContext(), ((PersistentDomainObject)obj).getId());
                    } else {
                        this.setLink(clazz, (DomainContext)binding.getBinder().getBindingProperty(DomainContext.class), 0L);
                    }
                    return;
                }
            }
            catch (Exception ex) {
                throw new BindingException("could not determine type for " + binding, (Throwable)ex);
            }
        }
        super.setFormValue(obj);
    }

    public Object getFormValue() {
        FormComponentBinding binding = this.getBinding();
        if (binding != null) {
            try {
                Class clazz = binding.getMember().getType();
                if (PersistentDomainObject.class.isAssignableFrom(clazz)) {
                    T pdo = this.getLink();
                    FormUtilities.getInstance().doValidate((FormComponent)this);
                    return pdo;
                }
            }
            catch (Exception ex) {
                throw new BindingException("could not determine type for " + binding, (Throwable)ex);
            }
        }
        return super.getFormValue();
    }

    public void setLink(PdoSearch<T> pdoSearch, long linkedId) {
        this.pdoSearch = pdoSearch;
        this.linkedId = linkedId;
        if (linkedId == 0L || pdoSearch == null) {
            this.linkedObject = null;
            this.linkedId = 0L;
        } else {
            try {
                this.linkedObject = pdoSearch.createPdo().selectCached(linkedId);
            }
            catch (Exception ex) {
                LOGGER.warning("loading PDO failed", (Throwable)ex);
            }
            if (this.linkedObject == null) {
                this.linkedId = 0L;
                this.fireValueEntered();
            }
        }
        this.loadObject();
    }

    public void setLink(T object) {
        if (object != null && this.pdoSearch != null && this.pdoSearch.getPdoClass().equals(object.getEffectiveClass())) {
            this.setLink(this.pdoSearch, object.getId());
        } else {
            this.setLink(this.pdoSearch, 0L);
        }
    }

    public void setLink(Class<T> clazz, DomainContext context, long linkedId, boolean keepPlugin) {
        try {
            if (context != null && clazz != null) {
                if (keepPlugin && this.pdoSearch != null) {
                    this.setLink(this.pdoSearch, linkedId);
                } else {
                    this.setLink(Rdc.createGuiProvider(Pdo.create(clazz, (DomainContext)context)).createPdoSearch(), linkedId);
                }
                return;
            }
        }
        catch (RuntimeException ex) {
            LOGGER.warning("installing search plugin failed", (Throwable)ex);
        }
        this.setLink(null, 0L);
    }

    public void setLink(Class<T> clazz, DomainContext context, long linkedId) {
        this.setLink(clazz, context, linkedId, false);
    }

    public long getLinkId() {
        return this.linkedId;
    }

    public T getLink() {
        return this.linkedObject;
    }

    public void setChangeable(boolean flag) {
        if (this.isHonourChangeable()) {
            this.changeable = flag;
            this.loadObject();
        }
    }

    public boolean isChangeable() {
        return this.changeable;
    }

    public boolean requestFocusInWindow() {
        if (this.isCellEditorUsage()) {
            return super.requestFocusInWindow();
        }
        if (this.linkedObject == null) {
            return this.linkButton.requestFocusInWindow();
        }
        return this.editButton.isVisible() && this.editButton.requestFocusInWindow();
    }

    public void setCellEditorUsage(boolean flag) {
        super.setCellEditorUsage(flag);
        this.editButton.setFocusable(!flag);
        this.linkButton.setFocusable(!flag);
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        if (!this.isDragAcceptable(event)) {
            event.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent event) {
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
        if (!this.isDragAcceptable(event)) {
            event.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        if (this.isDropAcceptable(event)) {
            event.acceptDrop(1);
            Transferable trans = event.getTransferable();
            try {
                Object transferData = trans.getTransferData(this.dndFlavor);
                if (transferData instanceof PdoTransferData) {
                    PersistentDomainObject object = this.pdoSearch.createPdo().selectCached(((PdoTransferData)transferData).getId());
                    this.setLink(object);
                    if (this.isAutoUpdate()) {
                        this.fireValueEntered();
                    }
                }
            }
            catch (Exception e) {
                FormError.showException((String)RdcSwingRdcBundle.getString("DROP ERROR:"), (Throwable)e);
            }
            event.dropComplete(true);
        } else {
            event.rejectDrop();
        }
    }

    private boolean isDragAcceptable(DropTargetDragEvent event) {
        return (event.getDropAction() & 3) != 0 && event.isDataFlavorSupported(this.dndFlavor);
    }

    private boolean isDropAcceptable(DropTargetDropEvent event) {
        return (event.getDropAction() & 3) != 0 && event.isDataFlavorSupported(this.dndFlavor);
    }

    private void loadObject() {
        this.linkButton.setEnabled(this.isChangeable());
        if (this.linkedObject == null) {
            this.getFormComponent().clearText();
            this.linkedId = 0L;
            this.linkButton.setIcon((Icon)PlafUtilities.getInstance().getIcon("link"));
            this.linkButton.setToolTipText(RdcSwingRdcBundle.getString("LINK"));
            this.editButton.setEnabled(false);
        } else {
            this.linkedId = this.linkedObject.getId();
            this.getFormComponent().setText(this.linkedObject.toString());
            this.linkButton.setIcon((Icon)PlafUtilities.getInstance().getIcon("unlink"));
            this.linkButton.setToolTipText(RdcSwingRdcBundle.getString("UNLINK"));
            this.editButton.setEnabled(this.isChangeable());
        }
        this.updateFormComponentDropAndColor();
    }

    private void updateFormComponentDropAndColor() {
        if (this.dropTarget != null) {
            if (this.isChangeable() && this.linkedId == 0L && this.pdoSearch != null) {
                this.dndFlavor = new DataFlavor(this.pdoSearch.getPdoClass(), ReflectionHelper.getClassBaseName(this.pdoSearch.getPdoClass()));
                this.dropTarget.setActive(true);
                ((Component)this.getFormComponent()).setBackground(PlafUtilities.getInstance().getDropFieldActiveColor());
            } else {
                this.dropTarget.setActive(false);
                ((Component)this.getFormComponent()).setBackground(PlafUtilities.getInstance().getDropFieldInactiveColor());
            }
        } else {
            ((Component)this.getFormComponent()).setBackground(PlafUtilities.getInstance().getTextFieldInactiveBackgroundColor());
        }
    }

    public PdoSearchDialog<T> createSearchDialog() {
        return Rdc.createPdoSearchDialog((Component)((Object)this), this.pdoSearch, o -> this.pdoSearch.getPdoClass().isAssignableFrom(o.getClass()), true, true);
    }

    public void runSearch() {
        if (this.pdoSearch != null) {
            try {
                this.linkedObject = this.createSearchDialog().showDialog();
            }
            catch (Exception ex) {
                FormError.showException((String)RdcSwingRdcBundle.getString("SEARCH FAILED"), (Throwable)ex);
            }
            this.loadObject();
            if (this.isAutoUpdate()) {
                this.fireValueEntered();
            }
        }
    }

    public void runEdit() {
        if (this.linkedObject != null && PdoEditDialogPool.getInstance().editModal(this.linkedObject) != null) {
            this.loadObject();
            if (this.isAutoUpdate()) {
                this.fireValueEntered();
            }
        }
    }

    private void initComponents() {
        this.linkButton = new FormButton();
        this.editButton = new FormButton();
        this.setToolTipText("");
        this.setLayout(new GridBagLayout());
        this.linkButton.setFormTraversable(true);
        this.linkButton.setIcon((Icon)PlafUtilities.getInstance().getIcon("link"));
        this.linkButton.setToolTipText(RdcSwingRdcBundle.getString("LINK"));
        this.linkButton.setName("link");
        this.linkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoLinkPanel.this.linkButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.add((Component)this.linkButton, gridBagConstraints);
        this.editButton.setIcon((Icon)PlafUtilities.getInstance().getIcon("edit"));
        this.editButton.setToolTipText(RdcSwingRdcBundle.getString("EDIT"));
        this.editButton.setName("edit");
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoLinkPanel.this.editButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.add((Component)this.editButton, gridBagConstraints);
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        this.runEdit();
    }

    private void linkButtonActionPerformed(ActionEvent evt) {
        if (this.linkedObject == null) {
            this.runSearch();
        } else if (FormQuestion.yesNo((String)MessageFormat.format(RdcSwingRdcBundle.getString("REMOVE LINK TO {0} {1}?"), this.linkedObject.getSingular(), this.linkedObject))) {
            this.linkedObject = null;
            this.loadObject();
            if (this.isAutoUpdate()) {
                this.fireValueEntered();
            }
        }
    }
}

