/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.rdc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.swing.FormButton;
import org.tentackle.swing.FormPanel;
import org.tentackle.swing.FormTable;
import org.tentackle.swing.FormTableEntry;
import org.tentackle.swing.FormTableModel;
import org.tentackle.swing.FormTableSorter;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.mocking.MockFormTableEntry;
import org.tentackle.swing.plaf.PlafUtilities;
import org.tentackle.swing.rdc.PdoTableCellRenderer;
import org.tentackle.swing.rdc.Rdc;
import org.tentackle.swing.rdc.RdcSwingRdcBundle;

public class PdoTablePanel<T extends PersistentDomainObject<T>>
extends FormPanel {
    private static final long serialVersionUID = -7533825918254146044L;
    private boolean templateChanged;
    private List<T> objList;
    private boolean ordered;
    private boolean unique;
    private FormTableModel<T> dataModel;
    private FormTableSorter<T> dataSorter;
    private FormTable<T> dataTable;
    private T current;
    private int rowIndex;
    private boolean forceSort;
    private int buttonMask;
    private boolean buttonsLessObstrusive;
    private boolean newBySearch;
    private FormTableEntry<T> template;
    public static final String ACTION_SAVE = "save";
    public static final String ACTION_CANCEL = "cancel";
    public static final int SHOW_CANCEL_BUTTON = 1;
    public static final int SHOW_DELETE_BUTTON = 2;
    public static final int SHOW_DOWN_BUTTON = 4;
    public static final int SHOW_UP_BUTTON = 8;
    public static final int SHOW_SAVE_BUTTON = 16;
    public static final int SHOW_NEW_BUTTON = 32;
    private FormPanel buttonPanel;
    private FormButton cancelButton;
    private JScrollPane dateScrollPane;
    private FormButton deleteButton;
    private JLabel jLabel1;
    private FormButton moveDownButton;
    private FormButton moveUpButton;
    private FormButton newButton;
    private FormButton saveButton;

    public PdoTablePanel(FormTableEntry<T> template, List<T> objList, boolean ordered, String prefName) {
        this.initComponents();
        this.buttonMask = !ordered ? 51 : 63;
        this.setVisibleButtons(this.buttonMask);
        this.setup(template, objList, ordered, prefName);
    }

    public PdoTablePanel() {
        this((FormTableEntry<T>)new MockFormTableEntry(), new ArrayList(), false, null);
    }

    public void setup(FormTableEntry<T> template, List<T> objList, boolean ordered, String prefName) {
        this.template = template;
        this.objList = objList;
        this.current = null;
        this.rowIndex = -1;
        this.forceSort = false;
        this.setOrdered(ordered);
        this.dataTable = this.createFormTable();
        if (this.dataModel != null) {
            this.dataModel.setTemplate(template);
        } else {
            this.dataModel = this.createFormTableModel(template);
        }
        this.dataSorter = null;
        if (ordered) {
            this.dataTable.setAutoCreateRowSorter(false);
            this.dataTable.setRowSorter(null);
        } else if (this.dataTable.getRowSorter() == null) {
            this.dataSorter = new FormTableSorter(this.dataModel);
        }
        this.dataTable.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.updateSelection();
            }
        });
        this.dataTable.setDragEnabled(true);
        this.dataTable.setSelectionMode(0);
        this.dataTable.setCellTraversal(1);
        this.dataTable.setSurrendersFocusOnKeystroke(true);
        this.dataTable.setDefaultRenderer(PersistentDomainObject.class, (TableCellRenderer)((Object)new PdoTableCellRenderer()));
        this.setTableName(prefName);
        this.dateScrollPane.setViewportView((Component)this.dataTable);
        this.dataTable.setModel(this.dataSorter == null ? this.dataModel : this.dataSorter);
        this.dataModel.listChanged(objList);
        this.updateSelection();
    }

    public FormTable<T> createFormTable() {
        return Rdc.createFormTable();
    }

    public FormTableModel<T> createFormTableModel(FormTableEntry<T> template) {
        FormTableModel model = new FormTableModel(template);
        model.bind();
        return model;
    }

    public FormPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setNewBySearch(boolean newBySearch) {
        this.newBySearch = newBySearch;
    }

    public boolean getNewBySearch() {
        return this.newBySearch;
    }

    public T searchObject() {
        PersistentDomainObject pdo = (PersistentDomainObject)this.template.getObject();
        return (T)Rdc.createPdoSearchDialog((Component)((Object)this), pdo.getDomainContext(), pdo.getEffectiveClass(), o -> pdo.getEffectiveClass().isAssignableFrom(o.getClass()), false, true).showDialog();
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setTableName(String prefName) {
        this.dataTable.setName(prefName);
        if (prefName != null) {
            this.dataTable.setCreateDefaultColumnsFromPreferences(true);
            this.dataTable.setUtilityPopup(Rdc.createPopup());
        } else {
            this.dataTable.setCreateDefaultColumnsFromPreferences(false);
            this.dataTable.setUtilityPopup(null);
        }
    }

    public String getTableName() {
        return this.dataTable.getName();
    }

    public void setVisibleButtons(int mask) {
        this.buttonMask = mask;
        this.cancelButton.setVisible(this.isCancelButtonVisible());
        this.deleteButton.setVisible(this.isDeleteButtonVisible());
        this.moveDownButton.setVisible(this.isDownButtonVisible());
        this.moveUpButton.setVisible(this.isUpButtonVisible());
        this.saveButton.setVisible(this.isSaveButtonVisible());
        this.newButton.setVisible(this.isNewButtonVisible());
    }

    public int getVisibleButtons() {
        return this.buttonMask;
    }

    public void setCancelButtonVisible(boolean visible) {
        this.buttonMask = visible ? this.buttonMask | 1 : this.buttonMask & 0xFFFFFFFE;
        this.cancelButton.setVisible(visible);
    }

    public boolean isCancelButtonVisible() {
        return (this.buttonMask & 1) != 0;
    }

    public void setDeleteButtonVisible(boolean visible) {
        this.buttonMask = visible ? this.buttonMask | 2 : this.buttonMask & 0xFFFFFFFD;
        this.deleteButton.setVisible(visible);
    }

    public boolean isDeleteButtonVisible() {
        return (this.buttonMask & 2) != 0;
    }

    public void setDownButtonVisible(boolean visible) {
        this.buttonMask = visible ? this.buttonMask | 4 : this.buttonMask & 0xFFFFFFFB;
        this.moveDownButton.setVisible(visible);
    }

    public boolean isDownButtonVisible() {
        return (this.buttonMask & 4) != 0;
    }

    public void setUpButtonVisible(boolean visible) {
        this.buttonMask = visible ? this.buttonMask | 8 : this.buttonMask & 0xFFFFFFF7;
        this.moveUpButton.setVisible(visible);
    }

    public boolean isUpButtonVisible() {
        return (this.buttonMask & 8) != 0;
    }

    public void setSaveButtonVisible(boolean visible) {
        this.buttonMask = visible ? this.buttonMask | 0x10 : this.buttonMask & 0xFFFFFFEF;
        this.saveButton.setVisible(visible);
    }

    public boolean isSaveButtonVisible() {
        return (this.buttonMask & 0x10) != 0;
    }

    public void setNewButtonVisible(boolean visible) {
        this.buttonMask = visible ? this.buttonMask | 0x20 : this.buttonMask & 0xFFFFFFDF;
        this.newButton.setVisible(visible);
    }

    public boolean isNewButtonVisible() {
        return (this.buttonMask & 0x20) != 0;
    }

    public void setButtonsLessObtrusive(boolean flag) {
        this.buttonsLessObstrusive = flag;
        this.setButtonLessObtrusive((JButton)this.cancelButton, flag);
        this.setButtonLessObtrusive((JButton)this.deleteButton, flag);
        this.setButtonLessObtrusive((JButton)this.moveDownButton, flag);
        this.setButtonLessObtrusive((JButton)this.moveUpButton, flag);
        this.setButtonLessObtrusive((JButton)this.saveButton, flag);
        this.setButtonLessObtrusive((JButton)this.newButton, flag);
    }

    public FormButton getCancelButton() {
        return this.cancelButton;
    }

    public FormButton getDeleteButton() {
        return this.deleteButton;
    }

    public FormButton getMoveDownButton() {
        return this.moveDownButton;
    }

    public FormButton getMoveUpButton() {
        return this.moveUpButton;
    }

    public FormButton getSaveButton() {
        return this.saveButton;
    }

    public FormButton getNewButton() {
        return this.newButton;
    }

    public boolean getButtonsLessObtrusive() {
        return this.buttonsLessObstrusive;
    }

    private void setButtonLessObtrusive(JButton button, boolean flag) {
        if (flag) {
            button.setMargin(new Insets(0, 0, 0, 0));
            button.setBorderPainted(false);
        } else {
            button.setMargin(new Insets(1, 3, 1, 3));
            button.setBorderPainted(true);
        }
    }

    public void setTemplate(FormTableEntry<T> template) {
        if (!Objects.equals(this.template, template)) {
            this.template = template;
            this.templateChanged = true;
            this.dataModel.setTemplate(template);
            this.dataModel.bind();
        }
    }

    public FormTableEntry<T> getTemplate() {
        return this.template;
    }

    public void setChangeable(boolean changeable) {
        super.setChangeable(changeable);
        if (changeable) {
            this.updateSelection();
        } else {
            this.cancelButton.setEnabled(true);
        }
    }

    public void listChanged(List<T> objList) {
        this.objList = objList;
        if (this.templateChanged) {
            this.templateChanged = false;
            this.setup(this.template, objList, this.ordered, this.getTableName());
        } else {
            this.dataModel.listChanged(objList);
            this.dataTable.clearSelection();
        }
    }

    public boolean isDataChanged() {
        return this.dataModel.isDataChanged();
    }

    public FormTable<T> getFormTable() {
        return this.dataTable;
    }

    public FormTableModel<T> getFormTableModel() {
        return this.dataModel;
    }

    public FormTableSorter<T> getFormTableSorter() {
        return this.dataSorter;
    }

    public void addTableModelListener(TableModelListener l) {
        this.dataModel.addTableModelListener(l);
    }

    public void removeTableModelListener(TableModelListener l) {
        this.dataModel.removeTableModelListener(l);
    }

    public void move(boolean down) {
        int swapIndex = this.rowIndex + (down ? 1 : -1);
        int currentRowHeight = this.dataTable.getRowHeight(this.rowIndex);
        int swapRowHeight = this.dataTable.getRowHeight(swapIndex);
        PersistentDomainObject swapObject = (PersistentDomainObject)this.objList.get(swapIndex);
        this.objList.set(swapIndex, this.current);
        this.objList.set(this.rowIndex, swapObject);
        if (down) {
            this.dataModel.listUpdated(this.rowIndex, swapIndex);
        } else {
            this.dataModel.listUpdated(swapIndex, this.rowIndex);
        }
        this.dataTable.setRowHeight(this.rowIndex, swapRowHeight);
        this.dataTable.setRowHeight(swapIndex, currentRowHeight);
        this.dataTable.setSelectedRow(swapIndex);
    }

    public boolean add(T object) {
        if (!(object == null || this.unique && this.objList.contains(object))) {
            if (this.ordered) {
                int itemIndex = this.rowIndex + (this.objList.size() <= 1 ? 1 : 0);
                if (itemIndex < 0) {
                    itemIndex = 0;
                }
                this.objList.add(itemIndex, object);
                this.dataModel.listInserted(itemIndex, itemIndex);
                this.dataTable.setSelectedRow(itemIndex);
            } else {
                this.objList.add(object);
                int itemIndex = this.objList.size() - 1;
                this.dataModel.listInserted(itemIndex, itemIndex);
                int tableRow = this.dataSorter == null ? itemIndex : this.dataSorter.getModelIndex(itemIndex);
                this.dataTable.setSelectedRow(tableRow);
                this.forceSort = true;
            }
            return true;
        }
        return false;
    }

    public boolean delete() {
        if (this.rowIndex >= 0) {
            int tableIndex = this.dataTable.getSelectedRow();
            this.objList.remove(this.rowIndex);
            this.dataModel.listDeleted(this.rowIndex, this.rowIndex);
            if (tableIndex >= this.objList.size()) {
                if (this.objList.isEmpty()) {
                    this.dataTable.clearSelection();
                } else {
                    tableIndex = this.objList.size() - 1;
                    this.dataTable.setSelectedRow(tableIndex);
                }
            }
            return true;
        }
        return false;
    }

    private void fireActionPerformed(String action) {
        this.fireActionPerformed(new ActionEvent((Object)this, 1001, action));
    }

    private void updateSelection() {
        this.rowIndex = this.dataTable.getSelectedRow();
        if (this.dataSorter != null) {
            this.rowIndex = this.dataSorter.getModelIndex(this.rowIndex);
        }
        if (this.rowIndex >= 0 && this.rowIndex < this.objList.size()) {
            this.rowIndex = this.dataTable.convertRowIndexToModel(this.rowIndex);
            if (this.dataSorter != null) {
                this.rowIndex = this.dataSorter.getModelIndex(this.rowIndex);
            }
            this.current = (PersistentDomainObject)this.objList.get(this.rowIndex);
            if (this.current != null && (this.current.isNew() || this.current.isRemovable())) {
                this.deleteButton.setEnabled(this.isChangeable());
            } else {
                this.deleteButton.setEnabled(false);
            }
            this.newButton.setEnabled(this.isChangeable());
            this.moveUpButton.setEnabled(this.isChangeable() && this.rowIndex > 0);
            this.moveDownButton.setEnabled(this.isChangeable() && this.rowIndex < this.objList.size() - 1);
        } else {
            this.current = null;
            this.newButton.setEnabled(this.isChangeable());
            this.deleteButton.setEnabled(false);
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
        }
        if (this.dataSorter != null && this.forceSort) {
            this.dataSorter.sort();
            this.forceSort = false;
        }
    }

    protected T createPdo() {
        return (T)Pdo.create((PersistentDomainObject)((PersistentDomainObject)this.template.getObject()));
    }

    private void initComponents() {
        this.dateScrollPane = new JScrollPane();
        this.buttonPanel = new FormPanel();
        this.newButton = new FormButton();
        this.saveButton = new FormButton();
        this.deleteButton = new FormButton();
        this.cancelButton = new FormButton();
        this.moveUpButton = new FormButton();
        this.moveDownButton = new FormButton();
        this.jLabel1 = new JLabel();
        this.setLayout(new BorderLayout());
        this.add(this.dateScrollPane, "Center");
        this.buttonPanel.setLayout((LayoutManager)new GridBagLayout());
        this.newButton.setIcon((Icon)PlafUtilities.getInstance().getIcon("add"));
        this.newButton.setText(RdcSwingRdcBundle.getString("ADD"));
        this.newButton.setToolTipText(RdcSwingRdcBundle.getString("ADD A NEW ROW"));
        this.newButton.setMargin(new Insets(1, 3, 1, 3));
        this.newButton.setName("add");
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoTablePanel.this.newButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.buttonPanel.add((Component)this.newButton, (Object)gridBagConstraints);
        this.saveButton.setIcon((Icon)PlafUtilities.getInstance().getIcon(ACTION_SAVE));
        this.saveButton.setText(RdcSwingRdcBundle.getString("SAVE"));
        this.saveButton.setToolTipText(RdcSwingRdcBundle.getString("SAVE ALL ROWS"));
        this.saveButton.setMargin(new Insets(1, 3, 1, 3));
        this.saveButton.setName(ACTION_SAVE);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoTablePanel.this.saveButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.buttonPanel.add((Component)this.saveButton, (Object)gridBagConstraints);
        this.deleteButton.setIcon((Icon)PlafUtilities.getInstance().getIcon("subtract"));
        this.deleteButton.setText(RdcSwingRdcBundle.getString("REMOVE"));
        this.deleteButton.setToolTipText(RdcSwingRdcBundle.getString("REMOVE ROW"));
        this.deleteButton.setMargin(new Insets(1, 3, 1, 3));
        this.deleteButton.setName("remove");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoTablePanel.this.deleteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.buttonPanel.add((Component)this.deleteButton, (Object)gridBagConstraints);
        this.cancelButton.setIcon((Icon)PlafUtilities.getInstance().getIcon("close"));
        this.cancelButton.setText(RdcSwingRdcBundle.getString("CANCEL"));
        this.cancelButton.setToolTipText(RdcSwingRdcBundle.getString("DISCARD CHANGES AND CLOSE"));
        this.cancelButton.setMargin(new Insets(1, 3, 1, 3));
        this.cancelButton.setName(ACTION_CANCEL);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoTablePanel.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.buttonPanel.add((Component)this.cancelButton, (Object)gridBagConstraints);
        this.moveUpButton.setIcon((Icon)PlafUtilities.getInstance().getIcon("up"));
        this.moveUpButton.setText(RdcSwingRdcBundle.getString("UP"));
        this.moveUpButton.setToolTipText(RdcSwingRdcBundle.getString("MOVE UP ONE ROW"));
        this.moveUpButton.setMargin(new Insets(1, 3, 1, 3));
        this.moveUpButton.setName("up");
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoTablePanel.this.moveUpButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.buttonPanel.add((Component)this.moveUpButton, (Object)gridBagConstraints);
        this.moveDownButton.setIcon((Icon)PlafUtilities.getInstance().getIcon("down"));
        this.moveDownButton.setText(RdcSwingRdcBundle.getString("DOWN"));
        this.moveDownButton.setToolTipText(RdcSwingRdcBundle.getString("MOVE DOWN ONE ROW"));
        this.moveDownButton.setMargin(new Insets(1, 3, 1, 3));
        this.moveDownButton.setName("down");
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdoTablePanel.this.moveDownButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.buttonPanel.add((Component)this.moveDownButton, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.buttonPanel.add((Component)this.jLabel1, (Object)gridBagConstraints);
        this.add((Component)this.buttonPanel, "South");
    }

    private void moveDownButtonActionPerformed(ActionEvent evt) {
        this.move(true);
    }

    private void moveUpButtonActionPerformed(ActionEvent evt) {
        this.move(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.fireActionPerformed(ACTION_CANCEL);
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        if (this.delete()) {
            FormUtilities.getInstance().requestFocusLater(this.dataTable);
        }
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.fireActionPerformed(ACTION_SAVE);
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        T pdo;
        T t = pdo = this.newBySearch ? this.searchObject() : this.createPdo();
        if (this.add(pdo)) {
            this.dataTable.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
            this.dataTable.requestFocusInWindow();
        }
    }
}

