/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.rdc;

import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.swing.rdc.PdoTree;
import org.tentackle.swing.rdc.PdoTreeExtension;
import org.tentackle.swing.rdc.PdoTreeObject;
import org.tentackle.swing.rdc.PdoTreeToggleNodeObject;
import org.tentackle.swing.rdc.Rdc;

public abstract class PdoTreeExtensionToggleNode {
    private final int toggleNodeId;
    private PdoTree tree;
    private DefaultMutableTreeNode popupNode;
    private TreePath popupPath;
    private int childIndex;

    public PdoTreeExtensionToggleNode(int toggleNodeId) {
        this.toggleNodeId = toggleNodeId;
    }

    public int getToggleNodeId() {
        return this.toggleNodeId;
    }

    public PdoTree getTree() {
        return this.tree;
    }

    public DefaultMutableTreeNode getPopupNode() {
        return this.popupNode;
    }

    public int getChildIndex() {
        return this.childIndex;
    }

    public abstract PdoTreeToggleNodeObject getToggleNodeObject(Object var1);

    public abstract JMenuItem getMenuItem(boolean var1);

    public JMenuItem getMenuItem(PdoTree tree, DefaultMutableTreeNode popupNode, TreePath popupPath) {
        this.tree = tree;
        this.popupNode = popupNode;
        this.popupPath = popupPath;
        boolean toggleNodeDisplayed = false;
        int childNum = popupNode.getChildCount();
        this.childIndex = 0;
        while (this.childIndex < childNum) {
            TreeNode childNode = popupNode.getChildAt(this.childIndex);
            if (childNode instanceof DefaultMutableTreeNode) {
                Object userObject = ((DefaultMutableTreeNode)childNode).getUserObject();
                if (!(userObject instanceof PdoTreeToggleNodeObject)) break;
                if (((PdoTreeToggleNodeObject)userObject).getToggleNodeId() == this.toggleNodeId) {
                    toggleNodeDisplayed = true;
                    break;
                }
            }
            ++this.childIndex;
        }
        return this.getMenuItem(toggleNodeDisplayed);
    }

    public void insertObjects(List list) {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        DefaultMutableTreeNode toggleNode = this.showToggleNode();
        if (list != null && !list.isEmpty()) {
            for (Object obj : list) {
                if (!this.tree.isObjectAppendable(obj)) continue;
                PdoTreeObject to = new PdoTreeObject(obj, null);
                DefaultMutableTreeNode childnode = new DefaultMutableTreeNode(to);
                childnode.setAllowsChildren(obj instanceof PdoTreeExtension && ((PdoTreeExtension)obj).allowsTreeChildObjects() || obj instanceof PersistentDomainObject && Rdc.createGuiProvider((PersistentDomainObject)obj).allowsTreeChildObjects());
                model.insertNodeInto(childnode, toggleNode, toggleNode.getChildCount());
            }
        }
        this.tree.doExpandPath(0, 1, null, this.popupPath);
        this.tree.doExpandPath(0, 1, null, this.popupPath.pathByAddingChild(toggleNode));
    }

    public DefaultMutableTreeNode showToggleNode() {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        Object popupObject = ((PdoTreeObject)this.popupNode.getUserObject()).getObject();
        DefaultMutableTreeNode toggleNode = new DefaultMutableTreeNode(this.getToggleNodeObject(popupObject));
        model.insertNodeInto(toggleNode, this.popupNode, 0);
        return toggleNode;
    }

    public void hideToggleNode() {
        ((DefaultTreeModel)this.tree.getModel()).removeNodeFromParent((DefaultMutableTreeNode)this.popupNode.getChildAt(this.childIndex));
    }
}

