/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.rdc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.tentackle.log.Logger;
import org.tentackle.swing.FormPanel;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.StringFormField;
import org.tentackle.swing.TooltipDisplay;
import org.tentackle.swing.plaf.PlafUtilities;
import org.tentackle.swing.rdc.InteractiveError;

public class TooltipAndErrorPanel
extends FormPanel
implements TooltipDisplay {
    private static final long serialVersionUID = 3958009871918539709L;
    private List<InteractiveError> errors;
    private final ErrorModel model;
    private int visibleErrorCount = 4;
    private JList<InteractiveError> errorList;
    private JScrollPane errorPane;
    private StringFormField tipField;

    public TooltipAndErrorPanel() {
        this.initComponents();
        this.tipField.setFont(this.tipField.getFont().deriveFont(0));
        this.setTooltipEnabled(false);
        this.model = new ErrorModel();
        this.errorPane.setVisible(false);
        this.errorList.setModel(this.model);
        this.errorList.setSelectionMode(0);
        this.errorList.setCellRenderer(new ErrorCellRenderer());
        this.errorList.addListSelectionListener(e -> {
            InteractiveError error;
            if (!e.getValueIsAdjusting() && (error = this.errorList.getSelectedValue()) != null) {
                error.showComponent();
            }
        });
    }

    public boolean areValuesChanged() {
        return false;
    }

    public void setTooltipEnabled(boolean enable) {
        this.tipField.setVisible(enable);
    }

    public boolean isTooltipEnabled() {
        return this.tipField.isVisible();
    }

    public void setVisibleErrorCount(int rows) {
        this.visibleErrorCount = rows;
        this.updateVisibleRows();
    }

    public int getVisibleErrorCount() {
        return this.visibleErrorCount;
    }

    public void setTooltip(String tooltip) {
        this.tipField.setText(tooltip);
    }

    public String getTooltip() {
        return this.tipField.getText();
    }

    public void clearErrors() {
        if (this.errors != null) {
            this.errors = null;
            this.errorPane.setVisible(false);
            FormUtilities.getInstance().packParentWindow((Component)((Object)this));
        }
    }

    public List<InteractiveError> getErrors() {
        return this.errors;
    }

    public void setErrors(List<InteractiveError> errors) {
        if (errors == null || errors.isEmpty()) {
            this.clearErrors();
        } else {
            this.errors = errors;
            this.updateVisibleRows();
            this.model.fireListChanged();
            this.errorPane.setVisible(true);
            InteractiveError ierr = errors.get(0);
            if (ierr.getFormComponent() != null) {
                ierr.getFormComponent().requestFocusLater();
            }
            this.errorList.clearSelection();
            FormUtilities.getInstance().packParentWindow((Component)((Object)this));
        }
    }

    public void setErrors(InteractiveError ... error) {
        this.setErrors(Arrays.asList(error));
    }

    private void updateVisibleRows() {
        if (this.errors != null) {
            int rows = this.errors.size();
            if (rows > this.visibleErrorCount) {
                rows = this.visibleErrorCount;
            }
            this.errorList.setVisibleRowCount(rows);
        }
    }

    private void initComponents() {
        this.tipField = new StringFormField();
        this.errorPane = new JScrollPane();
        this.errorList = new JList();
        this.setTriggerValuesChangedEnabled(false);
        this.setLayout(new BorderLayout());
        this.tipField.setChangeable(false);
        this.tipField.setName("tipField");
        this.add((Component)this.tipField, "North");
        this.errorList.setBackground(PlafUtilities.getInstance().getAlarmBackgroundColor());
        this.errorList.setFocusable(false);
        this.errorList.setName("errorList");
        this.errorPane.setViewportView(this.errorList);
        this.add(this.errorPane, "Center");
    }

    private static class ErrorCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 5377387954067688753L;

        private ErrorCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel comp = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof InteractiveError) {
                this.setIcon(((InteractiveError)value).getLevel() == Logger.Level.SEVERE ? PlafUtilities.getInstance().getIcon("error") : PlafUtilities.getInstance().getIcon("warning"));
            }
            return comp;
        }
    }

    private class ErrorModel
    extends AbstractListModel<InteractiveError> {
        private static final long serialVersionUID = 4345877639111757820L;

        private ErrorModel() {
        }

        @Override
        public int getSize() {
            return TooltipAndErrorPanel.this.errors == null ? 0 : TooltipAndErrorPanel.this.errors.size();
        }

        @Override
        public InteractiveError getElementAt(int i) {
            return TooltipAndErrorPanel.this.errors == null ? null : (InteractiveError)TooltipAndErrorPanel.this.errors.get(i);
        }

        public void fireListChanged() {
            this.fireContentsChanged(this, 0, TooltipAndErrorPanel.this.errors.size() - 1);
        }
    }
}

