/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.rdc;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Objects;
import org.tentackle.bind.BindingException;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.DomainContextProvider;
import org.tentackle.pdo.PdoRuntimeException;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.swing.AbstractFormField;
import org.tentackle.swing.FormFieldComboBox;
import org.tentackle.swing.bind.FormComponentBinding;

public class PdoComboBox<T extends PersistentDomainObject<T>>
extends FormFieldComboBox<T>
implements DomainContextProvider {
    private static final long serialVersionUID = 1L;
    private Class<T> pdoClass;
    private DomainContext domainContext;
    private boolean contextChanged;

    public PdoComboBox(AbstractFormField editorField) {
        super(editorField);
    }

    public PdoComboBox() {
    }

    public void setDomainContext(DomainContext domainContext) {
        this.contextChanged |= !Objects.equals(this.domainContext, domainContext);
        this.domainContext = domainContext;
    }

    public DomainContext getDomainContext() {
        return this.domainContext;
    }

    public void setPdoClass(Class<T> pdoClass) {
        this.contextChanged |= !Objects.equals(this.pdoClass, pdoClass);
        this.pdoClass = pdoClass;
    }

    public Class<T> getPdoClass() {
        return this.pdoClass;
    }

    public void loadItemsIfContextChanged() {
        FormComponentBinding binding = this.getBinding();
        if (binding != null) {
            try {
                Class clazz = binding.getMember().getType();
                if (PersistentDomainObject.class.isAssignableFrom(clazz)) {
                    this.setDomainContext((DomainContext)binding.getBinder().getBindingProperty(DomainContext.class));
                    this.setPdoClass(clazz);
                }
            }
            catch (Exception ex) {
                throw new BindingException("could not determine type for " + binding, (Throwable)ex);
            }
        }
        if (this.contextChanged && this.domainContext != null && this.pdoClass != null) {
            this.contextChanged = false;
            try {
                try {
                    this.setAllItems((Collection)this.pdoClass.getMethod("selectAllPdoCached", DomainContext.class).invoke(null, this.domainContext));
                }
                catch (NoSuchMethodException nme) {
                    this.setAllItems(this.on(this.pdoClass).selectAll());
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException ex) {
                throw new PdoRuntimeException(this.domainContext.getSession(), "cannot load items into combobox for " + binding, (Throwable)ex);
            }
        }
    }

    public void setFormValue(Object item) {
        this.loadItemsIfContextChanged();
        super.setFormValue(item);
    }

    public T getFormValue() {
        if (this.getBinding() != null) {
            String valueText;
            Object item = this.getSelectedItem();
            if (item == null && this.isEditable() && !this.isAllowDeselect() && (valueText = this.getText()) != null && valueText.length() > 0) {
                this.requestFocusLater();
            }
            return (T)((PersistentDomainObject)item);
        }
        return (T)((PersistentDomainObject)super.getFormValue());
    }
}

