/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.plaf.tinylaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;
import net.sf.tinylaf.TinyRadioButtonUI;
import org.tentackle.swing.FormRadioButton;
import org.tentackle.swing.plaf.TFlasherListener;
import org.tentackle.swing.plaf.TentackleLookAndFeel;

public class TTinyRadioButtonUI
extends TinyRadioButtonUI {
    private static final TTinyRadioButtonUI radioButtonUI = new TTinyRadioButtonUI();

    public static ComponentUI createUI(JComponent c) {
        return radioButtonUI;
    }

    public synchronized void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        Color selectedColor = null;
        Color unselectedColor = null;
        if (b instanceof FormRadioButton) {
            selectedColor = ((FormRadioButton)b).getSelectedColor();
            unselectedColor = ((FormRadioButton)b).getUnselectedColor();
        }
        ButtonModel model = b.getModel();
        Dimension size = c.getSize();
        int w = size.width;
        int h = size.height;
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics();
        Rectangle viewRect = new Rectangle(size);
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Insets i = c.getInsets();
        viewRect.x += i.left;
        viewRect.y += i.top;
        viewRect.width -= i.right + viewRect.x;
        viewRect.height -= i.bottom + viewRect.y;
        Icon altIcon = b.getIcon();
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), altIcon != null ? altIcon : this.getDefaultIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getIconTextGap());
        if (c.isOpaque()) {
            if (c instanceof FormRadioButton && ((FormRadioButton)c).isMandatory()) {
                g.setColor(UIManager.getColor("RadioButton.mandatoryBackground"));
            } else {
                g.setColor(b.getBackground());
            }
            g.fillRect(0, 0, size.width, size.height);
        }
        if (altIcon != null) {
            if (!model.isEnabled()) {
                altIcon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                altIcon = b.getPressedIcon();
                if (altIcon == null) {
                    altIcon = b.getSelectedIcon();
                }
            } else if (model.isSelected()) {
                if (b.isRolloverEnabled() && model.isRollover()) {
                    altIcon = b.getRolloverSelectedIcon();
                    if (altIcon == null) {
                        altIcon = b.getSelectedIcon();
                    }
                } else {
                    altIcon = b.getSelectedIcon();
                }
            } else if (b.isRolloverEnabled() && model.isRollover()) {
                altIcon = b.getRolloverIcon();
            }
            if (altIcon == null) {
                altIcon = b.getIcon();
            }
            altIcon.paintIcon(c, g, iconRect.x, iconRect.y);
        } else {
            this.getDefaultIcon().paintIcon(c, g, iconRect.x, iconRect.y);
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                int mnemIndex = b.getDisplayedMnemonicIndex();
                if (selectedColor != null && b.isSelected()) {
                    g.setColor(selectedColor);
                    BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
                } else if (unselectedColor != null && !b.isSelected()) {
                    g.setColor(unselectedColor);
                    BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
                } else if (model.isEnabled()) {
                    g.setColor(b.getForeground());
                    BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
                } else {
                    g.setColor(this.getDisabledTextColor());
                    BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
                }
            }
        }
        if (c.hasFocus() && ((AbstractButton)c).isFocusPainted()) {
            this.paintFlashingFocus(g, c);
        }
    }

    protected void paintFocus(Graphics g, Rectangle t, Dimension d) {
    }

    private void paintFlashingFocus(Graphics g, JComponent c) {
        g.setColor(!((TentackleLookAndFeel)UIManager.getLookAndFeel()).isFocusAnimated() || TFlasherListener.isFlasherVisible() ? this.getFocusColor() : c.getBackground());
        g.drawRect(0, 0, c.getWidth() - 1, c.getHeight() - 2);
    }

    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        if (((TentackleLookAndFeel)UIManager.getLookAndFeel()).isFocusAnimated()) {
            b.addFocusListener((FocusListener)new TFlasherListener((JComponent)b));
        }
    }

    protected void uninstallListeners(AbstractButton b) {
        super.uninstallListeners(b);
        TFlasherListener.removeFlasherListener((JComponent)b);
    }
}

