/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.plaf.tinylaf;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import net.sf.tinylaf.TinyComboBoxUI;
import org.tentackle.swing.plaf.TComboPopup;
import org.tentackle.swing.plaf.TFlasherListener;
import org.tentackle.swing.plaf.TentackleLookAndFeel;
import org.tentackle.swing.plaf.tinylaf.TTinyComboBoxButton;

public class TTinyComboBoxUI
extends TinyComboBoxUI {
    private static final Insets DEFAULT_INSETS = new Insets(0, 0, 0, 0);

    public static ComponentUI createUI(JComponent c) {
        return new TTinyComboBoxUI();
    }

    protected void installListeners() {
        super.installListeners();
        if (((TentackleLookAndFeel)UIManager.getLookAndFeel()).isFocusAnimated()) {
            this.comboBox.addFocusListener((FocusListener)((Object)new TComboBoxFlasherListener()));
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        TFlasherListener.removeFlasherListener((JComponent)this.comboBox);
    }

    public PropertyChangeListener createPropertyChangeListener() {
        return new TMetalPropertyChangeListener();
    }

    protected JButton createArrowButton() {
        TTinyComboBoxButton button = new TTinyComboBoxButton(this.comboBox, null, this.comboBox.isEditable(), this.currentValuePane, this.listBox);
        button.setMargin(DEFAULT_INSETS);
        button.putClientProperty("isComboBoxButton", Boolean.TRUE);
        return button;
    }

    protected ComboPopup createPopup() {
        return new TComboPopup(this.comboBox);
    }

    private class TComboBoxFlasherListener
    extends TFlasherListener {
        public TComboBoxFlasherListener() {
            super((JComponent)TTinyComboBoxUI.this.comboBox);
        }

        public void actionPerformed(ActionEvent e) {
            if (!TTinyComboBoxUI.this.comboBox.isEditable()) {
                boolean bl = flasherVisible = !flasherVisible;
                if (!flasherVisible) {
                    Graphics g = TTinyComboBoxUI.this.arrowButton.getGraphics();
                    if (g != null) {
                        g.setColor(TTinyComboBoxUI.this.arrowButton.getBackground());
                        Insets insets = TTinyComboBoxUI.this.arrowButton.getInsets();
                        int width = TTinyComboBoxUI.this.arrowButton.getWidth() - (insets.left + insets.right);
                        int height = TTinyComboBoxUI.this.arrowButton.getHeight() - (insets.top + insets.bottom);
                        if (height > 0 && width > 0) {
                            int left = insets.left;
                            int top = insets.top;
                            g.drawRect(left, top, width - 1, height - 1);
                        }
                    }
                } else {
                    TTinyComboBoxUI.this.arrowButton.repaint();
                }
            }
        }
    }

    public class TMetalPropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        public TMetalPropertyChangeListener() {
            super((BasicComboBoxUI)((Object)TTinyComboBoxUI.this));
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("mandatory")) {
                TTinyComboBoxUI.this.comboBox.repaint();
            } else {
                super.propertyChange(e);
            }
        }
    }
}

