/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.plaf.tinylaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.CellRendererPane;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import net.sf.tinylaf.Theme;
import net.sf.tinylaf.TinyLookAndFeel;
import net.sf.tinylaf.borders.TinyButtonBorder;
import net.sf.tinylaf.util.ColorRoutines;
import net.sf.tinylaf.util.DrawRoutines;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.swing.FormComboBox;

public class TTinyComboBoxButton
extends JButton {
    private static final Logger LOGGER = LoggerFactory.getLogger(TTinyComboBoxButton.class);
    static final int COMBO_BUTTON_WIDTH = 18;
    private static final HashMap<ButtonKey, Image> CACHE = new HashMap();
    protected JComboBox<?> comboBox;
    protected JList<?> listBox;
    protected CellRendererPane rendererPane;
    protected Icon comboIcon;
    protected boolean iconOnly = false;
    private static BufferedImage focusImg;

    public static void clearCache() {
        CACHE.clear();
    }

    public final JComboBox<?> getComboBox() {
        return this.comboBox;
    }

    public final void setComboBox(JComboBox<?> cb) {
        this.comboBox = cb;
    }

    public final Icon getComboIcon() {
        return this.comboIcon;
    }

    public final void setComboIcon(Icon i) {
        this.comboIcon = i;
    }

    public final boolean isIconOnly() {
        return this.iconOnly;
    }

    public final void setIconOnly(boolean isIconOnly) {
        this.iconOnly = isIconOnly;
    }

    public TTinyComboBoxButton() {
        super("");
        ImageIcon icon;
        this.setModel(new DefaultButtonModel(){

            @Override
            public void setArmed(boolean armed) {
                super.setArmed(this.isPressed() || armed);
            }
        });
        this.setBackground(UIManager.getColor("ComboBox.background"));
        this.setForeground(UIManager.getColor("ComboBox.foreground"));
        if (focusImg == null && (icon = TinyLookAndFeel.loadIcon((String)"ComboBoxFocus.png")) != null) {
            focusImg = new BufferedImage(2, 2, 1);
            Graphics g = focusImg.getGraphics();
            icon.paintIcon(this, g, 0, 0);
        }
    }

    public TTinyComboBoxButton(JComboBox<?> cb, Icon i, boolean onlyIcon, CellRendererPane pane, JList<?> list) {
        this();
        this.comboBox = cb;
        this.comboIcon = i;
        this.rendererPane = pane;
        this.listBox = list;
        this.setEnabled(this.comboBox.isEnabled());
    }

    @Override
    public void paintComponent(Graphics g) {
        Color panelBackground = this.getParent().getParent().getBackground();
        int h = this.getHeight();
        int w = this.getWidth();
        ButtonKey key = null;
        BufferedImage img = null;
        Graphics graphics = g;
        boolean cached = false;
        if (!TinyLookAndFeel.controlPanelInstantiated) {
            key = new ButtonKey(panelBackground, this.getSize(), this.comboBox.isEnabled(), this.comboBox.isEditable(), this.model.isPressed(), this.model.isRollover());
            Image value = CACHE.get(key);
            if (value != null) {
                g.drawImage(value, 0, 0, this);
                if (this.comboBox.isEditable()) {
                    return;
                }
                cached = true;
            } else {
                img = new BufferedImage(w, h, 2);
                graphics = ((Image)img).getGraphics();
            }
        }
        boolean leftToRight = this.getComponentOrientation().isLeftToRight();
        if (!cached) {
            if (this.comboBox.isEnabled()) {
                if (this.comboBox.isEditable()) {
                    graphics.setColor(Theme.textBgColor.getColor());
                } else {
                    graphics.setColor(this.comboBox.getBackground());
                }
            } else {
                graphics.setColor(Theme.textDisabledBgColor.getColor());
            }
            graphics.fillRect(1, 1, w - 2, h - 2);
            graphics.setColor(panelBackground);
            graphics.drawRect(0, 0, w - 1, h - 1);
            ColorUIResource color = !this.isEnabled() ? Theme.comboButtDisabledColor.getColor() : (this.model.isPressed() ? Theme.comboButtPressedColor.getColor() : (this.model.isRollover() ? Theme.comboButtRolloverColor.getColor() : Theme.comboButtColor.getColor()));
            graphics.setColor(color);
            Rectangle buttonRect = new Rectangle(w - 18, 1, 18, h - 2);
            this.drawXpButton(graphics, buttonRect, color);
            Border border = this.getBorder();
            if (border != null && border instanceof TinyButtonBorder.CompoundBorderUIResource) {
                if (!this.isEnabled()) {
                    DrawRoutines.drawRoundedBorder((Graphics)graphics, (Color)Theme.comboBorderDisabledColor.getColor(), (int)0, (int)0, (int)w, (int)h);
                } else {
                    DrawRoutines.drawRoundedBorder((Graphics)graphics, (Color)Theme.comboBorderColor.getColor(), (int)0, (int)0, (int)w, (int)h);
                    if (!this.getModel().isPressed() && this.getModel().isRollover() && Theme.comboRollover.getValue()) {
                        DrawRoutines.drawRolloverBorder((Graphics)graphics, (Color)Theme.buttonRolloverColor.getColor(), (int)0, (int)0, (int)w, (int)h);
                    }
                }
            }
            if (key != null) {
                graphics.dispose();
                g.drawImage(img, 0, 0, this);
                CACHE.put(key, img);
            }
        }
        Insets insets = new Insets(Theme.comboInsets.top, Theme.comboInsets.left, Theme.comboInsets.bottom, 0);
        int width = w - (insets.left + insets.right);
        int height = h - (insets.top + insets.bottom);
        if (height <= 0 || width <= 0) {
            return;
        }
        int left = insets.left;
        int top = insets.top;
        int iconWidth = 18;
        Component c = null;
        boolean mustResetOpaque = false;
        boolean savedOpaque = false;
        boolean paintFocus = false;
        if (!this.iconOnly && this.comboBox != null) {
            ListCellRenderer<?> renderer = this.comboBox.getRenderer();
            boolean rendererSelected = this.getModel().isPressed();
            c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, rendererSelected, false);
            c.setFont(this.rendererPane.getFont());
            if (this.model.isArmed() && this.model.isPressed()) {
                if (this.isOpaque()) {
                    c.setBackground(UIManager.getColor("Button.select"));
                }
                c.setForeground(this.comboBox.getForeground());
            } else if (!this.comboBox.isEnabled()) {
                if (this.isOpaque()) {
                    c.setBackground(Theme.textDisabledBgColor.getColor());
                } else {
                    this.comboBox.setBackground(Theme.textDisabledBgColor.getColor());
                }
                c.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            } else if (this.comboBox.hasFocus() && !this.comboBox.isPopupVisible()) {
                if (this.comboBox.isEditable()) {
                    c.setForeground(Theme.mainColor.getColor());
                } else {
                    c.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
                }
                c.setBackground(UIManager.getColor("ComboBox.focusBackground"));
                if (c instanceof JComponent) {
                    mustResetOpaque = true;
                    JComponent jc = (JComponent)c;
                    savedOpaque = jc.isOpaque();
                    jc.setOpaque(true);
                    paintFocus = true;
                }
            } else {
                c.setForeground(this.comboBox.getForeground());
                if (!this.comboBox.isEditable() && this.comboBox instanceof FormComboBox && ((FormComboBox)this.comboBox).isMandatory()) {
                    c.setBackground(UIManager.getColor("ComboBox.mandatoryBackground"));
                } else {
                    c.setBackground(this.comboBox.getBackground());
                }
            }
            int cWidth = width - (insets.right + iconWidth);
            boolean shouldValidate = c instanceof JPanel;
            if (leftToRight) {
                this.rendererPane.paintComponent(g, c, this, left, top, cWidth, height, shouldValidate);
            } else {
                this.rendererPane.paintComponent(g, c, this, left + iconWidth, top, cWidth, height, shouldValidate);
            }
            if (paintFocus && Theme.comboFocus.getValue()) {
                g.setColor(Color.black);
                Graphics2D g2d = (Graphics2D)g;
                Rectangle r = new Rectangle(left, top, 2, 2);
                TexturePaint tp = new TexturePaint(focusImg, r);
                g2d.setPaint(tp);
                g2d.draw(new Rectangle(left, top, cWidth, height));
            }
        }
        if (mustResetOpaque) {
            JComponent jc = (JComponent)c;
            jc.setOpaque(savedOpaque);
        }
    }

    private void drawXpButton(Graphics g, Rectangle buttonRect, Color c) {
        int x2 = buttonRect.x + buttonRect.width;
        int y2 = buttonRect.y + buttonRect.height;
        int spread1 = Theme.comboSpreadLight.getValue();
        int spread2 = Theme.comboSpreadDark.getValue();
        if (!this.isEnabled()) {
            spread1 = Theme.comboSpreadLightDisabled.getValue();
            spread2 = Theme.comboSpreadDarkDisabled.getValue();
        }
        int h = buttonRect.height - 2;
        float spreadStep1 = 10.0f * (float)spread1 / (float)(h - 3);
        float spreadStep2 = 10.0f * (float)spread2 / (float)(h - 3);
        int halfY = h / 2;
        for (int y = 1; y < h - 1; ++y) {
            int yd;
            if (y < halfY) {
                yd = halfY - y;
                g.setColor(ColorRoutines.lighten((Color)c, (int)((int)((float)yd * spreadStep1))));
            } else if (y == halfY) {
                g.setColor(c);
            } else {
                yd = y - halfY;
                g.setColor(ColorRoutines.darken((Color)c, (int)((int)((float)yd * spreadStep2))));
            }
            g.drawLine(buttonRect.x + 1, buttonRect.y + y + 1, buttonRect.x + buttonRect.width - 3, buttonRect.y + y + 1);
        }
        Color col = !this.isEnabled() ? Theme.comboButtBorderDisabledColor.getColor() : Theme.comboButtBorderColor.getColor();
        g.setColor(col);
        g.drawLine(buttonRect.x + 2, buttonRect.y + 1, x2 - 4, buttonRect.y + 1);
        g.drawLine(buttonRect.x + 1, buttonRect.y + 2, buttonRect.x + 1, y2 - 3);
        g.drawLine(x2 - 3, buttonRect.y + 2, x2 - 3, y2 - 3);
        g.drawLine(buttonRect.x + 2, y2 - 2, x2 - 4, y2 - 2);
        col = new Color(col.getRed(), col.getGreen(), col.getBlue(), 128);
        g.setColor(col);
        g.drawLine(buttonRect.x + 1, buttonRect.y + 1, buttonRect.x + 1, buttonRect.y + 1);
        g.drawLine(x2 - 3, buttonRect.y + 1, x2 - 3, buttonRect.y + 1);
        g.drawLine(buttonRect.x + 1, y2 - 2, buttonRect.x + 1, y2 - 2);
        g.drawLine(x2 - 3, y2 - 2, x2 - 3, y2 - 2);
        if (this.isEnabled()) {
            g.setColor(Theme.comboArrowColor.getColor());
        } else {
            g.setColor(Theme.comboArrowDisabledColor.getColor());
        }
        this.drawXpArrow(g, buttonRect);
    }

    private void drawXpArrow(Graphics g, Rectangle r) {
        int x = r.x + (r.width - 8) / 2 - 1;
        int y = r.y + (r.height - 6) / 2 + 1;
        g.drawLine(x + 1, y, x + 1, y);
        g.drawLine(x + 7, y, x + 7, y);
        g.drawLine(x, y + 1, x + 2, y + 1);
        g.drawLine(x + 6, y + 1, x + 8, y + 1);
        g.drawLine(x + 1, y + 2, x + 3, y + 2);
        g.drawLine(x + 5, y + 2, x + 7, y + 2);
        g.drawLine(x + 2, y + 3, x + 6, y + 3);
        g.drawLine(x + 3, y + 4, x + 5, y + 4);
        g.drawLine(x + 4, y + 5, x + 4, y + 5);
    }

    private static class ButtonKey {
        private final Color panelBackground;
        private final Dimension size;
        private final boolean enabled;
        private final boolean editable;
        private final boolean pressed;
        private final boolean rollover;

        ButtonKey(Color background, Dimension size, boolean enabled, boolean editable, boolean pressed, boolean rollover) {
            this.panelBackground = background;
            this.size = size;
            this.enabled = enabled;
            this.editable = editable;
            this.pressed = pressed;
            this.rollover = rollover;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof ButtonKey)) {
                return false;
            }
            ButtonKey other = (ButtonKey)o;
            return this.enabled == other.enabled && this.editable == other.editable && this.pressed == other.pressed && this.rollover == other.rollover && this.panelBackground.equals(other.panelBackground) && this.size.equals(other.size);
        }

        public int hashCode() {
            return this.panelBackground.hashCode() * this.size.hashCode() * (this.enabled ? 2 : 1) * (this.editable ? 8 : 4) * (this.pressed ? 32 : 16) * (this.rollover ? 128 : 64);
        }
    }
}

