/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.plaf.tinylaf;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import net.sf.tinylaf.TinyTextAreaUI;
import org.tentackle.swing.FormComponent;
import org.tentackle.swing.FormTextArea;

public class TTinyTextAreaUI
extends TinyTextAreaUI {
    public static ComponentUI createUI(JComponent c) {
        return new TTinyTextAreaUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof FormTextArea && (((FormTextArea)c).isMandatory() || !((FormTextArea)c).isEditable())) {
            this.updateBackground((JTextArea)c);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("mandatory") || evt.getPropertyName().equals("editable") || evt.getPropertyName().equals("enabled")) {
            this.updateBackground((JTextArea)evt.getSource());
        } else {
            super.propertyChange(evt);
        }
    }

    private void updateBackground(JTextArea c) {
        Color background = c.getBackground();
        if (background instanceof UIResource) {
            String prefix = this.getPropertyPrefix();
            Color mandatoryBG = UIManager.getColor(prefix + ".mandatoryBackground");
            Color disabledBG = UIManager.getColor(prefix + ".disabledBackground");
            Color inactiveBG = UIManager.getColor(prefix + ".inactiveBackground");
            Color bg = UIManager.getColor(prefix + ".background");
            if (background != disabledBG && background != inactiveBG && background != mandatoryBG && background != bg) {
                return;
            }
            Color newColor = null;
            if (!c.isEnabled()) {
                newColor = disabledBG;
            }
            if (newColor == null && !c.isEditable()) {
                newColor = inactiveBG;
            }
            if (newColor == null && c instanceof FormComponent && ((FormComponent)c).isMandatory()) {
                newColor = mandatoryBG;
            }
            if (newColor == null) {
                newColor = bg;
            }
            if (newColor != null && newColor != background) {
                c.setBackground(newColor);
            }
        }
    }
}

