/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.plaf.tinylaf;

import java.awt.Color;
import java.net.URL;
import java.util.MissingResourceException;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import net.sf.tinylaf.Theme;
import net.sf.tinylaf.TinyLookAndFeel;
import org.tentackle.common.Service;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.swing.plaf.PlafUtilities;
import org.tentackle.swing.plaf.TentackleLookAndFeel;

@Service(value=TentackleLookAndFeel.class)
public class TTinyLookAndFeel
extends TinyLookAndFeel
implements TentackleLookAndFeel {
    private static final long serialVersionUID = 4681423326797721021L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TTinyLookAndFeel.class);
    private Color mandatoryColor;
    private Color unselectedMandatoryColor;
    private boolean focusAnimated = true;

    public TTinyLookAndFeel() {
        this.loadInitialTheme();
        this.loadTentackleExtraColors();
    }

    public void loadInitialTheme() {
        URL url = TTinyLookAndFeel.class.getResource("tentackle.theme");
        if (url != null) {
            try {
                Theme.loadTheme((URL)url);
            }
            catch (Exception e) {
                LOGGER.severe("incompatible tinylaf theme", new Object[0]);
            }
        }
    }

    public void loadTentackleExtraColors() {
        this.mandatoryColor = new ColorUIResource(255, 255, 170);
        this.unselectedMandatoryColor = new ColorUIResource(PlafUtilities.getInstance().brighter(this.mandatoryColor, 0.75));
    }

    public Color getMandatoryColor() {
        return this.mandatoryColor;
    }

    public void setMandatoryColor(Color mandatoryColor) {
        this.mandatoryColor = mandatoryColor;
    }

    public Color getUnselectedMandatoryColor() {
        return this.unselectedMandatoryColor;
    }

    public void setUnselectedMandatoryColor(Color unselectedMandatoryColor) {
        this.unselectedMandatoryColor = unselectedMandatoryColor;
    }

    public static String getTTinyName() {
        return "TTiny";
    }

    public static String getTTinyDescription() {
        return "Enhanced TinyLAF for Tentackle";
    }

    public String getName() {
        return TTinyLookAndFeel.getTTinyName();
    }

    public String getDescription() {
        return TTinyLookAndFeel.getTTinyDescription();
    }

    public String getID() {
        return this.getName();
    }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String tTinyPackageName = "org.tentackle.swing.plaf.tinylaf.";
        Object[] uiDefaults = new Object[]{"ButtonUI", "org.tentackle.swing.plaf.tinylaf.TTinyButtonUI", "ComboBoxUI", "org.tentackle.swing.plaf.tinylaf.TTinyComboBoxUI", "RadioButtonUI", "org.tentackle.swing.plaf.tinylaf.TTinyRadioButtonUI", "CheckBoxUI", "org.tentackle.swing.plaf.tinylaf.TTinyCheckBoxUI", "TextFieldUI", "org.tentackle.swing.plaf.tinylaf.TTinyTextFieldUI", "TextAreaUI", "org.tentackle.swing.plaf.tinylaf.TTinyTextAreaUI", "TableUI", "org.tentackle.swing.plaf.tinylaf.TTinyTableUI"};
        table.putDefaults(uiDefaults);
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        Object[] defaults = new Object[]{"TextField.mandatoryBackground", this.getMandatoryColor(), "TextArea.mandatoryBackground", this.getMandatoryColor(), "TextArea.inactiveBackground", table.getColor("control"), "ComboBox.mandatoryBackground", this.getMandatoryColor(), "CheckBox.mandatoryBackground", this.getMandatoryColor(), "RadioButton.mandatoryBackground", this.getMandatoryColor(), "Table.selectedMandatoryBackground", this.getMandatoryColor(), "Table.unselectedMandatoryBackground", this.getUnselectedMandatoryColor()};
        table.putDefaults(defaults);
    }

    public ImageIcon loadImageIcon(String name) throws MissingResourceException {
        URL url = TTinyLookAndFeel.class.getResource("icons/" + name + ".png");
        if (url == null) {
            url = TTinyLookAndFeel.class.getResource("icons/" + name + ".gif");
        }
        if (url == null) {
            throw new MissingResourceException("no such icon '" + name + "'", TTinyLookAndFeel.class.getName(), name);
        }
        return new ImageIcon(url);
    }

    public void setFocusAnimated(boolean flag) {
        this.focusAnimated = flag;
    }

    public boolean isFocusAnimated() {
        return this.focusAnimated;
    }
}

