/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.plaf.tinylaf;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import net.sf.tinylaf.TinyButtonUI;
import org.tentackle.swing.plaf.TFlasherListener;
import org.tentackle.swing.plaf.TentackleLookAndFeel;

public class TTinyButtonUI
extends TinyButtonUI {
    private static final TTinyButtonUI buttonUI = new TTinyButtonUI();

    public static ComponentUI createUI(JComponent c) {
        return buttonUI;
    }

    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        if (((TentackleLookAndFeel)UIManager.getLookAndFeel()).isFocusAnimated()) {
            b.addFocusListener((FocusListener)new TFlasherListener((JComponent)b));
        }
    }

    protected void uninstallListeners(AbstractButton b) {
        super.uninstallListeners(b);
        TFlasherListener.removeFlasherListener((JComponent)b);
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        boolean isIcon;
        Rectangle focusRect = new Rectangle();
        String text = b.getText();
        boolean bl = isIcon = b.getIcon() != null;
        if (text != null && !text.isEmpty()) {
            if (!isIcon) {
                focusRect.setBounds(textRect);
            } else {
                focusRect.setBounds(iconRect.union(textRect));
            }
        } else if (isIcon) {
            focusRect.setBounds(iconRect);
        }
        g.setColor(!((TentackleLookAndFeel)UIManager.getLookAndFeel()).isFocusAnimated() || TFlasherListener.isFlasherVisible() ? this.getFocusColor() : b.getBackground());
        g.drawRect(focusRect.x - 1, focusRect.y - 1, focusRect.width + 1, focusRect.height + 1);
    }
}

