/**
 * Tentackle - http://www.tentackle.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package org.tentackle.swing;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Locale;
import org.tentackle.swing.plaf.PlafUtilities;


/**
 * Calendar dialog.
 *
 * @author harald
 */
@SuppressWarnings("serial")
public class FormCalendarDialog extends FormDialog {

  /**
   * Creates a calendar dialog associated to a given component
   * (usually a date field).
   *
   * @param comp the component, null if none
   * @param locale the locale, null if default locale
   * @param day the date, null if "today"
   * @param timeMode whether and how to display the time, one of SHOW_...
   * @return the created modal dialog
   */
  public static FormCalendarDialog createFormCalendarDialog (Component comp, Locale locale, Date day, int timeMode) {
    return new FormCalendarDialog(FormUtilities.getInstance().getParentWindow(comp), locale, day, timeMode);
  }


  private Date day;    // selected date


  /**
   * Creates a calendar dialog.
   *
   * @param owner the owner window, null if none
   * @param locale the locale, null if default locale
   * @param day the date, null if "today"
   * @param timeMode whether and how to display the time, one of SHOW_...
   */
  public FormCalendarDialog(Window owner, Locale locale, Date day, int timeMode) {
    super(owner);
    initComponents();
    calendar.setup(locale, day, timeMode);
    // listener for double click on date
    calendar.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e)  {
        okButton.doClick();
      }
    });
  }

  /**
   * Creates a calendar dialog in current locale for today.
   *
   * @param owner the owner window, null if none
   * @param timeMode whether and how to display the time, one of SHOW_...
   */
  public FormCalendarDialog(Window owner, int timeMode) {
    this(owner, null, null, timeMode);
  }

  /**
   * Creates a calendar dialog for today with no parent window, in
   * current locale, without time.
   */
  public FormCalendarDialog() {
    this(null, FormCalendar.SHOW_DATE);
  }


  /**
   * Shows the modal dialog.
   *
   * @return the date, null if cancel
   */
  public Date showDialog()  {
    pack();
    day = null;
    setVisible(true);
    return day;
  }




  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    buttonPanel = new org.tentackle.swing.FormPanel();
    okButton = new org.tentackle.swing.FormButton();
    cancelButton = new org.tentackle.swing.FormButton();
    calendar = new org.tentackle.swing.FormCalendar();

    setAutoPosition(true);
    setModal(true);

    okButton.setIcon(PlafUtilities.getInstance().getIcon("ok"));
    okButton.setMargin(new java.awt.Insets(1, 4, 1, 4));
    okButton.setName("ok"); // NOI18N
    okButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        okButtonActionPerformed(evt);
      }
    });
    buttonPanel.add(okButton);

    cancelButton.setIcon(PlafUtilities.getInstance().getIcon("cancel"));
    cancelButton.setMargin(new java.awt.Insets(1, 4, 1, 4));
    cancelButton.setName("cancel"); // NOI18N
    cancelButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        cancelButtonActionPerformed(evt);
      }
    });
    buttonPanel.add(cancelButton);

    getContentPane().add(buttonPanel, java.awt.BorderLayout.PAGE_END);
    getContentPane().add(calendar, java.awt.BorderLayout.CENTER);

    pack();
  }// </editor-fold>//GEN-END:initComponents

  private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
    day = calendar.getCalendar().getTime();
    dispose();
  }//GEN-LAST:event_okButtonActionPerformed

  private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
    dispose();
  }//GEN-LAST:event_cancelButtonActionPerformed


  // Variables declaration - do not modify//GEN-BEGIN:variables
  private org.tentackle.swing.FormPanel buttonPanel;
  private org.tentackle.swing.FormCalendar calendar;
  private org.tentackle.swing.FormButton cancelButton;
  private org.tentackle.swing.FormButton okButton;
  // End of variables declaration//GEN-END:variables

}
