/**
 * Tentackle - http://www.tentackle.org
 * Copyright (C) 2001-2008 Harald Krake, harald@krake.de, +49 7722 9508-0
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

// Created on January 23, 2003, 5:55 PM

package org.tentackle.swing;

import java.util.EventListener;

/**
 * Listener for form wrap events.
 * 
 * @author harald
 */
public interface FormWrapListener extends EventListener {

    /**
     * Invoked when an form wrap occurs, i.e. the keyboard
     * focus wraps from end to start of form.
     * 
     * @param e the form wrap event
     */
    public void formWrapped(FormWrapEvent e);

}  
