/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import org.tentackle.misc.Toolkit;
import org.tentackle.swing.FocusTraversalGroup;
import org.tentackle.swing.FormComponent;
import org.tentackle.swing.FormFieldComponent;
import org.tentackle.swing.FormFieldDocument;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.FormWindow;
import org.tentackle.swing.FormWrapEvent;
import org.tentackle.swing.GUIRuntimeException;
import org.tentackle.swing.PropertyGroup;
import org.tentackle.swing.TooltipDisplay;
import org.tentackle.swing.ValueListener;
import org.tentackle.swing.bind.FormComponentBinding;

public abstract class AbstractFormField
extends JTextField
implements FormFieldComponent {
    protected int errorOffset = -1;
    protected String errorMessage;
    protected String savedValue;
    private boolean honourChangeable = true;
    private boolean changeable = true;
    private boolean allChangeable = true;
    private boolean autoUpdate = true;
    private char convert = (char)61;
    private char adjust = (char)124;
    private boolean autoSelect;
    private boolean inhibitAutoSelect;
    private boolean autoNext;
    private int defaultColumns;
    private int maxColumns;
    private String validChars;
    private String invalidChars;
    private char filler = (char)32;
    private boolean override;
    private boolean startEditLeftmost;
    private boolean eraseFirst;
    private boolean wasError;
    private boolean fireRunning;
    private int verticalAlignment = 0;
    private String helpURL;
    private Window parentWindow;
    private TooltipDisplay tooltipDisplay;
    private boolean formTraversable = true;
    private boolean tableCellEditorUsage;
    private boolean transferFocusByEnter;
    private boolean transferFocusDone;
    private boolean transferFocusBackwardDone;
    private boolean focusGainedFromTransfer;
    private boolean focusGainedFromTransferBackward;
    private boolean valueChangedTriggered;
    private boolean triggerValueChangedEnabled = true;
    private boolean skipNextFocusLost;
    private FormWindow formWrapWindow;
    private boolean bindable = true;
    private String componentPath;
    private String bindingPath;
    private FormComponentBinding binding;
    private boolean smartValueEntered = true;
    private String oldValueShown;
    private boolean mandatory;
    private boolean focusLostWasTemporary;
    private KeyEvent lastKeyEvent;
    private FocusTraversalGroup focusTraversalGroup;
    private PropertyGroup propertyGroup;

    public AbstractFormField(Document doc, String str, int columns) {
        super(doc, str, columns);
        this.setAlignmentX(0.0f);
        FormUtilities.getInstance().setupDefaultBindings(this);
        if (str != null) {
            this.setText(str);
        }
    }

    public AbstractFormField(String str, int columns) {
        this(null, str, columns);
    }

    public AbstractFormField(String str) {
        this(null, str, 0);
    }

    public AbstractFormField(int columns) {
        this(null, null, columns);
    }

    public AbstractFormField() {
        this(null, null, 0);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (pressed) {
            this.lastKeyEvent = e;
            if (this.isAutoSelect() && ks.getKeyCode() == 8 && ks.getModifiers() == 0) {
                int selStart = this.getSelectionStart();
                int selEnd = this.getSelectionEnd();
                if (selEnd > selStart && this.getCaretPosition() == selEnd) {
                    this.setSelectionStart(this.getSelectionEnd());
                }
            }
            if (e.getKeyCode() == 90 && e.getModifiers() == 2) {
                this.restoreSavedValue();
            }
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    protected void restoreSavedValue() {
        this.setText(this.savedValue);
    }

    @Override
    public void setColumns(int columns) {
        super.setColumns(columns);
        this.setMinimumSize(this.getPreferredSize());
    }

    @Override
    protected Document createDefaultModel() {
        return new FormFieldDocument(this);
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (e.isTemporary()) {
            if (e.getID() == 1005) {
                this.focusLostWasTemporary = true;
            }
        } else if (e.getID() == 1004) {
            if (this.focusLostWasTemporary) {
                this.focusLostWasTemporary = false;
            } else {
                this.performFocusGained(e.getOppositeComponent());
            }
        } else if (e.getID() == 1005) {
            this.hideErrorPopup();
            if (this.skipNextFocusLost) {
                this.skipNextFocusLost = false;
                this.performWrapEvent();
            } else {
                this.performFocusLost();
            }
        }
    }

    @Override
    public void setText(String str) {
        this.focusLostWasTemporary = false;
        if (this.autoNext) {
            this.autoNext = false;
            super.setText(str);
            this.autoNext = true;
        } else {
            super.setText(str);
        }
        if (this.eraseFirst) {
            Document doc = this.getDocument();
            try {
                ((FormFieldDocument)doc).setEraseFirst(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.eraseFirst = false;
        }
        this.setCaretLeft();
    }

    @Override
    public String getText() {
        String str = super.getText();
        if (str != null) {
            int i;
            int len = str.length();
            if (this.adjust == '<' || this.adjust == '|') {
                for (i = 0; i < len && str.charAt(i) == this.filler; ++i) {
                }
                if (i > 0) {
                    str = str.substring(i);
                    len -= i;
                }
            }
            if (this.adjust == '>' || this.adjust == '|') {
                for (i = len - 1; i > 0 && str.charAt(i) == this.filler; --i) {
                }
                if (++i < len) {
                    str = str.substring(0, i);
                }
            }
        }
        return str;
    }

    @Override
    public void transferFocus() {
        this.transferFocusDone = true;
        super.transferFocus();
    }

    @Override
    public void transferFocusBackward() {
        this.transferFocusBackwardDone = true;
        super.transferFocusBackward();
    }

    @Override
    public void showErrorPopup(String message) {
        FormUtilities.getInstance().showErrorPopup(this, message);
    }

    protected void hideErrorPopup() {
        FormUtilities.getInstance().showErrorPopup(this, null);
    }

    protected void showErrorPopup() {
        this.showErrorPopup(this.errorMessage);
    }

    private void showTooltip(String text) {
        TooltipDisplay td = this.getTooltipDisplay();
        if (td != null) {
            td.setTooltip(text);
        }
    }

    private TooltipDisplay getTooltipDisplay() {
        Window w;
        if (this.tooltipDisplay == null && (w = this.getParentWindow()) instanceof FormWindow) {
            this.tooltipDisplay = ((FormWindow)((Object)w)).getTooltipDisplay();
        }
        return this.tooltipDisplay;
    }

    private void performFocusGained(Component opposite) {
        boolean wasEnter = false;
        if (opposite instanceof FormComponent) {
            this.focusGainedFromTransfer = ((FormComponent)((Object)opposite)).wasTransferFocus();
            this.focusGainedFromTransferBackward = ((FormComponent)((Object)opposite)).wasTransferFocusBackward();
            wasEnter = ((FormComponent)((Object)opposite)).wasTransferFocusByEnter();
        }
        this.transferFocusDone = false;
        this.transferFocusBackwardDone = false;
        if (this.wasError) {
            if (this.errorOffset >= 0 && this.getDocument().getLength() > this.errorOffset) {
                this.setCaretPosition(this.errorOffset);
            }
            this.wasError = false;
        } else {
            if (this.isAutoUpdate()) {
                int caretPos = this.getCaretPosition();
                this.fireValueChanged();
                if (this.focusGainedFromTransfer && !wasEnter && !this.startEditLeftmost) {
                    this.setCaretRight();
                } else if (this.focusGainedFromTransferBackward || wasEnter) {
                    this.setCaretLeft();
                } else {
                    if (caretPos < 0) {
                        caretPos = 0;
                    } else if (caretPos > this.getDocument().getLength()) {
                        caretPos = this.getDocument().getLength();
                    }
                    this.setCaretPosition(caretPos);
                }
            }
            if (this.isAutoSelect() && !this.inhibitAutoSelect) {
                this.selectAll();
            }
        }
        this.transferFocusByEnter = false;
        this.inhibitAutoSelect = false;
        this.formWrapWindow = null;
        this.showTooltip(super.getToolTipText());
        this.oldValueShown = this.getValueShown();
    }

    private void performFocusLost() {
        this.transferFocusByEnter = !(this.lastKeyEvent == null || this.lastKeyEvent.getKeyCode() != 10 && this.lastKeyEvent.getKeyCode() != 9 || this.lastKeyEvent.getModifiers() != 0 && this.lastKeyEvent.getModifiers() != 1);
        this.wasError = false;
        this.setEraseFirst(false);
        if (this.isChangeable()) {
            if (this.isCellEditorUsage() || !this.isSmartValueEntered() || this.isValueShownModified()) {
                this.errorOffset = -1;
                this.errorMessage = null;
                if (this.isAutoUpdate()) {
                    this.fireValueEntered();
                } else {
                    this.setFormValue(this.getFormValue());
                }
            }
            if (this.errorOffset >= 0) {
                this.setCaretPosition(this.errorOffset);
                Toolkit.beep();
                this.wasError = true;
                this.showErrorPopup();
                this.requestFocusLater();
            } else if (this.isAutoUpdate()) {
                this.fireValueChanged();
                FormUtilities.getInstance().doValidate(this);
            }
        }
        this.performWrapEvent();
        this.showTooltip(null);
        this.lastKeyEvent = null;
    }

    private void performWrapEvent() {
        if (this.formWrapWindow != null) {
            this.formWrapWindow.fireFormWrappedFocus(new FormWrapEvent(this));
            this.formWrapWindow = null;
        }
    }

    @Override
    public synchronized void addValueListener(ValueListener listener) {
        this.listenerList.add(ValueListener.class, listener);
    }

    @Override
    public synchronized void removeValueListener(ValueListener listener) {
        this.listenerList.remove(ValueListener.class, listener);
    }

    @Override
    public void requestFocusLater() {
        FormUtilities.getInstance().requestFocusLater(this);
    }

    @Override
    public void fireValueChanged() {
        FormUtilities.getInstance().doFireValueChanged(this, this.listenerList.getListenerList());
        this.valueChangedTriggered = false;
    }

    @Override
    public void fireValueEntered() {
        this.valueChangedTriggered = false;
        FormUtilities.getInstance().doFireValueEntered(this, this.listenerList.getListenerList());
    }

    @Override
    public void saveValue() {
        if (this.isHonourChangeable()) {
            this.savedValue = super.getText();
            this.valueChangedTriggered = false;
        }
    }

    @Override
    public boolean isValueChanged() {
        if (this.isHonourChangeable()) {
            String value = super.getText();
            if (this.savedValue == null) {
                return value != null;
            }
            if (value != null) {
                return !value.equals(this.savedValue);
            }
            return true;
        }
        return false;
    }

    @Override
    public void setTriggerValueChangedEnabled(boolean enabled) {
        this.triggerValueChangedEnabled = enabled;
    }

    @Override
    public boolean isTriggerValueChangedEnabled() {
        return this.triggerValueChangedEnabled;
    }

    @Override
    public void triggerValueChanged() {
        if (this.triggerValueChangedEnabled && !this.valueChangedTriggered && !this.fireRunning) {
            FormUtilities.getInstance().triggerValueChanged(this);
            this.valueChangedTriggered = this.isValueChanged();
        }
    }

    @Override
    public void setCellEditorUsage(boolean flag) {
        this.tableCellEditorUsage = flag;
    }

    @Override
    public boolean isCellEditorUsage() {
        return this.tableCellEditorUsage;
    }

    @Override
    public void prepareFocusLost() {
        if (!this.tableCellEditorUsage) {
            this.performFocusLost();
            if (this.errorOffset < 0) {
                this.skipNextFocusLost = true;
            }
        }
    }

    @Override
    public void showHelp() {
        FormUtilities.getInstance().openHelpURL(this);
    }

    @Override
    public void clearText() {
        this.setText("");
    }

    @Override
    public boolean isEmpty() {
        String text = this.getText();
        return text == null || text.length() == 0;
    }

    @Override
    public boolean isCaretLeft() {
        return this.getCaretPosition() == 0;
    }

    @Override
    public boolean isCaretRight() {
        return this.getCaretPosition() == this.getDocument().getLength();
    }

    @Override
    public void upLeft() {
        if (this.isCaretLeft()) {
            this.transferFocusBackward();
        } else {
            this.setCaretLeft();
        }
    }

    @Override
    public void downRight() {
        if (this.isCaretRight()) {
            this.transferFocus();
        } else {
            this.setCaretRight();
        }
    }

    @Override
    public void setCaretLeft() {
        this.setCaretPosition(0);
    }

    @Override
    public void setCaretRight() {
        this.setCaretPosition(this.getDocument().getLength());
    }

    @Override
    public void setEraseFirst(boolean erasefirst) {
        this.eraseFirst = erasefirst;
        if (!erasefirst) {
            Document doc = this.getDocument();
            try {
                ((FormFieldDocument)doc).setEraseFirst(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isEraseFirst() {
        return this.eraseFirst;
    }

    @Override
    public void setChangeable(boolean changeable) {
        if (this.isHonourChangeable()) {
            this.changeable = changeable;
            super.setEditable(changeable && this.allChangeable);
        }
    }

    @Override
    public boolean isChangeable() {
        return this.changeable && this.allChangeable;
    }

    @Override
    public void setHonourChangeable(boolean flag) {
        this.honourChangeable = flag;
    }

    @Override
    public boolean isHonourChangeable() {
        return this.honourChangeable;
    }

    @Override
    public void updateAllChangeable(boolean allChangeable) {
        if (this.allChangeable != allChangeable) {
            this.allChangeable = allChangeable;
            this.setChangeable(this.changeable);
        }
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.changeable = editable;
    }

    @Override
    public int getDefaultColumns() {
        return this.defaultColumns;
    }

    @Override
    public void setDefaultColumns(int defaultColumns) {
        this.defaultColumns = defaultColumns;
        if (defaultColumns < 0) {
            throw new IllegalArgumentException("defaultColumns less than zero.");
        }
        if (defaultColumns != this.defaultColumns) {
            this.defaultColumns = defaultColumns;
            if (this.getColumns() == 0) {
                this.invalidate();
            }
        }
    }

    @Override
    public void setMaxColumns(int maxColumns) {
        if (maxColumns < 0) {
            throw new IllegalArgumentException("maxColumns less than zero.");
        }
        if (maxColumns != this.maxColumns) {
            this.maxColumns = maxColumns;
            this.setText(this.getText());
            if (this.getColumns() == 0) {
                this.invalidate();
            }
        }
    }

    @Override
    public int getMaxColumns() {
        return this.maxColumns;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.getColumns() == 0) {
            int cols;
            int n = cols = this.defaultColumns > 0 ? this.defaultColumns : this.maxColumns;
            if (cols > 0) {
                Insets insets = this.getInsets();
                size.width = cols * this.getColumnWidth() + insets.left + insets.right;
            }
        }
        return size;
    }

    @Override
    public void setConvert(char convert) {
        this.convert = convert;
        String text = this.getText();
        if (text != null) {
            switch (convert) {
                case '^': {
                    this.setText(text.toUpperCase());
                    break;
                }
                case 'v': {
                    this.setText(text.toLowerCase());
                }
            }
        }
    }

    @Override
    public char getConvert() {
        return this.convert;
    }

    @Override
    public void setAdjust(char adjust) {
        this.adjust = adjust;
    }

    @Override
    public char getAdjust() {
        return this.adjust;
    }

    @Override
    public void setAutoSelect(boolean autoselect) {
        this.autoSelect = autoselect;
    }

    @Override
    public boolean isAutoSelect() {
        return this.autoSelect;
    }

    @Override
    public void setAutoNext(boolean autonext) {
        this.autoNext = autonext;
    }

    @Override
    public boolean isAutoNext() {
        return this.autoNext;
    }

    @Override
    public void setAutoUpdate(boolean autoupdate) {
        this.autoUpdate = autoupdate;
    }

    @Override
    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    @Override
    public void setValidChars(String validChars) {
        this.validChars = validChars;
    }

    @Override
    public String getValidChars() {
        return this.validChars;
    }

    @Override
    public void setInvalidChars(String invalidChars) {
        this.invalidChars = invalidChars;
    }

    @Override
    public String getInvalidChars() {
        return this.invalidChars;
    }

    @Override
    public void setFiller(char filler) {
        char oldfiller = this.filler;
        this.filler = filler;
        if (!this.isEmpty()) {
            this.setText(this.getText().replace(oldfiller, filler));
        }
    }

    @Override
    public char getFiller() {
        return this.filler;
    }

    @Override
    public void setOverwrite(boolean override) {
        this.override = override;
    }

    @Override
    public boolean isOverwrite() {
        return this.override;
    }

    @Override
    public void setStartEditLeftmost(boolean startEditLeftmost) {
        this.startEditLeftmost = startEditLeftmost;
    }

    @Override
    public boolean isStartEditLeftmost() {
        return this.startEditLeftmost;
    }

    @Override
    public int getErrorOffset() {
        return this.errorOffset;
    }

    @Override
    public void setErrorOffset(int errorOffset) {
        this.errorOffset = errorOffset;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Override
    public void setFireRunning(boolean running) {
        this.fireRunning = running;
    }

    @Override
    public boolean isFireRunning() {
        return this.fireRunning;
    }

    @Override
    public boolean isInhibitAutoSelect() {
        return this.inhibitAutoSelect;
    }

    @Override
    public void setInhibitAutoSelect(boolean inhibitAutoSelect) {
        this.inhibitAutoSelect = inhibitAutoSelect;
    }

    @Override
    public void setFormWrapWindow(FormWindow parent) {
        this.formWrapWindow = parent;
    }

    @Override
    public void setVerticalAlignment(int alignment) {
        this.verticalAlignment = alignment;
    }

    @Override
    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    @Override
    public String getHelpURL() {
        return this.helpURL;
    }

    @Override
    public void setHelpURL(String helpURL) {
        this.helpURL = helpURL;
    }

    @Override
    public Function<String, String> getConverter() {
        Document doc = this.getDocument();
        try {
            return ((FormFieldDocument)doc).getConverter();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setConverter(Function<String, String> converter) {
        Document doc = this.getDocument();
        try {
            ((FormFieldDocument)doc).setConverter(converter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Window getParentWindow() {
        if (this.parentWindow == null) {
            this.parentWindow = FormUtilities.getInstance().getParentWindow(this);
        }
        return this.parentWindow;
    }

    @Override
    public void invalidateParentInfo() {
        this.parentWindow = null;
        this.tooltipDisplay = null;
    }

    @Override
    public String getToolTipText() {
        return this.getTooltipDisplay() == null ? super.getToolTipText() : null;
    }

    @Override
    public boolean wasTransferFocus() {
        return this.transferFocusDone;
    }

    @Override
    public boolean wasTransferFocusBackward() {
        return this.transferFocusBackwardDone;
    }

    @Override
    public boolean wasFocusGainedFromTransfer() {
        return this.focusGainedFromTransfer;
    }

    @Override
    public boolean wasFocusGainedFromTransferBackward() {
        return this.focusGainedFromTransferBackward;
    }

    @Override
    public boolean wasTransferFocusByEnter() {
        return this.transferFocusByEnter;
    }

    @Override
    public void setFormTraversable(boolean formTraversable) {
        this.formTraversable = formTraversable;
    }

    @Override
    public boolean isFormTraversable() {
        return this.formTraversable;
    }

    @Override
    public void setFocusTraversalGroup(FocusTraversalGroup group) {
        if (this.focusTraversalGroup != group) {
            if (this.focusTraversalGroup != null) {
                if (this.focusTraversalGroup.removeComponent(this)) {
                    this.focusTraversalGroup = null;
                } else {
                    throw new GUIRuntimeException("component " + this + " not in focus travseral group " + this.focusTraversalGroup);
                }
            }
            if (group != null) {
                if (group.addComponent(this)) {
                    this.focusTraversalGroup = group;
                } else {
                    throw new GUIRuntimeException("component " + this + " already in focus travseral group " + group);
                }
            }
        }
    }

    @Override
    public FocusTraversalGroup getFocusTraversalGroup() {
        return this.focusTraversalGroup;
    }

    @Override
    public void setPropertyGroup(PropertyGroup group) {
        if (this.propertyGroup != group) {
            if (this.propertyGroup != null) {
                if (this.propertyGroup.removeComponent(this)) {
                    this.propertyGroup = null;
                } else {
                    throw new GUIRuntimeException("component " + this + " not in property group " + this.propertyGroup);
                }
            }
            if (group != null) {
                if (group.addComponent(this)) {
                    this.propertyGroup = group;
                } else {
                    throw new GUIRuntimeException("component " + this + " already in property group " + group);
                }
            }
        }
    }

    @Override
    public PropertyGroup getPropertyGroup() {
        return this.propertyGroup;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        if (this.mandatory != mandatory) {
            boolean oldValue = this.mandatory;
            this.mandatory = mandatory;
            this.firePropertyChange("mandatory", oldValue, mandatory);
            this.invalidate();
            this.repaint();
        }
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public void setComponentPath(String componentPath) {
        this.componentPath = componentPath;
    }

    @Override
    public String getComponentPath() {
        return this.componentPath;
    }

    @Override
    public void setBindingPath(String bindingPath) {
        this.bindingPath = bindingPath;
    }

    @Override
    public String getBindingPath() {
        return this.bindingPath;
    }

    @Override
    public void setBinding(FormComponentBinding binding) {
        this.binding = binding;
    }

    @Override
    public FormComponentBinding getBinding() {
        return this.binding;
    }

    @Override
    public void setBindable(boolean bindable) {
        this.bindable = bindable;
    }

    @Override
    public boolean isBindable() {
        return this.bindable;
    }

    @Override
    public String getValueShown() {
        return super.getText();
    }

    @Override
    public boolean isValueShownModified() {
        return this.errorOffset >= 0 || !Objects.equals(this.oldValueShown, this.getValueShown());
    }

    @Override
    public void clearValueShownModified() {
        this.oldValueShown = this.getValueShown();
    }

    @Override
    public void setSmartValueEntered(boolean smartValueEntered) {
        this.smartValueEntered = smartValueEntered;
    }

    @Override
    public boolean isSmartValueEntered() {
        return this.smartValueEntered;
    }
}

