/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import javax.swing.text.Document;
import org.tentackle.common.BMoney;
import org.tentackle.common.DMoney;
import org.tentackle.misc.FormatHelper;
import org.tentackle.swing.AbstractFractionNumberFormField;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.SwingSwingBundle;
import org.tentackle.swing.bind.BMoneyFormFieldBinding;

public class BMoneyFormField
extends AbstractFractionNumberFormField {
    public static boolean defaultAutoComma;
    private boolean autoComma;
    private char commaChar;
    private boolean parseDMoney;
    private BMoney minValue;
    private BMoney maxValue;

    public BMoneyFormField(Document doc, int columns, boolean parseDMoney) {
        super(doc, columns);
        this.parseDMoney = parseDMoney;
        this.autoComma = defaultAutoComma;
        this.decimalFormat.applyPattern(FormatHelper.getMoneyPattern());
        this.commaChar = this.decimalFormat.getDecimalFormatSymbols().getDecimalSeparator();
    }

    public BMoneyFormField(int columns, boolean parseDMoney) {
        this(null, columns, parseDMoney);
    }

    public BMoneyFormField(boolean parseDMoney) {
        this(0, parseDMoney);
    }

    public BMoneyFormField() {
        this(false);
    }

    public void setMinValue(BMoney minValue) {
        this.minValue = minValue;
    }

    public BMoney getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(BMoney maxValue) {
        this.maxValue = maxValue;
    }

    public BMoney getMaxValue() {
        return this.maxValue;
    }

    @Override
    public void setFormValue(Object object) {
        if (object instanceof BMoney) {
            this.setScale(((BMoney)object).scale());
        }
        super.setFormValue(object);
    }

    protected BMoney getFormValue(boolean parseDMoney) {
        block14: {
            String str = this.getText();
            if (str != null && (str = str.replace(this.getFiller(), ' ').trim()).length() > 0) {
                if (this.autoComma && this.getScale() > 0 && str.indexOf(this.commaChar) < 0) {
                    int len;
                    int prec = this.getScale();
                    for (len = str.length(); len <= prec; ++len) {
                        str = "0" + str;
                    }
                    str = str.substring(0, len - prec) + this.commaChar + str.substring(len - prec);
                }
                try {
                    this.decimalFormat.setParseBigDecimal(true);
                    BigDecimal value = (BigDecimal)this.decimalFormat.parse(str);
                    value = value.setScale(this.getScale(), 4);
                    DMoney money = null;
                    if (parseDMoney) {
                        if (value.precision() > 19) {
                            this.errorOffset = 0;
                            this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("MONEY VALUE MUST NOT EXCEED {0} DIGITS"), 19);
                        } else {
                            money = new DMoney(value);
                        }
                    } else if (value.precision() > 15) {
                        this.errorOffset = 0;
                        this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("MONEY VALUE MUST NOT EXCEED {0} DIGITS"), 15);
                    } else {
                        money = new BMoney(value);
                    }
                    if (this.errorOffset < 0 && money != null) {
                        if (this.minValue != null && money.compareTo((BigDecimal)this.minValue) < 0) {
                            this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("MONEY VALUE MUST BE_>= {0}"), this.minValue);
                            break block14;
                        }
                        if (this.maxValue != null && money.compareTo((BigDecimal)this.maxValue) > 0) {
                            this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("MONEY VALUE MUST BE <= {0}"), this.maxValue);
                            break block14;
                        }
                        return money;
                    }
                    return money;
                }
                catch (ParseException e) {
                    this.errorOffset = e.getErrorOffset();
                    this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("INVALID MONEY VALUE: {0}"), str);
                }
            }
        }
        return null;
    }

    public BMoney getFormValue() {
        return this.getFormValue(this.parseDMoney);
    }

    public DMoney getDMoney() {
        return (DMoney)this.getFormValue(true);
    }

    public void setParseDMoney(boolean parseDMoney) {
        this.parseDMoney = parseDMoney;
    }

    public boolean isParseDMoney() {
        return this.parseDMoney;
    }

    @Override
    public void setFormat(String pattern) {
        super.setFormat(pattern);
        this.commaChar = this.decimalFormat.getDecimalFormatSymbols().getDecimalSeparator();
    }

    public void setAutoComma(boolean autoComma) {
        this.autoComma = autoComma;
    }

    public boolean isAutoComma() {
        return this.autoComma;
    }

    static {
        FormUtilities.getInstance().getBindingFactory().setFormComponentBindingClass(BMoneyFormField.class, BMoneyFormFieldBinding.class);
        defaultAutoComma = false;
    }
}

