/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.beans.PropertyEditorSupport;
import org.tentackle.swing.FormCalendar;
import org.tentackle.swing.FormCalendarField;

public class CalendarTimeModePropertyEditor
extends PropertyEditorSupport {
    private static final String[] options = new String[]{"AUTO", "DATE", "HOUR", "MINUTE", "SECOND"};

    @Override
    public String[] getTags() {
        return options;
    }

    @Override
    public String getAsText() {
        int time = (Integer)this.getValue() + 1;
        if (time >= 0 && time < options.length) {
            return options[time];
        }
        return options[0];
    }

    @Override
    public void setAsText(String s) {
        for (int time = 0; time < options.length; ++time) {
            if (options[time].compareTo(s) != 0) continue;
            this.setValue(time - 1);
            return;
        }
        this.setValue(-1);
    }

    @Override
    public String getJavaInitializationString() {
        if ((Integer)this.getValue() < 0) {
            return FormCalendarField.class.getName() + ".SHOW_AUTO";
        }
        return FormCalendar.class.getName() + ".SHOW_" + this.getAsText();
    }
}

