/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Objects;
import javax.swing.text.Document;
import org.tentackle.common.Date;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.misc.DateHelper;
import org.tentackle.misc.FormatHelper;
import org.tentackle.misc.StringHelper;
import org.tentackle.swing.AbstractFormField;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.GUIRuntimeException;
import org.tentackle.swing.SqlDateField;
import org.tentackle.swing.SqlDateFieldBinding;
import org.tentackle.swing.SwingSwingBundle;

public class DateFormField
extends AbstractFormField
implements SqlDateField {
    private static final Logger LOGGER;
    public static java.util.Date defaultMinDate;
    public static java.util.Date defaultMaxDate;
    public static Logger.Level defaultInformationLossLogLevel;
    private static final String legacyDateDelimiters = ".,/*=-";
    private static final String legacyTimeDelimiters = ":;\"'";
    private String format;
    private String oldDefaultFormat;
    private SimpleDateFormat dateFormat;
    private String dateDelimiters;
    private boolean lenient;
    private java.util.Date referenceDate;
    private java.util.Date lastDate;
    private char defaultUnit;
    private ReferenceDateProvider refProvider;
    private java.util.Date minDate;
    private java.util.Date maxDate;
    private Logger.Level informationLossLogLevel;

    public DateFormField(Document doc, int columns) {
        super(doc, null, columns);
        this.setHorizontalAlignment(0);
        this.defaultUnit = (char)32;
    }

    public DateFormField(int columns) {
        this((Document)null, columns);
    }

    public DateFormField() {
        this(0);
    }

    public DateFormField(String pattern) {
        this(0);
        this.setFormat(pattern);
    }

    @Override
    public void setFormValue(Object date) {
        this.setText(this.doFormat(date));
    }

    public void setInformationLossLogLevel(Logger.Level informationLossLogLevel) {
        this.informationLossLogLevel = informationLossLogLevel;
    }

    public Logger.Level getInformationLossLogLevel() {
        return this.informationLossLogLevel;
    }

    protected Logger.Level getEffectiveInformationLossLogLevel() {
        return this.informationLossLogLevel != null ? this.informationLossLogLevel : defaultInformationLossLogLevel;
    }

    @Override
    public String doFormat(Object value) {
        if (value instanceof java.util.Date) {
            Logger.Level effectiveLevel;
            boolean infoLoss = false;
            if (value instanceof Timestamp || value instanceof Time) {
                if (!FormatHelper.isFormattingTime((SimpleDateFormat)this.getDateFormat())) {
                    infoLoss = true;
                }
            } else if (!FormatHelper.isFormattingDate((SimpleDateFormat)this.getDateFormat())) {
                infoLoss = true;
            }
            if (infoLoss && (effectiveLevel = this.getEffectiveInformationLossLogLevel()) != null && effectiveLevel != Logger.Level.SEVERE && LOGGER.isLoggable(effectiveLevel)) {
                String msg = "possible information loss while formatting " + value + " with format " + this.getDateFormat().toPattern() + " in:\n" + FormUtilities.getInstance().dumpComponentHierarchy(this, null);
                GUIRuntimeException uix = effectiveLevel == Logger.Level.FINE || effectiveLevel == Logger.Level.FINER ? new GUIRuntimeException(msg) : null;
                LOGGER.log(effectiveLevel, uix == null ? msg : "", (Throwable)uix);
                if (effectiveLevel == Logger.Level.FINER) {
                    throw uix;
                }
            }
            this.lastDate = (java.util.Date)value;
            return this.getDateFormat().format((java.util.Date)value);
        }
        if (value instanceof GregorianCalendar) {
            return this.doFormat(((GregorianCalendar)value).getTime());
        }
        return "";
    }

    @Override
    public void setText(String str) {
        if (str == null || str.isEmpty()) {
            this.lastDate = null;
        }
        super.setText(str);
    }

    @Override
    public java.util.Date getFormValue() {
        for (int loop = 0; loop < 3; ++loop) {
            GregorianCalendar cal;
            this.errorOffset = -1;
            this.errorMessage = null;
            String str = this.getText().replace(this.getFiller(), ' ').trim();
            int slen = str.length();
            if (slen == 0) {
                return null;
            }
            if (str.charAt(0) == '@') {
                ReferenceDateProvider refPro = this.getReferenceDateProvider();
                if (refPro != null) {
                    this.setReferenceDate(refPro.getReferenceDate());
                    str = str.substring(1, slen);
                    if (--slen == 0) {
                        str = "+0";
                        slen = 2;
                    }
                } else {
                    this.errorOffset = 0;
                    this.errorMessage = "no reference provider for @";
                    return null;
                }
            }
            String fmt = this.getFormat();
            boolean withDate = FormatHelper.isFormattingDate((SimpleDateFormat)this.dateFormat);
            boolean withTime = FormatHelper.isFormattingTime((SimpleDateFormat)this.dateFormat);
            if (slen == 1) {
                char c = str.charAt(0);
                if (withDate && (legacyDateDelimiters.indexOf(c) >= 0 || this.dateDelimiters.indexOf(c) >= 0)) {
                    cal = new GregorianCalendar();
                    DateHelper.setMidnight((GregorianCalendar)cal);
                    this.setFormValue(cal);
                    return this.getFormValue();
                }
                if (withTime && legacyTimeDelimiters.indexOf(c) >= 0) {
                    this.setFormValue(new java.util.Date());
                    return this.getFormValue();
                }
            }
            if (str.indexOf(45) == 0 || str.indexOf(43) == 0 || slen <= 2 && StringHelper.isAllDigits((String)str) || "sSmMhHdDwWyY".indexOf(str.charAt(slen - 1)) >= 0) {
                boolean setValue = Character.isDigit(str.charAt(0));
                try {
                    int value;
                    cal = new GregorianCalendar();
                    java.util.Date refDate = this.getReferenceDate();
                    if (refDate != null) {
                        cal.setTime(refDate);
                    } else if (!setValue && this.lastDate != null) {
                        cal.setTime(this.lastDate);
                    }
                    int type = str.charAt(slen - 1);
                    if (Character.isDigit((char)type)) {
                        int defUnit = this.getDefaultUnit();
                        if (defUnit != 0 && defUnit != 32) {
                            type = defUnit;
                        } else if (fmt.indexOf(115) >= 0) {
                            type = 115;
                        } else if (fmt.indexOf(109) >= 0) {
                            type = 109;
                        } else if (fmt.indexOf(104) >= 0) {
                            type = 104;
                        } else if (fmt.indexOf(72) >= 0) {
                            type = 72;
                        } else if (fmt.indexOf(100) >= 0) {
                            type = 100;
                        } else if (fmt.indexOf(77) >= 0) {
                            type = 77;
                        } else if (fmt.indexOf(89) >= 0) {
                            type = 121;
                        }
                        value = Integer.parseInt(str.charAt(0) == '+' ? str.substring(1) : str);
                    } else {
                        value = Integer.parseInt(str.substring(str.charAt(0) == '+' ? 1 : 0, slen - 1));
                    }
                    if (setValue) {
                        switch (type) {
                            case 83: 
                            case 115: {
                                this.setGregorianValue(cal, 13, value);
                                break;
                            }
                            case 109: {
                                if (fmt.indexOf(109) == -1) {
                                    this.setGregorianValue(cal, 2, value - 1);
                                    break;
                                }
                                this.setGregorianValue(cal, 12, value);
                                cal.set(13, 0);
                                break;
                            }
                            case 72: 
                            case 104: {
                                this.setGregorianValue(cal, 11, value);
                                cal.set(12, 0);
                                cal.set(13, 0);
                                break;
                            }
                            case 68: 
                            case 100: {
                                this.setGregorianValue(cal, 5, value);
                                DateHelper.setMidnight((GregorianCalendar)cal);
                                break;
                            }
                            case 87: 
                            case 119: {
                                this.setGregorianValue(cal, 3, value);
                                cal.set(7, cal.getFirstDayOfWeek());
                                DateHelper.setMidnight((GregorianCalendar)cal);
                                break;
                            }
                            case 77: {
                                this.setGregorianValue(cal, 2, value - 1);
                                cal.set(5, 1);
                                DateHelper.setMidnight((GregorianCalendar)cal);
                                break;
                            }
                            case 89: 
                            case 121: {
                                if (value < 100) {
                                    value = this.convert2DigitYearTo4DigitYear(value);
                                }
                                this.setGregorianValue(cal, 1, value);
                                cal.set(6, 1);
                                DateHelper.setMidnight((GregorianCalendar)cal);
                            }
                        }
                    } else {
                        switch (type) {
                            case 83: 
                            case 115: {
                                cal.add(13, value);
                                break;
                            }
                            case 109: {
                                if (fmt.indexOf(109) == -1) {
                                    cal.add(2, value);
                                    break;
                                }
                                cal.add(12, value);
                                break;
                            }
                            case 72: 
                            case 104: {
                                cal.add(10, value);
                                break;
                            }
                            case 68: 
                            case 100: {
                                cal.add(5, value);
                                DateHelper.setMidnight((GregorianCalendar)cal);
                                break;
                            }
                            case 87: 
                            case 119: {
                                cal.add(3, value);
                                DateHelper.setMidnight((GregorianCalendar)cal);
                                break;
                            }
                            case 77: {
                                cal.add(2, value);
                                DateHelper.setMidnight((GregorianCalendar)cal);
                                break;
                            }
                            case 89: 
                            case 121: {
                                cal.add(1, value);
                                DateHelper.setMidnight((GregorianCalendar)cal);
                            }
                        }
                    }
                    this.setFormValue(cal.getTime());
                    return this.getFormValue();
                }
                catch (ParseException e) {
                    this.errorOffset = e.getErrorOffset();
                    this.errorMessage = e.getMessage();
                    return null;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                int year;
                java.util.Date date = this.getDateFormat().parse(str);
                cal = new GregorianCalendar();
                cal.setTime(date);
                if (!withTime) {
                    DateHelper.setMidnight((GregorianCalendar)cal);
                    date = cal.getTime();
                }
                if ((year = cal.get(1)) < 100) {
                    year = this.convert2DigitYearTo4DigitYear(year);
                    cal.set(1, year);
                    date = cal.getTime();
                }
                if (date != null) {
                    java.util.Date effMaxDate;
                    java.util.Date effMinDate = this.getEffectiveMinDate();
                    if (effMinDate != null && date.before(effMinDate)) {
                        this.errorOffset = 0;
                        this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("VALUE MUST BE >= {0}"), this.getDateFormat().format(effMinDate));
                        date = null;
                    }
                    if ((effMaxDate = this.getEffectiveMaxDate()) != null && date.after(effMaxDate)) {
                        this.errorOffset = 0;
                        this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("VALUE MUST BE <= {0}"), this.getDateFormat().format(effMaxDate));
                        date = null;
                    }
                }
                return date;
            }
            catch (ParseException e) {
                char c;
                int spos;
                this.errorOffset = e.getErrorOffset();
                this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("INVALID DATE: {0}"), str);
                if (this.errorOffset > 0 && this.errorOffset == slen && this.dateDelimiters.indexOf(str.charAt(this.errorOffset - 1)) >= 0) {
                    this.setText(str + new GregorianCalendar().get(1));
                    continue;
                }
                String newstr = "";
                int dlen = this.dateDelimiters.length();
                int dpos = 0;
                for (spos = 0; spos < slen && this.dateDelimiters.indexOf(c = str.charAt(spos)) < 0 && legacyDateDelimiters.indexOf(c) < 0; ++spos) {
                    if (dpos < dlen && spos > 0 && spos % 2 == 0) {
                        newstr = newstr + this.dateDelimiters.charAt(dpos++);
                    }
                    newstr = newstr + c;
                }
                if (spos == slen) {
                    if (slen % 2 == 0 && dpos < dlen) {
                        newstr = newstr + this.dateDelimiters.charAt(dpos);
                    }
                    if (newstr.length() == 6) {
                        newstr = newstr + new GregorianCalendar().get(1);
                    }
                    this.setText(newstr);
                    continue;
                }
                boolean timeOnly = true;
                int colonCount = 0;
                for (int i = 0; i < slen; ++i) {
                    char c2 = str.charAt(i);
                    if (c2 == ':') {
                        ++colonCount;
                        continue;
                    }
                    if (Character.isDigit(c2)) continue;
                    timeOnly = false;
                    break;
                }
                if (timeOnly) {
                    try {
                        GregorianCalendar cal2 = new GregorianCalendar();
                        cal2.setTime(colonCount == 1 ? FormatHelper.parseShortTime((String)str) : FormatHelper.parseTime((String)str));
                        int hour = cal2.get(11);
                        int minute = cal2.get(12);
                        int second = cal2.get(13);
                        cal2.setTime(new java.util.Date());
                        cal2.set(11, hour);
                        cal2.set(12, minute);
                        cal2.set(13, second);
                        this.errorOffset = -1;
                        this.errorMessage = null;
                        return cal2.getTime();
                    }
                    catch (ParseException cal2) {
                        continue;
                    }
                }
                newstr = str + " 00:00:00";
                try {
                    this.getDateFormat().parse(newstr);
                    this.setText(newstr);
                }
                catch (ParseException ex) {
                    if (this.dateDelimiters.length() <= 0) continue;
                    StringBuilder buf = new StringBuilder(str);
                    String delimStr = this.dateDelimiters.substring(0, 1);
                    for (int i = 0; i < buf.length(); ++i) {
                        char c3 = buf.charAt(i);
                        if (legacyDateDelimiters.indexOf(c3) < 0) continue;
                        buf.replace(i, i + 1, delimStr);
                    }
                    newstr = buf.toString();
                    if (newstr.equals(str)) continue;
                    try {
                        this.getDateFormat().parse(newstr);
                        this.setText(newstr);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                continue;
            }
        }
        return null;
    }

    public void setMinDate(java.util.Date minDate) {
        this.minDate = minDate;
    }

    public java.util.Date getMinDate() {
        return this.minDate;
    }

    public void setMaxDate(java.util.Date maxDate) {
        this.maxDate = maxDate;
    }

    public java.util.Date getMaxDate() {
        return this.maxDate;
    }

    @Override
    public Date getDate() {
        java.util.Date date = this.getFormValue();
        return date == null ? null : new Date(date.getTime());
    }

    @Override
    public org.tentackle.common.Timestamp getTimestamp() {
        java.util.Date date = this.getFormValue();
        return date == null ? null : new org.tentackle.common.Timestamp(date.getTime());
    }

    @Override
    public org.tentackle.common.Time getTime() {
        java.util.Date date = this.getFormValue();
        return date == null ? null : new org.tentackle.common.Time(date.getTime());
    }

    public void setDateFormat(SimpleDateFormat fmt) {
        this.dateFormat = fmt;
        this.dateFormat.setLenient(this.lenient);
        this.dateDelimiters = "";
        String f = fmt.toPattern();
        for (int i = 0; i < f.length(); ++i) {
            char c = f.charAt(i);
            if (Character.isLetterOrDigit(c)) continue;
            this.dateDelimiters = this.dateDelimiters + c;
        }
    }

    public SimpleDateFormat getDateFormat() {
        String shortDatePattern = FormatHelper.getShortDatePattern();
        if (this.dateFormat == null || this.format == null && !Objects.equals(this.oldDefaultFormat, shortDatePattern)) {
            this.setDateFormat(new SimpleDateFormat(shortDatePattern));
            this.oldDefaultFormat = shortDatePattern;
        }
        return this.dateFormat;
    }

    @Override
    public void setFormat(String pattern) {
        this.format = pattern;
        this.setDateFormat(new SimpleDateFormat(pattern));
    }

    @Override
    public String getFormat() {
        return this.format != null ? this.format : this.getDateFormat().toPattern();
    }

    public void setLenient(boolean lenient) {
        this.getDateFormat().setLenient(lenient);
        this.lenient = this.dateFormat.isLenient();
    }

    public boolean isLenient() {
        this.lenient = this.getDateFormat().isLenient();
        return this.lenient;
    }

    public java.util.Date getReferenceDate() {
        return this.referenceDate;
    }

    public void setReferenceDate(java.util.Date referenceDate) {
        this.referenceDate = referenceDate;
    }

    public char getDefaultUnit() {
        return this.defaultUnit;
    }

    public void setDefaultUnit(char defaultUnit) {
        if (defaultUnit == '\u0000') {
            defaultUnit = (char)32;
        }
        this.defaultUnit = defaultUnit;
    }

    public ReferenceDateProvider getReferenceDateProvider() {
        return this.refProvider;
    }

    public void setReferenceDateProvider(ReferenceDateProvider refProvider) {
        this.refProvider = refProvider;
    }

    protected java.util.Date getEffectiveMinDate() {
        java.util.Date d = this.getMinDate();
        if (d == null) {
            d = defaultMinDate;
        }
        return d;
    }

    protected java.util.Date getEffectiveMaxDate() {
        java.util.Date d = this.getMaxDate();
        if (d == null) {
            d = defaultMaxDate;
        }
        return d;
    }

    protected void setGregorianValue(GregorianCalendar cal, int field, int value) throws ParseException {
        if (!this.lenient) {
            int min = cal.getActualMinimum(field);
            int max = cal.getActualMaximum(field);
            if (value < min || value > max) {
                if (field == 2) {
                    ++value;
                    ++min;
                    ++max;
                }
                throw new ParseException(MessageFormat.format(SwingSwingBundle.getString("INVALID {0}: {1} MUST BE BETWEEN {2} AND {3}"), FormatHelper.calendarFieldToString((int)field, (boolean)false), value, min, max), 0);
            }
        }
        cal.set(field, value);
    }

    protected int convert2DigitYearTo4DigitYear(int year2) {
        return DateHelper.convert2DigitYearTo4DigitYear((int)year2, (int)new GregorianCalendar().get(1));
    }

    static {
        FormUtilities.getInstance().getBindingFactory().setFormComponentBindingClass(DateFormField.class, SqlDateFieldBinding.class);
        LOGGER = LoggerFactory.getLogger(DateFormField.class);
        defaultInformationLossLogLevel = Logger.Level.INFO;
    }

    public static interface ReferenceDateProvider {
        public java.util.Date getReferenceDate();
    }
}

