/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import org.tentackle.swing.FormComboBox;
import org.tentackle.swing.FormPanel;
import org.tentackle.swing.HourSpinField;
import org.tentackle.swing.MinSecSpinField;
import org.tentackle.swing.MonthSpinField;
import org.tentackle.swing.ValueEvent;
import org.tentackle.swing.ValueListener;
import org.tentackle.swing.YearSpinField;
import org.tentackle.swing.plaf.PlafUtilities;

public class FormCalendar
extends FormPanel {
    public static final int SHOW_DATE = 0;
    public static final int SHOW_HOUR = 1;
    public static final int SHOW_MINUTE = 2;
    public static final int SHOW_SECOND = 3;
    private static final String ACTION_THISMONTH = "M";
    private static final String ACTION_PREVIOUSMONTH = "P";
    private static final String ACTION_NEXTMONTH = "N";
    private Locale locale;
    private GregorianCalendar calendar;
    private String[] dayNames;
    private int firstDayIndex;
    private JToggleButton firstClickButton;
    private FormPanel calendarPanel;
    private HourSpinField hourField;
    private JLabel jLabel1;
    private MinSecSpinField minuteField;
    private MonthSpinField monthField;
    private MinSecSpinField secondField;
    private FormPanel selectPanel;
    private YearSpinField yearField;

    public FormCalendar(Locale locale, Date day, int timeMode) {
        this.initComponents();
        ((FormComboBox)this.monthField.getFormComponent()).setValueEnteredOnSelect(true);
        this.setup(locale, day, timeMode);
    }

    public FormCalendar(Date day, int timeMode) {
        this(null, day, timeMode);
    }

    public FormCalendar(Date day) {
        this(day, 0);
    }

    public FormCalendar() {
        this((Date)null);
    }

    public void setup(Locale locale, Date day, int timeMode) {
        Locale locale2 = this.locale = locale == null ? Locale.getDefault() : locale;
        if (day == null) {
            day = new Date();
        }
        this.calendar = new GregorianCalendar(this.locale);
        this.calendar.setTime(day);
        if (timeMode < 3) {
            this.calendar.set(13, 0);
        }
        if (timeMode < 2) {
            this.calendar.set(12, 0);
        }
        if (timeMode < 1) {
            this.calendar.set(11, 0);
        }
        this.calendar.set(14, 0);
        String[] days = new DateFormatSymbols(this.locale).getWeekdays();
        this.dayNames = new String[7];
        for (int i = 0; i < 6; ++i) {
            this.dayNames[i] = days[i + 2].substring(0, 2);
        }
        this.dayNames[6] = days[1].substring(0, 2);
        this.secondField.setVisible(timeMode >= 3);
        this.minuteField.setVisible(timeMode >= 2);
        this.hourField.setVisible(timeMode >= 1);
        this.setupCalSheet();
    }

    public void setCalendar(GregorianCalendar cal) {
        this.calendar = cal;
        this.setupCalSheet();
    }

    public GregorianCalendar getCalendar() {
        return this.calendar;
    }

    private void setupCalSheet() {
        this.yearField.setYear(this.calendar.get(1));
        this.monthField.setMonth(this.calendar.get(2));
        this.hourField.setHour(this.calendar.get(11));
        this.minuteField.setMinSec(this.calendar.get(12));
        this.secondField.setMinSec(this.calendar.get(13));
        this.calendarPanel.removeAll();
        this.calendarPanel.add((Component)new JLabel(""), null);
        for (int i = 0; i < 7; ++i) {
            JLabel dayLabel = new JLabel(this.dayNames[i]);
            dayLabel.setHorizontalAlignment(0);
            this.calendarPanel.add((Component)dayLabel, null);
        }
        GregorianCalendar firstCal = new GregorianCalendar(this.locale);
        firstCal.setTime(this.calendar.getTime());
        firstCal.set(5, 1);
        this.firstDayIndex = firstCal.get(7) - 2;
        if (this.firstDayIndex <= 0) {
            this.firstDayIndex += 7;
        }
        firstCal.add(6, -this.firstDayIndex);
        GregorianCalendar today = new GregorianCalendar(this.locale);
        Font thisMonthButtonFont = new JToggleButton().getFont().deriveFont(1);
        Font otherMonthButtonFont = new JToggleButton().getFont().deriveFont(2);
        Color thisMonthBackgroundColor = PlafUtilities.getInstance().getTableSelectionBackgroundColor();
        Color thisMonthForegroundColor = PlafUtilities.getInstance().getTableSelectionForegroundColor();
        Color otherMonthBackgroundColor = PlafUtilities.getInstance().getTableBackgroundColor();
        Color otherMonthForegroundColor = PlafUtilities.getInstance().getTableForegroundColor();
        ButtonGroup dayButtonGroup = new ButtonGroup();
        for (int compCount = 0; compCount < 48; ++compCount) {
            if (compCount % 8 == 0) {
                JLabel weekLabel = new JLabel(Integer.toString(firstCal.get(3)));
                weekLabel.setHorizontalAlignment(0);
                this.calendarPanel.add((Component)weekLabel, null);
                continue;
            }
            CalToggleButton dayButton = new CalToggleButton(Integer.toString(firstCal.get(5)));
            if (firstCal.get(2) == this.calendar.get(2)) {
                dayButton.setBackground(thisMonthBackgroundColor);
                dayButton.setForeground(thisMonthForegroundColor);
                dayButton.setFont(thisMonthButtonFont);
                dayButton.setActionCommand(ACTION_THISMONTH);
            } else {
                dayButton.setBackground(otherMonthBackgroundColor);
                dayButton.setForeground(otherMonthForegroundColor);
                dayButton.setFont(otherMonthButtonFont);
                if (compCount <= this.firstDayIndex) {
                    dayButton.setActionCommand(ACTION_PREVIOUSMONTH);
                } else {
                    dayButton.setActionCommand(ACTION_NEXTMONTH);
                }
            }
            if (today.get(1) == firstCal.get(1) && today.get(6) == firstCal.get(6)) {
                dayButton.setForeground(Color.blue);
            }
            dayButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FormCalendar.this.dayButton_actionPerformed(e);
                }
            });
            dayButtonGroup.add(dayButton);
            this.calendarPanel.add((Component)dayButton, null);
            firstCal.add(6, 1);
        }
        this.selectDay();
    }

    private void selectDay() {
        Component[] comps = this.calendarPanel.getComponents();
        int buttonCount = 1;
        int day = this.calendar.get(5);
        Border border = BorderFactory.createLineBorder(PlafUtilities.getInstance().getAlarmColor());
        for (int i = 0; i < comps.length; ++i) {
            JToggleButton button;
            if (!(comps[i] instanceof JToggleButton) || !ACTION_THISMONTH.equals((button = (JToggleButton)comps[i]).getActionCommand())) continue;
            if (buttonCount == day) {
                button.setSelected(true);
                button.setBorder(border);
                button.setBorderPainted(true);
            } else {
                button.setBorder(null);
                button.setBorderPainted(false);
            }
            ++buttonCount;
        }
    }

    private void dayButton_actionPerformed(ActionEvent e) {
        JToggleButton button = (JToggleButton)e.getSource();
        String cmd = button.getActionCommand();
        NumberFormat format = DecimalFormat.getNumberInstance();
        try {
            int day = format.parse(button.getText()).intValue();
            if (ACTION_THISMONTH.equals(cmd)) {
                this.calendar.set(5, day);
                this.selectDay();
            } else if (ACTION_PREVIOUSMONTH.equals(cmd)) {
                this.calendar.add(2, -1);
                this.calendar.set(5, day);
                this.setupCalSheet();
            } else if (ACTION_NEXTMONTH.equals(cmd)) {
                this.calendar.add(2, 1);
                this.calendar.set(5, day);
                this.setupCalSheet();
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private void fireActionPerformed(String action) {
        this.fireActionPerformed(new ActionEvent(this, 1001, action));
    }

    private void initComponents() {
        this.selectPanel = new FormPanel();
        this.yearField = new YearSpinField();
        this.monthField = new MonthSpinField();
        this.hourField = new HourSpinField();
        this.minuteField = new MinSecSpinField();
        this.secondField = new MinSecSpinField();
        this.jLabel1 = new JLabel();
        this.calendarPanel = new FormPanel();
        this.setLayout(new BorderLayout());
        this.selectPanel.setLayout(new GridBagLayout());
        this.yearField.addValueListener(new ValueListener(){

            @Override
            public void valueEntered(ValueEvent evt) {
                FormCalendar.this.yearFieldValueEntered(evt);
            }

            @Override
            public void valueChanged(ValueEvent evt) {
                FormCalendar.this.yearFieldValueChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.selectPanel.add((Component)this.yearField, gridBagConstraints);
        this.monthField.addValueListener(new ValueListener(){

            @Override
            public void valueEntered(ValueEvent evt) {
                FormCalendar.this.monthFieldValueEntered(evt);
            }

            @Override
            public void valueChanged(ValueEvent evt) {
                FormCalendar.this.monthFieldValueChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.selectPanel.add((Component)this.monthField, gridBagConstraints);
        this.hourField.addValueListener(new ValueListener(){

            @Override
            public void valueEntered(ValueEvent evt) {
                FormCalendar.this.hourFieldValueEntered(evt);
            }

            @Override
            public void valueChanged(ValueEvent evt) {
                FormCalendar.this.hourFieldValueChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.selectPanel.add((Component)this.hourField, gridBagConstraints);
        this.minuteField.addValueListener(new ValueListener(){

            @Override
            public void valueEntered(ValueEvent evt) {
                FormCalendar.this.minuteFieldValueEntered(evt);
            }

            @Override
            public void valueChanged(ValueEvent evt) {
                FormCalendar.this.minuteFieldValueChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.selectPanel.add((Component)this.minuteField, gridBagConstraints);
        this.secondField.addValueListener(new ValueListener(){

            @Override
            public void valueEntered(ValueEvent evt) {
                FormCalendar.this.secondFieldValueEntered(evt);
            }

            @Override
            public void valueChanged(ValueEvent evt) {
                FormCalendar.this.secondFieldValueChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.selectPanel.add((Component)this.secondField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.selectPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.add((Component)this.selectPanel, "First");
        this.calendarPanel.setLayout(new GridLayout(7, 8));
        this.add((Component)this.calendarPanel, "Center");
    }

    private void yearFieldValueChanged(ValueEvent evt) {
    }

    private void yearFieldValueEntered(ValueEvent evt) {
        int yearDiff = this.yearField.getYear() - this.calendar.get(1);
        if (yearDiff != 0) {
            this.calendar.add(1, yearDiff);
            this.setupCalSheet();
        }
    }

    private void monthFieldValueChanged(ValueEvent evt) {
    }

    private void monthFieldValueEntered(ValueEvent evt) {
        int monthDiff = this.monthField.getMonth() - this.calendar.get(2);
        if (monthDiff != 0) {
            this.calendar.add(2, monthDiff);
            this.setupCalSheet();
        }
    }

    private void hourFieldValueChanged(ValueEvent evt) {
    }

    private void hourFieldValueEntered(ValueEvent evt) {
        this.calendar.set(11, this.hourField.getHour());
    }

    private void minuteFieldValueChanged(ValueEvent evt) {
    }

    private void minuteFieldValueEntered(ValueEvent evt) {
        this.calendar.set(12, this.minuteField.getMinSec());
    }

    private void secondFieldValueChanged(ValueEvent evt) {
    }

    private void secondFieldValueEntered(ValueEvent evt) {
        this.calendar.set(13, this.secondField.getMinSec());
    }

    private class CalToggleButton
    extends JToggleButton {
        private static final long serialVersionUID = -3905831436360712248L;

        CalToggleButton(String text) {
            super(text);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorderPainted(false);
            this.setBorder(BorderFactory.createEmptyBorder());
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected void processMouseEvent(MouseEvent e) {
            block4: {
                if (e.getID() == 501) {
                    if (e.getClickCount() == 2) {
                        if (FormCalendar.this.firstClickButton == this && FormCalendar.ACTION_THISMONTH.equals(this.getActionCommand())) {
                            FormCalendar.this.fireActionPerformed(this.getText());
                            break block4;
                        } else {
                            e.consume();
                            return;
                        }
                    }
                    FormCalendar.this.firstClickButton = this;
                }
            }
            super.processMouseEvent(e);
        }
    }
}

