/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeCellEditor;
import org.tentackle.swing.FormComboBox;
import org.tentackle.swing.FormComponent;
import org.tentackle.swing.FormTable;
import org.tentackle.swing.FormTableEntry;
import org.tentackle.swing.FormTextArea;
import org.tentackle.swing.FormTree;
import org.tentackle.swing.StringFormField;
import org.tentackle.swing.ValueEvent;
import org.tentackle.swing.ValueListener;
import org.tentackle.swing.plaf.PlafUtilities;

public class FormComponentCellEditor
extends AbstractCellEditor
implements TableCellEditor,
TreeCellEditor {
    protected FormTable<?> table;
    protected FormTree tree;
    protected int row;
    protected int column;
    protected boolean selected;
    protected boolean expanded;
    protected boolean leaf;
    protected FormComponent editor;
    protected int clickCountToStart = 2;
    private boolean autoRowHeight;
    private boolean startOver;
    private boolean editingCanceled;

    public FormComponentCellEditor(FormComponent editorComponent) {
        this.setEditorComponent(editorComponent);
    }

    public FormComponentCellEditor() {
        this(new StringFormField());
    }

    public void setEditorComponent(FormComponent editor) {
        this.editor = editor;
        editor.setCellEditorUsage(true);
        if (editor instanceof FormTextArea) {
            ((FormTextArea)editor).setSmartEnter(false);
        }
        editor.addValueListener(new ValueListener(){

            @Override
            public void valueChanged(ValueEvent e) {
            }

            @Override
            public void valueEntered(ValueEvent e) {
                FormComponentCellEditor.this.stopCellEditing();
            }
        });
        this.registerTextDocumentListener();
    }

    public FormComponent getEditorComponent() {
        return this.editor;
    }

    public void setAutoRowHeight(boolean autoRowHeight) {
        this.autoRowHeight = autoRowHeight;
        this.registerTextDocumentListener();
    }

    public boolean isAutoRowHeight() {
        return this.autoRowHeight;
    }

    public void startOver() {
        this.startOver = true;
    }

    public void clearStartOver() {
        this.startOver = false;
    }

    public void inhibitCellTraversal() {
        if (this.table != null) {
            this.table.inhibitCellTraversal();
        }
    }

    public void clearInhibitCellTraversal() {
        if (this.table != null) {
            this.table.clearInhibitCellTraversal();
        }
    }

    public boolean wasEditingCanceled() {
        return this.editingCanceled || this.table != null && !this.table.isEditing();
    }

    public boolean requestFocusInWindow() {
        if (this.editor instanceof Component) {
            return ((Component)((Object)this.editor)).requestFocusInWindow();
        }
        return false;
    }

    public void requestFocusLater() {
        this.editor.requestFocusLater();
    }

    public void setClickCountToStart(int clicks) {
        this.clickCountToStart = clicks;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public FormTable<?> getFormTable() {
        return this.table;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= this.clickCountToStart;
        }
        return super.isCellEditable(anEvent);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        if (this.editor instanceof FormComboBox && anEvent instanceof MouseEvent) {
            MouseEvent e = (MouseEvent)anEvent;
            return e.getID() != 506;
        }
        return super.shouldSelectCell(anEvent);
    }

    @Override
    public boolean stopCellEditing() {
        if (this.startOver) {
            this.startOver = false;
            if (this.editor instanceof JComponent) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((JComponent)((Object)FormComponentCellEditor.this.editor)).requestFocusInWindow();
                    }
                });
            }
            return false;
        }
        return super.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.editingCanceled = true;
        this.startOver = false;
        super.cancelCellEditing();
    }

    public void prepare(FormTableEntry<?> entry, int column) {
    }

    @Override
    public Object getCellEditorValue() {
        return this.editor.getFormValue();
    }

    public FormComponent getTableCellEditorComponent(FormTable<?> table, boolean selected, int row, int column) {
        this.prepareTableCellEditorComponent(table, selected, row, column);
        return this.editor;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.editor.setFormValue(value);
        this.editor.saveValue();
        return (Component)((Object)this.getTableCellEditorComponent((FormTable)table, isSelected, row, column));
    }

    public FormComponent getTreeCellEditorComponent(FormTree tree, boolean selected, boolean expanded, boolean leaf, int row) {
        this.prepareTreeCellEditorComponent(tree, selected, expanded, leaf, row);
        return this.editor;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        this.editor.setFormValue(value);
        this.editor.saveValue();
        return (Component)((Object)this.getTreeCellEditorComponent((FormTree)tree, isSelected, expanded, leaf, row));
    }

    protected void prepareTableCellEditorComponent(FormTable<?> table, boolean selected, int row, int column) {
        this.table = table;
        this.row = row;
        this.column = column;
        this.selected = selected;
        this.startOver = false;
        this.editingCanceled = false;
        if (this.autoRowHeight && !(this.editor instanceof JTextComponent)) {
            this.updateHeight();
        }
        if (this.editor instanceof JComponent) {
            ((JComponent)((Object)this.editor)).setBorder(BorderFactory.createLineBorder(PlafUtilities.getInstance().getTableEditCellBorderColor()));
        }
        this.editor.setMandatory(table.isCellMandatory(row, column));
    }

    protected void prepareTreeCellEditorComponent(FormTree tree, boolean selected, boolean expanded, boolean leaf, int row) {
        this.tree = tree;
        this.row = row;
        this.selected = selected;
        this.expanded = expanded;
        this.leaf = leaf;
        this.startOver = false;
        this.editingCanceled = false;
    }

    private void updateHeight() {
        if (this.table != null && (this.editor instanceof JTextComponent && ((JTextComponent)((Object)this.editor)).hasFocus() || !(this.editor instanceof JTextComponent))) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int preferredHeight = ((JComponent)((Object)FormComponentCellEditor.this.editor)).getPreferredSize().height;
                    int rowHeight = FormComponentCellEditor.this.table.getRowHeight(FormComponentCellEditor.this.row);
                    if (preferredHeight != rowHeight) {
                        FormComponentCellEditor.this.table.setRowHeight(FormComponentCellEditor.this.row, preferredHeight);
                    }
                }
            });
        }
    }

    private void registerTextDocumentListener() {
        if (this.autoRowHeight && this.editor instanceof JTextComponent) {
            ((JTextComponent)((Object)this.editor)).getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    FormComponentCellEditor.this.updateHeight();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    FormComponentCellEditor.this.updateHeight();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    FormComponentCellEditor.this.updateHeight();
                }
            });
        }
    }
}

