/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.event.KeyEvent;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.tentackle.io.BlockingByteArrayInputStream;
import org.tentackle.io.NotifyingByteArrayOutputStream;
import org.tentackle.swing.FormTextArea;

public class FormConsole
extends FormTextArea {
    private int maxRows;
    private final BlockingByteArrayInputStream in;
    private final OutputStream out = new AppendingOutputStream();

    public FormConsole(Document doc, String text, int rows, int columns) {
        super(doc, text, rows, columns);
        this.in = new BlockingByteArrayInputStream(new NotifyingByteArrayOutputStream());
    }

    public FormConsole(String text, int rows, int columns) {
        this(null, text, rows, columns);
    }

    public FormConsole(String text) {
        this(null, text, 0, 0);
    }

    public FormConsole(int rows, int columns) {
        this(null, null, rows, columns);
    }

    public FormConsole() {
        this(null, null, 0, 0);
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public void append(String str) {
        super.append(str);
        this.alignToMaxRows();
        this.setCaretPosition(this.getDocument().getLength());
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        char code;
        if (e.getID() == 400 && (code = e.getKeyChar()) != '\uffff') {
            this.in.getOutputStream().write((int)code);
        }
        e.consume();
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public void alignToMaxRows() {
        Element root;
        int lines;
        int tooMuch;
        if (this.maxRows > 0 && (tooMuch = (lines = (root = this.getDocument().getDefaultRootElement()).getElementCount()) - this.maxRows) > 0) {
            try {
                this.getDocument().remove(0, root.getElement(tooMuch - 1).getEndOffset());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private class AppendingOutputStream
    extends ByteArrayOutputStream {
        private AppendingOutputStream() {
        }

        @Override
        public synchronized void write(int b) {
            super.write(b);
            FormConsole.this.append(this.toString());
            this.reset();
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) {
            super.write(b, off, len);
            FormConsole.this.append(this.toString());
            this.reset();
        }
    }
}

