/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Window;
import java.io.Serializable;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;

public class FormLayoutComparator
implements Comparator<Component>,
Serializable {
    private int tolerance;
    private boolean horizontal;
    private boolean leftToRight;

    public FormLayoutComparator(int tolerance, boolean horizontal, boolean leftToRight) {
        this.tolerance = tolerance;
        this.horizontal = horizontal;
        this.leftToRight = leftToRight;
    }

    public FormLayoutComparator() {
        this(10, true, true);
    }

    public void setComponentOrientation(ComponentOrientation orientation) {
        this.horizontal = orientation.isHorizontal();
        this.leftToRight = orientation.isLeftToRight();
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setHorizontal(boolean horizontal) {
        this.horizontal = horizontal;
    }

    public boolean isLeftToRight() {
        return this.leftToRight;
    }

    public void setLeftToRight(boolean leftToRight) {
        this.leftToRight = leftToRight;
    }

    public int getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(int tolerance) {
        this.tolerance = tolerance;
    }

    @Override
    public int compare(Component o1, Component o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.getParent() != o2.getParent()) {
            LinkedList<Component> aAncestory = new LinkedList<Component>();
            while (o1 != null) {
                aAncestory.add(o1);
                if (o1 instanceof Window) break;
                o1 = o1.getParent();
            }
            if (o1 == null) {
                throw new ClassCastException();
            }
            LinkedList<Component> bAncestory = new LinkedList<Component>();
            while (o2 != null) {
                bAncestory.add(o2);
                if (o2 instanceof Window) break;
                o2 = o2.getParent();
            }
            if (o2 == null) {
                throw new ClassCastException();
            }
            ListIterator aIter = aAncestory.listIterator(aAncestory.size());
            ListIterator bIter = bAncestory.listIterator(bAncestory.size());
            do {
                if (!aIter.hasPrevious()) {
                    return -1;
                }
                o1 = (Component)aIter.previous();
                if (!bIter.hasPrevious()) {
                    return 1;
                }
                o2 = (Component)bIter.previous();
            } while (o1 == o2);
        }
        int ax = o1.getX();
        int ay = o1.getY();
        int bx = o2.getX();
        int by = o2.getY();
        int zOrder = o1.getParent().getComponentZOrder(o1) - o2.getParent().getComponentZOrder(o2);
        if (this.horizontal) {
            if (this.leftToRight) {
                if (Math.abs(ay - by) < this.tolerance) {
                    return ax < bx ? -1 : (ax > bx ? 1 : zOrder);
                }
                return ay < by ? -1 : 1;
            }
            if (Math.abs(ay - by) < this.tolerance) {
                return ax > bx ? -1 : (ax < bx ? 1 : zOrder);
            }
            return ay < by ? -1 : 1;
        }
        if (this.leftToRight) {
            if (Math.abs(ax - bx) < this.tolerance) {
                return ay < by ? -1 : (ay > by ? 1 : zOrder);
            }
            return ax < bx ? -1 : 1;
        }
        if (Math.abs(ax - bx) < this.tolerance) {
            return ay < by ? -1 : (ay > by ? 1 : zOrder);
        }
        return ax > bx ? -1 : 1;
    }
}

