/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.JPanel;
import org.tentackle.locale.I18nTranslatable;
import org.tentackle.locale.I18nTranslation;
import org.tentackle.swing.FormComponent;
import org.tentackle.swing.FormContainer;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.FormWindow;
import org.tentackle.swing.GUIRuntimeException;
import org.tentackle.swing.PropertyGroup;
import org.tentackle.swing.bind.FormComponentBinder;

public class FormPanel
extends JPanel
implements FormContainer,
I18nTranslatable,
ContainerListener {
    private String helpURL;
    private String title;
    private I18nTranslation i18nTranslation;
    private boolean honourChangeable = true;
    private boolean triggerValuesChangedEnabled = true;
    private boolean changeable = true;
    private Window parentWindow;
    private boolean parentWindowLoaded;
    private boolean bindable = true;
    private boolean autoUpdate = true;
    private FormComponentBinder binder;
    private PropertyGroup propertyGroup;

    public FormPanel(LayoutManager layout, boolean doubleBuffered) {
        super(layout, doubleBuffered);
        FormUtilities.getInstance().setDefaultFocusTraversalPolicy(this);
        this.addContainerListener(this);
    }

    public FormPanel(boolean doubleBuffered) {
        this(new FlowLayout(), doubleBuffered);
    }

    public FormPanel(LayoutManager layout) {
        this(layout, true);
    }

    public FormPanel() {
        this(true);
    }

    public void setTitle(I18nTranslation i18nTranslation) {
        this.setI18nTranslation(i18nTranslation);
    }

    public void setI18nTranslation(I18nTranslation i18nTranslation) {
        this.i18nTranslation = i18nTranslation;
        this.setTitle(i18nTranslation == null ? null : i18nTranslation.getText());
    }

    public I18nTranslation getI18nTranslation() {
        return this.i18nTranslation;
    }

    public void setPropertyGroup(PropertyGroup group) {
        if (this.propertyGroup != group) {
            if (this.propertyGroup != null) {
                if (this.propertyGroup.removeComponent(this)) {
                    this.propertyGroup = null;
                } else {
                    throw new GUIRuntimeException("panel " + this + " not in property group " + this.propertyGroup);
                }
            }
            if (group != null) {
                if (group.addComponent(this)) {
                    this.propertyGroup = group;
                } else {
                    throw new GUIRuntimeException("panel " + this + " already in property group " + group);
                }
            }
        }
    }

    public PropertyGroup getPropertyGroup() {
        return this.propertyGroup;
    }

    public synchronized void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    public void fireActionPerformed(ActionEvent e) {
        if (this.listenerList != null) {
            for (ActionListener l : (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
                l.actionPerformed(e);
            }
        }
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        if (this.getParent() != null) {
            this.componentRemoved(e);
        }
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        Component comp = e.getChild();
        if (comp instanceof FormComponent) {
            ((FormComponent)((Object)comp)).invalidateParentInfo();
        } else {
            FormUtilities.getInstance().invalidateParentInfo(comp);
        }
    }

    @Override
    public Window getParentWindow() {
        if (!this.parentWindowLoaded) {
            this.parentWindow = FormUtilities.getInstance().getParentWindow(this);
            this.parentWindowLoaded = true;
        }
        return this.parentWindow;
    }

    @Override
    public void invalidateParentInfo() {
        this.parentWindowLoaded = false;
        FormUtilities.getInstance().invalidateParentInfo(this);
    }

    @Override
    public void setAutoUpdate(boolean autoupdate) {
        this.autoUpdate = autoupdate;
        FormUtilities.getInstance().setAutoUpdate(this, this.autoUpdate);
    }

    @Override
    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    @Override
    public void setFormValues() {
        if (this.binder != null) {
            this.binder.requestMandatoryUpdate();
            this.binder.requestChangeableUpdate();
        }
        Window p = this.getParentWindow();
        boolean keepChanged = false;
        if (p instanceof FormWindow) {
            keepChanged = ((FormWindow)((Object)p)).getKeepChangedValues();
        }
        if (keepChanged) {
            FormUtilities.getInstance().setFormValueKeepChanged(this);
        } else {
            FormUtilities.getInstance().setFormValue(this);
        }
    }

    @Override
    public void setFormValuesKeepChanged() {
        if (this.binder != null) {
            this.binder.requestMandatoryUpdate();
            this.binder.requestChangeableUpdate();
        }
        FormUtilities.getInstance().setFormValueKeepChanged(this);
    }

    @Override
    public void getFormValues() {
        FormUtilities.getInstance().getFormValue(this);
    }

    @Override
    public void saveValues() {
        FormUtilities.getInstance().saveValue(this);
    }

    @Override
    public void setTriggerValuesChangedEnabled(boolean enabled) {
        this.triggerValuesChangedEnabled = enabled;
    }

    @Override
    public boolean isTriggerValuesChangedEnabled() {
        return this.triggerValuesChangedEnabled;
    }

    @Override
    public boolean areValuesChanged() {
        return FormUtilities.getInstance().isValueChanged(this, true);
    }

    @Override
    public void triggerValuesChanged() {
    }

    @Override
    public void setChangeable(boolean flag) {
        if (this.isHonourChangeable()) {
            FormUtilities.getInstance().setChangeable(this, flag);
            this.changeable = flag;
        }
    }

    @Override
    public boolean isChangeable() {
        return this.changeable;
    }

    @Override
    public void setHonourChangeable(boolean flag) {
        this.honourChangeable = flag;
    }

    @Override
    public boolean isHonourChangeable() {
        return this.honourChangeable;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setHelpURL(String helpURL) {
        this.helpURL = helpURL;
    }

    @Override
    public String getHelpURL() {
        return this.helpURL;
    }

    @Override
    public void showHelp() {
        FormUtilities.getInstance().openHelpURL(this);
    }

    protected FormComponentBinder createBinder() {
        return FormUtilities.getInstance().getBindingFactory().createFormComponentBinder(this);
    }

    @Override
    public FormComponentBinder getBinder() {
        if (this.binder == null) {
            this.binder = this.createBinder();
        }
        return this.binder;
    }

    @Override
    public void setBindable(boolean bindable) {
        this.bindable = bindable;
    }

    @Override
    public boolean isBindable() {
        return this.bindable;
    }
}

