/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellRenderer;
import org.tentackle.common.BMoney;
import org.tentackle.misc.FormatHelper;
import org.tentackle.swing.FormTable;

public class FormTableCellRenderer
implements TableCellRenderer,
Serializable {
    private static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private static final Border DEFAULT_FOCUS_BORDER = new LineBorder(Color.GRAY, 1);
    private JComponent component;
    private Border focusBorder;
    private Border noFocusBorder;
    private Font renderingFont;
    private Color selectedForeground;
    private Color selectedBackground;
    private Color unselectedForeground;
    private Color unselectedBackground;
    private Color focusedForeground;
    private Color focusedBackground;
    private Color selectedMandatoryBackground;
    private Color unselectedMandatoryBackground;

    public FormTableCellRenderer(JComponent component) {
        if (component == null) {
            throw new NullPointerException("component must not be null");
        }
        this.component = component;
        this.focusBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
        if (this.focusBorder == null) {
            this.focusBorder = DEFAULT_FOCUS_BORDER;
        }
        this.noFocusBorder = UIManager.getBorder("Table.cellNoFocusBorder");
        if (this.noFocusBorder == null) {
            this.noFocusBorder = DEFAULT_NO_FOCUS_BORDER;
        }
        component.setOpaque(true);
        component.setName("Table.cellRenderer");
    }

    public FormTableCellRenderer() {
        this(new JLabel(){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setForeground(null);
                this.setBackground(null);
            }
        });
    }

    public JComponent getComponent() {
        return this.component;
    }

    public Color getSelectedMandatoryBackground() {
        return this.selectedMandatoryBackground;
    }

    public void setSelectedMandatoryBackground(Color selectedMandatoryBackground) {
        this.selectedMandatoryBackground = selectedMandatoryBackground;
    }

    public Color getUnselectedMandatoryBackground() {
        return this.unselectedMandatoryBackground;
    }

    public void setUnselectedMandatoryBackground(Color unselectedMandatoryBackground) {
        this.unselectedMandatoryBackground = unselectedMandatoryBackground;
    }

    public void setSelectedForeground(Color c) {
        this.selectedForeground = c;
    }

    public Color getSelectedForeground() {
        return this.selectedForeground;
    }

    public void setSelectedBackground(Color c) {
        this.selectedBackground = c;
    }

    public Color getSelectedBackground() {
        return this.selectedBackground;
    }

    public void setUnselectedForeground(Color c) {
        this.unselectedForeground = c;
    }

    public Color getUnselectedForeground() {
        return this.unselectedForeground;
    }

    public void setUnselectedBackground(Color c) {
        this.unselectedBackground = c;
    }

    public Color getUnselectedBackground() {
        return this.unselectedBackground;
    }

    public void setFocusedForeground(Color c) {
        this.focusedForeground = c;
    }

    public Color getFocusedForeground() {
        return this.focusedForeground;
    }

    public void setFocusedBackground(Color c) {
        this.focusedBackground = c;
    }

    public Color getFocusedBackground() {
        return this.focusedBackground;
    }

    public void setRenderingFont(Font font) {
        this.renderingFont = font;
    }

    public Font getRenderingFont() {
        return this.renderingFont;
    }

    public Border getFocusBorder() {
        return this.focusBorder;
    }

    public void setFocusBorder(Border focusBorder) {
        this.focusBorder = focusBorder;
    }

    public Border getNoFocusBorder() {
        return this.noFocusBorder;
    }

    public void setNoFocusBorder(Border noFocusBorder) {
        this.noFocusBorder = noFocusBorder;
    }

    protected void setValue(Object value) {
        ((JLabel)this.component).setText(value == null ? "" : value.toString());
    }

    protected String getText() {
        return ((JLabel)this.component).getText();
    }

    protected void setHorizontalAlignment(int alignment) {
        ((JLabel)this.component).setHorizontalAlignment(alignment);
    }

    protected void setVerticalAlignment(int alignment) {
        ((JLabel)this.component).setVerticalAlignment(alignment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        FormTable formTable = null;
        if (table instanceof FormTable) {
            formTable = (FormTable)table;
        }
        int modelColumn = table.convertColumnIndexToModel(column);
        boolean mandatory = ((FormTable)table).isCellMandatory(row, column);
        boolean editable = hasFocus && table.isCellEditable(row, column);
        this.component.setBackground(this.getBackgroundColor(formTable, isSelected, hasFocus, editable, mandatory));
        this.component.setForeground(this.getForegroundColor(formTable, isSelected, hasFocus, editable, mandatory));
        this.component.setFont(this.renderingFont == null ? table.getFont() : this.renderingFont);
        if (hasFocus) {
            this.component.setBorder(this.getFocusBorder());
        } else {
            this.component.setBorder(this.getNoFocusBorder());
        }
        this.setValue(value);
        int hAlign = 2;
        int vAlign = 0;
        try {
            if (formTable != null) {
                if (value instanceof Number) {
                    hAlign = 11;
                    if (formTable.isBlankZero(modelColumn)) {
                        boolean blankZero = false;
                        if (value instanceof Double) {
                            if ((Double)value == 0.0) {
                                blankZero = true;
                            }
                        } else if (value instanceof Float) {
                            if (((Float)value).floatValue() == 0.0f) {
                                blankZero = true;
                            }
                        } else if (value instanceof BMoney) {
                            if (((BMoney)value).isZero()) {
                                blankZero = true;
                            }
                        } else if (value instanceof Number && ((Number)value).longValue() == 0L) {
                            blankZero = true;
                        }
                        if (blankZero) {
                            this.setValue(null);
                            JComponent jComponent = this.component;
                            return jComponent;
                        }
                    }
                    if (value instanceof BMoney) {
                        String fmt = formTable.getFormat(modelColumn);
                        if (fmt == null) {
                            formTable.setFormat(modelColumn, FormatHelper.getMoneyPattern());
                        }
                        DecimalFormat format = (DecimalFormat)formTable.getNumberFormat(modelColumn);
                        FormatHelper.setScale((DecimalFormat)format, (int)((BMoney)value).scale());
                        this.setValue(format.format(value));
                        if (fmt == null) {
                            formTable.setFormat(modelColumn, format.toPattern());
                        }
                    } else {
                        String fmt;
                        if ((value instanceof Float || value instanceof Double) && (fmt = formTable.getFormat(modelColumn)) == null) {
                            formTable.setFormat(modelColumn, FormatHelper.getFloatingNumberPattern());
                        }
                        this.setValue(value == null ? "" : formTable.getNumberFormat(modelColumn).format((Number)value));
                    }
                } else if (value instanceof Timestamp) {
                    hAlign = 0;
                    this.setValue(value == null ? "" : formTable.getDateFormat(modelColumn, true).format((Date)value));
                } else if (value instanceof Date) {
                    hAlign = 0;
                    this.setValue(value == null ? "" : formTable.getDateFormat(modelColumn).format((Date)value));
                }
            }
        }
        finally {
            if (formTable != null) {
                switch (formTable.getConvert(modelColumn)) {
                    case 'v': {
                        this.setValue(this.getText().toLowerCase());
                        break;
                    }
                    case '^': {
                        this.setValue(this.getText().toUpperCase());
                    }
                }
                int alignment = formTable.getHorizontalAlignment(modelColumn);
                if (alignment != -1) {
                    hAlign = alignment;
                }
                if ((alignment = formTable.getVerticalAlignment(modelColumn)) != -1) {
                    vAlign = alignment;
                }
            }
            this.setHorizontalAlignment(hAlign);
            this.setVerticalAlignment(vAlign);
        }
        return this.component;
    }

    protected Color getForegroundColor(JTable table, boolean selected, boolean hasFocus, boolean editable, boolean mandatory) {
        Color color;
        if (table instanceof FormTable) {
            if (selected) {
                color = this.selectedForeground == null ? ((FormTable)table).getSelectedForeground() : this.selectedForeground;
            } else {
                Color color2 = color = this.unselectedForeground == null ? ((FormTable)table).getUnselectedForeground() : this.unselectedForeground;
            }
            if (hasFocus && editable) {
                color = this.focusedForeground == null ? ((FormTable)table).getFocusedForeground() : this.focusedForeground;
            }
        } else {
            if (selected) {
                color = this.selectedForeground != null ? this.selectedForeground : table.getSelectionForeground();
            } else {
                Color color3 = color = this.unselectedForeground != null ? this.unselectedForeground : table.getForeground();
            }
            if (hasFocus && editable) {
                color = this.focusedForeground == null ? UIManager.getColor("Table.focusCellForeground") : this.focusedForeground;
            }
        }
        return color;
    }

    protected Color getBackgroundColor(JTable table, boolean selected, boolean hasFocus, boolean editable, boolean mandatory) {
        Color color;
        if (table instanceof FormTable) {
            if (selected) {
                color = this.selectedBackground == null ? ((FormTable)table).getSelectedBackground() : this.selectedBackground;
            } else {
                Color color2 = color = this.unselectedBackground == null ? ((FormTable)table).getUnselectedBackground() : this.unselectedBackground;
            }
            if (hasFocus && editable) {
                Color color3 = color = this.focusedBackground == null ? ((FormTable)table).getFocusedBackground() : this.focusedBackground;
            }
            if (mandatory) {
                color = selected ? (this.selectedMandatoryBackground == null ? ((FormTable)table).getSelectedMandatoryBackground() : this.selectedMandatoryBackground) : (this.unselectedMandatoryBackground == null ? ((FormTable)table).getUnselectedMandatoryBackground() : this.unselectedMandatoryBackground);
            }
        } else {
            if (selected) {
                color = this.selectedBackground != null ? this.selectedBackground : table.getSelectionBackground();
            } else {
                Color color4 = color = this.unselectedBackground != null ? this.unselectedBackground : table.getBackground();
            }
            if (hasFocus && editable) {
                color = this.focusedBackground == null ? UIManager.getColor("Table.focusCellBackground") : this.focusedBackground;
            }
        }
        return color;
    }
}

