/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.TableModelEvent;
import org.tentackle.swing.AbstractFormTableModel;
import org.tentackle.swing.FormTable;
import org.tentackle.swing.FormTableEntry;
import org.tentackle.swing.FormTableMap;
import org.tentackle.swing.FormUtilities;

public class FormTableSorter<T>
extends FormTableMap<T>
implements MouseListener {
    private boolean mouseListenerActive;
    private int[] map;
    private int[] sortby;
    private boolean sortdone;
    private boolean sorting;
    private FormTableEntry<T> sumEntry;

    public FormTableSorter(AbstractFormTableModel<T> model) {
        super(model);
        this.clearSorting();
        this.clearMapping();
    }

    @Override
    public void setTable(FormTable<T> table) {
        this.removeMouseListenerForHeaderOfTable();
        super.setTable(table);
        this.addMouseListenerForHeaderOfTable();
    }

    public void setSumEntry(FormTableEntry<T> sumEntry) {
        int rows = this.getRowCount();
        if (sumEntry != null) {
            if (this.sumEntry == null) {
                this.sumEntry = sumEntry;
                this.fireTableRowsInserted(rows, rows);
            } else {
                this.sumEntry = sumEntry;
                this.fireTableRowsUpdated(--rows, rows);
            }
        } else if (this.sumEntry != null) {
            this.sumEntry = null;
            this.fireTableRowsDeleted(--rows, rows);
        }
    }

    public FormTableEntry<T> getSumEntry() {
        return this.sumEntry;
    }

    @Override
    public int getRowCount() {
        if (this.sumEntry != null) {
            return super.getRowCount() + 1;
        }
        return super.getRowCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= 0 && rowIndex < this.map.length) {
            return this.model.getValueAt(this.map[rowIndex], columnIndex);
        }
        if (this.sumEntry != null && rowIndex == this.map.length) {
            return this.sumEntry.getValueAt(columnIndex);
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex >= 0 && rowIndex < this.map.length) {
            this.model.setValueAt(aValue, this.map[rowIndex], columnIndex);
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (rowIndex >= 0 && rowIndex < this.map.length) {
            return this.model.isCellEditable(this.map[rowIndex], columnIndex);
        }
        return false;
    }

    @Override
    public FormTableEntry<T> getEntryAt(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.map.length) {
            return this.model.getEntryAt(this.map[rowIndex]);
        }
        return null;
    }

    @Override
    public int getMappedIndex(int mappedRow) {
        for (int i = 0; i < this.map.length; ++i) {
            if (this.map[i] != mappedRow) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int[] getMappedIndex(int[] mappedRows) {
        if (mappedRows != null) {
            int[] rows = new int[mappedRows.length];
            for (int i = 0; i < mappedRows.length; ++i) {
                rows[i] = this.getMappedIndex(mappedRows[i]);
            }
            return rows;
        }
        return null;
    }

    @Override
    public int getModelIndex(int row) {
        if (row >= 0 && row < this.map.length) {
            return this.map[row];
        }
        return -1;
    }

    @Override
    public int[] getModelIndex(int[] rows) {
        if (rows != null) {
            int[] modelRows = new int[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                modelRows[i] = this.getModelIndex(rows[i]);
            }
            return modelRows;
        }
        return null;
    }

    public void addSortIndex(int column) {
        int[] newsortby = new int[this.sortby.length + 1];
        for (int i = 0; i < this.sortby.length; ++i) {
            if (this.sortby[i] == column || this.sortby[i] == -column - 1) {
                return;
            }
            newsortby[i] = this.sortby[i];
        }
        newsortby[i] = column;
        this.sortby = newsortby;
        this.fireSortingChanged();
    }

    public void sort() {
        int[] selectedRows = null;
        FormTable table = this.getTable();
        if (table != null) {
            selectedRows = this.getModelIndex(table.getSelectedRows());
        }
        this.sorting = true;
        this.fireSortingChanged();
        this.clearMapping();
        if (this.sortby.length > 0) {
            this.qsort(0, this.map.length - 1);
        }
        this.fireTableDataChanged();
        this.sorting = false;
        this.fireSortingChanged();
        if (table != null) {
            table.setSelectedRows(this.getMappedIndex(selectedRows));
        }
    }

    public void clearMapping() {
        this.map = new int[this.model.getRowCount()];
        for (int i = 0; i < this.map.length; ++i) {
            this.map[i] = i;
        }
        this.sortdone = true;
    }

    public void clearSorting() {
        this.sortby = new int[0];
        this.sortdone = false;
        this.fireSortingChanged();
    }

    public int[] getSorting() {
        return this.sortby;
    }

    public void setSorting(int[] sortby) {
        if (sortby == null) {
            this.clearSorting();
        } else {
            this.sortby = sortby;
            this.sortdone = false;
            this.fireSortingChanged();
        }
    }

    public boolean isSorted() {
        return this.sortby.length > 0;
    }

    public String getSortNames() {
        if (this.sortby.length == 0 || this.getRowCount() == 0) {
            return null;
        }
        String str = this.sorting ? "* " : (this.sortdone ? "" : "? ");
        FormTableEntry entry = this.getTemplate();
        for (int i = 0; i < this.sortby.length; ++i) {
            int ndx;
            if (i > 0) {
                str = str + ", ";
            }
            str = (ndx = this.sortby[i]) >= 0 ? str + entry.getDisplayedColumnName(ndx) : str + "-" + entry.getDisplayedColumnName(-ndx - 1);
        }
        return str;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        boolean needsort = false;
        if (this.map == null || this.map.length != this.model.getRowCount()) {
            needsort = true;
        } else {
            int col = e.getColumn();
            if (col == -1) {
                needsort = true;
            } else {
                for (int i = 0; i < this.sortby.length; ++i) {
                    if (this.sortby[i] != col) continue;
                    needsort = true;
                    break;
                }
            }
        }
        if (needsort) {
            this.sort();
        } else {
            super.tableChanged(e);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listenerList.add(PropertyChangeListener.class, listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listenerList.remove(PropertyChangeListener.class, listener);
    }

    public void addMouseListenerForHeaderOfTable() {
        FormTable table = this.getTable();
        if (table != null && !this.mouseListenerActive) {
            table.getTableHeader().addMouseListener(this);
            this.mouseListenerActive = true;
        }
    }

    public void removeMouseListenerForHeaderOfTable() {
        FormTable table = this.getTable();
        if (table != null && this.mouseListenerActive) {
            table.getTableHeader().removeMouseListener(this);
            this.mouseListenerActive = false;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int vCol;
        int col;
        FormTable table = this.getTable();
        if (table != null && e.getButton() == 1 && (col = table.convertColumnIndexToModel(vCol = table.getColumnModel().getColumnIndexAtX(e.getX()))) >= 0) {
            if (this.sortdone) {
                this.clearSorting();
            }
            if ((e.getModifiers() & 1) != 0) {
                col = -col - 1;
            }
            this.addSortIndex(col);
            if (e.getClickCount() == 2) {
                FormUtilities.getInstance().setWaitCursor(table);
                this.sort();
                FormUtilities.getInstance().setDefaultCursor(table);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private void qsort(int lower, int upper) {
        if (lower < upper) {
            int left = lower;
            int right = upper;
            int middle = lower + upper >> 1;
            while (left < right) {
                if (this.getEntryAt(middle).compareTo(this.getEntryAt(left), this.sortby) < 0) {
                    this.swap(left, middle);
                    middle = left;
                }
                if (this.getEntryAt(middle).compareTo(this.getEntryAt(right), this.sortby) > 0) {
                    this.swap(right, middle);
                    middle = right;
                }
                if (left < middle) {
                    ++left;
                }
                if (right <= middle) continue;
                --right;
            }
            this.qsort(lower, middle - 1);
            this.qsort(middle + 1, upper);
        }
    }

    private void swap(int idx1, int idx2) {
        int saved = this.map[idx1];
        this.map[idx1] = this.map[idx2];
        this.map[idx2] = saved;
    }

    private void fireSortingChanged() {
        PropertyChangeListener[] pl = (PropertyChangeListener[])this.listenerList.getListeners(PropertyChangeListener.class);
        PropertyChangeEvent pe = new PropertyChangeEvent(this, "sorting", null, null);
        for (int i = 0; i < pl.length; ++i) {
            pl[i].propertyChange(pe);
        }
    }
}

