/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.PropertyResourceBundle;
import javax.swing.JLabel;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.misc.Telno;
import org.tentackle.swing.FormButton;
import org.tentackle.swing.FormDialog;
import org.tentackle.swing.FormInfo;
import org.tentackle.swing.FormPanel;
import org.tentackle.swing.FormTelnoField;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.StringFormField;
import org.tentackle.swing.ValueEvent;
import org.tentackle.swing.ValueListener;
import org.tentackle.swing.plaf.PlafUtilities;

public class FormTelnoDialog
extends FormDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormTelnoDialog.class);
    private final FormTelnoField telnoField = new FormTelnoField();
    private int telnoNum;
    private String newText;
    private JLabel[] labels;
    private StringFormField[] telnos;
    private StringFormField[] comments;
    private FormButton[] dialButtons;
    private Process process;
    private static final String TELNO_PROPERTIES = "Telno.properties";
    private static String phoneCommand;
    private static String faxCommand;
    private static String cellCommand;
    private static String modemCommand;
    private StringFormField newTelnoStringField = new StringFormField();
    private StringFormField newCommentStringField = new StringFormField();
    private FormButton newButton = new FormButton();
    private FormPanel buttonPanel;
    private FormButton cancelButton;
    private FormPanel numberPanel;
    private FormButton okButton;

    public static FormTelnoDialog createFormTelnoDialog(FormTelnoField telnoField) {
        return new FormTelnoDialog(FormUtilities.getInstance().getParentWindow(telnoField), telnoField);
    }

    public FormTelnoDialog(Window owner, FormTelnoField telnoField) {
        super(owner);
        if (telnoField != null) {
            this.telnoField.setText(telnoField.getText());
            this.telnoField.setTelnoType(telnoField.getTelnoType());
            this.telnoField.setChangeable(telnoField.isChangeable());
            this.telnoField.setDefaultCountry(telnoField.getDefaultCountry());
        }
        this.initComponents();
        this.setTitle(this.telnoField.getText());
        this.initTelnos();
        this.newTelnoStringField.setColumns(15);
        this.newTelnoStringField.setName("newTelno");
        this.newTelnoStringField.addValueListener(new ValueListener(){

            @Override
            public void valueEntered(ValueEvent e) {
                Telno no = new Telno();
                no.setDefaultCountry(FormTelnoDialog.this.telnoField.getDefaultCountry());
                if (!no.setTelno(FormTelnoDialog.this.newTelnoStringField.getText())) {
                    FormInfo.show(no.getError());
                    FormTelnoDialog.this.newTelnoStringField.requestFocusLater();
                } else {
                    FormTelnoDialog.this.newTelnoStringField.setText(no.getTelno());
                }
            }

            @Override
            public void valueChanged(ValueEvent e) {
            }
        });
        this.newCommentStringField.setColumns(20);
        this.newButton.setIcon(PlafUtilities.getInstance().getIcon("add"));
        this.newButton.setName("add");
        this.newButton.setMargin(new Insets(0, 5, 0, 5));
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newTelno = FormTelnoDialog.this.newTelnoStringField.getText();
                String newComment = FormTelnoDialog.this.newCommentStringField.getText();
                if (newTelno != null && newTelno.trim().length() > 0) {
                    String tel = FormTelnoDialog.this.buildTelno();
                    if (tel.length() > 0) {
                        tel = tel + ", ";
                    }
                    tel = tel + newTelno;
                    if (newComment != null && newComment.trim().length() > 0) {
                        tel = tel + " " + newComment;
                    }
                    FormTelnoDialog.this.newTelnoStringField.clearText();
                    FormTelnoDialog.this.newCommentStringField.clearText();
                    FormTelnoDialog.this.telnoField.setText(tel);
                    FormTelnoDialog.this.telnoField.getText();
                    FormTelnoDialog.this.initTelnos();
                    FormTelnoDialog.this.pack();
                }
            }
        });
    }

    public FormTelnoDialog(FormTelnoField telnoField) {
        this(null, telnoField);
    }

    public FormTelnoDialog() {
        this((FormTelnoField)null);
    }

    public String showDialog() {
        this.pack();
        this.setVisible(true);
        return this.newText;
    }

    private String buildTelno() {
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < this.telnoNum; ++i) {
            String telno = this.telnos[i].getText();
            if (telno == null || telno.length() <= 0) continue;
            if (i > 0) {
                text.append(", ");
            }
            text.append(this.telnos[i].getText());
            String comment = this.comments[i].getText();
            if (comment == null || comment.length() <= 0) continue;
            text.append(' ');
            text.append(comment);
        }
        return text.toString();
    }

    private void initTelnos() {
        int telnoNdx;
        this.telnoNum = this.telnoField.getTelnoNum();
        this.labels = new JLabel[this.telnoNum];
        this.telnos = new StringFormField[this.telnoNum];
        this.comments = new StringFormField[this.telnoNum];
        this.dialButtons = new FormButton[this.telnoNum];
        this.numberPanel.removeAll();
        for (telnoNdx = 0; telnoNdx < this.telnoNum; ++telnoNdx) {
            this.labels[telnoNdx] = new JLabel("" + (telnoNdx + 1));
            final StringFormField tField = new StringFormField(this.telnoField.getTelno(telnoNdx).toString(), 15);
            tField.setName("telno" + telnoNdx);
            tField.addValueListener(new ValueListener(){

                @Override
                public void valueEntered(ValueEvent e) {
                    Telno no = new Telno();
                    no.setDefaultCountry(FormTelnoDialog.this.telnoField.getDefaultCountry());
                    if (!no.setTelno(tField.getText())) {
                        FormInfo.show(no.getError());
                        tField.requestFocusLater();
                    } else {
                        tField.setText(no.getTelno());
                    }
                }

                @Override
                public void valueChanged(ValueEvent e) {
                }
            });
            this.telnos[telnoNdx] = tField;
            this.comments[telnoNdx] = new StringFormField(this.telnoField.getComment(telnoNdx), 20);
            this.comments[telnoNdx].setName("comment" + telnoNdx);
            if (!this.telnoField.isChangeable()) {
                this.telnos[telnoNdx].setChangeable(false);
                this.comments[telnoNdx].setChangeable(false);
            }
            switch (this.telnoField.getTelnoType()) {
                case 'M': {
                    this.dialButtons[telnoNdx] = new FormButton(PlafUtilities.getInstance().getIcon("modem"));
                    if (modemCommand != null) break;
                    this.dialButtons[telnoNdx].setEnabled(false);
                    break;
                }
                case 'F': {
                    this.dialButtons[telnoNdx] = new FormButton(PlafUtilities.getInstance().getIcon("fax"));
                    if (faxCommand != null) break;
                    this.dialButtons[telnoNdx].setEnabled(false);
                    break;
                }
                case 'C': {
                    this.dialButtons[telnoNdx] = new FormButton(PlafUtilities.getInstance().getIcon("cellphone"));
                    if (cellCommand != null) break;
                    this.dialButtons[telnoNdx].setEnabled(false);
                    break;
                }
                default: {
                    this.dialButtons[telnoNdx] = new FormButton(PlafUtilities.getInstance().getIcon("phone"));
                    if (phoneCommand != null) break;
                    this.dialButtons[telnoNdx].setEnabled(false);
                }
            }
            this.dialButtons[telnoNdx].setMargin(new Insets(0, 5, 0, 5));
            this.dialButtons[telnoNdx].setActionCommand("" + telnoNdx);
            this.dialButtons[telnoNdx].setName("dial" + telnoNdx);
            this.dialButtons[telnoNdx].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FormTelnoDialog.this.telnoField.setText(FormTelnoDialog.this.buildTelno());
                    String dialNumber = FormTelnoDialog.this.telnoField.getTelno(new Integer(e.getActionCommand())).toString();
                    String command = null;
                    switch (FormTelnoDialog.this.telnoField.getTelnoType()) {
                        case 'M': {
                            if (modemCommand == null) break;
                            command = modemCommand + " " + dialNumber;
                            break;
                        }
                        case 'C': {
                            if (cellCommand == null) break;
                            command = cellCommand + " " + dialNumber;
                            break;
                        }
                        case 'F': {
                            if (faxCommand == null) break;
                            command = faxCommand + " " + dialNumber;
                            break;
                        }
                        default: {
                            if (phoneCommand == null) break;
                            command = phoneCommand + " " + dialNumber;
                        }
                    }
                    if (command != null) {
                        try {
                            LOGGER.fine(command, new Object[0]);
                            FormTelnoDialog.this.process = Runtime.getRuntime().exec(command);
                        }
                        catch (Exception ex) {
                            LOGGER.warning("dialing " + FormTelnoDialog.this.telnoField.getTelnoType() + ":" + dialNumber + " failed", new Object[0]);
                        }
                    }
                }
            });
            this.numberPanel.add((Component)this.labels[telnoNdx], new GridBagConstraints(0, telnoNdx, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.numberPanel.add((Component)this.telnos[telnoNdx], new GridBagConstraints(1, telnoNdx, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.numberPanel.add((Component)this.comments[telnoNdx], new GridBagConstraints(2, telnoNdx, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.numberPanel.add((Component)this.dialButtons[telnoNdx], new GridBagConstraints(3, telnoNdx, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        }
        if (this.telnoField.isChangeable()) {
            this.numberPanel.add((Component)this.newTelnoStringField, new GridBagConstraints(1, telnoNdx, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
            this.numberPanel.add((Component)this.newCommentStringField, new GridBagConstraints(2, telnoNdx, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
            this.numberPanel.add((Component)this.newButton, new GridBagConstraints(3, telnoNdx, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        }
    }

    private void initComponents() {
        this.buttonPanel = new FormPanel();
        this.okButton = new FormButton();
        this.cancelButton = new FormButton();
        this.numberPanel = new FormPanel();
        this.setAutoPosition(true);
        this.setModal(true);
        this.okButton.setIcon(PlafUtilities.getInstance().getIcon("ok"));
        this.okButton.setMargin(new Insets(1, 4, 1, 4));
        this.okButton.setName("ok");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormTelnoDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setIcon(PlafUtilities.getInstance().getIcon("cancel"));
        this.cancelButton.setMargin(new Insets(1, 4, 1, 4));
        this.cancelButton.setName("cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormTelnoDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "Last");
        this.numberPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.numberPanel, "Center");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.newText = this.buildTelno();
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.newText = null;
        this.dispose();
    }

    static {
        InputStream in = FormTelnoDialog.class.getResourceAsStream(TELNO_PROPERTIES);
        if (in != null) {
            try {
                PropertyResourceBundle rs = new PropertyResourceBundle(in);
                Enumeration<String> keys = rs.getKeys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    String prop = rs.getString(key);
                    if (key.compareTo("P") == 0) {
                        phoneCommand = prop;
                        continue;
                    }
                    if (key.compareTo("F") == 0) {
                        faxCommand = prop;
                        continue;
                    }
                    if (key.compareTo("M") == 0) {
                        modemCommand = prop;
                        continue;
                    }
                    if (key.compareTo("C") != 0) continue;
                    cellCommand = prop;
                }
                in.close();
            }
            catch (IOException e) {
                LOGGER.warning("loading Telno.properties failed", new Object[0]);
            }
        } else {
            LOGGER.warning("no config-file: Telno.properties", new Object[0]);
        }
    }
}

