/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.function.Function;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.swing.FocusTraversalGroup;
import org.tentackle.swing.FormComponent;
import org.tentackle.swing.FormFieldComponent;
import org.tentackle.swing.FormFieldDocument;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.FormWindow;
import org.tentackle.swing.FormWrapEvent;
import org.tentackle.swing.GUIRuntimeException;
import org.tentackle.swing.PropertyGroup;
import org.tentackle.swing.TooltipDisplay;
import org.tentackle.swing.ValueListener;
import org.tentackle.swing.bind.FormComponentBinding;

public class FormTextArea
extends JTextArea
implements FormFieldComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormTextArea.class);
    private static final String TABLECELLEDITOR_PROPERTY = "JTextArea.isTableCellEditor";
    private boolean nullIfEmpty = true;
    private boolean autoUpdate = true;
    private boolean startEditLeftmost;
    private int horizontalAlignment = 10;
    private int verticalAlignment = 0;
    private boolean skipNextFocusLost;
    private FormWindow formWrapWindow;
    private String savedValue;
    private String helpURL;
    private boolean smartEnter = true;
    private boolean enterWillInsert;
    private boolean transferFocusDone;
    private boolean transferFocusBackwardDone;
    private boolean transferFocusByEnter;
    private boolean focusGainedFromTransfer;
    private boolean focusGainedFromTransferBackward;
    private boolean formTraversable = true;
    private boolean valueChangedTriggered;
    private boolean triggerValueChangedEnabled = true;
    private boolean honourChangeable = true;
    private boolean changeable = true;
    private boolean allChangeable = true;
    private boolean fireRunning;
    private boolean eraseFirst;
    private char convert = (char)61;
    private char adjust = (char)124;
    private boolean autoSelect;
    private boolean inhibitAutoSelect;
    private boolean autoNext;
    private int maxColumns;
    private String validChars;
    private String invalidChars;
    private char filler = (char)32;
    private boolean override;
    private Window parentWindow;
    private TooltipDisplay tooltipDisplay;
    private boolean bindable = true;
    private String componentPath;
    private String bindingPath;
    private FormComponentBinding binding;
    private boolean smartValueEntered = true;
    private String oldValueShown;
    private boolean mandatory;
    private boolean focusLostWasTemporary;
    private KeyEvent lastKeyEvent;
    private FocusTraversalGroup focusTraversalGroup;
    private PropertyGroup propertyGroup;
    private Action upAction;
    private Action downAction;

    public FormTextArea(Document doc, String text, int rows, int columns) {
        super(doc, text, rows, columns);
        this.setupActions();
        this.upAction = this.getActionMap().get("caret-up");
        this.downAction = this.getActionMap().get("caret-down");
    }

    public FormTextArea(String text, int rows, int columns) {
        this(null, text, rows, columns);
    }

    public FormTextArea(String text) {
        this(null, text, 0, 0);
    }

    public FormTextArea(int rows, int columns) {
        this(null, null, rows, columns);
    }

    public FormTextArea() {
        this(null, null, 0, 0);
    }

    @Override
    public void showErrorPopup(String message) {
        FormUtilities.getInstance().showErrorPopup(this, message);
    }

    public void setNullIfEmpty(boolean nullIfEmpty) {
        this.nullIfEmpty = nullIfEmpty;
    }

    public boolean isNullIfEmpty() {
        return this.nullIfEmpty;
    }

    @Override
    public String getText() {
        String text = super.getText();
        if (this.nullIfEmpty && text != null && text.length() == 0) {
            text = null;
        }
        return text;
    }

    public boolean isSmartEnter() {
        return this.smartEnter;
    }

    public void setSmartEnter(boolean smartEnter) {
        this.smartEnter = smartEnter;
    }

    public void doSmartEnter() {
        if (this.enterWillInsert && this.smartEnter && this.lastKeyEvent != null && this.lastKeyEvent.getKeyCode() == 10) {
            this.insert("\n", this.getCaretPosition());
        } else {
            this.prepareFocusLost();
            this.transferFocus();
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    protected void fireActionPerformed() {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = new ActionEvent(this, 1001, this.getText(), EventQueue.getMostRecentEventTime(), 0);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    @Override
    public void postActionEvent() {
        this.fireActionPerformed();
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (!e.isTemporary()) {
            if (e.getID() == 1004) {
                if (this.focusLostWasTemporary) {
                    this.focusLostWasTemporary = false;
                } else {
                    this.performFocusGained(e.getOppositeComponent());
                }
            } else if (e.getID() == 1005) {
                if (this.skipNextFocusLost) {
                    this.skipNextFocusLost = false;
                    this.performWrapEvent();
                } else {
                    this.performFocusLost();
                }
            }
        } else if (e.getID() == 1005) {
            this.focusLostWasTemporary = true;
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getID() == 401) {
            this.lastKeyEvent = e;
            if (e.getKeyCode() != 10) {
                this.enterWillInsert = true;
            }
            if (e.getKeyCode() == 90 && e.getModifiers() == 2) {
                this.setText(this.savedValue);
                e.consume();
            }
        }
        super.processKeyEvent(e);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (e.getID() == 501) {
            this.enterWillInsert = true;
        }
    }

    @Override
    protected Document createDefaultModel() {
        return new FormFieldDocument(this);
    }

    public Dimension getOptimalSize() {
        String text = this.getText();
        if (text != null) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            StringTokenizer tokenizer = new StringTokenizer(text, "\n");
            int numberOfLines = tokenizer.countTokens();
            int width = 0;
            for (int i = 0; i < numberOfLines; ++i) {
                int lineWidth = fm.stringWidth(tokenizer.nextToken());
                if (lineWidth <= width) continue;
                width = lineWidth;
            }
            Insets insets = this.getInsets();
            return new Dimension(width + insets.left + insets.right, fm.getHeight() * numberOfLines + insets.bottom + insets.top);
        }
        return this.getPreferredSize();
    }

    @Override
    public String getToolTipText() {
        return this.getTooltipDisplay() == null ? super.getToolTipText() : null;
    }

    @Override
    public void transferFocus() {
        this.transferFocusDone = true;
        super.transferFocus();
    }

    @Override
    public void transferFocusBackward() {
        this.transferFocusBackwardDone = true;
        super.transferFocusBackward();
    }

    @Override
    public void setFormTraversable(boolean formTraversable) {
        this.formTraversable = formTraversable;
    }

    @Override
    public boolean isFormTraversable() {
        return this.formTraversable;
    }

    @Override
    public void setFocusTraversalGroup(FocusTraversalGroup group) {
        if (this.focusTraversalGroup != group) {
            if (this.focusTraversalGroup != null) {
                if (this.focusTraversalGroup.removeComponent(this)) {
                    this.focusTraversalGroup = null;
                } else {
                    throw new GUIRuntimeException("component " + this + " not in focus travseral group " + this.focusTraversalGroup);
                }
            }
            if (group != null) {
                if (group.addComponent(this)) {
                    this.focusTraversalGroup = group;
                } else {
                    throw new GUIRuntimeException("component " + this + " already in focus travseral group " + group);
                }
            }
        }
    }

    @Override
    public FocusTraversalGroup getFocusTraversalGroup() {
        return this.focusTraversalGroup;
    }

    @Override
    public void setPropertyGroup(PropertyGroup group) {
        if (this.propertyGroup != group) {
            if (this.propertyGroup != null) {
                if (this.propertyGroup.removeComponent(this)) {
                    this.propertyGroup = null;
                } else {
                    throw new GUIRuntimeException("component " + this + " not in property group " + this.propertyGroup);
                }
            }
            if (group != null) {
                if (group.addComponent(this)) {
                    this.propertyGroup = group;
                } else {
                    throw new GUIRuntimeException("component " + this + " already in property group " + group);
                }
            }
        }
    }

    @Override
    public PropertyGroup getPropertyGroup() {
        return this.propertyGroup;
    }

    @Override
    public void setFormValue(Object object) {
        if (object != null) {
            this.setText(object.toString());
        } else {
            this.clearText();
        }
    }

    @Override
    public String getFormValue() {
        return this.getText();
    }

    @Override
    public String getHelpURL() {
        return this.helpURL;
    }

    @Override
    public void setHelpURL(String helpURL) {
        this.helpURL = helpURL;
    }

    @Override
    public void showHelp() {
        FormUtilities.getInstance().openHelpURL(this);
    }

    @Override
    public void requestFocusLater() {
        FormUtilities.getInstance().requestFocusLater(this);
    }

    @Override
    public synchronized void addValueListener(ValueListener l) {
        this.listenerList.add(ValueListener.class, l);
    }

    @Override
    public synchronized void removeValueListener(ValueListener l) {
        this.listenerList.remove(ValueListener.class, l);
    }

    @Override
    public void fireValueChanged() {
        FormUtilities.getInstance().doFireValueChanged(this, this.listenerList.getListenerList());
        this.valueChangedTriggered = false;
        this.enterWillInsert = false;
    }

    @Override
    public void fireValueEntered() {
        this.valueChangedTriggered = false;
        FormUtilities.getInstance().doFireValueEntered(this, this.listenerList.getListenerList());
    }

    @Override
    public void saveValue() {
        if (this.honourChangeable) {
            this.savedValue = super.getText();
            this.valueChangedTriggered = false;
        }
    }

    @Override
    public boolean isValueChanged() {
        if (this.honourChangeable) {
            String value = super.getText();
            if (this.savedValue == null) {
                return value != null;
            }
            if (value != null) {
                return value.compareTo(this.savedValue) != 0;
            }
            return true;
        }
        return false;
    }

    @Override
    public void setTriggerValueChangedEnabled(boolean enabled) {
        this.triggerValueChangedEnabled = enabled;
    }

    @Override
    public boolean isTriggerValueChangedEnabled() {
        return this.triggerValueChangedEnabled;
    }

    @Override
    public void triggerValueChanged() {
        if (this.triggerValueChangedEnabled && !this.valueChangedTriggered && !this.fireRunning) {
            FormUtilities.getInstance().triggerValueChanged(this);
            this.valueChangedTriggered = true;
        }
    }

    @Override
    public void setCellEditorUsage(boolean flag) {
        this.putClientProperty(TABLECELLEDITOR_PROPERTY, flag);
    }

    @Override
    public boolean isCellEditorUsage() {
        try {
            Object obj = this.getClientProperty(TABLECELLEDITOR_PROPERTY);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
        }
        catch (Exception ex) {
            LOGGER.severe("FormTextArea: isTableCellEditor not Boolean! " + ex, new Object[0]);
        }
        return false;
    }

    @Override
    public void setChangeable(boolean changeable) {
        if (this.isHonourChangeable()) {
            this.changeable = changeable;
            super.setEditable(changeable && this.allChangeable);
        }
    }

    @Override
    public boolean isChangeable() {
        return this.changeable && this.allChangeable;
    }

    @Override
    public void setHonourChangeable(boolean flag) {
        this.honourChangeable = flag;
    }

    @Override
    public boolean isHonourChangeable() {
        return this.honourChangeable;
    }

    @Override
    public void updateAllChangeable(boolean allChangeable) {
        if (this.allChangeable != allChangeable) {
            this.allChangeable = allChangeable;
            this.setChangeable(this.changeable);
        }
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.changeable = editable;
    }

    @Override
    public void prepareFocusLost() {
        if (!this.isCellEditorUsage()) {
            this.performFocusLost();
            this.skipNextFocusLost = true;
        }
    }

    @Override
    public Window getParentWindow() {
        if (this.parentWindow == null) {
            this.parentWindow = FormUtilities.getInstance().getParentWindow(this);
        }
        return this.parentWindow;
    }

    @Override
    public void invalidateParentInfo() {
        this.parentWindow = null;
        this.tooltipDisplay = null;
    }

    @Override
    public boolean wasTransferFocus() {
        return this.transferFocusDone;
    }

    @Override
    public boolean wasTransferFocusBackward() {
        return this.transferFocusBackwardDone;
    }

    @Override
    public boolean wasFocusGainedFromTransfer() {
        return this.focusGainedFromTransfer;
    }

    @Override
    public boolean wasFocusGainedFromTransferBackward() {
        return this.focusGainedFromTransferBackward;
    }

    @Override
    public boolean wasTransferFocusByEnter() {
        return this.transferFocusByEnter;
    }

    @Override
    public void setText(String str) {
        this.focusLostWasTemporary = false;
        if (str == null) {
            str = "";
        }
        if (this.autoNext) {
            this.autoNext = false;
            super.setText(str);
            this.autoNext = true;
        } else {
            super.setText(str);
        }
        if (this.eraseFirst) {
            Document doc = this.getDocument();
            if (doc instanceof FormFieldDocument) {
                ((FormFieldDocument)doc).setEraseFirst(true);
            }
            this.eraseFirst = false;
        }
        this.setCaretLeft();
    }

    @Override
    public void clearText() {
        this.setText("");
    }

    @Override
    public boolean isCaretLeft() {
        return this.getCaretPosition() == 0;
    }

    @Override
    public boolean isCaretRight() {
        return this.getCaretPosition() == this.getDocument().getLength();
    }

    @Override
    public void setCaretLeft() {
        this.setCaretPosition(0);
    }

    @Override
    public void setCaretRight() {
        this.setCaretPosition(this.getDocument().getLength());
    }

    @Override
    public void upLeft() {
        if (this.isCaretLeft()) {
            this.transferFocusBackward();
        }
        if (this.upAction != null) {
            int pos = this.getCaretPosition();
            this.upAction.actionPerformed(new ActionEvent(this, 0, null));
            if (pos == this.getCaretPosition()) {
                this.setCaretLeft();
            }
        }
    }

    @Override
    public void downRight() {
        if (this.isCaretRight()) {
            this.transferFocus();
        }
        if (this.downAction != null) {
            int pos = this.getCaretPosition();
            this.downAction.actionPerformed(new ActionEvent(this, 0, null));
            if (pos == this.getCaretPosition()) {
                this.setCaretRight();
            }
        }
    }

    @Override
    public void setConvert(char convert) {
        this.convert = convert;
        String text = this.getText();
        if (text != null) {
            switch (convert) {
                case '^': {
                    this.setText(text.toUpperCase());
                    break;
                }
                case 'v': {
                    this.setText(text.toLowerCase());
                }
            }
        }
    }

    @Override
    public char getConvert() {
        return this.convert;
    }

    @Override
    public void setAutoSelect(boolean autoselect) {
        this.autoSelect = autoselect;
    }

    @Override
    public boolean isAutoSelect() {
        return this.autoSelect;
    }

    @Override
    public void setAutoUpdate(boolean autoupdate) {
        this.autoUpdate = autoupdate;
    }

    @Override
    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    @Override
    public void setValidChars(String str) {
        this.validChars = str.length() == 0 ? null : str;
    }

    @Override
    public String getValidChars() {
        return this.validChars;
    }

    @Override
    public void setInvalidChars(String str) {
        this.invalidChars = str.length() == 0 ? null : str;
    }

    @Override
    public String getInvalidChars() {
        return this.invalidChars;
    }

    @Override
    public void setFiller(char filler) {
        char oldfiller = this.filler;
        this.filler = filler;
        this.setText(this.getText().replace(oldfiller, filler));
    }

    @Override
    public char getFiller() {
        return this.filler;
    }

    @Override
    public void setOverwrite(boolean override) {
        this.override = override;
    }

    @Override
    public boolean isOverwrite() {
        return this.override;
    }

    @Override
    public void setEraseFirst(boolean erasefirst) {
        Document doc;
        this.eraseFirst = erasefirst;
        if (!erasefirst && (doc = this.getDocument()) instanceof FormFieldDocument) {
            ((FormFieldDocument)doc).setEraseFirst(false);
        }
    }

    @Override
    public boolean isEraseFirst() {
        return this.eraseFirst;
    }

    @Override
    public void setFormat(String pattern) {
    }

    @Override
    public String getFormat() {
        return "";
    }

    @Override
    public String doFormat(Object object) {
        return object == null ? null : object.toString();
    }

    @Override
    public void setAutoNext(boolean autonext) {
        this.autoNext = autonext;
    }

    @Override
    public boolean isAutoNext() {
        return this.autoNext;
    }

    @Override
    public void setAdjust(char adjust) {
        this.adjust = adjust;
    }

    @Override
    public char getAdjust() {
        return this.adjust;
    }

    @Override
    public void setMaxColumns(int maxColumns) {
        this.maxColumns = maxColumns;
    }

    @Override
    public int getMaxColumns() {
        return this.maxColumns;
    }

    @Override
    public void setDefaultColumns(int defaultColumns) {
    }

    @Override
    public int getDefaultColumns() {
        return this.getColumns();
    }

    @Override
    public void setHorizontalAlignment(int alignment) {
        this.horizontalAlignment = alignment;
    }

    @Override
    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @Override
    public void setVerticalAlignment(int alignment) {
        this.verticalAlignment = alignment;
    }

    @Override
    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    @Override
    public boolean isInhibitAutoSelect() {
        return this.inhibitAutoSelect;
    }

    @Override
    public void setInhibitAutoSelect(boolean inhibitAutoSelect) {
        this.inhibitAutoSelect = inhibitAutoSelect;
    }

    @Override
    public void setFireRunning(boolean fireRunning) {
        this.fireRunning = fireRunning;
    }

    @Override
    public boolean isFireRunning() {
        return this.fireRunning;
    }

    @Override
    public void setFormWrapWindow(FormWindow parent) {
        this.formWrapWindow = parent;
    }

    @Override
    public Function<String, String> getConverter() {
        Document doc = this.getDocument();
        if (doc instanceof FormFieldDocument) {
            return ((FormFieldDocument)doc).getConverter();
        }
        return null;
    }

    @Override
    public void setConverter(Function<String, String> converter) {
        Document doc = this.getDocument();
        if (doc instanceof FormFieldDocument) {
            ((FormFieldDocument)doc).setConverter(converter);
        }
    }

    @Override
    public int getErrorOffset() {
        return -1;
    }

    @Override
    public void setErrorOffset(int errorOffset) {
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public void setErrorMessage(String errorMessage) {
    }

    @Override
    public boolean isEmpty() {
        String text = this.getText();
        return text == null || text.length() == 0;
    }

    @Override
    public void setStartEditLeftmost(boolean startEditLeftmost) {
        this.startEditLeftmost = startEditLeftmost;
    }

    @Override
    public boolean isStartEditLeftmost() {
        return this.startEditLeftmost;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        if (this.mandatory != mandatory) {
            boolean oldValue = this.mandatory;
            this.mandatory = mandatory;
            this.firePropertyChange("mandatory", oldValue, mandatory);
            this.invalidate();
            this.repaint();
        }
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public void setComponentPath(String componentPath) {
        this.componentPath = componentPath;
    }

    @Override
    public String getComponentPath() {
        return this.componentPath;
    }

    @Override
    public void setBindingPath(String bindingPath) {
        this.bindingPath = bindingPath;
    }

    @Override
    public String getBindingPath() {
        return this.bindingPath;
    }

    @Override
    public void setBinding(FormComponentBinding binding) {
        this.binding = binding;
    }

    @Override
    public FormComponentBinding getBinding() {
        return this.binding;
    }

    @Override
    public void setBindable(boolean bindable) {
        this.bindable = bindable;
    }

    @Override
    public boolean isBindable() {
        return this.bindable;
    }

    @Override
    public void setSmartValueEntered(boolean smartValueEntered) {
        this.smartValueEntered = smartValueEntered;
    }

    @Override
    public boolean isSmartValueEntered() {
        return this.smartValueEntered;
    }

    private void setupActions() {
        FormUtilities.getInstance().setupDefaultBindings(this);
        AbstractAction tabAction = new AbstractAction("insertTab"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormTextArea.this.insert("\t", FormTextArea.this.getCaretPosition());
            }
        };
        this.getActionMap().put(tabAction.getValue("Name"), tabAction);
        this.getInputMap().put(KeyStroke.getKeyStroke(9, 2), tabAction.getValue("Name"));
        AbstractAction newlineAction = new AbstractAction("insertNewline"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int pos = FormTextArea.this.getCaretPosition();
                FormTextArea.this.insert("\n", pos);
                if (FormTextArea.this.smartEnter) {
                    FormTextArea.this.setCaretPosition(pos);
                }
            }
        };
        this.getActionMap().put(newlineAction.getValue("Name"), newlineAction);
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 2), newlineAction.getValue("Name"));
    }

    @Override
    public String getValueShown() {
        return super.getText();
    }

    @Override
    public boolean isValueShownModified() {
        return !Objects.equals(this.oldValueShown, this.getValueShown());
    }

    @Override
    public void clearValueShownModified() {
        this.oldValueShown = this.getValueShown();
    }

    private void performFocusGained(Component opposite) {
        boolean wasEnter = false;
        if (opposite instanceof FormComponent) {
            this.focusGainedFromTransfer = ((FormComponent)((Object)opposite)).wasTransferFocus();
            this.focusGainedFromTransferBackward = ((FormComponent)((Object)opposite)).wasTransferFocusBackward();
            wasEnter = ((FormComponent)((Object)opposite)).wasTransferFocusByEnter();
        }
        this.transferFocusDone = false;
        this.transferFocusBackwardDone = false;
        if (this.isAutoUpdate()) {
            int caretPos = this.getCaretPosition();
            this.fireValueChanged();
            if (this.focusGainedFromTransfer && !wasEnter && !this.startEditLeftmost) {
                this.setCaretRight();
            } else if (this.focusGainedFromTransferBackward || wasEnter) {
                this.setCaretLeft();
            } else {
                if (caretPos < 0) {
                    caretPos = 0;
                } else if (caretPos > this.getDocument().getLength()) {
                    caretPos = this.getDocument().getLength() - 1;
                }
                this.setCaretPosition(caretPos);
            }
        }
        if (this.isAutoSelect() && !this.inhibitAutoSelect) {
            this.selectAll();
        }
        this.inhibitAutoSelect = false;
        this.formWrapWindow = null;
        this.transferFocusByEnter = false;
        this.showTooltip(super.getToolTipText());
        this.oldValueShown = this.getValueShown();
    }

    private void performFocusLost() {
        boolean bl = this.transferFocusByEnter = !(this.lastKeyEvent == null || this.lastKeyEvent.getKeyCode() != 10 && this.lastKeyEvent.getKeyCode() != 9 || this.lastKeyEvent.getModifiers() != 0 && this.lastKeyEvent.getModifiers() != 1);
        if (this.isAutoUpdate() && this.isChangeable()) {
            if (this.isCellEditorUsage() || !this.isSmartValueEntered() || this.isValueShownModified()) {
                this.fireValueEntered();
            }
            FormUtilities.getInstance().doValidate(this);
        }
        this.setEraseFirst(false);
        this.performWrapEvent();
        this.showTooltip(null);
        this.lastKeyEvent = null;
    }

    private void performWrapEvent() {
        if (this.formWrapWindow != null) {
            this.formWrapWindow.fireFormWrappedFocus(new FormWrapEvent(this));
            this.formWrapWindow = null;
        }
    }

    private void showTooltip(String text) {
        TooltipDisplay td = this.getTooltipDisplay();
        if (td != null) {
            td.setTooltip(text);
        }
    }

    private TooltipDisplay getTooltipDisplay() {
        Window w;
        if (this.tooltipDisplay == null && (w = this.getParentWindow()) instanceof FormWindow) {
            this.tooltipDisplay = ((FormWindow)((Object)w)).getTooltipDisplay();
        }
        return this.tooltipDisplay;
    }
}

