/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.log.LoggerOutputStream;
import org.tentackle.swing.GUISaveable;

public class GUIExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(GUIExceptionHandler.class);
    private static boolean exitOnException = true;
    private static CharArrayWriter writer = new CharArrayWriter();
    private static PrintWriter printWriter = new PrintWriter(writer);
    private static Set<GUISaveable> saveables = new HashSet<GUISaveable>();
    private static final String GUIExceptionHandlerKey = "sun.awt.exception.handler";
    private static final String GUIExceptionHandler = "org.tentackle.swing.GUIExceptionHandler";

    public static void install(boolean override) {
        if (override || System.getProperty(GUIExceptionHandlerKey) == null) {
            System.setProperty(GUIExceptionHandlerKey, GUIExceptionHandler);
        }
    }

    public static void setExitOnException(boolean flag) {
        exitOnException = flag;
    }

    public static boolean isExitOnException() {
        return exitOnException;
    }

    public static void registerSaveable(GUISaveable saveable) {
        saveables.add(saveable);
    }

    public static void unregisterSaveable(GUISaveable saveable) {
        saveables.remove(saveable);
    }

    public static void runSaveState() {
        for (GUISaveable s : saveables) {
            s.saveState();
        }
    }

    public void handle(Throwable thrown) {
        printWriter.println(thrown.getMessage());
        thrown.printStackTrace(printWriter);
        printWriter.flush();
        LOGGER.severe(writer.toString(), new Object[0]);
        writer.reset();
        try {
            org.tentackle.swing.GUIExceptionHandler.runSaveState();
        }
        catch (Exception e) {
            LoggerOutputStream.logException((Exception)e, (Logger)LOGGER);
        }
        if (exitOnException) {
            System.exit(1);
        }
    }
}

