/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.tentackle.common.Compare;
import org.tentackle.misc.ShortLongText;
import org.tentackle.swing.FormComboBox;

public class LocaleComboBox
extends FormComboBox<ShortLongText> {
    public LocaleComboBox() {
        this.setShortLongPopupEnabled(true);
        this.setMultiKeySelectionManager(true);
        Locale[] locales = Locale.getAvailableLocales();
        Object[] tlocales = new TLocale[locales.length];
        for (int i = 0; i < locales.length; ++i) {
            tlocales[i] = new TLocale(locales[i]);
        }
        Arrays.sort(tlocales);
        this.addAllItems(tlocales);
    }

    public void setLocaleValue(Locale locale) {
        this.setFormValue(locale == null ? null : new TLocale(locale));
    }

    public Locale getLocaleValue() {
        TLocale tloc = (TLocale)this.getFormValue();
        return tloc == null ? null : tloc.locale;
    }

    private static class TLocale
    implements ShortLongText,
    Comparable<TLocale> {
        private Locale locale;

        public TLocale(Locale locale) {
            this.locale = locale;
        }

        public String toString() {
            return this.locale.toString();
        }

        public String getShortText() {
            return this.locale.toString();
        }

        public String getLongText() {
            return this.locale.getDisplayName();
        }

        public Locale getLocale() {
            return this.locale;
        }

        public boolean equals(Object obj) {
            return Objects.equals(this.locale, obj instanceof TLocale ? ((TLocale)obj).locale : null);
        }

        public int hashCode() {
            int hash = 7;
            hash = 61 * hash + Objects.hashCode(this.locale);
            return hash;
        }

        @Override
        public int compareTo(TLocale o) {
            return Compare.compare((Comparable)((Object)this.locale.toString()), o == null ? null : o.locale.toString());
        }
    }
}

