/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import javax.swing.text.Document;
import org.tentackle.swing.AbstractFormField;

public class StringFormField
extends AbstractFormField {
    private boolean nullIfEmpty = true;

    public StringFormField(Document doc, String str, int columns) {
        super(doc, str, columns);
    }

    public StringFormField(String str, int columns) {
        super(null, str, columns);
    }

    public StringFormField(int columns) {
        this(null, columns);
    }

    public StringFormField() {
        this(0);
    }

    public void setNullIfEmpty(boolean nullIfEmpty) {
        this.nullIfEmpty = nullIfEmpty;
    }

    public boolean isNullIfEmpty() {
        return this.nullIfEmpty;
    }

    @Override
    public void setFormValue(Object object) {
        if (object != null) {
            this.setText(object.toString());
        } else {
            this.clearText();
        }
    }

    @Override
    public String getFormValue() {
        return this.getText();
    }

    @Override
    public void setText(String str) {
        if (str == null) {
            str = "";
        }
        super.setText(str);
    }

    @Override
    public String getText() {
        String text = super.getText();
        if (this.nullIfEmpty && text != null && text.length() == 0) {
            text = null;
        }
        return text;
    }

    @Override
    public void setFormat(String pattern) {
    }

    @Override
    public String getFormat() {
        return "";
    }

    @Override
    public String doFormat(Object object) {
        return object == null ? null : object.toString();
    }
}

