/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.tentackle.common.BMoney;
import org.tentackle.swing.AbstractFormTableModel;
import org.tentackle.swing.FormTable;
import org.tentackle.swing.FormTableEntry;

public class SumFormTableEntry<T>
extends FormTableEntry<T> {
    private static final int UNKNOWN = 0;
    private static final int NAN = 1;
    private static final int DOUBLE = 2;
    private static final int LONG = 3;
    private static final int BIGDEC = 4;
    private static final int BIGINT = 5;
    private static final int BMONEY = 6;
    private int[] types;
    private Class[] classes;
    private Object[] sums;
    private double[] doubles;
    private long[] longs;
    private BigDecimal[] bigdecs;
    private BigInteger[] bigints;
    private BMoney[] bmoneys;

    public SumFormTableEntry(AbstractFormTableModel model) {
        if (model != null) {
            this.sumUp(model);
        }
    }

    public SumFormTableEntry() {
    }

    public void sumUp(AbstractFormTableModel model) {
        FormTableEntry template = model.getTemplate();
        int cols = template.getColumnCount();
        this.types = new int[cols];
        this.classes = new Class[cols];
        this.sums = new Object[cols];
        this.doubles = new double[cols];
        this.longs = new long[cols];
        this.bigdecs = new BigDecimal[cols];
        this.bigints = new BigInteger[cols];
        this.bmoneys = new BMoney[cols];
        FormTable table = model.getTable();
        for (int col = 0; col < cols; ++col) {
            this.types[col] = table != null && !table.isColumnVisible(col) || template.isColumnNotSummable(col) ? 1 : 0;
        }
        int rows = model.getRowCount();
        for (int row = 0; row < rows; ++row) {
            FormTableEntry entry = model.getEntryAt(row);
            if (entry == null) continue;
            for (int col = 0; col < cols; ++col) {
                Object value;
                int type = this.types[col];
                if (type == 1 || (value = entry.getValueAt(col)) == null) continue;
                try {
                    switch (type) {
                        case 0: {
                            Class<?> clazz = value.getClass();
                            if (clazz == BMoney.class) {
                                this.types[col] = 6;
                                this.classes[col] = clazz;
                                this.bmoneys[col] = (BMoney)value;
                                break;
                            }
                            if (clazz == BigDecimal.class) {
                                this.types[col] = 4;
                                this.classes[col] = clazz;
                                this.bigdecs[col] = (BigDecimal)value;
                                break;
                            }
                            if (clazz == BigInteger.class) {
                                this.types[col] = 5;
                                this.classes[col] = clazz;
                                this.bigints[col] = (BigInteger)value;
                                break;
                            }
                            if (clazz == Double.class || clazz == Float.class) {
                                this.types[col] = 2;
                                this.classes[col] = clazz;
                                this.doubles[col] = ((Number)value).doubleValue();
                                break;
                            }
                            if (value instanceof Number) {
                                this.types[col] = 3;
                                this.classes[col] = clazz;
                                this.longs[col] = ((Number)value).longValue();
                                break;
                            }
                            this.types[col] = 1;
                            break;
                        }
                        case 6: {
                            this.bmoneys[col] = this.bmoneys[col].add((BMoney)value);
                            break;
                        }
                        case 4: {
                            this.bigdecs[col] = this.bigdecs[col].add((BigDecimal)value);
                            break;
                        }
                        case 5: {
                            this.bigints[col] = this.bigints[col].add((BigInteger)value);
                            break;
                        }
                        case 2: {
                            int n = col;
                            this.doubles[n] = this.doubles[n] + ((Number)value).doubleValue();
                            break;
                        }
                        case 3: {
                            int n = col;
                            this.longs[n] = this.longs[n] + ((Number)value).longValue();
                        }
                    }
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        block20: for (int col = 0; col < cols; ++col) {
            switch (this.types[col]) {
                case 6: {
                    this.sums[col] = this.bmoneys[col];
                    continue block20;
                }
                case 4: {
                    this.sums[col] = this.bigdecs[col];
                    continue block20;
                }
                case 5: {
                    this.sums[col] = this.bigints[col];
                    continue block20;
                }
                case 2: {
                    if (this.classes[col] == Double.class) {
                        this.sums[col] = new Double(this.doubles[col]);
                        continue block20;
                    }
                    this.sums[col] = new Float((float)this.doubles[col]);
                    continue block20;
                }
                case 3: {
                    if (this.classes[col] == Byte.class) {
                        this.sums[col] = new Byte((byte)this.longs[col]);
                        continue block20;
                    }
                    if (this.classes[col] == Short.class) {
                        this.sums[col] = new Short((short)this.longs[col]);
                        continue block20;
                    }
                    if (this.classes[col] == Integer.class) {
                        this.sums[col] = new Integer((int)this.longs[col]);
                        continue block20;
                    }
                    this.sums[col] = new Long(this.longs[col]);
                    continue block20;
                }
                default: {
                    this.sums[col] = null;
                }
            }
        }
    }

    @Override
    public FormTableEntry<T> newInstance(T object) {
        return null;
    }

    @Override
    public Object getValueAt(int mColumn) {
        return this.sums[mColumn];
    }

    @Override
    public String getColumnName(int mColumn) {
        return null;
    }

    @Override
    public T getObject() {
        return null;
    }

    @Override
    public int getColumnCount() {
        return this.types.length;
    }
}

