/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.EventQueue;
import javax.swing.JDialog;
import org.tentackle.swing.WorkerDialog;

public class WorkerThread
extends Thread {
    private Runnable runnable;
    private JDialog workerDialog;

    public WorkerThread(Runnable runnable, boolean modal, String title, JDialog workerDialog) {
        this.runnable = runnable;
        JDialog jDialog = this.workerDialog = workerDialog == null ? new WorkerDialog(this) : workerDialog;
        if (title != null) {
            this.workerDialog.setTitle(title);
        }
        this.workerDialog.setModal(modal);
        this.setPriority(5);
    }

    public WorkerThread(Runnable worker, boolean modal, String title) {
        this(worker, modal, title, null);
    }

    public WorkerThread(Runnable worker, String title) {
        this(worker, true, title, null);
    }

    public JDialog getWorkerDialog() {
        return this.workerDialog;
    }

    @Override
    public void run() {
        if (this.runnable != null) {
            this.runnable.run();
        }
        EventQueue.invokeLater(() -> this.workerDialog.dispose());
    }

    @Override
    public void start() {
        EventQueue.invokeLater(() -> {
            this.workerDialog.pack();
            this.workerDialog.setVisible(true);
        });
        super.start();
    }

    public void startAndWait() {
        super.start();
        this.workerDialog.pack();
        this.workerDialog.setVisible(true);
    }
}

